/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher.util;

import cerent.cms.fv.IFvDwdmPortModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.fv.net.IFvNetNodeGraph;
import cerent.cms.fv.net.IFvNetSidePosition;
import cerent.cms.fv.net.IFvVirtualLink;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidNodeId;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.functional.FunctOpenHelper;
import cerent.cms.ui.ppc.PPCHelper;
import cerent.util.IFvDebug;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.KDebug;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.AbstractViewLink;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.ViewBandDomainGrapher;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.ViewCardHelper;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.AbstractNode;
import com.cisco.ctc.util.map.DetailedMapLink;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.InterGraphLink;
import com.cisco.ctc.util.map.LinkedSideInfo;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapObjectAdapter;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.INfvGraphicalValue;
import com.cisco.fv.grapher.FunctNetMapLink;
import com.cisco.fv.grapher.FunctNetMapNode;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.circuit.FvNetworkCircuitPath;
import com.cisco.fv.grapher.util.FvMapToolkit;
import com.cisco.fv.grapher.util.MapGrapherNode;
import com.cisco.fv.grapher.util.SidePositionInNtw;
import com.cisco.fv.gui.FunctionalNetworkDialog;
import com.cisco.fv.power.PowerBallon;
import ilog.views.IlvApplyObject;
import ilog.views.IlvDefaultManagerFrame;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerListener;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FvMapGraph
extends MapGraph
implements ActionListener,
IFvNetNodeGraph {
    public static final String CMD_GOTO_NODE_FV = "Open Node FV";
    private static final String CMD_CLOSE_NODE_FV = "Close Node FV";
    private static final String CMD_DOUBLE_UP = "Node DoubleZoomIN";
    private static final String CMD_DOUBLE_DOWN = "Node DoubleZoomOUT";
    private static final int PORT_TX = 0;
    private static final int PORT_RX = 1;
    private ArrayList children = new ArrayList();
    HashMap portToLinkMap = new HashMap();
    private ActionOrganizer actOrg;
    private FunctNetMapNode node = null;
    private ViewManagerToolKit nodeFv = null;
    private Color bgColor = Color.BLUE;
    private HashMap<Integer, Integer> sectorPosForSide;
    private ArrayList<Integer> sidesPosCalculated;
    private LinkedList<InterGraphLink> interLinks = new LinkedList();
    private IFvDebug fd;
    private static long circuitDbgtime;
    private int[] sidePos = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    private int[] sidePosOnRes = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    private AbstractGraph graph;
    private IlvPinLinkConnector connectorBag = null;
    private LinkedList<LinkedSideInfo> otherConnectedNodeSideInfo;
    private double collapsedNodeX = -1.0;
    private double collapsedNodeY = -1.0;
    private ConnectionObserver connectionObserver = new ConnectionObserver();
    private boolean removedOnDisconnection = false;
    private int sidesRePositioned = 0;
    private boolean keyStroked;
    private int previousLayer = 3;
    private static boolean dbgDelete;

    public FvMapGraph(MapToolkit mapToolkit, Object object) {
        super(mapToolkit, object, false);
        this.sectorPosForSide = new HashMap();
        this.sidesPosCalculated = new ArrayList();
        this.setKeepingAspectRatio(true);
        this.fd = FunctDebug.instance().addChild("FvMapGraph", "FVMap Graph debug");
        this.keyStroked = false;
        this.otherConnectedNodeSideInfo = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkAdded(MapLink mapLink) {
        if (this.mtk.isDetailed()) {
            if (mapLink == null) {
                return;
            }
            DetailedMapLink detailedMapLink = (DetailedMapLink)mapLink;
            int n = this.getNodeRoleInLink(detailedMapLink);
            if (n == 0) {
                return;
            }
            DetailedMapNode detailedMapNode = n == 1 ? (DetailedMapNode)detailedMapLink.getTarget() : (DetailedMapNode)detailedMapLink.getSource();
            MapLinkConnector mapLinkConnector = this.createLinkConnector(0.0f, 0.0f);
            MapPort mapPort = this.addPort(mapLink, mapLinkConnector);
            int n2 = 0;
            mapPort.setCreateOrder(n2);
            mapLinkConnector.attach(mapLink);
            if (n == 1) {
                detailedMapLink.setSourceConnector(mapLinkConnector);
                detailedMapLink.setSourcePort(mapPort);
            } else {
                detailedMapLink.setTargetConnector(mapLinkConnector);
                detailedMapLink.setTargetPort(mapPort);
            }
            FvMapGraph fvMapGraph = this;
            synchronized (fvMapGraph) {
                Object v = this.portToLinkMap.get(mapPort);
                if (v != null) {
                    LinkedList<Object> linkedList = null;
                    if (v instanceof LinkedList) {
                        linkedList = (LinkedList<Object>)v;
                    } else {
                        linkedList = new LinkedList<Object>();
                        linkedList.add(v);
                    }
                    linkedList.add(mapLink);
                    this.portToLinkMap.put(mapPort, linkedList);
                } else {
                    this.portToLinkMap.put(mapPort, mapLink);
                }
            }
            this.updatePortSides(new HashSet());
        } else {
            super.linkAdded(mapLink);
            if (mapLink instanceof FunctNetMapLink && this.nodeFv != null) {
                this.restoreFunctions();
            }
        }
    }

    private void restoreFunctions() {
        this.nodeFv.setBalloonsPowerAndVisibility(FunctViewManagerDelegate.getInstance().isPowerVisible(), PowerBallon.getInstance().isForCircuit());
        this.nodeFv.showFunctViewPowerBallons();
        this.createLineCardConnection();
        FvNetworkCircuitPath.getInstance().updateCircuits(true);
    }

    private HashSet updatePortSides(HashSet hashSet) {
        ActionListener actionListener;
        int n;
        ArrayList<DetailedMapNode> arrayList = new ArrayList<DetailedMapNode>();
        MapPort[] mapPortArray = this.getPorts();
        if (mapPortArray != null) {
            for (n = 0; n < mapPortArray.length; ++n) {
                actionListener = mapPortArray[n];
                MapPort[] mapPortArray2 = this.getTargetPorts((MapPort)actionListener);
                for (int i = 0; i < mapPortArray2.length; ++i) {
                    MapPort mapPort = mapPortArray2[i];
                    DetailedMapNode detailedMapNode = mapPort.getParentNode();
                    arrayList.add(detailedMapNode);
                }
            }
        }
        this.computeSideSpacing(1);
        this.computeSideSpacing(-1);
        this.computeSideSpacing(2);
        this.computeSideSpacing(-2);
        mapPortArray = this.getPorts();
        if (mapPortArray != null) {
            for (n = 0; n < mapPortArray.length; ++n) {
                actionListener = mapPortArray[n];
                actionListener.updatePositionInNode();
            }
        }
        hashSet.add(this);
        for (n = 0; n < arrayList.size(); ++n) {
            actionListener = (DetailedMapNode)arrayList.get(n);
            if (!hashSet.contains(actionListener)) continue;
        }
        return hashSet;
    }

    private static int computeSide(Node node, Node node2) {
        double d;
        double d2 = node2.getCenterX() - node.getCenterX();
        double d3 = node2.getCenterY() - node.getCenterY();
        int n = d2 == 0.0 ? (d3 > 0.0 ? 1 : -1) : ((d = Math.abs(d3 / d2)) > 1.0 ? (d3 > 0.0 ? 1 : -1) : (d2 > 0.0 ? -2 : 2));
        return n;
    }

    private void computeSideSpacing(int n) {
        ArrayList arrayList = this.returnPortsOnSide(n);
        int n2 = arrayList.size();
        if (n2 == 1) {
            MapPort mapPort = (MapPort)arrayList.get(0);
            if (n == 1 || n == -1) {
                mapPort.setSideOffset(0.4375);
            } else {
                mapPort.setSideOffset(0.4375);
            }
            return;
        }
        int n3 = 2 * n2 + 1;
        double d = 1.0 / (double)n3;
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            MapPort mapPort = (MapPort)arrayList.get(i);
            double d2 = (double)n4 * d;
            mapPort.setSideOffset(d2);
            n4 += 2;
        }
    }

    protected ArrayList returnPortsOnSide(int n) {
        ArrayList<MapPort> arrayList = new ArrayList<MapPort>();
        MapPort[] mapPortArray = this.getPorts();
        if (mapPortArray != null) {
            for (int i = 0; i < mapPortArray.length; ++i) {
                MapPort mapPort = mapPortArray[i];
                int n2 = mapPort.getSide();
                if (n2 != n) continue;
                arrayList.add(mapPort);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public MapPort[] getPorts() {
        return this.getPorts(false);
    }

    public MapPort[] getPorts(boolean bl) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            MapPort mapPort;
            if (!(objectArray[i] instanceof MapPort) || !bl && ((mapPort = (MapPort)objectArray[i]).isInternalPort() || mapPort.getInternalPG() != null)) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new MapPort[0]);
    }

    public MapPort[] getTargetPorts(MapPort mapPort) {
        String string = null;
        DetailedMapLink[] detailedMapLinkArray = this.getLinks(mapPort);
        LinkedList<MapPort> linkedList = new LinkedList<MapPort>();
        for (int i = 0; i < detailedMapLinkArray.length; ++i) {
            DetailedMapLink detailedMapLink = detailedMapLinkArray[i];
            DetailedMapNode detailedMapNode = null;
            int n = this.getNodeRoleInLink(detailedMapLink);
            if (n == 1) {
                detailedMapNode = (DetailedMapNode)detailedMapLink.getTarget();
            } else if (n == 2) {
                detailedMapNode = (DetailedMapNode)detailedMapLink.getSource();
            } else {
                string = "getTargetPort() could not find the role of " + this + " on link " + detailedMapLink;
            }
            if (detailedMapNode == null) continue;
            MapPort mapPort2 = detailedMapNode.getPort(detailedMapLink);
            if (mapPort2 != null) {
                linkedList.add(mapPort2);
                continue;
            }
            string = null;
        }
        if (string != null && this.fd.on()) {
            this.fd.println(string);
        }
        return linkedList.toArray(new MapPort[0]);
    }

    public MapPort getPort(DetailedMapLink detailedMapLink) {
        for (MapPort mapPort : this.portToLinkMap.keySet()) {
            DetailedMapLink[] detailedMapLinkArray = this.getLinks(mapPort);
            for (int i = 0; i < detailedMapLinkArray.length; ++i) {
                if (detailedMapLinkArray[i] != detailedMapLink) continue;
                return mapPort;
            }
        }
        return null;
    }

    public DetailedMapLink[] getLinks(MapPort mapPort) {
        LinkedList linkedList;
        Object v = this.portToLinkMap.get(mapPort);
        if (v instanceof DetailedMapLink) {
            linkedList = new LinkedList();
            linkedList.add(v);
        } else {
            linkedList = v != null ? (LinkedList)v : new LinkedList();
        }
        return linkedList.toArray(new DetailedMapLink[0]);
    }

    protected int getNodeRoleInLink(MapLink mapLink) {
        DetailedMapNode detailedMapNode = (DetailedMapNode)mapLink.getSource();
        if (this.getCollapsedGraphic() == detailedMapNode) {
            return 1;
        }
        detailedMapNode = (DetailedMapNode)mapLink.getTarget();
        if (this.getCollapsedGraphic() == detailedMapNode) {
            return 2;
        }
        return 0;
    }

    MapLinkConnector createLinkConnector(float f, float f2) {
        if (this.connectorBag == null) {
            this.initConnectorBag();
        }
        return new MapLinkConnector(this, f, f2);
    }

    public MapPort addPort(MapLink mapLink, MapLinkConnector mapLinkConnector) {
        MapPort mapPort = this.createMapPort(this, mapLink, mapLinkConnector);
        this.addComponent((IlvGraphic)mapPort, 7);
        mapPort.setSelectable(false);
        if (mapPort.isInternalPort()) {
            // empty if block
        }
        return mapPort;
    }

    boolean addComponent(IlvGraphic ilvGraphic, int n) {
        if (super.getGraphicBag() == null || this.children.contains(ilvGraphic)) {
            return false;
        }
        ((AbstractGraph)super.getGraphicBag()).addObject(ilvGraphic, n, false);
        this.children.add(ilvGraphic);
        return true;
    }

    protected MapPort createMapPort(MapGraph mapGraph, MapLink mapLink, MapLinkConnector mapLinkConnector) {
        return new MapPort(mapGraph, mapLinkConnector);
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.mtk.initPopupMenu(this, this.actOrg, uPopupMenu);
        this.actOrg = null;
    }

    public void secondaryOnInitPopupMenu(IlvGraphic ilvGraphic, UPopupMenu uPopupMenu) {
        if (ilvGraphic instanceof ViewDomainGrapher || ilvGraphic instanceof ViewCardGrapher || ilvGraphic instanceof ViewBandDomainGrapher || ilvGraphic instanceof AbstractViewLink) {
            uPopupMenu.addSeparator();
            this.nodeFv.onInitPopupMenu(ilvGraphic, uPopupMenu);
        }
    }

    public void doubleClicked() {
        FunctNetMapNode functNetMapNode = (FunctNetMapNode)this.getCollapsedGraphic();
        IFvNetNode iFvNetNode = (IFvNetNode)functNetMapNode.getUserObject();
        if (iFvNetNode.isInited() && this.getOwner() instanceof MapGrapherNode && this.isCollapsed()) {
            this.doOpenNodeFv();
        }
    }

    public void secondaryDoubleClicked(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof ViewCardGrapher || ilvGraphic instanceof ViewBandDomainGrapher) {
            this.nodeFv.doubleClicked(ilvGraphic);
        } else {
            this.doubleClicked();
        }
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        FunctNetMapNode functNetMapNode = (FunctNetMapNode)this.getCollapsedGraphic();
        IFvNetNode iFvNetNode = (IFvNetNode)functNetMapNode.getUserObject();
        if (iFvNetNode.isInited()) {
            if (this.isCollapsed()) {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_GOTO_NODE_FV, 79);
            } else {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_CLOSE_NODE_FV, 78);
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_DOUBLE_UP, 85);
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_DOUBLE_DOWN, 68);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_GOTO_NODE_FV) {
            this.doOpenNodeFv();
        } else if (string == CMD_CLOSE_NODE_FV) {
            this.doGoToNormalNetworkView();
        } else if (string == CMD_DOUBLE_UP) {
            this.nodeZoom(2.0);
        } else if (string == CMD_DOUBLE_DOWN) {
            this.nodeZoom(0.5);
        }
    }

    public double nodeZoom(double d) {
        if (this.nodeFv == null) {
            return 1.0;
        }
        IlvGraphicBag ilvGraphicBag = this.nodeFv.getGraph().getGraphicBag();
        ilvGraphicBag.applyToObject((IlvGraphic)this.nodeFv.getGraph(), new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvPoint ilvPoint = ilvGraphic.getCenter(null);
                Double d = (Double)object;
                IlvTransformer ilvTransformer = new IlvTransformer();
                ilvTransformer.scale((double)ilvPoint.x, (double)ilvPoint.y, d.doubleValue(), d.doubleValue());
                ilvGraphic.applyTransform(ilvTransformer);
            }
        }, (Object)d, true);
        double d2 = this.nodeFv.setNodeZoom(d);
        Collection collection = this.nodeFv.getGraphChildren().values();
        IViewGraph iViewGraph2 = null;
        for (IViewGraph iViewGraph2 : collection) {
            if (!(iViewGraph2 instanceof ViewDomainGrapher)) continue;
            ((ViewDomainGrapher)iViewGraph2).setNodeZoom(d);
        }
        return d2;
    }

    private void doGoToNormalNetworkView() {
        if (this.node != null) {
            this.connectionObserver.removeNode(this.node);
            this.setViewCollapsed(true);
            FunctViewManagerDelegate.getInstance().nodeChange(this.node, 1);
            if (!this.removedOnDisconnection) {
                this.updateLinks();
            }
            if (this.nodeFv != null) {
                this.nodeFv.closeNFV();
            }
            this.node.setNodeFv(null);
            IFvNetNode iFvNetNode = (IFvNetNode)this.node.getUserObject();
            iFvNetNode.setOpen(false);
        }
        this.removeInterLink(true);
    }

    private void updateLinks() {
        boolean bl = true;
        LinkedList<InterGraphLink> linkedList = this.mtk.getInterGraphLinks();
        MapNode mapNode = (MapNode)this.getCollapsedGraphic();
        IFvNetNode iFvNetNode = (IFvNetNode)mapNode.getUserObject();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            MapLinkBundle mapLinkBundle;
            InterGraphLink interGraphLink = (InterGraphLink)iterator.next();
            if (!(interGraphLink.getActualNetLink() instanceof MapLink)) continue;
            MapLink mapLink = (MapLink)interGraphLink.getActualNetLink();
            IFvNetLink iFvNetLink = (IFvNetLink)mapLink.getUserObject();
            IFvNetNode iFvNetNode2 = iFvNetLink.getSource().getNetworkNode();
            IFvNetNode iFvNetNode3 = iFvNetLink.getDestination().getNetworkNode();
            if (!iFvNetNode2.equals(iFvNetNode) && !iFvNetNode3.equals(iFvNetNode)) continue;
            if (!iFvNetNode2.isFVActive() && !iFvNetNode3.isFVActive()) {
                interGraphLink.setLinkVisible(false);
                iterator.remove();
                mapLink.setLinkVisible(true);
                mapLinkBundle = ((FvMapToolkit)this.mtk).getCollapsedLinkBundle(mapLink);
                if (mapLinkBundle.getBundleState() != 1) continue;
                mapLinkBundle.setLinkVisible(true);
                continue;
            }
            if (interGraphLink.getFrom() instanceof ViewCardGrapher || interGraphLink.getTo() instanceof ViewCardGrapher) {
                mapLink.setLinkVisible(false);
                mapLinkBundle = ((FvMapToolkit)this.mtk).getCollapsedLinkBundle(mapLink);
                if (mapLinkBundle.getBundleState() == 1) {
                    mapLinkBundle.setLinkVisible(false);
                }
                interGraphLink.setLinkVisible(true);
                continue;
            }
            if (!iFvNetNode2.isFVActive() || !iFvNetNode3.isFVActive() || !(interGraphLink.getFrom() instanceof FvMapGraph) && !(interGraphLink.getFrom() instanceof FvMapGraph)) continue;
            bl = false;
        }
        if (!bl) {
            this.createLineCardConnection();
        }
    }

    private void doOpenNodeFv() {
        Object object;
        if (this.fd.on()) {
            circuitDbgtime = System.currentTimeMillis();
        }
        FunctViewManagerDelegate.getInstance().setMousePointer(3);
        boolean bl = true;
        this.node = (FunctNetMapNode)this.getCollapsedGraphic();
        Object object2 = this.node.getUserObject();
        IFvNodeModel iFvNodeModel = null;
        IFvNetNode iFvNetNode = null;
        if (object2 instanceof IFvNetNode) {
            iFvNetNode = (IFvNetNode)object2;
            try {
                iFvNodeModel = iFvNetNode.getFvDelegate();
            }
            catch (InvalidNodeId invalidNodeId) {
                CerentDialog.infoDialog((Component)((Object)this.mtk), (String)"The Node Does not support the Network Functionl View.\n Open its Functional View fron the Node View.", (String)"Cannot Open Node FV");
                return;
            }
        } else {
            return;
        }
        if (!FunctOpenHelper.isFVSupported(iFvNodeModel)) {
            return;
        }
        this.deleteCache();
        this.connectionObserver.addNode(this.node, iFvNetNode);
        if (this.nodeFv == null) {
            if (this.fd.on()) {
                this.fd.println("start Open Node (" + iFvNetNode.getName() + ") " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            }
            if (!this.removedOnDisconnection) {
                this.calculateSidesPositions();
                this.sidesRePositioned = this.sidesPosCalculated.size();
            } else {
                this.sidePos = this.sidePosOnRes;
            }
            object = new SidePositionInNtw(this.sidePos, this.sidesRePositioned);
            this.nodeFv = (ViewManagerToolKit)iFvNetNode.getNodeFv((IFvNetSidePosition)object);
            if (this.nodeFv != null) {
                this.nodeFv.setKeepingAspectRatio(false);
                bl = false;
                if (this.fd.on()) {
                    this.fd.println("end Open Node (" + iFvNetNode.getName() + ") " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
                }
            }
        }
        if (this.nodeFv != null) {
            this.node.setNodeFv(this.nodeFv);
            this.setCollapsedObject((IlvGraphic)this.nodeFv.getGraph(), true, false, bl);
            if (!bl) {
                object = this.createLineCardConnection();
                if (this.fd.on()) {
                    this.fd.println("after inergraph  (" + iFvNetNode.getName() + ") " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
                }
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    if (((ViewPortGraphic)((ArrayList)object).get(i)).getPowerBalloon() == null) continue;
                    ((ArrayList)object).remove(i);
                    --i;
                }
                this.nodeFv.attachLinePortBalloon((ArrayList)object);
                if (this.fd.on()) {
                    this.fd.println("after baloon (" + iFvNetNode.getName() + ") " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
                }
            } else {
                this.updateLinks();
            }
            FunctViewManagerDelegate.getInstance().nodeChange(this.node, 0);
            if (this.fd.on()) {
                this.fd.println("after notify (" + iFvNetNode.getName() + ") " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            }
            this.nodeFv.setKeepingAspectRatio(true);
            FunctViewManagerDelegate.getInstance().setMousePointer(0);
            if (this.fd.on()) {
                this.fd.println("exit from doOpenNodeFv (" + iFvNetNode.getName() + ") " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            }
            this.nodeFv.transformerChanged(null);
            if (this.fd.on()) {
                this.fd.println("after TranformerChanged (" + iFvNetNode.getName() + ") " + (System.currentTimeMillis() - circuitDbgtime) + "mSec.");
            }
            iFvNetNode.setOpen(true);
        } else {
            CerentDialog.infoDialog((Component)((Object)this.mtk), (String)"The Node probably has no internal patchcords.\nSo Node FV couldn't be opened.", (String)"Cannot Open Node FV");
        }
    }

    private void deleteCache() {
        boolean bl = false;
        if (this.nodeFv != null) {
            try {
                this.removeNode((IlvGraphic)this.nodeFv.getGraph(), false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            bl = true;
        }
        this.removeInterLink(bl);
        this.sidesPosCalculated.clear();
        this.cleanConnectedNodeSideInfo();
        this.sidePos = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.nodeFv = null;
    }

    private void removeInterLink(boolean bl) {
        for (int i = 0; i < this.interLinks.size(); ++i) {
            InterGraphLink interGraphLink = this.interLinks.get(i);
            if (bl && !interGraphLink.getFrom().equals(this) && !interGraphLink.getTo().equals(this)) continue;
            this.mtk.removeInterGraphLink(interGraphLink);
        }
        this.interLinks.clear();
    }

    public void interLinkAdded(InterGraphLink interGraphLink) {
        this.interLinks.add(interGraphLink);
    }

    private ArrayList<IlvGraphic> createLineCardConnection() {
        ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
        try {
            if (this.nodeFv != null) {
                IFvSideModel[] iFvSideModelArray = this.nodeFv.getSides();
                IFvNodeModel iFvNodeModel = this.nodeFv.getNodeModel();
                for (int i = 0; i < this.connectedLinks.size(); ++i) {
                    IFvEntityModel iFvEntityModel;
                    IFvEntityModel iFvEntityModel2;
                    MapLink mapLink = (MapLink)this.connectedLinks.get(i);
                    int n = -1;
                    int n2 = -1;
                    IFvEntityModel[] iFvEntityModelArray = null;
                    IFvSideModel iFvSideModel = null;
                    IFvNetNode iFvNetNode = null;
                    FvMapGraph fvMapGraph = null;
                    boolean bl = true;
                    IFvNetLink iFvNetLink = (IFvNetLink)mapLink.getUserObject();
                    if (iFvNetLink instanceof IFvVirtualLink) {
                        iFvEntityModel2 = iFvNetLink.getTheLinkModel().getTheEndEntityModel(true);
                        iFvEntityModel = iFvNetLink.getReverseLink().getTheLinkModel().getTheEndEntityModel(true);
                        if (iFvEntityModel2 instanceof IFvDwdmPortModel || iFvEntityModel instanceof IFvDwdmPortModel) {
                            iFvEntityModelArray = this.TrunkToFilter(iFvEntityModel2, iFvEntityModel);
                        }
                    }
                    if (((Object)((Object)mapLink.getSource().getChildGrapher())).equals(this)) {
                        iFvEntityModel2 = iFvNetLink.getTheLinkModel().getTheEndEntityModel(true);
                        n = iFvEntityModel2.getSide();
                        if (iFvNetLink.getLinkType() == 6) {
                            n2 = iFvNetLink.getTheLinkModel().getDstEntityIndex() == 0 ? iFvNetLink.getReverseLink().getTheLinkModel().getTheEndEntityModel(true).getSide() : iFvNetLink.getTheLinkModel().getTheEndEntityModel(false).getSide();
                        } else {
                            iFvEntityModel = iFvNetLink.getTheLinkModel().getTheEndEntityModel(false);
                            n2 = iFvEntityModel.getSide();
                        }
                        iFvNetNode = iFvNetLink.getDestination().getNetworkNode();
                        fvMapGraph = (FvMapGraph)mapLink.getDst().getChildGrapher();
                    } else {
                        iFvEntityModel2 = iFvNetLink.getTheLinkModel().getTheEndEntityModel(true);
                        n2 = iFvEntityModel2.getSide();
                        iFvNetNode = iFvNetLink.getSource().getNetworkNode();
                        fvMapGraph = (FvMapGraph)mapLink.getSrc().getChildGrapher();
                        if (iFvNetLink.getLinkType() == 6) {
                            n = iFvNetLink.getTheLinkModel().getDstEntityIndex() == 0 ? iFvNetLink.getReverseLink().getTheLinkModel().getTheEndEntityModel(true).getSide() : iFvNetLink.getTheLinkModel().getTheEndEntityModel(false).getSide();
                        } else {
                            iFvEntityModel = iFvNetLink.getTheLinkModel().getTheEndEntityModel(false);
                            n = iFvEntityModel.getSide();
                        }
                        bl = false;
                    }
                    for (int j = 0; j < iFvSideModelArray.length; ++j) {
                        if (iFvSideModelArray[j].getId() != n) continue;
                        iFvSideModel = iFvSideModelArray[j];
                        break;
                    }
                    if (iFvSideModel == null) {
                        return arrayList;
                    }
                    iFvEntityModel2 = this.nodeFv.getSideDomain(iFvSideModel.getNameLabel());
                    int n3 = iFvSideModel.getRole();
                    if (iFvEntityModel2 == null) {
                        iFvEntityModel2 = this.findRootSide(this.nodeFv.getNodeModel(), iFvSideModel, iFvSideModelArray);
                        n3 = 3;
                    }
                    ViewPortGraphic[] viewPortGraphicArray = iFvEntityModel2.getLineCardPort(true, n3);
                    ViewPortGraphic[] viewPortGraphicArray2 = iFvEntityModel2.getLineCardPort(false, n3);
                    int n4 = -1;
                    int n5 = -1;
                    if (bl) {
                        n4 = n;
                        n5 = n2;
                    } else {
                        n4 = n2;
                        n5 = n;
                    }
                    AbstractNetLink abstractNetLink = (AbstractNetLink)mapLink.getUserObject();
                    int n6 = 0;
                    int n7 = -1;
                    ViewPortGraphic viewPortGraphic = null;
                    if (iFvNodeModel.getName() == abstractNetLink.getSource().getNetworkNode().getName()) {
                        for (ViewPortGraphic viewPortGraphic2 : viewPortGraphicArray) {
                            if (abstractNetLink.getSrcEntityIndex() == viewPortGraphic2.getPortModel().getIndex()) {
                                viewPortGraphic = viewPortGraphic2;
                                n7 = n6;
                                break;
                            }
                            ++n6;
                        }
                    }
                    if (iFvNodeModel.getName() == abstractNetLink.getDestination().getNetworkNode().getName()) {
                        n6 = 0;
                        for (ViewPortGraphic viewPortGraphic3 : viewPortGraphicArray2) {
                            if (abstractNetLink.getDstEntityIndex() == viewPortGraphic3.getPortModel().getIndex()) {
                                viewPortGraphic = viewPortGraphic3;
                                n7 = n6;
                                break;
                            }
                            ++n6;
                        }
                    }
                    Object object3 = null;
                    if (n7 == -1 && iFvEntityModelArray == null) continue;
                    InterGraphLink[] interGraphLinkArray = null;
                    ViewPortGraphic[] viewPortGraphicArray3 = new ViewPortGraphic[2];
                    if (n7 != -1) {
                        viewPortGraphicArray3[0] = viewPortGraphicArray[n7];
                        viewPortGraphicArray3[1] = viewPortGraphicArray2[n7];
                    } else if (iFvEntityModelArray != null) {
                        this.getNotInSideGraphPort(viewPortGraphicArray3, iFvEntityModelArray);
                    }
                    interGraphLinkArray = this.createInterGrapCouple(viewPortGraphicArray3[0], viewPortGraphicArray3[1], mapLink, n, n4, n5, fvMapGraph, iFvNetNode, bl, arrayList, iFvEntityModelArray);
                    if (interGraphLinkArray == null) continue;
                    object3 = new LinkedSideInfo(fvMapGraph, n2, viewPortGraphicArray3[1], viewPortGraphicArray3[0]);
                    if (interGraphLinkArray[0] != null) {
                        ((LinkedSideInfo)object3).addLink(interGraphLinkArray[0]);
                    }
                    if (interGraphLinkArray[1] != null) {
                        ((LinkedSideInfo)object3).addLink(interGraphLinkArray[1]);
                    }
                    this.addLinkedSideInfo((LinkedSideInfo)object3);
                    this.mtk.reDrawViews();
                    mapLink.setLinkVisible(false);
                    MapLinkBundle mapLinkBundle = ((FvMapToolkit)this.mtk).getCollapsedLinkBundle(mapLink);
                    if (mapLinkBundle.getBundleState() != 1) continue;
                    mapLinkBundle.setLinkVisible(false);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private void getNotInSideGraphPort(ViewPortGraphic[] viewPortGraphicArray, IFvEntityModel[] iFvEntityModelArray) {
        try {
            ViewPortGraphic viewPortGraphic = null;
            ViewCardGrapher viewCardGrapher = (ViewCardGrapher)ViewCardHelper.getGraphCardByIndex((int)iFvEntityModelArray[0].getParentModel().getIndex(), (ViewManagerToolKit)this.nodeFv);
            Collection collection = viewCardGrapher.getGraphChildren().values();
            for (IViewGraph iViewGraph : collection) {
                if (!(iViewGraph instanceof ViewPortGraphic) || !(viewPortGraphic = (ViewPortGraphic)iViewGraph).hasIndex(iFvEntityModelArray[0].getIndex())) continue;
                viewPortGraphicArray[0] = viewPortGraphic;
                break;
            }
            viewPortGraphic = null;
            viewCardGrapher = (ViewCardGrapher)ViewCardHelper.getGraphCardByIndex((int)iFvEntityModelArray[1].getParentModel().getIndex(), (ViewManagerToolKit)this.nodeFv);
            collection = viewCardGrapher.getGraphChildren().values();
            for (IViewGraph iViewGraph : collection) {
                if (!(iViewGraph instanceof ViewPortGraphic) || !(viewPortGraphic = (ViewPortGraphic)iViewGraph).hasIndex(iFvEntityModelArray[1].getIndex())) continue;
                viewPortGraphicArray[1] = viewPortGraphic;
                break;
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    private IFvEntityModel[] TrunkToFilter(IFvEntityModel iFvEntityModel, IFvEntityModel iFvEntityModel2) {
        IFvEntityModel[] iFvEntityModelArray = new IFvEntityModel[2];
        if (iFvEntityModel instanceof IFvDwdmPortModel) {
            iFvEntityModelArray[0] = iFvEntityModel2;
        }
        if (iFvEntityModel2 instanceof IFvDwdmPortModel) {
            iFvEntityModelArray[0] = iFvEntityModel;
        }
        if (iFvEntityModelArray[0] != null) {
            iFvEntityModelArray[1] = PPCHelper.getReversePorts((IEntityModel)iFvEntityModelArray[0])[0];
        }
        return iFvEntityModelArray;
    }

    private InterGraphLink[] createInterGrapCouple(ViewPortGraphic viewPortGraphic, ViewPortGraphic viewPortGraphic2, MapLink mapLink, int n, int n2, int n3, FvMapGraph fvMapGraph, IFvNetNode iFvNetNode, boolean bl, ArrayList<IlvGraphic> arrayList, IFvEntityModel[] iFvEntityModelArray) {
        InterGraphLink[] interGraphLinkArray = new InterGraphLink[2];
        if (viewPortGraphic == null || viewPortGraphic2 == null) {
            return null;
        }
        interGraphLinkArray[0] = this.mtk.createInterGraphLinks((IlvGraphic)viewPortGraphic, this.getOtherSideOfLink(this, n, fvMapGraph, iFvNetNode.isFVActive(), mapLink, true), mapLink, n2, n3, bl, true, arrayList);
        interGraphLinkArray[1] = this.mtk.createInterGraphLinks(this.getOtherSideOfLink(this, n, fvMapGraph, iFvNetNode.isFVActive(), mapLink, false), (IlvGraphic)viewPortGraphic2, mapLink, n3, n2, bl, false, arrayList);
        return interGraphLinkArray;
    }

    private ViewDomainGrapher findRootSide(IFvNodeModel iFvNodeModel, IFvSideModel iFvSideModel, IFvSideModel[] iFvSideModelArray) {
        int[] nArray;
        for (int n : nArray = iFvSideModel.getLinesIn()) {
            IFvEntityModel iFvEntityModel = iFvNodeModel.getEntityModelByIndex(n).getParentModel();
            if (iFvEntityModel.getEqType() == 249) {
                IFvOpticsCardModel iFvOpticsCardModel = (IFvOpticsCardModel)iFvEntityModel;
                IFvOpticsLineModel[] iFvOpticsLineModelArray = iFvOpticsCardModel.getComTxLineModels();
                try {
                    int n2 = iFvOpticsLineModelArray[0].getSide();
                    for (int i = 0; i < iFvSideModelArray.length; ++i) {
                        IFvSideModel iFvSideModel2 = iFvSideModelArray[i];
                        if (iFvSideModel2 == iFvSideModel || n2 != iFvSideModel2.getId()) continue;
                        return this.nodeFv.getSideDomain(iFvSideModel2.getNameLabel());
                    }
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    wrongInterfaceType.printStackTrace();
                    continue;
                }
                catch (InternalCommError internalCommError) {
                    internalCommError.printStackTrace();
                    continue;
                }
            }
            return null;
        }
        return null;
    }

    private void calculateSidesPositions() {
        double d = this.boundingBox(this.mtk.getGraph().getTransformer()).getCenterX();
        double d2 = this.boundingBox(this.mtk.getGraph().getTransformer()).getCenterY();
        for (int i = 0; i < this.connectedLinks.size(); ++i) {
            int n;
            MapLink mapLink = (MapLink)this.connectedLinks.get(i);
            FvMapGraph fvMapGraph = null;
            boolean bl = false;
            if (mapLink.getFrom().equals(this)) {
                fvMapGraph = (FvMapGraph)mapLink.getTo();
                bl = true;
            } else {
                fvMapGraph = (FvMapGraph)mapLink.getFrom();
            }
            if (fvMapGraph == null) continue;
            IFvNetLink iFvNetLink = (IFvNetLink)mapLink.getUserObject();
            if (bl) {
                IFvEntityModel iFvEntityModel = iFvNetLink.getTheLinkModel().getTheEndEntityModel(true);
                n = iFvEntityModel.getSide();
            } else if (iFvNetLink.getLinkType() == 6) {
                n = iFvNetLink.getTheLinkModel().getDstEntityIndex() == 0 ? iFvNetLink.getReverseLink().getTheLinkModel().getTheEndEntityModel(true).getSide() : iFvNetLink.getTheLinkModel().getTheEndEntityModel(false).getSide();
            } else {
                IFvEntityModel iFvEntityModel = iFvNetLink.getTheLinkModel().getTheEndEntityModel(false);
                n = iFvEntityModel.getSide();
            }
            n = DwdmSide.getSideLabelFromId(n);
            if (n <= 0) continue;
            double d3 = fvMapGraph.boundingBox(this.mtk.getGraph().getTransformer()).getCenterX();
            double d4 = fvMapGraph.boundingBox(this.mtk.getGraph().getTransformer()).getCenterY();
            double d5 = Math.atan(-(d4 - d2) / (d3 - d));
            if (d3 < d) {
                d5 += Math.PI;
            }
            boolean bl2 = true;
            Iterator<Integer> iterator = this.sidesPosCalculated.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != n) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            int n2 = this.findSectorPosition(d5);
            int n3 = this.sidePos[n2 - 1];
            int n4 = this.getCurrentPositionOfSide(n);
            this.sidePos[n2 - 1] = n;
            this.sidePos[n4] = n3;
            this.sectorPosForSide.put(new Integer(n2), new Integer(n));
            this.sidesPosCalculated.add(new Integer(n));
        }
    }

    private int getCurrentPositionOfSide(int n) {
        for (int i = 0; i < this.sidePos.length; ++i) {
            if (this.sidePos[i] != n) continue;
            return i;
        }
        return 0;
    }

    private int findSectorPosition(double d) {
        int n = 3;
        if (d >= 0.7853981633974483 && d < 1.5707963267948966) {
            n = 2;
        } else if (d >= 1.5707963267948966 && d < 2.356194490192345) {
            n = 1;
        } else if (d >= 2.356194490192345 && d < Math.PI) {
            n = 8;
        } else if (d > -0.7853981633974483 && d <= 0.0) {
            n = 4;
        } else if (d > -1.5707963267948966 && d <= -0.7853981633974483) {
            n = 5;
        } else if (d >= 3.9269908169872414 && d < 4.71238898038469) {
            n = 6;
        } else if (d >= Math.PI && d < 3.9269908169872414) {
            n = 7;
        }
        Set<Integer> set = this.sectorPosForSide.keySet();
        Iterator<Integer> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != n) continue;
            n = this.getCloserSectorPosition(n, d);
            break;
        }
        return n;
    }

    private int getCloserSectorPosition(int n, double d) {
        int n2 = 1;
        boolean bl = true;
        if (n == 2) {
            if (Math.abs(d - 0.7853981633974483) < Math.abs(d - 1.5707963267948966)) {
                bl = false;
            }
        } else if (n == 1) {
            if (Math.abs(d - 1.5707963267948966) < Math.abs(d - 2.356194490192345)) {
                bl = false;
            }
        } else if (n == 8) {
            if (Math.abs(d - 2.356194490192345) < Math.abs(d - Math.PI)) {
                bl = false;
            }
        } else if (n == 7) {
            if (Math.abs(d - -Math.PI) < Math.abs(d - -2.356194490192345)) {
                bl = false;
            }
        } else if (n == 6) {
            if (Math.abs(d - -2.356194490192345) < Math.abs(d - -1.5707963267948966)) {
                bl = false;
            }
        } else if (n == 5) {
            if (Math.abs(d - -1.5707963267948966) < Math.abs(d - -0.7853981633974483)) {
                bl = false;
            }
        } else if (n == 4) {
            if (Math.abs(d - -0.7853981633974483) < Math.abs(d)) {
                bl = false;
            }
        } else if (n == 3 && Math.abs(d) < Math.abs(d - 0.7853981633974483)) {
            bl = false;
        }
        if ((n2 = bl ? n - 1 : n + 1) == 9) {
            n2 = 1;
        }
        if (n2 == 0) {
            n2 = 8;
        }
        return n2;
    }

    @Override
    public void setBackgroundImage(String string) {
    }

    @Override
    public void setBackgroundImage(URL uRL) {
    }

    public void goBackToNetworkFv() {
        FunctionalNetworkDialog functionalNetworkDialog = FunctionalNetworkDialog.getInstance();
        functionalNetworkDialog.updateGraph(this.mtk.getGraphWindow());
        if (this.nodeFv != null) {
            this.nodeFv.getViewManager().getViewTk().updateAngle(false);
            this.nodeFv.collapseMPOs();
        }
    }

    public void setBackground(Color color) {
        this.bgColor = color;
        super.setBackground(this.bgColor);
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.bgColor != null) {
            graphics.setColor(this.bgColor);
        }
        super.draw(graphics, ilvTransformer);
    }

    public void removeNodeFv() {
        if (this.nodeFv != null) {
            this.removedOnDisconnection = true;
            this.sidePosOnRes = this.sidePos;
            this.sidesRePositioned = this.sidesPosCalculated.size();
            this.doGoToNormalNetworkView();
        }
    }

    public void restoreNodeFv() {
        if (this.removedOnDisconnection) {
            this.doOpenNodeFv();
            this.removedOnDisconnection = false;
        }
    }

    public void setBackGroundForSides(Color color) {
        if (this.nodeFv != null) {
            Collection collection = this.nodeFv.getGraphChildren().values();
            for (IViewGraph iViewGraph : collection) {
                if (!(iViewGraph instanceof ViewDomainGrapher)) continue;
                IlvDefaultManagerFrame ilvDefaultManagerFrame = (IlvDefaultManagerFrame)((ViewDomainGrapher)iViewGraph).getFrame();
                ilvDefaultManagerFrame.setBackground((Paint)color);
                ((ViewDomainGrapher)iViewGraph).reDraw();
            }
        }
    }

    public String getNodeName() {
        if (this.node == null) {
            return "";
        }
        IFvNetNode iFvNetNode = (IFvNetNode)this.node.getUserObject();
        return iFvNetNode.getName();
    }

    public IFvNetNode getNode() {
        return (IFvNetNode)this.node.getUserObject();
    }

    public void keyStroke(boolean bl) {
        if (bl) {
            this.keyStroked = true;
            this.setBackGroundForSides(INfvGraphicalValue.SOLID_NODE);
            this.nodeZoom(2.0);
            this.previousLayer = FvNetworkMap.getInstance().getRootGraph().changeLayer(10, this);
        } else {
            if (this.nodeFv != null && !this.nodeFv.isFVClose() && this.keyStroked) {
                this.setBackGroundForSides(INfvGraphicalValue.TRANSPARENT_NODE);
                this.nodeZoom(0.5);
                FvNetworkMap.getInstance().getRootGraph().changeLayer(this.previousLayer, this);
            }
            this.keyStroked = false;
        }
    }

    protected void setCollapsedObject(IlvGraphic ilvGraphic, boolean bl, final boolean bl2, final boolean bl3) {
        final IlvGraphic ilvGraphic2 = ilvGraphic;
        this.graph = this;
        this.getGraphicBag().applyToObject((IlvGraphic)this, new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvRect ilvRect = FvMapGraph.this.graph.boundingBox();
                FvMapGraph.this.setCollapsed(bl2);
                if (bl2) {
                    FvMapGraph.this.graph.setCollapsedGraphic(ilvGraphic2);
                    FvMapGraph.this.setMovable(true);
                } else if (!bl3) {
                    IlvGraphic ilvGraphic22 = ilvGraphic2;
                    double d = ilvGraphic22.boundingBox().getWidth();
                    double d2 = ilvGraphic22.boundingBox().getHeight();
                    ilvGraphic22.resize((float)((int)d / 6), (float)((int)d2 / 6));
                    FvMapGraph.this.addNode(ilvGraphic22, false);
                    ilvGraphic22.setMovable(true);
                    FvMapGraph.this.collapsedNodeX = ilvRect.getX();
                    FvMapGraph.this.collapsedNodeY = ilvRect.getY();
                    if (ilvGraphic22 instanceof IlvGrapher) {
                        IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphic22;
                        IlvGraphicBag ilvGraphicBag = ilvGrapher.getGraphicBag();
                        if (ilvGraphicBag == null) {
                            ilvGrapher.setFrame(null);
                        } else {
                            ilvGraphicBag.applyToObject((IlvGraphic)ilvGrapher, new IlvApplyObject(){

                                public void apply(IlvGraphic ilvGraphic, Object object) {
                                    ((IlvGrapher)object).setFrame(null);
                                }
                            }, (Object)ilvGrapher, false);
                        }
                        FvMapGraph.this.setBackGroundForSides((IlvGrapher)ilvGraphic22, INfvGraphicalValue.TRANSPARENT_NODE);
                        FvMapGraph.this.addTransformerListenerForSides((IlvGrapher)ilvGraphic22);
                        ilvGraphic22.reDraw();
                    }
                    FvMapGraph.this.resize((int)d / 6, (int)d2 / 6);
                    FvMapGraph.this.setFrame(null);
                    FvMapGraph.this.reDraw();
                    MapObjectAdapter.setCenter(FvMapGraph.this.mtk.getGraph(), (IlvGraphic)FvMapGraph.this, FvMapGraph.this.collapsedNodeX, FvMapGraph.this.collapsedNodeY);
                } else if (bl3) {
                    // empty if block
                }
                FvMapGraph.this.graph.setVisible(true);
            }
        }, null, true);
    }

    private void setBackGroundForSides(IlvGrapher ilvGrapher, Color color) {
        if (ilvGrapher instanceof ViewGrapher) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ((ViewGrapher)ilvGrapher).getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                if (!(ilvGraphic instanceof ViewDomainGrapher)) continue;
                IlvDefaultManagerFrame ilvDefaultManagerFrame = (IlvDefaultManagerFrame)((ViewDomainGrapher)ilvGraphic).getFrame();
                ilvDefaultManagerFrame.setOpaque(true);
                ilvDefaultManagerFrame.setBackground((Paint)color);
                ilvDefaultManagerFrame.setForeground(new Color(255, 255, 255, 0));
                ((ViewDomainGrapher)ilvGraphic).reDraw();
            }
        }
    }

    public void addTransformerListenerForSides(IlvGrapher ilvGrapher) {
        if (ilvGrapher instanceof ViewGrapher) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ((ViewGrapher)ilvGrapher).getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                if (!(ilvGraphic instanceof ViewDomainGrapher)) continue;
                this.mtk.addTransformerListener((TransformerListener)((ViewDomainGrapher)ilvGraphic));
                ((ViewDomainGrapher)ilvGraphic).setNtwZoom(this.mtk.getTransformer().zoomFactor());
            }
        }
    }

    public void applyNodeToGraph(AbstractNode abstractNode) {
        AbstractNode abstractNode2 = abstractNode;
        this.graph = this;
        abstractNode2.setChildGrapher(this.graph);
        this.node = (FunctNetMapNode)abstractNode;
        this.setCollapsedObject((IlvGraphic)abstractNode2, false, true, false);
    }

    public void setViewCollapsed(final boolean bl) {
        this.getGraphicBag().applyToObject((IlvGraphic)this, new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                FvMapGraph.this.setCollapsed(bl);
                if (FvMapGraph.this.collapsedNodeX != -1.0 && FvMapGraph.this.collapsedNodeY != -1.0) {
                    FvMapGraph.this.move((int)FvMapGraph.this.collapsedNodeX, (int)FvMapGraph.this.collapsedNodeY);
                    FvMapGraph.this.reDraw();
                }
            }
        }, null, true);
    }

    protected void initConnectorBag() {
        this.connectorBag = new IlvPinLinkConnector((IlvGraphic)this);
    }

    public IlvPinLinkConnector getLinkConnectorBag() {
        return this.connectorBag;
    }

    protected IlvGraphic getOtherSideOfLink(AbstractGraph abstractGraph, int n, AbstractGraph abstractGraph2, boolean bl, MapLink mapLink, boolean bl2) {
        if (bl) {
            LinkedSideInfo linkedSideInfo = ((FvMapGraph)abstractGraph2).getLinkedSideInfo(abstractGraph, n);
            if (linkedSideInfo != null) {
                ViewPortGraphic viewPortGraphic = bl2 ? linkedSideInfo.getLineRxPort() : linkedSideInfo.getLineTxPort();
                LinkedList<InterGraphLink> linkedList = linkedSideInfo.getAssociatedLinks();
                for (int i = 0; i < linkedList.size(); ++i) {
                    InterGraphLink interGraphLink = linkedList.get(i);
                    this.mtk.removeInterGraphLink(interGraphLink);
                }
                linkedSideInfo.clearTheAssociatedLinkList();
                return viewPortGraphic;
            }
            return abstractGraph2;
        }
        return abstractGraph2;
    }

    public void addLinkedSideInfo(LinkedSideInfo linkedSideInfo) {
        this.otherConnectedNodeSideInfo.add(linkedSideInfo);
    }

    public void deleteLinkedSideInfo(LinkedSideInfo linkedSideInfo) {
        this.otherConnectedNodeSideInfo.remove(linkedSideInfo);
    }

    public LinkedSideInfo getLinkedSideInfo(AbstractGraph abstractGraph, int n) {
        for (int i = 0; i < this.otherConnectedNodeSideInfo.size(); ++i) {
            LinkedSideInfo linkedSideInfo = this.otherConnectedNodeSideInfo.get(i);
            if (!((Object)((Object)linkedSideInfo.getOtherEnd())).equals((Object)abstractGraph) || linkedSideInfo.getOtherEndSideId() != n) continue;
            return linkedSideInfo;
        }
        return null;
    }

    protected void cleanConnectedNodeSideInfo() {
        this.otherConnectedNodeSideInfo.clear();
    }

    public void dispose() {
        if (this.nodeFv != null) {
            this.nodeFv.closeNFV();
        }
    }

    public void setCoordinates(double d, double d2, boolean bl) {
        double d3;
        double d4;
        block2: {
            block3: {
                d4 = this.mtk.clipWorldX(d);
                d3 = this.mtk.clipWorldY(d2);
                if (bl) break block2;
                if (d4 == 0.0) break block3;
                FvMapGraph fvMapGraph = this;
                if (d4 == (double)fvMapGraph.mtk.getCanvasWidth() || d3 == 0.0) break block3;
                FvMapGraph fvMapGraph2 = this;
                if (d3 != (double)fvMapGraph2.mtk.getCanvasHeight()) break block2;
            }
            FvMapGraph fvMapGraph = this;
            d4 = fvMapGraph.mtk.getCanvasCenterX();
            FvMapGraph fvMapGraph3 = this;
            d3 = fvMapGraph3.mtk.getCanvasCenterY();
        }
        this.setCenter(d4, d3);
    }

    public void setCenter(double d, double d2) {
        if (this.getParent() instanceof AbstractGraph) {
            MapObjectAdapter.setCenter((AbstractGraph)this.getParent(), (IlvGraphic)this, d, d2);
        }
    }

    public LinkedList<MapLink> getMapLinks() {
        return this.connectedLinks;
    }

    static {
        dbgDelete = false;
    }

    private class ConnectionObserver
    implements IObserver {
        HashMap<IFvNetNode, FunctNetMapNode> nodes = new HashMap();

        private ConnectionObserver() {
        }

        public void update(IObservable iObservable, Object object) {
            if (iObservable instanceof NodeModel.ConnectionNotifier) {
                NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)iObservable;
                NodeModel nodeModel = connectionNotifier.getNodeModel();
                FvMapGraph.this.node = this.nodes.get(nodeModel);
                if ((object == ModelUpdateType.CHANGED || object == ModelUpdateType.DELETED) && nodeModel.isFVActive()) {
                    FvMapGraph.this.doGoToNormalNetworkView();
                    FvMapGraph.this.nodeFv.closeNFV();
                }
            }
        }

        public void removeNode(FunctNetMapNode functNetMapNode) {
            this.nodes.remove((IFvNetNode)functNetMapNode.getUserObject());
        }

        public void addNode(FunctNetMapNode functNetMapNode, IFvNetNode iFvNetNode) {
            this.nodes.put(iFvNetNode, functNetMapNode);
            ((NodeModel)iFvNetNode).getConnectionNotifier().addObserver((IObserver)this);
        }
    }
}

