/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.gui;

import cerent.cms.fv.IFvEditDialog;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.network.MapPersist;
import cerent.util.DebugManager;
import cerent.util.IFvDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFrame;
import cerent.util.view.fv.IFunctDialog;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctDialog;
import cerent.util.view.fv.helper.FunctException;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.circuit.FVNetworkCircuitPanel;
import com.cisco.fv.circuit.model.FvCircuitModels;
import com.cisco.fv.grapher.FvNetMapFactory;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.circuit.FvNetworkCircuitPath;
import com.cisco.fv.grapher.util.FvStrokeHandle;
import com.cisco.fv.gui.FunctionalOverView;
import com.cisco.fv.gui.NfvMenuToolBar;
import ilog.views.swing.IlvJScrollManagerView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class FunctionalNetworkDialog
extends JFrame
implements IFvEditDialog,
WindowListener {
    private static final String FUNCTIONAL_VIEW_ICON = "/images/icons/CTC_icon.gif";
    private static final String DEBUG_INFORMATION_TITLE = "Debug Information ";
    private static FunctionalNetworkDialog _instance;
    JPanel parent;
    private JSplitPane graphAndSplitPane;
    private JSplitPane circuitAndOverviewPane;
    private JComponent graph;
    private SDebug dbg;
    private FvNetworkMap nm;
    private NfvMenuToolBar menuAndToolBar;
    private FVNetworkCircuitPanel netCircuitPane;
    private AbstractViewController avc;
    private ArrayList<JTable> allExportableTable;
    private String exportableTitle = "Debug Information ";
    private FunctViewManagerDelegate viewManager;
    private IUiToolkit uiToolkit;

    public IUiToolkit getUiToolkit() {
        return this.uiToolkit;
    }

    public FunctionalNetworkDialog(IUiToolkit iUiToolkit, AbstractViewController abstractViewController) {
        super("DWDM Network Functional View");
        this.avc = abstractViewController;
        this.uiToolkit = iUiToolkit;
        this.allExportableTable = new ArrayList();
        this.dbg = new SDebug("FunctionalNetworkDialog");
        FunctDebug.instance().init((IFvDebug)DebugManager.instance().getRoot());
        FunctDialog.init((IFunctDialog)new CerentDialog());
        this.initFV();
        URL uRL = UFrame.class.getResource(FUNCTIONAL_VIEW_ICON);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.setIconImage(image);
        Container container = this.getContentPane();
        Component component = this.getMainSplitPane();
        try {
            this.menuAndToolBar = new NfvMenuToolBar(this, container, component, this.graph);
            this.viewManager.addToolBar(this.menuAndToolBar);
        }
        catch (FunctException functException) {
            SDebug.printStackTrace((Throwable)functException);
        }
        this.setDefaultCloseOperation(2);
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.addWindowListener(this);
    }

    public static FunctionalNetworkDialog getInstance() {
        if (_instance != null) {
            return _instance;
        }
        return null;
    }

    private Component getMainSplitPane() {
        if (this.graphAndSplitPane == null) {
            this.graphAndSplitPane = new JSplitPane(1, this.getCircuitOverViewSplitPane(), this.graph);
            this.graphAndSplitPane.setOneTouchExpandable(true);
            this.graphAndSplitPane.setContinuousLayout(true);
            int n = Toolkit.getDefaultToolkit().getScreenSize().width * 30 / 100;
            this.graphAndSplitPane.setDividerLocation(n);
        }
        return this.graphAndSplitPane;
    }

    public void fitGraphView() {
        if (this.graph != null) {
            ((FvNetworkMap)((IlvJScrollManagerView)this.graph).getView()).fitView();
        }
    }

    public void updateGraph(Component component) {
        this.graphAndSplitPane.setRightComponent(component);
        this.graphAndSplitPane.updateUI();
    }

    private Component getCircuitOverViewSplitPane() {
        if (this.circuitAndOverviewPane == null) {
            this.netCircuitPane = new FVNetworkCircuitPanel(this.uiToolkit, this);
            try {
                this.netCircuitPane.setShowing(true);
            }
            catch (AbstractLeavePageException abstractLeavePageException) {
                SDebug.printStackTrace((Throwable)abstractLeavePageException);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            FunctionalOverView functionalOverView = new FunctionalOverView((Component)((Object)this.nm));
            this.circuitAndOverviewPane = new JSplitPane(0, (Component)((Object)this.netCircuitPane), (Component)((Object)functionalOverView));
            this.circuitAndOverviewPane.setOneTouchExpandable(true);
            this.circuitAndOverviewPane.setContinuousLayout(true);
            int n = Toolkit.getDefaultToolkit().getScreenSize().height * 70 / 100;
            this.circuitAndOverviewPane.setDividerLocation(n);
        }
        return this.circuitAndOverviewPane;
    }

    public static FunctionalNetworkDialog instance(IUiToolkit iUiToolkit, AbstractViewController abstractViewController) {
        if (_instance == null) {
            _instance = new FunctionalNetworkDialog(iUiToolkit, abstractViewController);
        }
        return _instance;
    }

    public static FunctionalNetworkDialog instance() {
        return _instance;
    }

    private void initFV() {
        try {
            this.nm = new FvNetworkMap((IFvDebug)this.dbg, 2, FvNetMapFactory.instance(), Network.instance(), VirtualLinksDirector.instance(), new MapPersist());
            this.graph = this.nm.getGraphWindow();
            this.setKeyStroke();
            this.viewManager = FunctViewManagerDelegate.getInstance();
            this.viewManager.addNetworkMap(this.nm);
        }
        catch (RuntimeException runtimeException) {
            SDebug.printStackTrace((Throwable)runtimeException);
            runtimeException.printStackTrace();
        }
    }

    public JButton addToolbar(ActionListener actionListener, String string, String string2, Object object) {
        return null;
    }

    public Container getToolBar() {
        return null;
    }

    public void syncButton(String string, boolean bl) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public AbstractViewController getViewController() {
        return this.avc;
    }

    public void dispose() {
        super.dispose();
        _instance = null;
        this.netCircuitPane.destroy();
        FvCircuitModels.getInstance().dispose();
        FvNetworkCircuitPath.getInstance().dispose();
        FunctViewManagerDelegate.getInstance().dispose();
        this.nm.dispose();
        this.removeWindowListener(this);
        this.menuAndToolBar = null;
    }

    public JTable[] getExportableTables() {
        return this.allExportableTable.toArray(new JTable[0]);
    }

    public void addTableToExport(JTable jTable) {
        this.allExportableTable.add(jTable);
    }

    public void removeTableToExport(JTable jTable) {
        this.allExportableTable.remove(jTable);
    }

    public void removeTableToExport(JTable[] jTableArray) {
        for (int i = 0; i < jTableArray.length; ++i) {
            JTable jTable = jTableArray[i];
            this.removeTableToExport(jTable);
        }
        this.setExportableTitle(DEBUG_INFORMATION_TITLE);
    }

    public void addTableToExport(JTable[] jTableArray) {
        for (int i = 0; i < jTableArray.length; ++i) {
            JTable jTable = jTableArray[i];
            this.addTableToExport(jTable);
        }
    }

    public String getExportableTitle() {
        return this.exportableTitle;
    }

    public void setExportableTitle(String string) {
        this.exportableTitle = string;
    }

    private void setKeyStroke() {
        this.graph.getInputMap().put(KeyStroke.getKeyStroke(113, 0, true), "showNode");
        this.graph.getActionMap().put("showNode", new FvKeyStrokeAction());
    }

    public boolean isPortPowerVisible() {
        return this.viewManager.isPowerVisible();
    }

    private class FvKeyStrokeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            FvStrokeHandle.getInstance().pressed();
        }
    }
}

