/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.ActivatorPOA;
import org.jacorb.imrutility.imr.AlreadyRegistered;
import org.jacorb.imrutility.imr.CommandData;
import org.jacorb.imrutility.imr.CommandInfo;
import org.jacorb.imrutility.imr.NotFound;
import org.jacorb.imrutility.imr.POANameKey;
import org.jacorb.imrutility.imr.ServerName;
import org.jacorb.imrutility.imr.StartupFailed;
import org.jacorb.imrutility.imr.UnknownServer;
import org.jacorb.imrutility.imr.persistence.ActFilePersistence;
import org.jacorb.imrutility.imr.persistence.ActivatorData;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class ActivatorImpl
extends ActivatorPOA {
    private ActivatorData actData = null;
    private long id;
    private int heartbeat;
    private static String activatorIOR;
    private static ORB orb;
    private HashMap commands = new HashMap();
    private final Logger logger = Debug.getNamedLogger("jacorb.activator");
    private final ActFilePersistence persistence = new ActFilePersistence();
    protected static boolean newFile;

    public ActivatorImpl() throws InvalidName, AdapterInactive, InvalidPolicy, ServantAlreadyActive, FileNotFoundException, ServantNotActive, ObjectAlreadyActive, AdapterAlreadyExists, WrongPolicy {
        if (!newFile) {
            this.populateData();
        } else {
            this.actData = new ActivatorData();
        }
        Shutdown shutdownThread = new Shutdown();
        shutdownThread.setDaemon(true);
        shutdownThread.setName("Act Shutdown Thread");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        POA rootPOA = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
        rootPOA.the_POAManager().activate();
        Policy[] policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
        POA ActivatorPOA2 = rootPOA.create_POA("ActivatorPOA", rootPOA.the_POAManager(), policies);
        for (int i = 0; i < policies.length; ++i) {
            policies[i].destroy();
        }
        byte[] id = "imr_activator".getBytes();
        ActivatorPOA2.activate_object_with_id(id, this);
        PrintWriter pw = new PrintWriter(new FileOutputStream(new File(activatorIOR)));
        pw.println(orb.object_to_string(ActivatorPOA2.servant_to_reference(this)));
        pw.flush();
        pw.close();
        orb.run();
    }

    private void populateData() {
        this.actData = this.persistence.read();
        this.commands = this.actData.getCommands();
    }

    public void addCommand(CommandInfo cmd) throws AlreadyRegistered {
        new POANameKey();
        POANameKey[] keys = POANameKey.serverNameToKeys(cmd.name);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                if (this.commands.containsKey(keys[i])) {
                    throw new AlreadyRegistered(cmd.name);
                }
                CommandData cdata = new CommandData(cmd.cmd);
                this.commands.put(keys[i], cdata);
                this.actData.addCommand(keys[i], cdata);
                this.persistence.write(this.actData);
            }
        }
    }

    public void removeCommand(ServerName sname) throws NotFound {
        new POANameKey();
        POANameKey[] keys = POANameKey.serverNameToKeys(sname);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                if (!this.commands.containsKey(keys[i])) {
                    throw new NotFound("Command not found for " + keys[i].toString());
                }
                this.commands.remove(keys[i]);
                this.actData.removeCommand(keys[i]);
            }
        } else {
            throw new NotFound("Command not found");
        }
        this.persistence.write(this.actData);
    }

    public CommandInfo[] listCommands() {
        CommandInfo[] cmds = new CommandInfo[this.commands.size()];
        CommandInfo cinfo = null;
        Iterator iter = this.commands.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            POANameKey pnKey = (POANameKey)entry.getKey();
            CommandData rec = (CommandData)entry.getValue();
            ServerName sname = pnKey.keyToServerName();
            cmds[i] = cinfo = new CommandInfo(sname, rec.command);
            ++i;
        }
        return cmds;
    }

    public CommandInfo[] listPOACommands(ServerName sname) {
        CommandInfo cinfo = null;
        ArrayList<CommandInfo> alist = new ArrayList<CommandInfo>();
        new POANameKey();
        POANameKey[] keys = POANameKey.serverNameToKeys(sname);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                if (!this.commands.containsKey(keys[i])) continue;
                CommandData rec = (CommandData)this.commands.get(keys[i]);
                cinfo = new CommandInfo(keys[i].keyToServerName(), rec.command);
                alist.add(cinfo);
            }
        }
        CommandInfo[] cinfoArray = new CommandInfo[alist.size()];
        return alist.toArray(cinfoArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startServer(ServerName sname, boolean shared) throws UnknownServer, StartupFailed {
        new POANameKey();
        POANameKey[] keys = POANameKey.serverNameToKeys(sname);
        if (keys.length > 1) {
            throw new StartupFailed("Cannot start multiple POAS");
        }
        CommandData crec = (CommandData)this.commands.get(keys[0]);
        if (crec == null) throw new UnknownServer(sname);
        if (crec.getServerCount() != 0) throw new StartupFailed(keys[0].toString() + " :: Server already running");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Activator starting server " + keys[0].toString() + " and command " + crec.command);
        }
        crec.add();
        try {
            Runtime.getRuntime().exec(crec.command);
            return;
        }
        catch (Exception ex) {
            throw new StartupFailed("Failed to start server " + keys[0].toString() + " :: " + ex);
        }
    }

    public void serverStarted(ServerName sname) throws UnknownServer {
        new POANameKey();
        POANameKey[] keys = POANameKey.serverNameToKeys(sname);
        CommandData crec = (CommandData)this.commands.get(keys[0]);
        if (crec == null) {
            throw new UnknownServer(sname);
        }
        crec.remove();
    }

    public void ping(long id) {
    }

    public void shutdown(boolean wait) {
        this.persistence.backup(this.actData);
        orb.shutdown(wait);
    }

    public long id() {
        return this.id;
    }

    public void id(long id) {
        this.id = id;
    }

    public int heartbeat() {
        return this.heartbeat;
    }

    public void heartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public static void main(String[] args) {
        Properties props = null;
        String dataFile = null;
        System.setProperty("jacorb.implname", "imr_activator");
        System.setProperty("jacorb.use_imr", "off");
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h") || args[i].equals("--help")) {
                    ActivatorImpl.usage();
                }
                if (args[i].equals("-n") || args[i].equals("--act_new")) {
                    if (dataFile != null) {
                        System.out.println("New file not appropriate if data file specified");
                        System.exit(0);
                        continue;
                    }
                    newFile = true;
                    continue;
                }
                if (i < args.length - 1) {
                    if (args[i].equals("-i") || args[i].equals("-act_ior")) {
                        activatorIOR = args[++i];
                        continue;
                    }
                    if (args[i].equals("-f") || args[i].equals("--act_data")) {
                        if (newFile) {
                            System.out.println("Data file name not appropriate if new file specified");
                            System.exit(0);
                            continue;
                        }
                        dataFile = args[++i];
                        Environment.setProperty("jacorb.imr.act_data_file", dataFile);
                        continue;
                    }
                    if (!args[i].equals("-b") && !args[i].equals("--act_backup")) continue;
                    Environment.setProperty("jacorb.imr.act_backup_file", args[++i]);
                    continue;
                }
                ActivatorImpl.usage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ActivatorImpl.usage();
        }
        if (activatorIOR == null && (activatorIOR = Environment.getProperty("jacorb.imr.activator_ior_file")) == null) {
            System.out.println("IOR file name for Activator not known");
            ActivatorImpl.usage();
        }
        orb = ORB.init(args, props);
        try {
            new ActivatorImpl();
        }
        catch (Exception ex) {
            System.out.println("Exception starting the Activator");
            ex.printStackTrace();
        }
    }

    private static void usage() {
        String separator = "--------------------------------------------------------------";
        System.out.println(separator);
        System.out.println("Usage:                                                        ");
        System.out.println();
        System.out.println(" [ -i | --act_ior ] <filename> The filename for the IOR for   ");
        System.out.println("                               this Activator                 ");
        System.out.println(separator);
        System.out.println();
        System.out.println(" [ -f | --act_data ] <filename>The filename to be used for    ");
        System.out.println("                               data persistence for this      ");
        System.out.println("                               Activator                      ");
        System.out.println(separator);
        System.out.println("[ -b | --act_backup ] <filename> The filename in which the   ");
        System.out.println("                               Activator data is to be       ");
        System.out.println("                               backed up - if required       ");
        System.out.println(separator);
        System.out.println("[ -n | --act_new ]            If set a new file will be      ");
        System.out.println("                               created for the Activator data");
        System.out.println("                               - if not set data in any      ");
        System.out.println("                               existing file will be loaded  ");
        System.out.println(separator);
        System.out.println(" [ -h | --help ]               Displays this help             ");
        System.out.println(separator);
        System.exit(0);
    }

    protected class Shutdown
    extends Thread {
        protected Shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ActivatorImpl.this.logger.isDebugEnabled()) {
                ActivatorImpl.this.logger.info("ImR Activator: Shutting down");
            }
            Shutdown shutdown = this;
            synchronized (shutdown) {
                ActivatorImpl.this.shutdown(true);
            }
        }
    }
}

