/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.persistence;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jacorb.imrutility.imr.EndpointProfile;
import org.jacorb.imrutility.imr.ImplRecord;
import org.jacorb.imrutility.imr.POANameKey;
import org.jacorb.imrutility.imr.POARecord;
import org.jacorb.imrutility.imr.ServerRecord;
import org.jacorb.imrutility.imr.persistence.DataLock;

public class RepositoryData
implements Serializable {
    protected Map impls = Collections.synchronizedMap(new HashMap());
    protected Map servers = Collections.synchronizedMap(new HashMap());
    protected Map poas = Collections.synchronizedMap(new HashMap());
    protected transient DataLock lock;
    protected Map activators = Collections.synchronizedMap(new HashMap());

    public RepositoryData() {
        this.initTransient();
    }

    private void initTransient() {
        this.lock = new DataLock();
    }

    public void addServer(long sid, ServerRecord srec) {
        this.lock.getLock(0);
        this.servers.put(new Long(sid), srec);
        this.lock.releaseLock(0);
    }

    public void addImpl(POANameKey pnkey, ImplRecord irec) {
        this.lock.getLock(0);
        this.impls.put(pnkey, irec);
        this.lock.releaseLock(0);
    }

    public void addPOA(POANameKey pnkey, POARecord prec) {
        this.lock.getLock(0);
        if (this.poas.get(pnkey) == null) {
            HashSet<POARecord> set = new HashSet<POARecord>();
            set.add(prec);
            this.poas.put(pnkey, set);
        } else {
            ((HashSet)this.poas.get(pnkey)).add(prec);
        }
        this.lock.releaseLock(0);
    }

    public void replacePOA(POANameKey pnkey, POARecord prec) {
        this.lock.getLock(1);
        HashSet set = (HashSet)this.poas.get(pnkey);
        if (set != null) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                POARecord rec = (POARecord)iter.next();
                if (rec.getID() != prec.getID()) continue;
                rec = prec;
            }
        }
        this.lock.releaseLock(1);
    }

    public ImplRecord getImpl(POANameKey pnkey) {
        return (ImplRecord)this.impls.get(pnkey);
    }

    public Long[] getServerIDs(POANameKey pnkey) {
        return new Long[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointProfile[] getEndpoints(POANameKey pnkey, long serverID) {
        EndpointProfile[] endpoints = null;
        this.lock.getLock(1);
        Map map = this.poas;
        synchronized (map) {
            HashSet set = (HashSet)this.poas.get(pnkey);
            if (set != null) {
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    POARecord prec = (POARecord)iter.next();
                    if (prec.getID() != serverID) continue;
                    return prec.getEndpoints();
                }
            }
        }
        this.lock.releaseLock(1);
        return endpoints;
    }

    public ServerRecord getServer(long serverID) {
        return (ServerRecord)this.servers.get(new Long(serverID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POARecord getPOA(POANameKey pnkey, long serverID) {
        POARecord prec = null;
        this.lock.getLock(1);
        Map map = this.poas;
        synchronized (map) {
            HashSet rpoas = (HashSet)this.poas.get(pnkey);
            Iterator iter = rpoas.iterator();
            while (iter.hasNext()) {
                prec = (POARecord)iter.next();
                if (prec.getID() != serverID) continue;
                return prec;
            }
        }
        this.lock.releaseLock(1);
        return prec;
    }

    public void removePOA(POANameKey pnkey) {
        this.poas.remove(pnkey);
    }

    public void removePOAs(ArrayList poaList) {
        for (int i = 0; i < poaList.size(); ++i) {
            this.removePOA((POANameKey)poaList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePOA(long serverID, POANameKey pnkey) {
        if (pnkey != null) {
            this.lock.getLock(1);
            Map map = this.poas;
            synchronized (map) {
                HashSet set = (HashSet)this.poas.get(pnkey);
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    POARecord prec = (POARecord)iter.next();
                    if (prec.getID() != serverID) continue;
                    iter.remove();
                }
            }
            this.lock.releaseLock(1);
        } else {
            Set clone = this.poas.keySet();
            Iterator iter = clone.iterator();
            while (iter.hasNext()) {
                POANameKey key = (POANameKey)iter.next();
                this.removePOA(serverID, key);
            }
        }
    }

    public void removeServer(long serverID) {
        Long sID = new Long(serverID);
        ServerRecord srecord = (ServerRecord)this.servers.get(sID);
        if (srecord != null) {
            this.removePOA(serverID, null);
            this.servers.remove(sID);
        }
    }

    public void removeServers(ArrayList serverIDs) {
        for (int i = 0; i < serverIDs.size(); ++i) {
            this.removeServer((Long)serverIDs.get(i));
        }
    }

    public ImplRecord removeImpl(POANameKey pnkey) {
        return (ImplRecord)this.impls.remove(pnkey);
    }

    public Map getImpls() {
        return this.impls;
    }

    public Map getServers() {
        return this.servers;
    }

    public Map getPOAs() {
        return this.poas;
    }

    public void addActivator(Long id, String activator) {
        this.activators.put(id, activator);
    }

    public void removeActivator(Long id, String activator) {
        this.activators.remove(id);
    }

    public void removeActivators(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.removeActivator((Long)entry.getKey(), (String)entry.getValue());
        }
    }

    public Map getActivators() {
        return this.activators;
    }

    private void readObject(ObjectInputStream in) throws IOException, NotActiveException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransient();
    }
}

