/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.dns.DNSLookup;
import org.jacorb.util.Environment;
import org.omg.CORBA.portable.InputStream;

public class IIOPAddress {
    private String hostname = null;
    private String ip;
    private final int port;
    private boolean hideZoneID = true;
    private final boolean doEagerResolve = Environment.isPropertyOn("jacorb.dns.eager_resolve", "on");

    public IIOPAddress(String host, int port) {
        this.hideZoneID = Environment.isPropertyOn("jacorb.ipv6.hide_zoneid", "on");
        if (IIOPAddress.isIP(host)) {
            this.ip = host;
        } else {
            int zoneIndex;
            this.hostname = host;
            int slash = this.hostname.indexOf(47);
            if (slash > 0) {
                this.hostname = this.hostname.substring(0, slash);
            }
            if (this.hideZoneID && (zoneIndex = this.hostname.indexOf(37)) != -1) {
                this.hostname = this.hostname.substring(0, zoneIndex);
            }
            if (this.doEagerResolve) {
                this.getIP();
            }
        }
        this.port = port < 0 ? port + 65536 : port;
    }

    public static IIOPAddress read(InputStream in) {
        String host = in.read_string();
        short port = in.read_ushort();
        return new IIOPAddress(host, port);
    }

    private static boolean isIP(String host) {
        int index = 0;
        int numberStart = 0;
        int length = host.length();
        int ch = 32;
        for (int i = 0; i < 4; ++i) {
            while (index < length && (ch = (int)host.charAt(index)) != 46) {
                if (ch < 48 || ch > 57) {
                    return false;
                }
                ++index;
            }
            if (index >= length && i == 3 && index - numberStart <= 3 && index - numberStart > 0) {
                return true;
            }
            if (ch != 46 || index - numberStart > 3 || index - numberStart <= 0) {
                return false;
            }
            numberStart = ++index;
        }
        return false;
    }

    public String getIP() {
        if (this.ip == null) {
            try {
                this.ip = InetAddress.getByName(this.hostname).getHostAddress();
            }
            catch (UnknownHostException ex) {
                return this.hostname;
            }
        }
        return this.ip;
    }

    public String getHostname() {
        if (this.hostname == null) {
            this.hostname = DNSLookup.inverseLookup(this.getIP());
            if (this.hostname == null) {
                this.hostname = this.getIP();
            }
        }
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (other instanceof IIOPAddress) {
            IIOPAddress x = (IIOPAddress)other;
            if (this.port == x.port) {
                return this.getIP().equals(x.getIP());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getIP().hashCode() + this.port;
    }

    public String toString() {
        if (this.hostname != null) {
            return this.hostname + ":" + this.port;
        }
        return this.getIP() + ":" + this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toCDR() {
        CDROutputStream out = new CDROutputStream();
        try {
            out.beginEncapsulatedArray();
            out.write_string(this.getIP());
            out.write_ushort((short)this.port);
            byte[] byArray = out.getBufferCopy();
            return byArray;
        }
        finally {
            out.close();
        }
    }
}

