/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;

public class Messages {
    static final int MSG_HEADER_SIZE = 12;
    static final ServiceContext[] service_context = new ServiceContext[0];

    private static int skipServiceContext(byte[] buf, int offset, int length, boolean little_endian) {
        int pos = offset;
        for (int i = 0; i < length; ++i) {
            pos += 4;
            int diff = (pos = Messages.skipSequence(buf, pos, 1, little_endian)) % 4;
            if (diff == 0) continue;
            pos += 4 - diff;
        }
        return pos;
    }

    private static final int skipSequence(byte[] buf, int offset, int element_size, boolean little_endian) {
        int length = Messages.readULong(buf, offset, little_endian);
        return offset + 4 + length * element_size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getRequestId(byte[] buf) {
        int msg_type = Messages.getMsgType(buf);
        int giop_minor = Messages.getGIOPMinor(buf);
        boolean little_endian = Messages.isLittleEndian(buf);
        int request_id = -1;
        if (giop_minor == 2) {
            if (msg_type == 0) return Messages.readULong(buf, 12, little_endian);
            if (msg_type == 3) return Messages.readULong(buf, 12, little_endian);
            if (msg_type == 1) return Messages.readULong(buf, 12, little_endian);
            if (msg_type == 4) return Messages.readULong(buf, 12, little_endian);
            if (msg_type == 2) return Messages.readULong(buf, 12, little_endian);
            if (msg_type != 7) throw new BAD_PARAM("Messages of type " + msg_type + " don't have request ids");
            return Messages.readULong(buf, 12, little_endian);
        }
        if (giop_minor != 0) {
            if (giop_minor != 1) return request_id;
        }
        if (msg_type == 0 || msg_type == 1) {
            int service_ctx_length = Messages.readULong(buf, 12, little_endian);
            if (service_ctx_length == 0) {
                return Messages.readULong(buf, 16, little_endian);
            }
            int pos = Messages.skipServiceContext(buf, 16, service_ctx_length, little_endian);
            return Messages.readULong(buf, pos, little_endian);
        }
        if (msg_type == 3) return Messages.readULong(buf, 12, little_endian);
        if (msg_type != 4) throw new BAD_PARAM("Messages of type " + msg_type + " don't have request ids");
        return Messages.readULong(buf, 12, little_endian);
    }

    public static final int getMsgSize(byte[] buf) {
        return Messages.readULong(buf, 8, Messages.isLittleEndian(buf));
    }

    public static final int readULong(byte[] buf, int pos, boolean little_endian) {
        if (little_endian) {
            return ((buf[pos + 3] & 0xFF) << 24) + ((buf[pos + 2] & 0xFF) << 16) + ((buf[pos + 1] & 0xFF) << 8) + ((buf[pos] & 0xFF) << 0);
        }
        return ((buf[pos] & 0xFF) << 24) + ((buf[pos + 1] & 0xFF) << 16) + ((buf[pos + 2] & 0xFF) << 8) + ((buf[pos + 3] & 0xFF) << 0);
    }

    public static final boolean isLittleEndian(byte[] buf) {
        return (1 & buf[6]) != 0;
    }

    public static final boolean moreFragmentsFollow(byte[] buf) {
        return (2 & buf[6]) != 0;
    }

    public static final int getMsgType(byte[] buf) {
        return buf[7];
    }

    public static final int getGIOPMajor(byte[] buf) {
        return buf[4];
    }

    public static final int getGIOPMinor(byte[] buf) {
        return buf[5];
    }

    public static final boolean responseExpected(byte flags) {
        return flags == 1 || flags == 3;
    }

    public static final byte responseFlags(boolean response_expected) {
        return (byte)(response_expected ? 3 : 0);
    }
}

