/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.List;
import org.jacorb.imrutility.imr.handler.IMRRequestHandler;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class ServerRequestListener
implements RequestListener {
    private final ORB orb;
    private final org.jacorb.poa.POA rootPOA;
    private boolean require_ssl = false;

    public ServerRequestListener(org.omg.CORBA.ORB orb, POA rootPOA) {
        this.orb = (ORB)orb;
        this.rootPOA = (org.jacorb.poa.POA)rootPOA;
        if (Environment.getSupportSSL()) {
            int required = Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16);
            this.require_ssl = Environment.getSupportSSL() && (required & 0x60) != 0;
        }
    }

    public void requestReceived(byte[] request, GIOPConnection connection) {
        ReplyOutputStream out;
        RequestInputStream in;
        boolean sendJacSvcReply;
        block23: {
            block21: {
                block22: {
                    sendJacSvcReply = false;
                    in = new RequestInputStream(this.orb, request);
                    if (this.require_ssl && !connection.isSSL()) {
                        ReplyOutputStream out2 = new ReplyOutputStream(in.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, in.getGIOPMinor(), false);
                        Debug.output(2, "About to reject request because connection is not SSL.");
                        SystemExceptionHelper.write(out2, new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO));
                        try {
                            connection.sendReply(out2);
                        }
                        catch (IOException e) {
                            Debug.output(1, e);
                        }
                        return;
                    }
                    if (Messages.responseExpected(in.req_hdr.response_flags)) {
                        connection.incPendingMessages();
                    }
                    if (connection.isTCSNegotiated()) break block21;
                    if (in.getGIOPMinor() != 0) break block22;
                    connection.markTCSNegotiated();
                    break block23;
                }
                CodeSetContext ctx = null;
                for (int i = 0; i < in.req_hdr.service_context.length; ++i) {
                    if (in.req_hdr.service_context[i].context_id == 1) {
                        CDRInputStream is = new CDRInputStream(null, in.req_hdr.service_context[i].context_data);
                        is.openEncapsulatedArray();
                        ctx = CodeSetContextHelper.read(is);
                        continue;
                    }
                    if (in.req_hdr.service_context[i].context_id != 1245904912) continue;
                    sendJacSvcReply = true;
                }
                if (ctx == null) break block23;
                connection.setCodeSets(ctx.char_data, ctx.wchar_data);
                if (!Debug.isDebugEnabled()) break block23;
                Debug.output(3, "Received CodeSetContext. Using " + CodeSet.csName(ctx.char_data) + " as TCS and " + CodeSet.csName(ctx.wchar_data) + " as TCSW");
                break block23;
            }
            for (int i = 0; i < in.req_hdr.service_context.length; ++i) {
                if (in.req_hdr.service_context[i].context_id != 1245904912) continue;
                sendJacSvcReply = true;
            }
        }
        in.setCodeSet(connection.getTCS(), connection.getTCSW());
        in.updateMutatorConnection(connection);
        ServerRequest server_request = null;
        try {
            try {
                server_request = new ServerRequest(this.orb, in, connection);
            }
            catch (INTERNAL e) {
                if (Debug.isDebugEnabled()) {
                    Debug.output("Unable to create ServerRequest throwing marshal for client to resend with full object key.");
                    Debug.output(4, e);
                }
                out = new ReplyOutputStream(in.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, in.getGIOPMinor(), false);
                SystemExceptionHelper.write(out, new MARSHAL("Could not find object key " + e, 1245904912, CompletionStatus.COMPLETED_MAYBE));
                try {
                    connection.sendReply(out);
                }
                catch (IOException ie) {
                    Debug.output(1, ie);
                }
                return;
            }
            if (sendJacSvcReply) {
                server_request.sendServiceCtxReply();
            }
        }
        catch (POAInternalError pie) {
            Debug.output(1, "WARNING: Received a request with a non-jacorb object key");
            if (in.isLocateRequest()) {
                LocateReplyOutputStream lr_out = new LocateReplyOutputStream(in.req_hdr.request_id, 0, in.getGIOPMinor());
                try {
                    connection.sendReply(lr_out);
                }
                catch (IOException e) {
                    Debug.output(1, e);
                }
            } else {
                out = new ReplyOutputStream(in.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, in.getGIOPMinor(), false);
                SystemExceptionHelper.write(out, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                try {
                    connection.sendReply(out);
                }
                catch (IOException e) {
                    Debug.output(1, e);
                }
            }
            return;
        }
        this.deliverRequest(server_request);
    }

    public void locateRequestReceived(byte[] request, GIOPConnection connection) {
        this.requestReceived(request, connection);
    }

    public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
    }

    private void deliverRequest(ServerRequest request) {
        block14: {
            org.jacorb.poa.POA tmp_poa = this.rootPOA;
            try {
                String res;
                String refImplName = "";
                String orbImplName = Environment.implNameStr();
                String orbServerId = Environment.serverIdStr();
                try {
                    refImplName = POAUtil.extractImplName(request.objectKey());
                }
                catch (POAInternalError pie) {
                    Debug.output("serverRequestListener: reference generated by foreign POA");
                }
                if (!orbImplName.equals(refImplName) && !orbServerId.equals(refImplName)) {
                    if (Debug.isDebugEnabled()) {
                        Debug.output("serverRequestListener: impl_name mismatch (refImplName: " + refImplName + " and orbServerId " + orbServerId + " and orbImplName " + orbImplName);
                    }
                    throw new WrongAdapter();
                }
                List scopes = request.getScopes();
                for (int i = 0; i < scopes.size() && (res = (String)scopes.get(i)).length() != 0; ++i) {
                    try {
                        tmp_poa = tmp_poa._getChildPOA(res);
                        continue;
                    }
                    catch (ParentIsHolding p) {
                        String[] rest_of_name = new String[scopes.size() - i];
                        for (int j = 0; j < i; ++j) {
                            rest_of_name[j] = (String)scopes.get(j + i);
                        }
                        request.setRemainingPOAName(rest_of_name);
                        break;
                    }
                }
                if (tmp_poa == null) {
                    throw new INTERNAL("Request POA null!");
                }
                tmp_poa._invoke(request);
            }
            catch (Exception ex) {
                if (Environment.isImR()) {
                    IMRRequestHandler irh = new IMRRequestHandler(this.orb);
                    irh.handle_request(request);
                }
                if (ex instanceof WrongAdapter) {
                    request.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
                    request.reply();
                }
                if (ex instanceof SystemException) {
                    request.setSystemException((SystemException)ex);
                    request.reply();
                }
                request.setSystemException(new UNKNOWN(ex.toString()));
                request.reply();
                if (!Debug.isDebugEnabled()) break block14;
                Debug.output(4, ex);
            }
        }
    }
}

