/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.listener.AcceptorExceptionEvent;
import org.jacorb.orb.listener.AcceptorExceptionListener;
import org.jacorb.orb.listener.SSLListenerUtil;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.ETF.Connection;
import org.omg.ETF.Handle;
import org.omg.ETF.Profile;
import org.omg.ETF._ListenerLocalBase;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPListener
extends _ListenerLocalBase {
    private Acceptor acceptor;
    private SSLAcceptor sslAcceptor;
    private IIOPProfile endpoint;
    private Logger logger;
    private Handle up;
    private final List incoming_connections = new ArrayList();
    private volatile boolean terminated = false;
    private AcceptorExceptionListener acceptorExceptionListener;
    static /* synthetic */ Class class$java$net$Socket;

    public IIOPListener() {
        this.logger = Debug.getNamedLogger("jacorb.orb.iiop");
        if (!this.isSSLRequired() || Environment.isPropertyOn("jacorb.security.ssl.always_open_unsecured_endpoint")) {
            this.acceptor = new Acceptor();
            this.acceptor.init();
        }
        if (this.isSSLSupported()) {
            this.sslAcceptor = new SSLAcceptor();
            this.sslAcceptor.init();
        }
        this.endpoint = this.createEndPointProfile();
        this.acceptorExceptionListener = (AcceptorExceptionListener)Environment.getObjectProperty("jacorb.acceptor_exception_listener");
    }

    public void renewSSLServerSocket() {
        if (this.sslAcceptor != null) {
            this.sslAcceptor.renewSSLServerSocket();
        }
    }

    public void set_handle(Handle up) {
        this.up = up;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection accept() {
        if (this.up != null) {
            throw new BAD_INV_ORDER("Must not call accept() when a Handle has been set");
        }
        List list = this.incoming_connections;
        synchronized (list) {
            while (!this.terminated && this.incoming_connections.isEmpty()) {
                try {
                    this.incoming_connections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.terminated) {
                return (Connection)this.incoming_connections.remove(0);
            }
            return null;
        }
    }

    public void listen() {
        if (this.acceptor != null) {
            this.acceptor.start();
        }
        if (this.sslAcceptor != null) {
            this.sslAcceptor.start();
        }
    }

    public void destroy() {
        if (this.acceptor != null) {
            this.acceptor.terminate();
        }
        if (this.sslAcceptor != null) {
            this.sslAcceptor.terminate();
        }
        this.terminated = true;
        if (this.up == null) {
            this.incoming_connections.notifyAll();
        }
    }

    public void completed_data(Connection conn) {
        throw new NO_IMPLEMENT();
    }

    public Profile endpoint() {
        return this.endpoint.copy();
    }

    private boolean isSSLSupported() {
        return Environment.getSupportSSL();
    }

    private boolean isSSLRequired() {
        if (this.isSSLSupported()) {
            int minimum_options = 126;
            String prop = Environment.getProperty("jacorb.ssl.server.required_options");
            if (prop != null) {
                try {
                    int server_requires = Integer.parseInt(prop, 16);
                    return (server_requires & minimum_options) != 0;
                }
                catch (NumberFormatException e) {
                    throw new INITIALIZE("could not parse jacorb.ssl.server.required_options: " + prop);
                }
            }
        }
        return false;
    }

    private int getServerTimeout() {
        String prop = Environment.getProperty("jacorb.connection.server.timeout");
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return 0;
    }

    private IIOPProfile createEndPointProfile() {
        int port = 0;
        if (this.acceptor != null) {
            port = this.getConfiguredPort();
            if (port == 0) {
                port = this.acceptor.getLocalAddress().getPort();
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using port " + port);
            }
        } else if (this.sslAcceptor == null) {
            throw new INITIALIZE("no acceptors found, cannot create endpoint profile");
        }
        IIOPProfile result = new IIOPProfile(new IIOPAddress(Environment.getDnsEnable() ? this.getHost().getHostName() : this.getHost().getHostAddress(), port), null);
        if (this.sslAcceptor != null) {
            result.addComponent(20, this.createSSL(), SSLHelper.class);
        }
        return result;
    }

    private SSL createSSL() {
        int target_supports = Environment.getIntProperty("jacorb.security.ssl.server.supported_options", 16);
        int target_requires = Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16);
        return new SSL((short)target_supports, (short)target_requires, (short)this.sslAcceptor.getLocalAddress().getPort());
    }

    private InetAddress getConfiguredHost() {
        try {
            int zoneIndex;
            int slash;
            String oa_addr = Environment.getProperty("OAIAddr");
            int n = slash = oa_addr == null ? -1 : oa_addr.indexOf(47);
            if (slash > 0) {
                oa_addr = oa_addr.substring(0, slash);
            }
            if (Environment.isPropertyOn("jacorb.ipv6.hide_zoneid", "on") && oa_addr != null && (zoneIndex = oa_addr.indexOf(37)) != -1) {
                oa_addr = oa_addr.substring(0, zoneIndex);
            }
            return oa_addr == null ? null : InetAddress.getByName(oa_addr);
        }
        catch (UnknownHostException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Caught host exception ", e);
            }
            e.printStackTrace();
            throw new INITIALIZE("Could not resolve configured listener host");
        }
    }

    private InetAddress getHost() {
        try {
            InetAddress configuredHost = this.getConfiguredHost();
            return configuredHost == null ? InetAddress.getLocalHost() : configuredHost;
        }
        catch (UnknownHostException e) {
            throw new INITIALIZE("Could not resolve configured listener host");
        }
    }

    private int getConfiguredPort() {
        String prop = Environment.getProperty("OAPort");
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return 0;
    }

    private int getConfiguredSSLPort() {
        String prop = Environment.getProperty("OASSLPort");
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverConnection(Socket socket, ServerSocket serverSocket, boolean isSSL) {
        Connection result = null;
        try {
            result = this.createServerConnection(socket, serverSocket, isSSL);
        }
        catch (IOException ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create connection from socket: ", ex);
            }
            return;
        }
        if (this.up != null) {
            this.up.add_input(result);
        } else {
            List list = this.incoming_connections;
            synchronized (list) {
                this.incoming_connections.add(result);
                this.incoming_connections.notifyAll();
            }
        }
    }

    protected Connection createServerConnection(Socket socket, ServerSocket serverSocket, boolean is_ssl) throws IOException {
        ServerIIOPConnection iiopConnection = new ServerIIOPConnection(socket, is_ssl);
        this.fireConnectionOpened(socket, serverSocket, iiopConnection);
        return iiopConnection;
    }

    private void fireConnectionOpened(Socket socket, ServerSocket serverSocket, IIOPConnection connection) {
        if (socket != null && SocketFactoryManager.getTCPListener() != null) {
            String localhost;
            try {
                localhost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Unable to resolve local host - using default 127.0.0.1");
                }
                localhost = "127.0.0.1";
            }
            SocketFactoryManager.getTCPListener().connectionOpened(new TCPConnectionEvent(connection, socket.getInetAddress().getHostAddress(), socket.getPort(), serverSocket.getLocalPort(), localhost));
        }
    }

    public class Acceptor
    extends Thread {
        protected ServerSocket serverSocket;
        private boolean terminated;
        protected boolean blockedOnAccept;
        protected boolean renewingSocket;
        protected byte[] renewSocketSync;
        protected int soTimeout;
        protected boolean keepAlive;
        protected boolean reuseAddress;
        private final long serverSocketRetryDelay;
        private boolean firstPass;

        Acceptor() {
            this("ServerSocketListener");
        }

        Acceptor(String name) {
            super(name);
            this.terminated = false;
            this.blockedOnAccept = false;
            this.renewingSocket = false;
            this.renewSocketSync = new byte[0];
            this.soTimeout = 0;
            this.setDaemon(true);
            this.soTimeout = Environment.getIntPropertyWithDefault("jacorb.listener.server_socket_timeout", 0);
            this.keepAlive = Environment.isPropertyOn("jacorb.connection.server.keepalive");
            this.reuseAddress = Environment.isPropertyOn("jacorb.connection.server.reuse_address");
            if (this.reuseAddress && Environment.getJDK13()) {
                this.reuseAddress = false;
                IIOPListener.this.logger.warn("socket option SO_REUSE is not supported by jdk13 (jacorb.connection.server.reuse_address=on).");
            }
            this.serverSocketRetryDelay = Environment.getIntPropertyWithDefault("jacorb.listener.server_socket_retry_delay", 1000);
        }

        void init() {
            this.serverSocket = this.createServerSocket();
            if (IIOPListener.this.logger.isDebugEnabled()) {
                IIOPListener.this.logger.debug("Created socket listener on " + this.serverSocket.getInetAddress());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (true) {
                byte[] byArray;
                block20: {
                    if (this.terminated) {
                        if (!IIOPListener.this.logger.isInfoEnabled()) return;
                        IIOPListener.this.logger.info("Listener exited");
                        return;
                    }
                    try {
                        byArray = this.renewSocketSync;
                        // MONITORENTER : this.renewSocketSync
                        while (this.renewingSocket) {
                            this.renewSocketSync.wait();
                        }
                        this.blockedOnAccept = true;
                        // MONITOREXIT : byArray
                        Socket socket = this.serverSocket.accept();
                        this.setup(socket);
                        try {
                            this.deliverConnection(socket);
                            this.firstPass = true;
                        }
                        catch (NO_RESOURCES e) {
                            if (socket.getClass().isAssignableFrom(class$java$net$Socket == null ? IIOPListener.class$("java.net.Socket") : class$java$net$Socket)) {
                                try {
                                    socket.shutdownOutput();
                                    throw e;
                                }
                                catch (SocketException socketException) {
                                    // empty catch block
                                }
                                throw e;
                            }
                            socket.close();
                        }
                    }
                    catch (InterruptedIOException e) {
                        if (this.soTimeout == 0) {
                            IIOPListener.this.logger.warn("Received exception of accept()", e);
                        }
                    }
                    catch (Throwable th) {
                        if (this.terminated) break block20;
                        if (IIOPListener.this.logger.isWarnEnabled()) {
                            IIOPListener.this.logger.warn("Caught Throwable while listening", th);
                        }
                        if (IIOPListener.this.acceptorExceptionListener != null) {
                            IIOPListener.this.acceptorExceptionListener.exceptionCaught(new AcceptorExceptionEvent(this, ((BasicAdapter)IIOPListener.this.up).getORB(), th));
                        }
                        try {
                            Thread.sleep(this.serverSocketRetryDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                byArray = this.renewSocketSync;
                // MONITORENTER : this.renewSocketSync
                this.blockedOnAccept = false;
                this.renewSocketSync.notifyAll();
                // MONITOREXIT : byArray
            }
        }

        public boolean getAcceptorSocketLoop() {
            return this.firstPass;
        }

        void terminate() {
            block2: {
                this.terminated = true;
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    if (!IIOPListener.this.logger.isWarnEnabled()) break block2;
                    IIOPListener.this.logger.warn(e.toString());
                }
            }
        }

        IIOPAddress getLocalAddress() {
            return new IIOPAddress(this.serverSocket.getInetAddress().getHostAddress(), this.serverSocket.getLocalPort());
        }

        protected ServerSocket createServerSocket() {
            try {
                ServerSocket result = SocketFactoryManager.getServerSocketFactory().createServerSocket(IIOPListener.this.getConfiguredPort(), 20, IIOPListener.this.getConfiguredHost());
                if (this.soTimeout > 0) {
                    result.setSoTimeout(this.soTimeout);
                }
                this.setReuseAddress(result);
                return result;
            }
            catch (IOException ex) {
                IIOPListener.this.logger.warn("Unable to create server socket", ex);
                throw new INITIALIZE("Could not create server socket");
            }
        }

        void setReuseAddress(ServerSocket s) throws SocketException {
            if (this.reuseAddress) {
                try {
                    Method method = s.getClass().getMethod("setReuseAddress", Boolean.TYPE);
                    method.invoke((Object)s, Boolean.TRUE);
                }
                catch (Exception e) {
                    IIOPListener.this.logger.fatalError("cannot setReuseAddress", e);
                    throw new INTERNAL(e.getMessage());
                }
            }
        }

        protected void setup(Socket socket) throws IOException {
            socket.setSoTimeout(IIOPListener.this.getServerTimeout());
            socket.setKeepAlive(this.keepAlive);
            try {
                SSLListenerUtil.addListener(socket);
            }
            catch (Throwable t) {
                t.printStackTrace();
                IIOPListener.this.logger.warn("unexpected exception in SSL listener", t);
            }
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, this.serverSocket, false);
        }
    }

    public class SSLAcceptor
    extends Acceptor {
        public SSLAcceptor() {
            super("SSLServerSocketListener");
        }

        protected ServerSocket createServerSocket() {
            try {
                ServerSocket s = SocketFactoryManager.getSSLServerSocketFactory().createServerSocket(IIOPListener.this.getConfiguredSSLPort(), 20, IIOPListener.this.getConfiguredHost());
                if (this.soTimeout > 0) {
                    s.setSoTimeout(this.soTimeout);
                }
                this.setReuseAddress(s);
                return s;
            }
            catch (IOException e) {
                IIOPListener.this.logger.warn("Unable to create SSL server socket", e);
                throw new INITIALIZE("Could not create SSL server socket");
            }
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, this.serverSocket, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renewSSLServerSocket() {
            int oldPort = this.serverSocket.getLocalPort();
            InetAddress oldAddress = this.serverSocket.getInetAddress();
            try {
                byte[] byArray = this.renewSocketSync;
                synchronized (this.renewSocketSync) {
                    this.renewingSocket = true;
                    while (this.blockedOnAccept) {
                        this.renewSocketSync.wait();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    this.serverSocket.close();
                }
            }
            catch (Exception e) {
                IIOPListener.this.logger.warn("Failed to close SSLServerSocket", e);
            }
            {
                try {
                    this.serverSocket = SocketFactoryManager.getSSLServerSocketFactory().createServerSocket(oldPort, 20, oldAddress);
                    if (this.soTimeout > 0) {
                        this.serverSocket.setSoTimeout(this.soTimeout);
                    }
                    byte[] e = this.renewSocketSync;
                    synchronized (this.renewSocketSync) {
                        this.renewingSocket = false;
                        this.renewSocketSync.notifyAll();
                        // ** MonitorExit[e] (shouldn't be in output)
                    }
                }
                catch (Exception e) {
                    IIOPListener.this.logger.warn("Failed to create SSLServerSocket", e);
                    throw new INITIALIZE("Could not create SSL server socket: " + e);
                }
                {
                    return;
                }
            }
        }
    }
}

