/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.apache.avalon.framework.logger.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.Debug;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class KerberosContext
implements ISASContext {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS");
    private GSSContext validatedContext = null;
    private GSSCredential targetCreds = null;
    private GSSCredential clientCreds = null;

    public void initClient() {
        String principal = "";
        try {
            Oid krb5Oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gssManager = GSSManager.getInstance();
            this.clientCreds = gssManager.createCredential(null, Integer.MAX_VALUE, krb5Oid, 1);
        }
        catch (Exception e) {
            logger.warn("Error getting created principal: " + e);
        }
    }

    public String getMechOID() {
        return "oid:1.2.840.113554.1.2.2".substring(4);
    }

    public byte[] createClientContext(ClientRequestInfo ri, CompoundSecMechList csmList) {
        byte[] contextToken = new byte[]{};
        try {
            byte[] target = csmList.mechanism_list[0].as_context_mech.target_name;
            Oid krb5Oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gssManager = GSSManager.getInstance();
            GSSName myPeer = gssManager.createName(target, null, krb5Oid);
            if (this.clientCreds == null) {
                this.clientCreds = gssManager.createCredential(null, Integer.MAX_VALUE, krb5Oid, 1);
            }
            GSSContext myContext = gssManager.createContext(myPeer, krb5Oid, this.clientCreds, Integer.MAX_VALUE);
            contextToken = myContext.initSecContext(contextToken, 0, contextToken.length);
        }
        catch (Exception e) {
            logger.error("Error creating Kerberos context: " + e);
        }
        return contextToken;
    }

    public String getClientPrincipal() {
        String principal = "";
        try {
            Oid krb5Oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gssManager = GSSManager.getInstance();
            if (this.clientCreds == null) {
                this.clientCreds = gssManager.createCredential(null, Integer.MAX_VALUE, krb5Oid, 1);
            }
            principal = ((Object)this.clientCreds.getName()).toString();
        }
        catch (Exception e) {
            logger.error("Error getting created principal: " + e);
        }
        return principal;
    }

    public void initTarget() {
        try {
            Oid krb5Oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gssManager = GSSManager.getInstance();
            if (this.targetCreds == null) {
                this.targetCreds = gssManager.createCredential(null, Integer.MAX_VALUE, krb5Oid, 2);
            }
        }
        catch (GSSException e) {
            logger.warn("Error accepting Kerberos context: " + e);
        }
    }

    public boolean validateContext(ServerRequestInfo ri, byte[] contextToken) {
        byte[] token = null;
        try {
            Oid krb5Oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gssManager = GSSManager.getInstance();
            if (this.targetCreds == null) {
                this.targetCreds = gssManager.createCredential(null, Integer.MAX_VALUE, krb5Oid, 2);
            }
            this.validatedContext = gssManager.createContext(this.targetCreds);
            token = this.validatedContext.acceptSecContext(contextToken, 0, contextToken.length);
        }
        catch (GSSException e) {
            logger.error("Error accepting Kerberos context: " + e);
        }
        if (token == null) {
            logger.warn("Could not accept token");
            return false;
        }
        return true;
    }

    public String getValidatedPrincipal() {
        if (this.validatedContext == null) {
            return null;
        }
        try {
            return ((Object)this.validatedContext.getSrcName()).toString();
        }
        catch (GSSException e) {
            logger.error("Error getting name: " + e);
            return null;
        }
    }
}

