/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.DownloadState;
import cerent.util.KDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class DownloadView
implements Observer {
    private DownloadState myState;
    private JFrame myFrame;
    private JProgressBar myProgress;
    private static final KDebug db = new KDebug("DownloadView");

    public DownloadView(DownloadState downloadState) {
        if (db.on()) {
            db.println("<init>");
        }
        this.myState = downloadState;
        this.myFrame = null;
        this.myProgress = null;
        this.myState.addObserver(this);
    }

    private synchronized void init(String string, String string2, long l) {
        if (db.on()) {
            db.println("init title is " + string + " msg is " + string2 + " max is " + l);
        }
        if (this.myFrame == null && this.myState != null) {
            this.myFrame = new JFrame(string);
            JLabel jLabel = new JLabel("Downloading " + string2 + "...");
            this.myFrame.getContentPane().add((Component)jLabel, "North");
            this.myProgress = new JProgressBar(0, (int)l);
            this.myProgress.setStringPainted(true);
            this.myFrame.getContentPane().add((Component)this.myProgress, "Center");
            this.myFrame.pack();
            this.center();
            this.myFrame.setVisible(true);
        }
    }

    private void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.myFrame.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.myFrame.setLocation(n, n2);
    }

    private void update(long l, long l2) {
        if (db.on()) {
            db.println("update cur is " + l + " max is " + l2);
        }
        if (this.myProgress != null) {
            if (l2 != (long)this.myProgress.getMaximum()) {
                this.myProgress.setMaximum((int)l2);
            }
            this.myProgress.setValue((int)l);
        }
    }

    public synchronized void doFini() {
        if (db.on()) {
            db.println("doFini");
        }
        if (this.myState != null) {
            this.myState.deleteObserver(this);
            this.myState = null;
        }
        if (this.myFrame != null) {
            this.myFrame.dispose();
            this.myProgress = null;
            this.myFrame = null;
        }
    }

    public void fini() {
        SwingUtilities.invokeLater(new Fini());
    }

    private void doUpdate(DownloadState downloadState) {
        long l = downloadState.getMaximum();
        long l2 = downloadState.getCurrent();
        if (l2 < l) {
            if (this.myFrame == null) {
                this.init("CTC Downloading", downloadState.sourceName(), l);
            }
            this.update(l2, l);
        } else {
            this.doFini();
        }
    }

    public void update(Observable observable, Object object) {
        SwingUtilities.invokeLater(new Update((DownloadState)observable));
    }

    public DownloadState getState() {
        return this.myState;
    }

    private class Fini
    implements Runnable {
        Fini() {
        }

        public void run() {
            DownloadView.this.doFini();
        }
    }

    private class Update
    implements Runnable {
        DownloadState _state;

        Update(DownloadState downloadState) {
            this._state = downloadState;
        }

        public void run() {
            DownloadView.this.doUpdate(this._state);
        }
    }
}

