/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.DebugConsole;
import cerent.util.DebugTelnetd;
import cerent.util.DebugWindow;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.RootDebug;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DebugManager {
    private static final String PREF_EXC_SYSOUT = "debug.excsysout";
    private static final String PREF_PATH = "ctc";
    public static final String BOOT_DEBUG = "boot.debug";
    public static final String DEBUG_HISTORY = "debug.history";
    public static final String DEBUG_HISTORY_LINE = "debug.history.line";
    private static final String BOOT_CONSOLE_DEBUG = "boot.console.debug";
    private static final String TELNET_PSWD = "otbu+1";
    private static final String DEBUG_PORT = "telnet.port";
    private static final String COPYRIGHT = "Copyright (c) 2000-2006 Cisco Systems, Inc.";
    private static final int MAX_HISTORY = 30;
    private static final String prompt = "> ";
    private static DebugManager _instance = null;
    private static LinkedList<PrintStream> printList = new LinkedList();
    private History history = new History();
    private static boolean excToSysOut = true;
    private static boolean sysOutInList = false;
    private RootDebug root;
    private static boolean bootDbgResumed = false;
    private static KDebug bootDbg;
    private static KDebug exitDbg;
    private static final String[][] helpMatrix;

    private DebugManager() {
        if (_instance != null) {
            throw new RuntimeException("A fatal error occurred. Multiple DebugManager instances are present!");
        }
        _instance = this;
        this.root = new RootDebug(this);
        excToSysOut = Preferences.instance().getBoolean(PREF_PATH, PREF_EXC_SYSOUT, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(boolean bl) {
        Object object;
        if (_instance != null) {
            return;
        }
        DebugManager debugManager = new DebugManager();
        Preferences.setAllParentIfNeeded(debugManager.root);
        bootDbg = new BootDebug();
        int n = Preferences.instance().getInt(PREF_PATH, DEBUG_PORT, -1);
        if (n > 0) {
            object = new DebugTelnetd(DebugManager.instance().getRoot(), n, TELNET_PSWD, false);
            ((Thread)object).start();
        }
        boolean bl2 = ((String)(object = Preferences.instance().getProperty(PREF_PATH, BOOT_DEBUG, "false"))).compareTo("false") != 0;
        boolean bl3 = Preferences.instance().getBoolean(PREF_PATH, BOOT_CONSOLE_DEBUG, false);
        if (!bootDbgResumed && (bl2 || bl3)) {
            if (bl3) {
                DebugConsole.startInstance();
            }
            if (bl2 && !GraphicsEnvironment.isHeadless()) {
                DebugWindow.instance().display();
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bootDbg.println("Bootstrap paused, type \"BootDebug resume\" to resume.");
            bootDbg.println("To avoid modal dialog blocking, it is recommended to");
            bootDbg.println("start telnetd \"telnetd <password> [<port>]\" before resuming");
            if (bl2 && new File((String)object).exists()) {
                new Thread(new Runnable((String)object){
                    final /* synthetic */ String val$bootDebugStr;
                    {
                        this.val$bootDebugStr = string;
                    }

                    public void run() {
                        DebugManager.instance().getRoot().read(this.val$bootDebugStr);
                    }
                }, "Boot Debug File Reader").start();
            }
            KDebug kDebug = bootDbg;
            synchronized (kDebug) {
                try {
                    bootDbg.wait();
                }
                catch (Exception exception) {
                    bootDbg.finest("Exception in bootstrapDebug/db.wait() " + exception);
                }
            }
            bootDbgResumed = true;
            bootDbg.println("BootDebug resumed");
        }
    }

    public static void displayDebugWindow() {
        boolean bl = Preferences.instance().getBoolean(PREF_PATH, BOOT_DEBUG, false);
        if (bl) {
            DebugWindow.instance().display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(int n) {
        exitDbg = new ExitDebug();
        if (bootDbgResumed) {
            exitDbg.println("*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***");
            exitDbg.println("System.exit(" + n + ") paused, type \"XitDebug resume\" to resume.");
            try {
                KDebug kDebug = exitDbg;
                synchronized (kDebug) {
                    try {
                        exitDbg.wait();
                    }
                    catch (Exception exception) {
                        exitDbg.finest("Exception in exitDebug/db.wait() " + exception);
                    }
                }
                exitDbg.println("ExitDebug resumed");
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                System.exit(n);
                throw throwable;
            }
            System.exit(n);
            {
            }
        }
    }

    public static DebugManager instance() {
        return _instance;
    }

    public void addPrintStream(PrintStream printStream) {
        this.addPrintStream(printStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintStream(PrintStream printStream, boolean bl) {
        LinkedList<PrintStream> linkedList = printList;
        synchronized (linkedList) {
            if (!printList.contains(printStream)) {
                printList.add(printStream);
                if (bl) {
                    printStream.println("CTC debugger");
                    printStream.println(COPYRIGHT);
                    printStream.print(prompt);
                }
                if (printStream == System.out) {
                    sysOutInList = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintStream(PrintStream printStream) {
        LinkedList<PrintStream> linkedList = printList;
        synchronized (linkedList) {
            printList.remove(printStream);
            if (printStream == System.out) {
                sysOutInList = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean exec(String string) {
        block25: {
            Object object;
            block23: {
                Object object2;
                block22: {
                    block21: {
                        string = string == null ? "" : string.trim();
                        if (!string.startsWith("!") || (string = this.history.load(string)) != null) break block21;
                        this.history.print();
                        boolean bl = false;
                        Object var9_6 = null;
                        this.print(prompt);
                        return bl;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    boolean bl = true;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken();
                        if (bl && ((String)object).indexOf(".") != -1) {
                            object2 = new StringTokenizer((String)object, ".");
                            while (((StringTokenizer)object2).hasMoreTokens()) {
                                arrayList.add(((StringTokenizer)object2).nextToken());
                            }
                        } else if (((String)object).startsWith("\"")) {
                            if (((String)object).endsWith("\"") && ((String)object).length() > 2) {
                                arrayList.add(((String)object).substring(1, ((String)object).length() - 1));
                            } else if (((String)object).endsWith("\"") && ((String)object).length() == 2) {
                                arrayList.add(object);
                            } else {
                                object = ((String)object).length() > 1 ? ((String)object).substring(1) : "";
                                object2 = "";
                                while (stringTokenizer.hasMoreTokens() && !((String)object2).endsWith("\"")) {
                                    object2 = stringTokenizer.nextToken();
                                    object = (String)object + " " + (String)object2;
                                }
                                if (((String)object).endsWith("\"")) {
                                    object = ((String)object).substring(0, ((String)object).length() - 1);
                                }
                                arrayList.add(object);
                            }
                        } else {
                            arrayList.add(object);
                        }
                        bl = false;
                    }
                    object = new String[arrayList.size()];
                    arrayList.toArray((T[])object);
                    if (((String[])object).length != 0) break block22;
                    boolean bl2 = false;
                    Object var9_7 = null;
                    this.print(prompt);
                    return bl2;
                }
                object2 = object[0].toUpperCase(Locale.ENGLISH);
                if (!((String)object2).equals("QUIT") && !((String)object2).equals("BYE") && !((String)object2).equals("EXIT")) break block23;
                this.println("Goodbye");
                boolean bl = true;
                Object var9_8 = null;
                this.print(prompt);
                return bl;
            }
            try {
                block24: {
                    try {
                        if (this.root.apply((String[])object, 0)) {
                            this.history.save(string);
                            break block24;
                        }
                        this.println("Syntax error");
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        DebugManager.printStackTrace(noSuchElementException);
                        Object var9_10 = null;
                        this.print(prompt);
                        break block25;
                    }
                    catch (Exception exception) {
                        DebugManager.printStackTrace(exception);
                        Object var9_11 = null;
                        this.print(prompt);
                    }
                }
                Object var9_9 = null;
                this.print(prompt);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.print(prompt);
                throw throwable;
            }
        }
        return false;
    }

    public synchronized void disposeClassLoader(ClassLoader classLoader) {
        this.root.disposeClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Throwable throwable) {
        LinkedList<PrintStream> linkedList = printList;
        synchronized (linkedList) {
            Iterator iterator = printList.iterator();
            while (iterator.hasNext()) {
                throwable.printStackTrace((PrintStream)iterator.next());
            }
        }
        if (excToSysOut && !sysOutInList) {
            throwable.printStackTrace(System.out);
        }
    }

    String[][] getHelpMatrix() {
        return helpMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        LinkedList<PrintStream> linkedList = printList;
        synchronized (linkedList) {
            Iterator iterator = printList.iterator();
            while (iterator.hasNext()) {
                ((PrintStream)iterator.next()).println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String string) {
        LinkedList<PrintStream> linkedList = printList;
        synchronized (linkedList) {
            Iterator iterator = printList.iterator();
            while (iterator.hasNext()) {
                ((PrintStream)iterator.next()).print(string);
            }
        }
    }

    public LinkedList loadHistory() {
        return this.history.loadHistory();
    }

    public boolean getExcToSysOut() {
        return excToSysOut;
    }

    public void setExcToSysOut(boolean bl) {
        excToSysOut = bl;
        Preferences.instance().setBoolean(PREF_PATH, PREF_EXC_SYSOUT, excToSysOut);
    }

    public RootDebug getRoot() {
        return this.root;
    }

    static {
        helpMatrix = new String[][]{{"?", "Print this help message"}, {"quit, exit, bye", "Terminate debug session"}, {"!!", "Execute last command"}, {"!?", "Print command history"}, {"!<number>", "Execute command at rank <number>"}, {"!<text>", "Execute previous command matching <text>"}};
    }

    static class AbstractDebug
    extends KDebug {
        protected AbstractDebug(String string) {
            super(string, true);
        }

        public final synchronized void resume() {
            this.notifyAll();
        }
    }

    public static class BootDebug
    extends AbstractDebug {
        public BootDebug() {
            super("BootDebug");
        }

        public final void debugAtBoot(boolean bl) {
            if (bl) {
                this.display("Bootstrap will pause and display the debug window at next start");
            } else {
                this.display("Bootstrap debug at boot reset (normal setting)");
            }
            Preferences.instance().setBoolean(DebugManager.PREF_PATH, DebugManager.BOOT_DEBUG, bl);
        }
    }

    public static class ExitDebug
    extends AbstractDebug {
        public ExitDebug() {
            super("XitDebug");
        }
    }

    class History {
        private LinkedList<String> _history = new LinkedList();

        History() {
        }

        void save(String string) {
            ListIterator listIterator = this._history.listIterator();
            while (listIterator.hasNext()) {
                String string2 = (String)listIterator.next();
                if (!string.equals(string2)) continue;
                listIterator.remove();
                break;
            }
            this._history.addFirst(string);
            if (this._history.size() >= 30) {
                this._history.removeLast();
            }
            DebugManager.this.history.saveHistory();
        }

        void print() {
            for (int i = 0; i < this._history.size(); ++i) {
                String string = i < 10 ? " " : "";
                DebugManager.this.println("[" + string + i + "] " + this._history.get(i));
            }
        }

        void saveHistory() {
            Preferences preferences = Preferences.instance();
            if (preferences.getBoolean(DebugManager.PREF_PATH, DebugManager.DEBUG_HISTORY, false)) {
                int n = 0;
                ListIterator listIterator = this._history.listIterator();
                while (listIterator.hasNext()) {
                    String string = (String)listIterator.next();
                    if (string.length() <= 0) continue;
                    preferences.setProperty(DebugManager.DEBUG_HISTORY_LINE, String.valueOf(n++), string);
                }
                try {
                    preferences.store();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    KDebug.printStackTrace(fileNotFoundException);
                }
                catch (IOException iOException) {
                    KDebug.printStackTrace(iOException);
                }
            }
        }

        public LinkedList loadHistory() {
            this._history.clear();
            Preferences preferences = Preferences.instance();
            if (preferences.getBoolean(DebugManager.PREF_PATH, DebugManager.DEBUG_HISTORY, false)) {
                for (int i = 0; i < 30; ++i) {
                    String string = preferences.getProperty(DebugManager.DEBUG_HISTORY_LINE, String.valueOf(i), "");
                    if (string.length() <= 0) continue;
                    this._history.addFirst(string);
                }
            }
            return this._history;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String load(String string) {
            String string2 = null;
            if ((string = string.substring(1)).startsWith("?")) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("!")) {
                string3 = "0";
            }
            try {
                int n = Integer.parseInt(string3);
                if (n < this._history.size()) {
                    string2 = this._history.get(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                ListIterator listIterator = this._history.listIterator();
                while (listIterator.hasNext()) {
                    String string4 = (String)listIterator.next();
                    if (string4.indexOf(string3) == -1) continue;
                    string2 = string4;
                    break;
                }
            }
            if (string2 != null) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = string2 + " " + stringTokenizer.nextToken();
                }
            }
            DebugManager.this.println("->" + string2);
            return string2;
        }
    }
}

