/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.BusEvent;
import cerent.util.KDebug;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class EventBus
extends Observable {
    private static EventBus instance = null;
    private KDebug dbg = new EventBusDebug();
    private Map map = Collections.synchronizedMap(new HashMap());

    private EventBus() {
    }

    public static synchronized EventBus instance() {
        if (instance == null) {
            instance = new EventBus();
        }
        return instance;
    }

    public void addObserver(Observer observer, Object object) {
        Set<Observer> set;
        if (this.dbg.isFinestEnabled()) {
            this.dbg.println("addObserver observer=" + observer + ", source=" + object);
        }
        if ((set = (Set<Observer>)this.map.get(object)) == null) {
            set = Collections.synchronizedSet(new HashSet());
            this.map.put(object, set);
        }
        set.add(observer);
    }

    public void deleteObserver(Observer observer, Object object) {
        Set set;
        if (this.dbg.isFinestEnabled()) {
            this.dbg.println("deleteObserver observer=" + observer + ", source=" + object);
        }
        if ((set = (Set)this.map.get(object)) != null) {
            set.remove(observer);
            if (set.isEmpty()) {
                this.map.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Observer observer) {
        if (this.dbg.isFinestEnabled()) {
            this.dbg.println("deleteObserver observer=" + observer + " source=all");
        }
        Map map = this.map;
        synchronized (map) {
            Object[] objectArray = this.map.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.deleteObserver(observer, objectArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(Object object, Object object2) {
        HashSet hashSet;
        if (this.dbg.isFinestEnabled()) {
            this.dbg.println("notifyObservers source=" + object + ", event=" + object2);
        }
        if ((hashSet = (HashSet)this.map.get(object)) != null) {
            Object object3 = hashSet;
            synchronized (object3) {
                hashSet = new HashSet(hashSet);
            }
            object3 = new BusEvent(object, object2);
            for (Observer observer : hashSet) {
                if (this.dbg.isFinestEnabled()) {
                    this.dbg.println("notifying observer=" + observer);
                }
                try {
                    observer.update(this, object3);
                }
                catch (Exception exception) {
                    KDebug.printStackTrace(exception);
                }
            }
        }
    }

    public class EventBusDebug
    extends KDebug {
        EventBusDebug() {
            super("EventBus");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpDiag() {
            this.display("EventBus dump");
            Map map = EventBus.this.map;
            synchronized (map) {
                for (Object k : EventBus.this.map.keySet()) {
                    this.display("    source=" + k);
                    HashSet hashSet = new HashSet((Set)EventBus.this.map.get(k));
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        this.display("        observer=" + iterator.next());
                    }
                }
            }
        }
    }
}

