/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.ComparisonUtil;
import cerent.util.IIPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.OutOfVirtualAddressesException;
import cerent.util.Preferences;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPAddressTranslator
implements IIPAddressTranslator {
    static InetAddress startAddr = null;
    static final String DEFAULT_END_VIRTUAL_ADDR = "255.255.255.254";
    private static final String TRANSLATOR_PATH = "ctc";
    private static final String TRANSLATOR_KEY = "addressTranslatorClass";
    private static final String DUP_IP = "dupip";
    private static final String ENABLE_KEY = "dupip.enable";
    private static final String START_VIRTUAL_KEY = "dupip.startvirtual";
    private static final String END_VIRTUAL_KEY = "dupip.endvirtual";
    protected static final Preferences prefs = Preferences.instance();
    private static final String className = prefs.getProperty("ctc", "addressTranslatorClass", null);
    protected static final boolean enabled = prefs.getBoolean("ctc", "dupip.enable", false);
    protected static final String DEFAULT_START_VIRTUAL_ADDR = "240.0.0.0";
    protected static final String startVirtual = prefs.getProperty("ctc", "dupip.startvirtual", "240.0.0.0");
    protected static final String endVirtual = prefs.getProperty("ctc", "dupip.endvirtual", "255.255.255.254");
    private static KDebug db = new IPAddressTranslatorDebug();
    private static IIPAddressTranslator _instance = null;
    private BigSerial serial = new BigSerial();
    private HashMap<ActualAddress, InetAddress> actualMap = new HashMap();
    private HashMap<InetAddress, ActualAddress> virtualMap = new HashMap();

    public boolean isEnabled() {
        return enabled;
    }

    public byte[] getStart() {
        return this.serial.getStart();
    }

    public byte[] getEnd() {
        return this.serial.getEnd();
    }

    public InetAddress getStartAddr() {
        return this.serial.getStartAddr();
    }

    public InetAddress getEndAddr() {
        return this.serial.getEndAddr();
    }

    public InetAddress getNext() {
        return this.serial.toInet6Address();
    }

    protected final void setEnd(InetAddress inetAddress) {
        this.serial.setEnd(inetAddress);
    }

    public static synchronized IIPAddressTranslator instance() {
        if (_instance == null) {
            Serializable serializable;
            try {
                startAddr = InetAddress.getByName(startVirtual);
            }
            catch (UnknownHostException unknownHostException) {
                db.println("Invalid start virtual address: " + startVirtual);
                db.println("Falling back to default start virtual addr.");
                KDebug.printStackTrace(unknownHostException);
                try {
                    startAddr = InetAddress.getByName(DEFAULT_START_VIRTUAL_ADDR);
                }
                catch (UnknownHostException unknownHostException2) {
                    // empty catch block
                }
            }
            if (className != null) {
                try {
                    serializable = Class.forName(className);
                    Object obj = serializable.newInstance();
                    if (obj instanceof IIPAddressTranslator) {
                        _instance = (IIPAddressTranslator)obj;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    db.println("ClassNotFoundException loading " + className);
                    db.println("Falling back to default implementation.");
                    KDebug.printStackTrace(classNotFoundException);
                    _instance = null;
                }
                catch (InstantiationException instantiationException) {
                    db.println("InstantiationException creating " + className);
                    db.println("Falling back to default implementation.");
                    KDebug.printStackTrace(instantiationException);
                    _instance = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    db.println("IllegalAccessException creating " + className);
                    db.println("Falling back to default implementation.");
                    KDebug.printStackTrace(illegalAccessException);
                    _instance = null;
                }
            }
            if (_instance == null) {
                _instance = new IPAddressTranslator();
            }
            if (_instance instanceof IPAddressTranslator) {
                serializable = null;
                try {
                    serializable = InetAddress.getByName(endVirtual);
                    ((IPAddressTranslator)_instance).setEnd((InetAddress)serializable);
                }
                catch (UnknownHostException unknownHostException) {
                    db.println("Invalid end virtual address: " + endVirtual);
                    db.println("Falling back to default end virtual addr.");
                    KDebug.printStackTrace(unknownHostException);
                }
            }
        }
        return _instance;
    }

    private IPAddressTranslator() {
    }

    public boolean isVirtual(InetAddress inetAddress) {
        if (!enabled) {
            return true;
        }
        byte[] byArray = this.getStart();
        byte[] byArray2 = this.getEnd();
        byte[] byArray3 = inetAddress.getAddress();
        boolean bl = BigSerial.compareTo(byArray3, byArray) >= 0 && BigSerial.compareTo(byArray3, byArray2) <= 0;
        return bl;
    }

    public boolean isVirtual(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return this.isVirtual(inetAddress);
    }

    public InetAddress getVirtualAddress(String string, int n) throws UnknownHostException {
        return this.getVirtualAddress(InetAddress.getByName(string), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getVirtualAddress(InetAddress inetAddress, int n) throws UnknownHostException {
        IPAddressTranslator iPAddressTranslator = this;
        synchronized (iPAddressTranslator) {
            if (this.virtualMap.keySet().contains(inetAddress)) {
                return inetAddress;
            }
            InetAddress inetAddress2 = this.findVirtualAddress(inetAddress, n);
            ActualAddress actualAddress = new ActualAddress(inetAddress, n);
            if (inetAddress2 == null) {
                if (enabled) {
                    inetAddress2 = this.serial.toInet4Address();
                    this.serial.increment(inetAddress);
                } else {
                    inetAddress2 = inetAddress;
                }
                this.actualMap.put(actualAddress, inetAddress2);
                this.virtualMap.put(inetAddress2, actualAddress);
                if (db.on()) {
                    db.println("getVirtualAddress: Added mapping for " + actualAddress.getIpNodeIdString() + " => " + inetAddress2.getHostAddress());
                    if (db.isFinestEnabled()) {
                        KDebug.printStackTrace(new Throwable().fillInStackTrace());
                    }
                }
            }
            return inetAddress2;
        }
    }

    public String translateIPsVirtualToActual(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?\\.\\d\\d?\\d?");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        for (String string3 : arrayList) {
            InetAddress inetAddress;
            try {
                inetAddress = this.getActualAddress(InetAddress.getByName(string3));
            }
            catch (UnknownHostException unknownHostException) {
                continue;
            }
            if (inetAddress != null) {
                matcher.usePattern(Pattern.compile(string3));
                string2 = matcher.replaceFirst(inetAddress.getHostAddress());
                matcher.reset(string2);
            }
            db.fine("translateIPsVirtualToActual: msg " + string2);
        }
        return string2;
    }

    public InetAddress getActualAddress(InetAddress inetAddress) {
        ActualAddress actualAddress = this.virtualMap.get(inetAddress);
        return actualAddress == null ? null : actualAddress.getActualAddress();
    }

    public String getActualAddressDisplay(String string) {
        InetAddress inetAddress = this.getActualAddress(string);
        return inetAddress == null ? string : inetAddress.getHostAddress();
    }

    public InetAddress getActualAddress(String string) {
        try {
            return this.getActualAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public String getSecureAddressDisplay(String string) {
        InetAddress inetAddress = this.getSecureAddress(string);
        return inetAddress == null ? string : inetAddress.getHostAddress();
    }

    public InetAddress getSecureAddress(InetAddress inetAddress) {
        ActualAddress actualAddress = this.virtualMap.get(inetAddress);
        return actualAddress == null ? null : actualAddress.getSecureAddress();
    }

    public InetAddress getSecureAddress(String string) {
        try {
            return this.getSecureAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public InetAddress getPublicAddress(InetAddress inetAddress) {
        ActualAddress actualAddress = this.virtualMap.get(inetAddress);
        return actualAddress == null ? null : actualAddress.getPublicAddress();
    }

    public String getPublicAddressDisplay(String string) {
        InetAddress inetAddress = this.getPublicAddress(string);
        return inetAddress == null ? string : inetAddress.getHostAddress();
    }

    public InetAddress getPublicAddress(String string) {
        try {
            return this.getPublicAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getActualNodeId(InetAddress inetAddress) {
        ActualAddress actualAddress = this.virtualMap.get(inetAddress);
        if (actualAddress == null) {
            if (db.on()) {
                if (inetAddress != null) {
                    db.println("getActualNodeId: No mapping for " + inetAddress.getHostAddress());
                } else {
                    db.println("getActualNodeId: virtual address passed for lookup is null");
                }
            }
            return -1;
        }
        return actualAddress.getNodeId();
    }

    public int getActualNodeId(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return -1;
        }
        return this.getActualNodeId(inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress findVirtualAddress(InetAddress inetAddress) throws UnknownHostException {
        if (enabled && this.isVirtual(inetAddress)) {
            throw new UnknownHostException("actual addr " + inetAddress + " is in the virtual range");
        }
        InetAddress inetAddress2 = null;
        IPAddressTranslator iPAddressTranslator = this;
        synchronized (iPAddressTranslator) {
            for (Map.Entry<ActualAddress, InetAddress> entry : this.actualMap.entrySet()) {
                if (!entry.getKey().getPublicAddress().equals(inetAddress) && !entry.getKey().getActualAddress().equals(inetAddress)) continue;
                if (inetAddress2 == null) {
                    inetAddress2 = entry.getValue();
                    continue;
                }
                throw new UnknownHostException("unable to translate actual address " + inetAddress.getHostAddress() + " to a virtual " + "address because more than one mapping exists");
            }
        }
        return inetAddress2;
    }

    public InetAddress findVirtualAddress(String string, int n) throws UnknownHostException {
        if (string == null) {
            return this.findVirtualAddress(n);
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        return this.findVirtualAddress(inetAddress, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress findVirtualAddress(InetAddress inetAddress, int n) throws UnknownHostException {
        InetAddress inetAddress2 = null;
        if (inetAddress.getAddress().length == 16 && (n == 0 || n == -1) && (inetAddress2 = this.findVirtualAddressForIPv6(inetAddress)) != null) {
            return inetAddress2;
        }
        try {
            inetAddress2 = this.findVirtualAddress(n);
            if (!(inetAddress2 == null || inetAddress.equals(this.getPublicAddress(inetAddress2)) || n != 0 && n != -1)) {
                return null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (n != 0 && n != -1) {
                throw new UnknownHostException("node id " + Integer.toHexString(n) + " is a duplicate");
            }
            if (db.on()) {
                db.println("findVirtualAddress: caught " + unknownHostException.getMessage() + " exception.  Retrying query for virtual ip with " + inetAddress.getHostAddress());
            }
            inetAddress2 = this.findVirtualAddress(inetAddress);
        }
        IPAddressTranslator iPAddressTranslator = this;
        synchronized (iPAddressTranslator) {
            try {
                if (inetAddress2 == null) {
                    ActualAddress actualAddress = new ActualAddress(inetAddress, 0);
                    ActualAddress actualAddress2 = new ActualAddress(inetAddress, -1);
                    inetAddress2 = this.actualMap.get(actualAddress);
                    if (inetAddress2 != null) {
                        this.updateNodeId(inetAddress2, n);
                        return inetAddress2;
                    }
                    inetAddress2 = this.actualMap.get(actualAddress2);
                    if (inetAddress2 != null) {
                        this.updateNodeId(inetAddress2, n);
                        return inetAddress2;
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                db.println("findVirtualAddress: caught UnknownHostException " + unknownHostException.getMessage());
                KDebug.printStackTrace(unknownHostException);
            }
        }
        return inetAddress2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress findVirtualAddress(int n) throws UnknownHostException {
        InetAddress inetAddress = null;
        Integer n2 = new Integer(n);
        IPAddressTranslator iPAddressTranslator = this;
        synchronized (iPAddressTranslator) {
            for (Map.Entry<ActualAddress, InetAddress> entry : this.actualMap.entrySet()) {
                if (!entry.getKey().getNodeId().equals(n2)) continue;
                if (inetAddress == null) {
                    inetAddress = entry.getValue();
                    continue;
                }
                throw new UnknownHostException("unable to translate nodeId " + Integer.toHexString(n) + " to a virtual " + "address because more than one mapping exists");
            }
        }
        return inetAddress;
    }

    public boolean updateSecureIpAddress(String string, String string2) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        if (inetAddress == null || this.virtualMap.get(inetAddress) == null) {
            String string3 = inetAddress == null ? "unknown" : inetAddress.getHostAddress();
            throw new UnknownHostException("updateSecureIpAddress: host " + string3 + " not found");
        }
        ActualAddress actualAddress = this.virtualMap.get(inetAddress);
        InetAddress inetAddress2 = InetAddress.getByName(string2);
        if (inetAddress2.equals(actualAddress.getSecureAddress())) {
            return false;
        }
        if (db.on()) {
            db.println("updateSecureIpAddress: BEFORE - " + actualAddress.toStringWithVirtual() + "attempting to change to" + inetAddress2);
        }
        InetAddress inetAddress3 = actualAddress.getActualAddress();
        InetAddress inetAddress4 = actualAddress.getPublicAddress();
        InetAddress inetAddress5 = actualAddress.getSecureAddress();
        InetAddress inetAddress6 = !inetAddress5.equals(inetAddress4) && inetAddress5.equals(inetAddress3) ? inetAddress2 : inetAddress3;
        ActualAddress actualAddress2 = new ActualAddress(inetAddress6, inetAddress2, inetAddress4, actualAddress.getIPv6Address(), actualAddress.getNodeId());
        this.updateMapsWithNewActualAddress(actualAddress, inetAddress, actualAddress2);
        if (db.on()) {
            db.println("updateSecureIpAddress: AFTER - " + actualAddress2.toStringWithVirtual());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapsWithNewActualAddress(ActualAddress actualAddress, InetAddress inetAddress, ActualAddress actualAddress2) {
        if (db.on()) {
            db.fine("Inside updateMapsWithNewActualAddress ");
        }
        IPAddressTranslator iPAddressTranslator = this;
        synchronized (iPAddressTranslator) {
            if (enabled) {
                this.actualMap.remove(actualAddress);
                this.virtualMap.remove(inetAddress);
                this.actualMap.put(actualAddress2, inetAddress);
                this.virtualMap.put(inetAddress, actualAddress2);
            } else {
                this.actualMap.remove(actualAddress);
                this.virtualMap.remove(inetAddress);
                inetAddress = actualAddress2.getActualAddress();
                this.actualMap.put(actualAddress2, inetAddress);
                this.virtualMap.put(inetAddress, actualAddress2);
            }
        }
    }

    public boolean updatePublicIpAddress(String string, String string2) throws UnknownHostException {
        InetAddress inetAddress;
        InetAddress inetAddress2 = InetAddress.getByName(string);
        if (inetAddress2 == null || this.virtualMap.get(inetAddress2) == null) {
            String string3 = inetAddress2 == null ? "unknown" : inetAddress2.getHostAddress();
            throw new UnknownHostException("updatePublicIpAddress: host " + string3 + " not found");
        }
        ActualAddress actualAddress = this.virtualMap.get(inetAddress2);
        InetAddress inetAddress3 = InetAddress.getByName(string2);
        if (inetAddress3.equals(actualAddress.getPublicAddress())) {
            return false;
        }
        if (db.on()) {
            db.println("updatePublicIpAddress: BEFORE - " + actualAddress.toStringWithVirtual() + "attempting to change to" + inetAddress3);
        }
        InetAddress inetAddress4 = actualAddress.getActualAddress();
        InetAddress inetAddress5 = actualAddress.getPublicAddress();
        InetAddress inetAddress6 = !inetAddress5.equals(inetAddress = actualAddress.getSecureAddress()) && inetAddress5.equals(inetAddress4) ? inetAddress3 : inetAddress4;
        ActualAddress actualAddress2 = new ActualAddress(inetAddress6, inetAddress, inetAddress3, actualAddress.getIPv6Address(), actualAddress.getNodeId());
        this.updateMapsWithNewActualAddress(actualAddress, inetAddress2, actualAddress2);
        if (db.on()) {
            db.println("updatePublicIpAddress: AFTER - " + actualAddress2.toStringWithVirtual());
        }
        return true;
    }

    public void updateNodeId(String string, int n) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        this.updateNodeId(inetAddress, n);
    }

    public void updateNodeId(InetAddress inetAddress, int n) throws UnknownHostException {
        ActualAddress actualAddress = this.virtualMap.get(inetAddress);
        if (actualAddress == null) {
            throw new UnknownHostException("updateNodeId: host " + inetAddress.getHostAddress() + " not found");
        }
        if (actualAddress.getNodeId() == n) {
            return;
        }
        InetAddress inetAddress2 = null;
        try {
            inetAddress2 = this.findVirtualAddress(n);
        }
        catch (UnknownHostException unknownHostException) {
            if (n != 0 && n != -1 && inetAddress.getAddress().length == 16) {
                if (db.on()) {
                    db.println("updateNodeId : Removing redundant IPv6 entry from translation map");
                }
                this.removeVirtual(inetAddress.getHostName());
            }
            return;
        }
        if (inetAddress2 != null && n != 0 && n != -1) {
            ActualAddress actualAddress2 = this.virtualMap.get(inetAddress2);
            if (inetAddress.getAddress().length == 16) {
                if (db.on()) {
                    db.println("updateNodeId : Removing redundant IPv6 entry from translation map");
                }
                this.removeVirtual(inetAddress.getHostName());
            }
            throw new UnknownHostException("unable to update " + inetAddress.getHostAddress() + " because the nodeId is owned by actual " + actualAddress2.getIpNodeIdString() + " virtual " + inetAddress2.getHostAddress());
        }
        if (db.on()) {
            db.println("updateNodeId: BEFORE - " + actualAddress.toStringWithVirtual());
        }
        ActualAddress actualAddress3 = new ActualAddress(actualAddress.getActualAddress(), actualAddress.getSecureAddress(), actualAddress.getPublicAddress(), actualAddress.getIPv6Address(), n);
        this.updateMapsWithNewActualAddress(actualAddress, inetAddress, actualAddress3);
        if (db.on()) {
            db.println("updateNodeId: AFTER - " + actualAddress3.toStringWithVirtual());
        }
    }

    public boolean updateActualAddress(String string, String string2) throws UnknownHostException {
        if (string.equals(string2)) {
            return false;
        }
        if (this.getActualAddress(string) == null || this.getActualAddress(string2) == null) {
            throw new UnknownHostException("updateActualAddress: host " + string + " or host " + string2 + " not found");
        }
        String string3 = this.getSecureAddressDisplay(string2);
        String string4 = this.getSecureAddressDisplay(string);
        String string5 = this.getPublicAddressDisplay(string2);
        String string6 = this.getPublicAddressDisplay(string);
        this.updateSecureIpAddress(string, this.getSecureAddressDisplay(string2));
        this.updatePublicIpAddress(string, this.getPublicAddressDisplay(string2));
        return !string3.equals(string4) || !string5.equals(string6);
    }

    public boolean isVirtualMapped(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return this.virtualMap.containsKey(inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVirtual(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        IPAddressTranslator iPAddressTranslator = this;
        synchronized (iPAddressTranslator) {
            if (this.virtualMap.containsKey(inetAddress)) {
                ActualAddress actualAddress = this.virtualMap.get(inetAddress);
                if (db.on()) {
                    db.println("removeVirtual: removing " + actualAddress.getIpNodeIdString() + " virtual " + string + " from the translation table");
                }
                this.actualMap.remove(actualAddress);
                this.virtualMap.remove(inetAddress);
            }
        }
    }

    public void dumpAddressTranslations(KDebug kDebug) {
        for (Map.Entry<ActualAddress, InetAddress> entry : this.actualMap.entrySet()) {
            kDebug.println(entry.getValue().getHostAddress() + " ==> " + entry.getKey().toString());
        }
    }

    public void dumpVirtualMap(KDebug kDebug) {
        kDebug.println("----------------------VirtualMap------------------");
        for (Map.Entry<InetAddress, ActualAddress> entry : this.virtualMap.entrySet()) {
            kDebug.println(entry.getValue().toString() + " ==> " + entry.getKey().toString());
        }
    }

    public InetAddress getIPv6Address(InetAddress inetAddress) {
        ActualAddress actualAddress = this.virtualMap.get(inetAddress);
        return actualAddress == null ? null : actualAddress.getIPv6Address();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress findVirtualAddressForIPv6(InetAddress inetAddress) throws UnknownHostException {
        if (enabled && this.isVirtual(inetAddress)) {
            throw new UnknownHostException("actual addr " + inetAddress + " is in the virtual range");
        }
        InetAddress inetAddress2 = null;
        IPAddressTranslator iPAddressTranslator = this;
        synchronized (iPAddressTranslator) {
            for (Map.Entry<ActualAddress, InetAddress> entry : this.actualMap.entrySet()) {
                if (!entry.getKey().getIPv6Address().equals(inetAddress)) continue;
                if (inetAddress2 == null) {
                    inetAddress2 = entry.getValue();
                    continue;
                }
                throw new UnknownHostException("unable to translate IPv6 address " + inetAddress.getHostAddress() + " to a virtual ");
            }
        }
        return inetAddress2;
    }

    public boolean updateIPv6Address(InetAddress inetAddress, int n, InetAddress inetAddress2) throws UnknownHostException {
        ActualAddress actualAddress;
        if (db.on()) {
            db.fine("Entering updateIPv6Address : virtual -> " + inetAddress + " nodeId -> " + n + "ipv6Address -> " + inetAddress2);
        }
        if ((actualAddress = this.virtualMap.get(inetAddress)) == null) {
            db.println("updateIPv6Address: host " + inetAddress.getHostAddress() + " not found");
            return false;
        }
        InetAddress inetAddress3 = null;
        try {
            if (n != 0 && n != -1) {
                inetAddress3 = this.findVirtualAddress(n);
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (db.on()) {
                db.println("Removing duplicate virtual entry\n");
            }
            this.removeVirtual(inetAddress.getHostName());
            return false;
        }
        if (actualAddress.getNodeId() == n && actualAddress.getIPv6Address().equals(inetAddress2)) {
            return true;
        }
        if (db.on()) {
            db.println("updateIPv6Address: before update - " + actualAddress.toStringWithVirtual());
        }
        if (n == 0) {
            n = actualAddress.getNodeId();
        }
        InetAddress inetAddress4 = null;
        inetAddress4 = actualAddress.getActualAddress().getAddress().length == 16 ? inetAddress2 : actualAddress.getActualAddress();
        ActualAddress actualAddress2 = new ActualAddress(inetAddress4, actualAddress.getSecureAddress(), actualAddress.getPublicAddress(), inetAddress2, n);
        this.updateMapsWithNewActualAddress(actualAddress, inetAddress, actualAddress2);
        if (db.on()) {
            db.println("updateIPv6Address: after update - " + actualAddress2.toStringWithVirtual());
        }
        return true;
    }

    private static class ActualAddress {
        private final InetAddress actualIpAddr;
        private final InetAddress secureIpAddr;
        private final InetAddress publicIpAddr;
        private final InetAddress nodeIpv6Addr;
        private final Integer nodeId;

        public ActualAddress(InetAddress inetAddress, int n) {
            InetAddress inetAddress2;
            InetAddress inetAddress3;
            try {
                inetAddress3 = InetAddress.getByName("0.0.0.0");
                inetAddress2 = InetAddress.getByName("0:0:0:0:0:0:0:0");
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress3 = inetAddress;
                inetAddress2 = inetAddress;
            }
            this.actualIpAddr = inetAddress;
            this.secureIpAddr = inetAddress3;
            this.publicIpAddr = inetAddress3;
            this.nodeIpv6Addr = inetAddress2;
            this.nodeId = new Integer(n);
        }

        public ActualAddress(InetAddress inetAddress, InetAddress inetAddress2, InetAddress inetAddress3, InetAddress inetAddress4, int n) {
            this.actualIpAddr = inetAddress;
            this.secureIpAddr = inetAddress2;
            this.publicIpAddr = inetAddress3;
            this.nodeIpv6Addr = inetAddress4;
            this.nodeId = new Integer(n);
        }

        public ActualAddress(InetAddress inetAddress, InetAddress inetAddress2, InetAddress inetAddress3, int n) {
            InetAddress inetAddress4;
            try {
                inetAddress4 = InetAddress.getByName("0:0:0:0:0:0:0:0");
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress4 = inetAddress;
            }
            this.actualIpAddr = inetAddress;
            this.secureIpAddr = inetAddress2;
            this.publicIpAddr = inetAddress3;
            this.nodeIpv6Addr = inetAddress4;
            this.nodeId = new Integer(n);
        }

        public InetAddress getActualAddress() {
            return this.actualIpAddr;
        }

        public InetAddress getSecureAddress() {
            return this.secureIpAddr;
        }

        public InetAddress getPublicAddress() {
            return this.publicIpAddr;
        }

        public InetAddress getIPv6Address() {
            return this.nodeIpv6Addr;
        }

        public Integer getNodeId() {
            return this.nodeId;
        }

        public int hashCode() {
            int n = 17;
            n = n * 37 + this.actualIpAddr.hashCode();
            n = n * 37 + this.secureIpAddr.hashCode();
            n = n * 37 + this.publicIpAddr.hashCode();
            n = n * 37 + this.nodeIpv6Addr.hashCode();
            n = n * 37 + this.nodeId.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (object != null) {
                if (object == this) {
                    return true;
                }
                if (object instanceof ActualAddress) {
                    ActualAddress actualAddress = (ActualAddress)object;
                    if (actualAddress.actualIpAddr.equals(this.actualIpAddr) && actualAddress.secureIpAddr.equals(this.secureIpAddr) && actualAddress.publicIpAddr.equals(this.publicIpAddr) && actualAddress.nodeIpv6Addr.equals(this.nodeIpv6Addr) && actualAddress.nodeId.equals(this.nodeId)) {
                        return true;
                    }
                }
            }
            return false;
        }

        public String getIpNodeIdString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.actualIpAddr.getHostAddress());
            stringBuffer.append('(');
            stringBuffer.append(this.getNodeIdString());
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public String getNodeIdString() {
            StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(this.nodeId));
            while (stringBuffer.length() < 8) {
                stringBuffer.insert(0, '0');
            }
            return stringBuffer.toString();
        }

        public String toStringWithVirtual() {
            String string = "";
            try {
                InetAddress inetAddress = IPAddressTranslator.instance().findVirtualAddress(this.publicIpAddr, (int)this.nodeId);
                string = inetAddress == null ? "unknown" : inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return this.toString() + " virtual " + string;
        }

        public String toString() {
            return "node id " + this.getNodeIdString() + ", actual ip " + this.actualIpAddr.getHostAddress() + ", public ip " + this.publicIpAddr.getHostAddress() + ", secure ip " + this.secureIpAddr.getHostAddress() + ", ipv6 addr " + this.nodeIpv6Addr.getHostAddress();
        }
    }

    private static class BigSerial {
        private byte[] bytes = new byte[16];
        private byte[] start;
        private byte[] end;

        public BigSerial() {
            this(startAddr);
        }

        public BigSerial(byte[] byArray) {
            this.start = byArray;
            System.arraycopy(byArray, 0, this.bytes, this.bytes.length - byArray.length, byArray.length);
            try {
                this.setEnd(InetAddress.getByName(IPAddressTranslator.DEFAULT_END_VIRTUAL_ADDR).getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }

        public BigSerial(InetAddress inetAddress) {
            this(inetAddress.getAddress());
        }

        public byte[] getStart() {
            return this.start;
        }

        public byte[] getEnd() {
            return this.end;
        }

        public InetAddress getStartAddr() {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByAddress(this.start);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return inetAddress;
        }

        public InetAddress getEndAddr() {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByAddress(this.end);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return inetAddress;
        }

        protected final void setEnd(byte[] byArray) {
            if (byArray != null) {
                this.end = byArray;
                if (this.compareTo(byArray) > 0) {
                    String string = this.getStartAddr().getHostAddress();
                    String string2 = this.getEndAddr().getHostAddress();
                    String string3 = "-any-";
                    String string4 = KErrorMsg.getString(KEMC.OUT_OF_VIRTUAL_ADDRS, string3, string, string2);
                    db.severe(string4 + ". End address is < start address.");
                    OutOfVirtualAddressesException outOfVirtualAddressesException = new OutOfVirtualAddressesException(string4, string3, string, string2);
                    throw outOfVirtualAddressesException;
                }
            }
        }

        protected final void setEnd(InetAddress inetAddress) {
            this.setEnd(inetAddress == null ? null : inetAddress.getAddress());
        }

        protected final void increment(InetAddress inetAddress) {
            boolean bl = true;
            if (this.compareTo(this.end) > 0) {
                String string = inetAddress.getHostAddress();
                String string2 = this.getStartAddr().getHostAddress();
                String string3 = this.getEndAddr().getHostAddress();
                String string4 = KErrorMsg.getString(KEMC.OUT_OF_VIRTUAL_ADDRS, string, string2, string3);
                db.severe(string4 + " If CTM is using the default CTC implementation of IIpAddressTranslator, this is probably the root cause of the problem. IP address recycling is mandatory in a 24x7 ENMS.");
                OutOfVirtualAddressesException outOfVirtualAddressesException = new OutOfVirtualAddressesException(string4, string, string2, string3);
                throw outOfVirtualAddressesException;
            }
            for (int i = this.bytes.length - 1; i >= 0; --i) {
                int n = this.bytes[i] & 0xFF;
                if (!bl) continue;
                this.bytes[i] = (byte)(++n & 0xFF);
                bl = n > 255;
            }
        }

        protected final int compareTo(byte[] byArray) {
            return BigSerial.compareTo(this.bytes, byArray);
        }

        static int compareTo(byte[] byArray, byte[] byArray2) {
            int n = 0;
            int n2 = byArray2 == null ? 0 : byArray2.length;
            int n3 = byArray.length - n2;
            for (int i = 0; n == 0 && i < byArray.length; ++i) {
                int n4 = byArray[i] & 0xFF;
                int n5 = n3 > i ? 0 : byArray2[i - n3] & 0xFF;
                n = ComparisonUtil.compare(n4, n5);
            }
            return n;
        }

        public InetAddress toInet4Address() {
            byte[] byArray = new byte[4];
            System.arraycopy(this.bytes, 12, byArray, 0, 4);
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                db.println("toInet4Address: UnknownHostException");
                db;
                KDebug.printStackTrace(unknownHostException);
            }
            return inetAddress;
        }

        public InetAddress toInet6Address() {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByAddress(this.bytes);
            }
            catch (UnknownHostException unknownHostException) {
                db.println("toInet6Address: UnknownHostException");
                db;
                KDebug.printStackTrace(unknownHostException);
            }
            return inetAddress;
        }

        private String toHexDigit(byte by) {
            String string = Integer.toHexString(by & 0xFF);
            if (string.length() < 2) {
                return "0" + string;
            }
            return string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.toHexDigit(this.bytes[0]));
            stringBuffer.append(this.toHexDigit(this.bytes[1]));
            stringBuffer.append(' ');
            stringBuffer.append(this.toHexDigit(this.bytes[2]));
            stringBuffer.append(this.toHexDigit(this.bytes[3]));
            stringBuffer.append(' ');
            stringBuffer.append(this.toHexDigit(this.bytes[4]));
            stringBuffer.append(this.toHexDigit(this.bytes[5]));
            stringBuffer.append(' ');
            stringBuffer.append(this.toHexDigit(this.bytes[6]));
            stringBuffer.append(this.toHexDigit(this.bytes[7]));
            stringBuffer.append(' ');
            stringBuffer.append(this.toHexDigit(this.bytes[8]));
            stringBuffer.append(this.toHexDigit(this.bytes[9]));
            stringBuffer.append(' ');
            stringBuffer.append(this.toHexDigit(this.bytes[10]));
            stringBuffer.append(this.toHexDigit(this.bytes[11]));
            stringBuffer.append(' ');
            stringBuffer.append(this.toHexDigit(this.bytes[12]));
            stringBuffer.append(this.toHexDigit(this.bytes[13]));
            stringBuffer.append(' ');
            stringBuffer.append(this.toHexDigit(this.bytes[14]));
            stringBuffer.append(this.toHexDigit(this.bytes[15]));
            return stringBuffer.toString();
        }
    }

    private static class IPAddressTranslatorDebug
    extends KDebug {
        public IPAddressTranslatorDebug() {
            super("IPAddressTranslator");
        }

        public final void dumpDiag() throws Exception {
            this.println("dup ip enabled: " + enabled);
            if (_instance instanceof IPAddressTranslator) {
                IPAddressTranslator iPAddressTranslator = (IPAddressTranslator)_instance;
                this.println("start virtual address: " + iPAddressTranslator.getStartAddr().getHostAddress());
                this.println("end virtual address: " + iPAddressTranslator.getEndAddr().getHostAddress());
                this.println("next virtual address to be returned: " + iPAddressTranslator.getNext().getHostAddress());
            }
            this.dumpAddressMap();
        }

        public final void dumpVirtual() throws Exception {
            _instance.dumpVirtualMap(this);
        }

        public final void dumpAddressMap() {
            _instance.dumpAddressTranslations(this);
        }
    }
}

