/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.EncryptionException;
import cerent.util.IDecrypter;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PBEEncrypter
implements IDecrypter {
    private static final String DefaultAlgorithm = "PBEWithMD5AndDES";
    private static final int SaltLength = 8;
    private Cipher ecipher;
    private Cipher dcipher;

    public PBEEncrypter(String string, String string2) throws EncryptionException {
        this(string, PBEEncrypter.createSecretKey(string2));
    }

    public PBEEncrypter(String string, SecretKey secretKey) throws EncryptionException {
        String string2 = DefaultAlgorithm;
        try {
            Object object;
            this.ecipher = Cipher.getInstance(string2);
            this.dcipher = Cipher.getInstance(string2);
            int n = string.length();
            if (n < 8) {
                object = new StringBuffer(string);
                for (int i = n; i < 8; ++i) {
                    ((StringBuffer)object).append("0");
                }
                string = ((StringBuffer)object).toString();
            } else if (n > 8) {
                string = string.substring(n - 8, n);
            }
            object = string.getBytes();
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec((byte[])object, 1000);
            this.ecipher.init(1, (Key)secretKey, pBEParameterSpec);
            this.dcipher.init(2, (Key)secretKey, pBEParameterSpec);
        }
        catch (Throwable throwable) {
            throw new EncryptionException(throwable);
        }
    }

    public String encrypt(String string) throws EncryptionException {
        String string2 = null;
        try {
            byte[] byArray = string.getBytes("UTF8");
            byte[] byArray2 = this.ecipher.doFinal(byArray);
            string2 = new BASE64Encoder().encode(byArray2);
        }
        catch (Throwable throwable) {
            throw new EncryptionException(throwable);
        }
        return string2;
    }

    public String decrypt(String string) throws EncryptionException {
        String string2 = null;
        try {
            byte[] byArray = new BASE64Decoder().decodeBuffer(string);
            byte[] byArray2 = this.dcipher.doFinal(byArray);
            string2 = new String(byArray2, "UTF8");
        }
        catch (Throwable throwable) {
            throw new EncryptionException(throwable);
        }
        return string2;
    }

    private static SecretKey createSecretKey(String string) throws EncryptionException {
        String string2 = DefaultAlgorithm;
        SecretKey secretKey = null;
        String string3 = "";
        try {
            char[] cArray = string.toCharArray();
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string2);
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            byte[] byArray = secretKey.getEncoded();
            string3 = new String(byArray, "UTF8");
        }
        catch (Throwable throwable) {
            throw new EncryptionException(throwable);
        }
        return secretKey;
    }

    public static void main(String[] stringArray) {
        try {
            PBEEncrypter pBEEncrypter = new PBEEncrypter(stringArray[1], stringArray[0]);
            String string = pBEEncrypter.encrypt(stringArray[2]);
            System.out.println("encrypted: " + string);
            System.out.println("decrypted: " + pBEEncrypter.decrypt(string));
        }
        catch (EncryptionException encryptionException) {
            encryptionException.printStackTrace(System.out);
        }
    }
}

