/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RotatingLogOutputStream
extends OutputStream {
    private static final int DEFAULT_LOG_SIZE = 0x100000;
    private static final int DEFAULT_NUM_OLD_LOGS = 7;
    private static boolean userWarned = false;
    private String baseName;
    private String baseInstanceName;
    private String prefix;
    private int numOldLogs;
    private int logSize;
    private FileOutputStream currentLogStream;
    private int fileOffset;

    public RotatingLogOutputStream(String string, String string2, int n, int n2) {
        this.baseName = string + File.separator + string2;
        this.numOldLogs = n;
        this.logSize = n2;
        this.currentLogStream = null;
        this.rotateLogFiles();
    }

    public RotatingLogOutputStream(String string, String string2, int n) {
        this(string, string2, n, 0x100000);
    }

    public RotatingLogOutputStream(String string, String string2) {
        this(string, string2, 7, 0x100000);
    }

    public void write(int n) {
        this.rotatingWrite(n);
    }

    private synchronized void rotatingWrite(int n) {
        try {
            if (this.logSize < this.fileOffset + 1) {
                this.rotateLogFiles();
            }
            this.currentLogStream.write(n);
            ++this.fileOffset;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void write(byte[] byArray) {
        this.rotatingWrite(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.rotatingWrite(byArray, n, n2);
    }

    private synchronized void rotatingWrite(byte[] byArray, int n, int n2) {
        try {
            if (this.logSize < this.fileOffset + n2) {
                this.rotateLogFiles();
            }
            this.currentLogStream.write(byArray, n, n2);
            this.fileOffset += n2;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void flush() {
        try {
            this.currentLogStream.flush();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void close() {
        try {
            this.currentLogStream.close();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        this.currentLogStream = null;
        super.finalize();
    }

    private void rotateLogFiles() {
        try {
            if (this.currentLogStream != null) {
                this.currentLogStream.flush();
                this.currentLogStream.close();
                this.currentLogStream = null;
            }
            for (int i = this.numOldLogs; i > 0; --i) {
                File file = new File(this.baseName + "." + i);
                if (!file.exists()) continue;
                if (i == this.numOldLogs) {
                    file.delete();
                    continue;
                }
                file.renameTo(new File(this.baseName + "." + (i + 1)));
            }
            File file = new File(this.baseName);
            file.renameTo(new File(this.baseName + ".1"));
            this.currentLogStream = new FileOutputStream(file);
            this.fileOffset = 0;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    private void handleException(Exception exception) {
        if (!userWarned) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    KErrorMsg.displayError(null, KEMC.EID_IO_EXC_IN_RLOS);
                }
            });
            thread.start();
            userWarned = true;
            thread = null;
        }
    }
}

