/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.proxy.CtcProxy;
import cerent.util.proxy.CtcProxyFactory;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;

public class CtcBinding {
    private InetAddress _proxyName;
    private HashMap<InetAddress, CtcProxy> _bindings;

    public CtcBinding(InetAddress inetAddress) {
        this._proxyName = inetAddress;
        this._bindings = new HashMap();
    }

    public int size() {
        return this._bindings.size();
    }

    public CtcProxy get(InetAddress inetAddress) {
        return this._bindings.get(inetAddress);
    }

    public void put(InetAddress inetAddress, CtcProxy ctcProxy) {
        this._bindings.put(inetAddress, ctcProxy);
    }

    public CtcProxy remove(InetAddress inetAddress) {
        return this._bindings.remove(inetAddress);
    }

    public CtcProxy any() {
        CtcProxy ctcProxy = null;
        Iterator<CtcProxy> iterator = this._bindings.values().iterator();
        while (iterator.hasNext()) {
            CtcProxy ctcProxy2 = iterator.next();
            if (ctcProxy2.expired()) {
                iterator.remove();
                ctcProxy2 = null;
            }
            if (ctcProxy2 == null) continue;
            ctcProxy = ctcProxy2;
        }
        return ctcProxy;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        CtcProxy ctcProxy = null;
        Iterator<CtcProxy> iterator = this._bindings.values().iterator();
        while (iterator.hasNext()) {
            ctcProxy = iterator.next();
            stringBuffer.append(CtcProxyFactory.getActualAddressDisplay(ctcProxy.getBindHost()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" <- ");
        if (ctcProxy != null) {
            stringBuffer.append(ctcProxy.proxyString());
        } else {
            stringBuffer.append(this._proxyName);
        }
        return stringBuffer.toString();
    }
}

