/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.CtcSslFactory;
import cerent.util.IPAddressTranslator;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.Sckfwd;
import cerent.util.proxy.SckfwdClient;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdRequestReply;
import com.cisco.sot.SotSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtcProxy {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private static WeakHashMap<Socket, Exception> sockets = new WeakHashMap();
    private InetAddress _bindHost;
    private InetAddress _targetHost;
    private int _targetPort;
    private boolean _expired;
    private SckfwdIo _sckfwdIo;
    private Sckfwd _proxy;
    private InetAddress _proxyHost;
    private int _proxyPort;
    private long _created;
    private boolean _secure;
    private boolean _proxying;
    private static SotSocketFactory _socketFactory = new SotSocketFactory();

    CtcProxy(InetAddress inetAddress, int n) throws IOException {
        block6: {
            this._bindHost = null;
            this._targetHost = inetAddress;
            this._targetPort = n;
            this._expired = false;
            this._sckfwdIo = null;
            this._secure = false;
            if (this._proxyHost != null) {
                return;
            }
            try {
                CtcProxyFactory.getServer(inetAddress);
            }
            catch (IOException iOException) {
                if (!CtcProxyFactory.debug()) break block6;
                CtcProxyFactory.println(CtcProxyFactory.getActualAddressDisplay(inetAddress) + ": not a SOCKS server");
            }
        }
        SckfwdClient sckfwdClient = CtcProxyFactory.proxyFor(this._targetHost);
        InetAddress inetAddress2 = IPAddressTranslator.instance().getActualAddress(this._targetHost);
        if (inetAddress2 == null) {
            inetAddress2 = this._targetHost;
        }
        if (sckfwdClient == null) {
            this._proxy = null;
            this._proxyHost = inetAddress2;
            this._proxyPort = n;
        } else {
            this._proxy = sckfwdClient.getServer();
            Sckfwd.SckfwdConnectHolder sckfwdConnectHolder = this._proxy.connect(sckfwdClient, inetAddress2, n);
            SckfwdRequestReply sckfwdRequestReply = sckfwdConnectHolder._reply;
            this._sckfwdIo = sckfwdConnectHolder._sckfwdIo;
            this._expired = this._sckfwdIo != null;
            this._proxyHost = sckfwdRequestReply.getHost();
            this._proxyPort = sckfwdRequestReply.getPort();
        }
        this._proxying = this._proxy != null;
        this._created = System.currentTimeMillis();
    }

    CtcProxy(InetAddress inetAddress, InetAddress inetAddress2, int n, SckfwdIo sckfwdIo, Sckfwd sckfwd, InetAddress inetAddress3, int n2) {
        this._bindHost = inetAddress;
        this._targetHost = inetAddress2;
        this._targetPort = n;
        this._expired = sckfwdIo != null;
        this._sckfwdIo = sckfwdIo;
        this._proxy = sckfwd;
        this._proxyHost = inetAddress3;
        this._proxyPort = n2;
        this._proxying = this._proxy != null;
        this._created = System.currentTimeMillis();
        this._secure = false;
    }

    CtcProxy(InetAddress inetAddress, InetAddress inetAddress2, int n, CtcProxy ctcProxy) {
        this(inetAddress, inetAddress2, n, null, ctcProxy._proxy, ctcProxy._proxyHost, ctcProxy._proxyPort);
    }

    public boolean secured() {
        return this._secure;
    }

    public void setSecure(boolean bl) {
        this._secure = bl;
    }

    public boolean expired() {
        if (!this._expired) {
            if (this._proxy == null) {
                long l = System.currentTimeMillis() - this._created;
                this._expired = l > CtcProxyFactory.timeout();
            } else {
                InetAddress inetAddress = this._targetHost;
                if (this._bindHost != null) {
                    inetAddress = this._bindHost;
                }
                this._expired = !CtcProxyFactory.willProxyFor(this._proxy, inetAddress);
            }
        }
        return this._expired;
    }

    public void expire() {
        this._expired = true;
    }

    public String getKey() {
        if (this._bindHost == null) {
            return CtcProxyFactory.key(this._targetHost, this._targetPort);
        }
        return this._bindHost.getHostAddress() + "->" + CtcProxyFactory.key(this._targetHost, this._targetPort);
    }

    public String getHost() {
        return this._proxyHost.getHostAddress();
    }

    public InetAddress getHostAddr() {
        return this._proxyHost;
    }

    public int getPort() {
        return this._proxyPort;
    }

    Sckfwd getProxy() {
        return this._proxy;
    }

    SckfwdIo getIo() {
        return this._sckfwdIo;
    }

    public boolean isProxying() {
        return this._proxying;
    }

    private Socket openSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        Socket socket;
        if (inetAddress != null) {
            socket = new Socket();
            socket.bind(new InetSocketAddress(inetAddress, n));
            socket.connect(new InetSocketAddress(this._proxyHost, this._proxyPort), n2);
        } else {
            socket = _socketFactory.createSocket(this._proxyHost, this._proxyPort, n2);
        }
        return socket;
    }

    private Socket openSocket(InetAddress inetAddress, int n) throws IOException {
        return this.openSocket(inetAddress, n, CtcProxyFactory.connectTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        Socket socket;
        if (this._sckfwdIo != null) {
            this._sckfwdIo.setConnectTimeout(n2);
            socket = this._sckfwdIo.getSocket();
        } else {
            socket = this.openSocket(inetAddress, n, n2);
        }
        if (this._secure) {
            socket = CtcSslFactory.getSSLSocketFactory().createSocket(socket, this._targetHost.getHostAddress(), this._targetPort, true);
        }
        if (CtcProxyFactory.isSocketHistoryEnabled()) {
            Date date = new Date();
            String string = sdf.format(date);
            String string2 = this.getBindHost() == null ? "ctc->ne" : "ne->ctc";
            WeakHashMap<Socket, Exception> weakHashMap = sockets;
            synchronized (weakHashMap) {
                sockets.put(socket, new Exception("for " + string2 + " proxy: " + this.toString(false) + " created " + date));
            }
        }
        return socket;
    }

    public Socket getSocket(InetAddress inetAddress, int n) throws IOException {
        return this.getSocket(inetAddress, n, CtcProxyFactory.connectTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Socket, Exception> getSockets() {
        HashMap<Socket, Exception> hashMap = null;
        WeakHashMap<Socket, Exception> weakHashMap = sockets;
        synchronized (weakHashMap) {
            hashMap = new HashMap<Socket, Exception>(sockets);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSocketHistory() {
        WeakHashMap<Socket, Exception> weakHashMap = sockets;
        synchronized (weakHashMap) {
            sockets.clear();
        }
    }

    public Socket getSocket() throws IOException, UnknownHostException {
        return this.getSocket(null, -1);
    }

    public Socket getSocket(int n) throws IOException, UnknownHostException {
        return this.getSocket(null, -1, n);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._bindHost == null) {
            if (this.isProxying()) {
                stringBuffer.append(CtcProxyFactory.keyDisplay(this._proxyHost, this._proxyPort));
            } else {
                stringBuffer.append("no-proxy");
            }
        } else if (this.isProxying()) {
            stringBuffer.append(CtcProxyFactory.getActualAddressDisplay(this._bindHost));
            stringBuffer.append("<-");
            stringBuffer.append(CtcProxyFactory.keyDisplay(this._proxyHost, this._proxyPort));
        } else {
            stringBuffer.append("no-proxy(");
            stringBuffer.append(CtcProxyFactory.getActualAddressDisplay(this._bindHost));
            stringBuffer.append(")");
        }
        if (this._bindHost == null) {
            stringBuffer.append("->");
        } else {
            stringBuffer.append("<-");
        }
        stringBuffer.append(CtcProxyFactory.keyDisplay(this._targetHost, this._targetPort));
        if (bl) {
            if (this._proxy == null) {
                stringBuffer.append(" (");
                stringBuffer.append(System.currentTimeMillis() - this._created);
                stringBuffer.append("ms)");
            } else {
                stringBuffer.append(" (");
                stringBuffer.append(this._proxy.toString());
                stringBuffer.append(")");
            }
            if (this._expired) {
                stringBuffer.append(" (expired)");
            }
        }
        return stringBuffer.toString();
    }

    boolean isSelfProxying() {
        boolean bl = false;
        if (this._proxy != null) {
            bl = this._bindHost != null ? this._proxyHost.equals(this._bindHost) : this._proxyHost.equals(this._targetHost);
        }
        return bl;
    }

    InetAddress getBindHost() {
        return this._bindHost;
    }

    String proxyString() {
        return CtcProxyFactory.key(this._proxyHost, this._proxyPort);
    }
}

