/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.CtcRuntime;
import cerent.util.IDebugDiag;
import cerent.util.IIPAddressTranslator;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.proxy.CtcProxy;
import cerent.util.proxy.CtcServerProxy;
import cerent.util.proxy.IInetAddressTranslator;
import cerent.util.proxy.Sckfwd;
import cerent.util.proxy.SckfwdBid;
import cerent.util.proxy.SckfwdClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtcProxyFactory {
    private static final String PROXY_PREF = "ctc.proxy";
    private static final String PROXY_DESGNE = "designatedgnes";
    private static final String SOCKET_HISTORY = "sockethistory";
    private static final String INITIAL_SERVER = "initialserver";
    static final String CTC_NE_DIR = "ctc->ne";
    static final String NE_CTC_DIR = "ne->ctc";
    static final Long INFINITY = new Long(Long.MAX_VALUE);
    private static final long _timeout = Preferences.instance().getInt("ctc.proxy", "timeout", 60000);
    private static final int _connectTimeout = Preferences.instance().getInt("ctc.proxy", "connect", 5000);
    private static final int _readTimeout = Preferences.instance().getInt("ctc.proxy", "read", 60000);
    private static final int _acceptTimeout = Preferences.instance().getInt("ctc.proxy", "accept", 120000);
    private static final String _bindAddress = Preferences.instance().getProperty("ctc.proxy", "bindAddress", null);
    private static final int _defaultCost = Preferences.instance().getInt("ctc.proxy", "defaultCost", 500);
    public static final int SCKFWD_PORT = 1080;
    static final Debug _debug = new Debug("CtcProxyFactory");
    private static final int _numWorkerThreads = Preferences.instance().getInt("ctc.proxy", "workerThreads", CtcRuntime.isWindows ? 5 : 16);
    private static final Workers _workers = new Workers("CtcProxy worker", _numWorkerThreads);
    private static HashMap _sckfwdServers = new HashMap();
    private static HashMap<String, Long> _failedServers = new HashMap();
    private static OnePerKey _serverGetters = new OnePerKey();
    private static HashMap<String, CtcProxy> _proxies = new HashMap();
    private static HashMap<String, CtcServerProxy> _serverProxies = new HashMap();
    private static OnePerKey _proxyGetters = new OnePerKey();
    private static IInetAddressTranslator _translator = null;
    private static IIPAddressTranslator trans = IPAddressTranslator.instance();
    private static boolean context = false;
    private static boolean ipv6Net = false;
    private static HashSet<InetAddress> _designatedGnes = new HashSet();
    private static InetAddress permGne = null;
    private static String initialServer = Preferences.instance().getProperty("ctc.proxy", "initialserver", null);
    public static InetAddress virtualInitialServer = null;
    public static Exception initialServerException = null;
    static InetAddress loginEne = null;

    public static boolean debug() {
        return _debug.on();
    }

    static KDebug getDebug() {
        return _debug;
    }

    public static void println(String string) {
        _debug.println(string);
    }

    static long timeout() {
        return _timeout;
    }

    public static int connectTimeout() {
        return _connectTimeout;
    }

    public static int readTimeout() {
        return _readTimeout;
    }

    static int acceptTimeout() {
        return _acceptTimeout;
    }

    static InetAddress bindAddress(InetAddress inetAddress) {
        InetAddress inetAddress2 = inetAddress;
        if (_bindAddress != null) {
            try {
                inetAddress2 = InetAddress.getByName(_bindAddress);
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress2 = inetAddress;
            }
        }
        return inetAddress2;
    }

    static int defaultCost() {
        return _defaultCost;
    }

    static String getActualAddressDisplay(InetAddress inetAddress) {
        if (inetAddress == null) {
            return "";
        }
        String string = inetAddress.getHostAddress();
        String string2 = trans instanceof IPAddressTranslator ? ((IPAddressTranslator)trans).getActualAddressDisplay(string) : string;
        return string2;
    }

    static String getActualAddressDisplay(String string) {
        if (string == null) {
            return "";
        }
        String string2 = trans instanceof IPAddressTranslator ? ((IPAddressTranslator)trans).getActualAddressDisplay(string) : string;
        return string2;
    }

    public static boolean isIPv6Network() {
        return ipv6Net;
    }

    public static void initInitialServer(String string, String string2) {
        if (string != null) {
            initialServer = string;
        } else if (initialServer == null) {
            return;
        }
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("configuring initial server: " + CtcProxyFactory.getActualAddressDisplay(initialServer) + " with loginEne: " + CtcProxyFactory.getActualAddressDisplay(string2));
        }
        if (initialServer != null) {
            try {
                String[] stringArray;
                InetAddress inetAddress;
                InetAddress inetAddress2 = loginEne = string2 == null ? null : InetAddress.getByName(string2);
                if (loginEne != null && trans.isEnabled() && trans.isVirtual(loginEne)) {
                    throw new IllegalArgumentException("login ENE: " + loginEne + " cannot be a virtual address");
                }
                virtualInitialServer = inetAddress = InetAddress.getByName(initialServer);
                if (!trans.isVirtual(inetAddress)) {
                    virtualInitialServer = trans.getVirtualAddress(initialServer, 0);
                }
                if ((stringArray = CtcProxyFactory.getDesignatedGnesFromPrefs()) != null && stringArray.length > 0) {
                    _designatedGnes.add(inetAddress);
                }
                Sckfwd sckfwd = CtcProxyFactory.getServer(virtualInitialServer);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                initialServerException = exception;
            }
        }
    }

    private CtcProxyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDesignatedGnes(String[] stringArray, boolean bl) throws IOException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        if (stringArray != null) {
            for (String string : stringArray) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    hashSet.add(inetAddress);
                }
                catch (UnknownHostException unknownHostException) {
                    Debug.printStackTrace(unknownHostException);
                }
            }
        }
        Object object = _designatedGnes;
        synchronized (object) {
            _designatedGnes.clear();
            _designatedGnes.addAll(hashSet);
        }
        if (bl) {
            Object object2 = object = Preferences.instance();
            synchronized (object2) {
                if (stringArray == null || stringArray.length == 0) {
                    ((Preferences)object).removeProperty(PROXY_PREF, PROXY_DESGNE);
                } else {
                    ((Preferences)object).setPropertyArray(PROXY_PREF, PROXY_DESGNE, stringArray);
                }
                ((Preferences)object).store();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDesignatedGnes(String[] stringArray, boolean bl) throws IOException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        HashSet<String> hashSet2 = new HashSet<String>();
        if (stringArray != null) {
            for (String string : stringArray) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    hashSet.add(inetAddress);
                    hashSet2.add(string);
                }
                catch (UnknownHostException unknownHostException) {
                    Debug.printStackTrace(unknownHostException);
                }
            }
        }
        Object object = _designatedGnes;
        synchronized (object) {
            _designatedGnes.addAll(hashSet);
        }
        if (bl) {
            Object object2 = object = Preferences.instance();
            synchronized (object2) {
                hashSet2.addAll(Arrays.asList(CtcProxyFactory.getDesignatedGnesFromPrefs()));
                ((Preferences)object).setPropertyArray(PROXY_PREF, PROXY_DESGNE, hashSet2.toArray(new String[0]));
                ((Preferences)object).store();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDesignatedGnes(String[] stringArray, boolean bl) throws IOException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        HashSet<String> hashSet2 = new HashSet<String>();
        if (stringArray != null) {
            for (String string : stringArray) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    hashSet.add(inetAddress);
                }
                catch (UnknownHostException unknownHostException) {
                    Debug.printStackTrace(unknownHostException);
                }
            }
        }
        Object object = _designatedGnes;
        synchronized (object) {
            _designatedGnes.removeAll(hashSet);
        }
        if (bl) {
            Object object2 = object = Preferences.instance();
            synchronized (object2) {
                hashSet2.addAll(Arrays.asList(CtcProxyFactory.getDesignatedGnesFromPrefs()));
                hashSet2.removeAll(Arrays.asList(stringArray));
                ((Preferences)object).setPropertyArray(PROXY_PREF, PROXY_DESGNE, hashSet2.toArray(new String[0]));
                ((Preferences)object).store();
            }
        }
    }

    public static Collection<InetAddress> getDesignatedGnes() {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>(_designatedGnes);
        return hashSet;
    }

    public static String[] getDesignatedGnesFromPrefs() {
        String[] stringArray = Preferences.instance().getPropertyArray(PROXY_PREF, PROXY_DESGNE, new String[0]);
        return stringArray;
    }

    public static void setIPv6Network(boolean bl) {
        ipv6Net = bl;
    }

    public static boolean setPermGne(String string) throws UnknownHostException {
        if (virtualInitialServer != null) {
            return false;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        if (inetAddress.getAddress().length == 16) {
            CtcProxyFactory.setIPv6Network(true);
        } else {
            CtcProxyFactory.setIPv6Network(false);
        }
        if (trans.isEnabled() && trans.isVirtual(inetAddress)) {
            throw new IllegalArgumentException("IP address confllicts with virtual address range: " + inetAddress);
        }
        permGne = inetAddress;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress updateProxiesForIpChange(String string, String string2) throws UnknownHostException {
        InetAddress inetAddress = null;
        Class<CtcProxyFactory> clazz = CtcProxyFactory.class;
        synchronized (CtcProxyFactory.class) {
            inetAddress = CtcProxyFactory.updatePermGne(string, string2);
            InetAddress inetAddress2 = CtcProxyFactory.updateDss(string, string2);
            if (inetAddress == null) {
                inetAddress = inetAddress2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return inetAddress;
        }
    }

    private static InetAddress updatePermGne(String string, String string2) throws UnknownHostException {
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = InetAddress.getByName(string);
        if (permGne != null) {
            InetAddress inetAddress3 = InetAddress.getByName(string2);
            if (trans.isEnabled() && trans.isVirtual(inetAddress3)) {
                throw new IllegalArgumentException("IP address confllicts with virtual address range: " + inetAddress3);
            }
            if (permGne.equals(inetAddress2)) {
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("Updating perm GNE from: " + CtcProxyFactory.getActualAddressDisplay(inetAddress2) + " to: " + CtcProxyFactory.getActualAddressDisplay(inetAddress3));
                }
                inetAddress = permGne = inetAddress3;
            }
        }
        CtcProxyFactory.incrementCostOfExistingServer(inetAddress2);
        return inetAddress;
    }

    private static InetAddress updateDss(String string, String string2) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string2);
        InetAddress inetAddress2 = InetAddress.getByName(string);
        InetAddress inetAddress3 = null;
        if (_designatedGnes.contains(inetAddress2)) {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("Updating DSS list entry from: " + inetAddress2 + " to: " + inetAddress);
            }
            _designatedGnes.remove(inetAddress2);
            _designatedGnes.add(inetAddress);
            String[] stringArray = new String[_designatedGnes.size()];
            int n = 0;
            for (InetAddress inetAddress4 : _designatedGnes) {
                stringArray[n++] = inetAddress4.getHostAddress();
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("Updated DSS list (saved to prefs):");
                for (String string3 : stringArray) {
                    CtcProxyFactory.println("  " + string3);
                }
            }
            Preferences.instance().setPropertyArray(PROXY_PREF, PROXY_DESGNE, stringArray);
        }
        return inetAddress3;
    }

    private static boolean incrementCostOfExistingServer(InetAddress inetAddress) {
        Sckfwd sckfwd = CtcProxyFactory.getExistingServer(inetAddress);
        boolean bl = false;
        if (sckfwd != null) {
            bl = true;
            sckfwd.setDeltaCost(1);
        }
        return bl;
    }

    public static InetAddress getPermanentGne() {
        return permGne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDesignatedGne(InetAddress inetAddress) {
        InetAddress inetAddress2 = trans.getActualAddress(inetAddress);
        if (inetAddress2 == null) {
            inetAddress2 = inetAddress;
        }
        HashSet<InetAddress> hashSet = _designatedGnes;
        synchronized (hashSet) {
            boolean bl;
            boolean bl2 = bl = _designatedGnes.isEmpty() || _designatedGnes.contains(inetAddress2) || inetAddress2.equals(permGne);
            if (_debug.isFinestEnabled()) {
                _debug.println("   isDesignatedGne " + inetAddress2 + "=" + bl);
            }
            return bl;
        }
    }

    public static boolean isDesignatedGne(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return CtcProxyFactory.isDesignatedGne(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
    }

    public static Sckfwd getServer(InetAddress inetAddress) throws IOException {
        SckfwdGetter sckfwdGetter = new SckfwdGetter(inetAddress, 1080);
        _serverGetters.run(inetAddress.getHostAddress(), sckfwdGetter);
        return sckfwdGetter.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expire(CtcProxy ctcProxy) {
        HashMap<String, CtcProxy> hashMap = _proxies;
        synchronized (hashMap) {
            Sckfwd sckfwd;
            ctcProxy.expire();
            _proxies.remove(ctcProxy.getKey());
            if (ctcProxy.isProxying() && (sckfwd = ctcProxy.getProxy()) != null) {
                sckfwd.decrementUsage();
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("expire-proxy-deleting: " + ctcProxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeAssociatedServerProxyBindings(CtcProxy ctcProxy) {
        if (!ctcProxy.isSelfProxying()) {
            return;
        }
        HashMap<String, CtcServerProxy> hashMap = _serverProxies;
        synchronized (hashMap) {
            for (CtcServerProxy ctcServerProxy : _serverProxies.values()) {
                try {
                    ctcServerProxy.removeAssociatedServerProxyBindings(ctcProxy);
                }
                catch (UnknownHostException unknownHostException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expire(CtcServerProxy ctcServerProxy) {
        HashMap<String, CtcServerProxy> hashMap = _serverProxies;
        synchronized (hashMap) {
            ctcServerProxy.expire();
            _serverProxies.remove(ctcServerProxy.getKey());
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("expire-server-proxy-deleting: " + ctcServerProxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeAssociatedServerProxyBindings(Sckfwd sckfwd) {
        int n = 0;
        int n2 = 0;
        HashMap<String, CtcServerProxy> hashMap = _serverProxies;
        synchronized (hashMap) {
            n2 = _serverProxies.size();
            for (CtcServerProxy ctcServerProxy : _serverProxies.values()) {
                try {
                    n += ctcServerProxy.removeAssociatedServerProxyBindings(sckfwd);
                }
                catch (UnknownHostException unknownHostException) {}
            }
        }
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("Number of server proxy bindings removed for server: " + sckfwd + " was: " + n + " from " + n2 + " servers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeProxyServer(String string) {
        try {
            Sckfwd sckfwd = CtcProxyFactory.getServer(InetAddress.getByName(string));
            CtcProxyFactory.expire(sckfwd);
            String[] stringArray = _sckfwdServers;
            synchronized (_sckfwdServers) {
                _sckfwdServers.remove(CtcProxyFactory.key(sckfwd.getHost(), sckfwd.getPort()));
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("removing proxy server: " + sckfwd);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                stringArray = new String[]{string};
                CtcProxyFactory.removeDesignatedGnes(stringArray, true);
                return;
            }
        }
        catch (IOException iOException) {
            if (!CtcProxyFactory.debug()) return;
            CtcProxyFactory.println("Proxy server for " + string + "doesn not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expire(Sckfwd sckfwd) {
        CtcProxyFactory.removeAssociatedServerProxyBindings(sckfwd);
        HashMap hashMap = _proxies;
        synchronized (hashMap) {
            Iterator<CtcProxy> iterator = _proxies.values().iterator();
            while (iterator.hasNext()) {
                CtcProxy ctcProxy = iterator.next();
                if (ctcProxy.getProxy() != sckfwd) continue;
                ctcProxy.expire();
                iterator.remove();
                if (ctcProxy.isProxying()) {
                    sckfwd.decrementUsage();
                }
                if (!CtcProxyFactory.debug()) continue;
                CtcProxyFactory.println("expire-sckfwd-deleting: " + ctcProxy);
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("expiring proxy server: " + sckfwd);
            }
        }
        hashMap = _sckfwdServers;
        synchronized (hashMap) {
            if (sckfwd.getFailures() > 15) {
                _sckfwdServers.remove(CtcProxyFactory.key(sckfwd.getHost(), sckfwd.getPort()));
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("removing proxy server: " + sckfwd);
                }
            }
        }
    }

    private static SckfwdClient proxyFor(HashSet<Sckfwd> hashSet, InetAddress inetAddress) {
        SckfwdBid sckfwdBid;
        if (_debug.on()) {
            _debug.println("Enter proxyFor:  Servers are = " + hashSet.toString() + " Client address = " + inetAddress.getHostAddress());
        }
        SckfwdBid sckfwdBid2 = null;
        Sckfwd sckfwd = null;
        HashSet<Sckfwd> hashSet2 = new HashSet<Sckfwd>();
        for (Sckfwd sckfwd2 : hashSet) {
            if (CtcProxyFactory.isIPv6Network() && sckfwd2.getRealHost().getAddress().length != 16) {
                if (_debug.on()) {
                    _debug.println("Skipping IPv4 server : " + sckfwd2.toString());
                }
                hashSet2.add(sckfwd2);
                continue;
            }
            sckfwdBid = sckfwd2.willProxyFor(inetAddress);
            if (sckfwdBid == null || sckfwdBid.compareTo(sckfwdBid2) >= 0) continue;
            sckfwdBid2 = sckfwdBid;
            sckfwd = sckfwd2;
        }
        if (CtcProxyFactory.isIPv6Network() && null == sckfwdBid2) {
            if (_debug.on()) {
                _debug.println("proxyFor: Trying Skipped IPv4 servers : " + hashSet2.toString());
            }
            for (Sckfwd sckfwd2 : hashSet2) {
                sckfwdBid = sckfwd2.willProxyFor(inetAddress);
                if (sckfwdBid == null || sckfwdBid.compareTo(sckfwdBid2) >= 0) continue;
                sckfwdBid2 = sckfwdBid;
                sckfwd = sckfwd2;
            }
        }
        if (sckfwdBid2 != null) {
            if (CtcProxyFactory.debug()) {
                _debug.println("best proxyFor for: " + CtcProxyFactory.getActualAddressDisplay(inetAddress) + " was server: " + sckfwd);
                _debug.println("Exit proxyFor: Winning bid = " + sckfwdBid2.toString());
            }
            return sckfwdBid2.getClient();
        }
        if (_debug.on()) {
            _debug.println("Exit proxyFor: No server found :( ");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Sckfwd getExistingServer(InetAddress inetAddress) {
        Sckfwd sckfwd = null;
        HashMap hashMap = _sckfwdServers;
        synchronized (hashMap) {
            HashSet hashSet = new HashSet(_sckfwdServers.values());
            for (Sckfwd sckfwd2 : hashSet) {
                if (!sckfwd2.getRealHost().equals(inetAddress)) continue;
                sckfwd = sckfwd2;
            }
        }
        return sckfwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SckfwdClient proxyFor(InetAddress inetAddress) {
        HashSet<Sckfwd> hashSet;
        Object object = _sckfwdServers;
        synchronized (object) {
            hashSet = new HashSet<Sckfwd>(_sckfwdServers.values());
        }
        object = CtcProxyFactory.proxyFor(hashSet, inetAddress);
        if (object == null) {
            ArrayList<Validator> arrayList = new ArrayList<Validator>();
            for (Sckfwd object2 : hashSet) {
                Validator validator = new Validator(object2);
                _workers.submit(validator);
                arrayList.add(validator);
            }
            for (Validator validator : arrayList) {
                validator.join();
            }
            object = CtcProxyFactory.proxyFor(hashSet, inetAddress);
        }
        return object;
    }

    static void discover(Collection<InetAddress> collection) {
        for (InetAddress inetAddress : collection) {
            _workers.submit(new Discoverer(inetAddress));
        }
    }

    static boolean willProxyFor(Sckfwd sckfwd, InetAddress inetAddress) {
        try {
            sckfwd.validate();
            return sckfwd.willProxyFor(inetAddress) != null;
        }
        catch (IOException iOException) {
            CtcProxyFactory.expire(sckfwd);
            return false;
        }
    }

    public static boolean willProxyFor(InetAddress inetAddress, InetAddress inetAddress2) {
        try {
            Sckfwd sckfwd = CtcProxyFactory.getServer(inetAddress);
            return CtcProxyFactory.willProxyFor(sckfwd, inetAddress2);
        }
        catch (IOException iOException) {
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("There was a failure while attempting to discover a Proxy server at : " + CtcProxyFactory.getActualAddressDisplay(inetAddress.getHostAddress()));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CtcProxy getProxy(CtcProxy ctcProxy) {
        String string = ctcProxy.getKey();
        CtcProxy ctcProxy2 = null;
        HashMap<String, CtcProxy> hashMap = _proxies;
        synchronized (hashMap) {
            ctcProxy2 = _proxies.get(string);
        }
        return ctcProxy2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addProxy(String string, CtcProxy ctcProxy) {
        HashMap<String, CtcProxy> hashMap = _proxies;
        synchronized (hashMap) {
            Sckfwd sckfwd;
            _proxies.put(string, ctcProxy);
            if (ctcProxy.isProxying() && (sckfwd = ctcProxy.getProxy()) != null) {
                sckfwd.incrementUsage();
            }
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("creating: " + ctcProxy);
            }
        }
    }

    static void addProxy(CtcProxy ctcProxy) {
        CtcProxyFactory.addProxy(ctcProxy.getKey(), ctcProxy);
    }

    public static boolean isReachable(String string, int n, int n2) {
        boolean bl = false;
        try {
            CtcProxy ctcProxy = CtcProxyFactory.connect(string, n);
            ctcProxy.getSocket(n2).close();
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static CtcProxy connect(String string, int n) throws IOException {
        CtcProxy ctcProxy;
        String string2;
        String string3 = string2 = CtcProxyFactory.debug() ? CtcProxyFactory.getActualAddressDisplay(string) : string;
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("connect(" + string2 + ", " + n + "): enter");
            if (context) {
                CtcProxyFactory.getDebug();
                KDebug.printStackTrace(new Exception());
            }
        }
        CtcProxy ctcProxy2 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            ProxyGetter proxyGetter = new ProxyGetter(inetAddress, n);
            _proxyGetters.run(inetAddress.getHostAddress(), proxyGetter);
            ctcProxy = ctcProxy2 = proxyGetter.getProxy();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            try {
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("error in connect " + throwable);
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (CtcProxyFactory.debug()) {
                    Debug.printStackTrace(throwable);
                }
                throw new IOException(throwable.getMessage());
            }
            catch (Throwable throwable2) {
                block10: {
                    Object var8_9 = null;
                    if (!CtcProxyFactory.debug()) break block10;
                    CtcProxyFactory.println("connect(" + string2 + ", " + n + "): exit " + ctcProxy2);
                }
                throw throwable2;
            }
        }
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("connect(" + string2 + ", " + n + "): exit " + ctcProxy2);
        }
        return ctcProxy;
    }

    public static CtcProxy sslConnect(String string, int n) throws IOException {
        CtcProxy ctcProxy = CtcProxyFactory.connect(string, n);
        ctcProxy.setSecure(true);
        return ctcProxy;
    }

    public static void validateSocket(String string, int n, Socket socket) throws IOException {
        if (socket.isClosed() || !socket.isConnected()) {
            throw new IOException(string.toString() + " on port " + n + " not close or not connected");
        }
        OutputStream outputStream = socket.getOutputStream();
        if (outputStream == null) {
            throw new IOException(string.toString() + " on port " + n + " had trouble getting the OutputStream");
        }
        outputStream.write(new byte[0], 0, 0);
    }

    public static CtcServerProxy bind(String string, int n) throws IOException {
        return CtcProxyFactory.bind(string, n, false);
    }

    public static CtcServerProxy bind(String string, int n, boolean bl) throws IOException {
        CtcServerProxy ctcServerProxy;
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("bind(" + string + ", " + n + ", " + bl + "): enter");
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            ServerProxyGetter serverProxyGetter = new ServerProxyGetter(inetAddress, n, bl);
            _proxyGetters.run(inetAddress.getHostAddress(), serverProxyGetter);
            ctcServerProxy = serverProxyGetter.getProxy();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            try {
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("error in bind " + throwable);
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (CtcProxyFactory.debug()) {
                    Debug.printStackTrace(throwable);
                }
                throw new IOException(throwable.getMessage());
            }
            catch (Throwable throwable2) {
                block9: {
                    Object var7_8 = null;
                    if (!CtcProxyFactory.debug()) break block9;
                    CtcProxyFactory.println("bind(" + string + ", " + n + ", " + bl + "): exit");
                }
                throw throwable2;
            }
        }
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("bind(" + string + ", " + n + ", " + bl + "): exit");
        }
        return ctcServerProxy;
    }

    public static CtcProxy accept(String string, int n, String string2) throws IOException {
        return CtcProxyFactory.accept(string, n, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CtcProxy accept(String string, int n, String string2, boolean bl) throws IOException {
        CtcProxy ctcProxy;
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("accept(" + string + ", " + n + ", " + CtcProxyFactory.getActualAddressDisplay(string2) + ", " + bl + "): enter");
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            ctcProxy = CtcProxyFactory.bind(string, n, bl).accept(inetAddress);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var7_7 = null;
                if (!CtcProxyFactory.debug()) break block4;
                CtcProxyFactory.println("accept(" + string + ", " + n + ", " + CtcProxyFactory.getActualAddressDisplay(string2) + ", " + bl + "): exit");
            }
            throw throwable;
        }
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("accept(" + string + ", " + n + ", " + CtcProxyFactory.getActualAddressDisplay(string2) + ", " + bl + "): exit");
        }
        return ctcProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getClients(String string) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("getClients(" + CtcProxyFactory.getActualAddressDisplay(string) + "): enter");
        }
        Collection collection = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            Sckfwd sckfwd = CtcProxyFactory.getServer(inetAddress);
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("getClients(" + CtcProxyFactory.getActualAddressDisplay(string) + "): server=" + sckfwd);
            }
            try {
                collection = sckfwd.getClients();
            }
            catch (IOException iOException) {
                CtcProxyFactory.expire(sckfwd);
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("getClients(" + CtcProxyFactory.getActualAddressDisplay(string) + "): server=" + sckfwd + " got error: " + iOException);
                }
                throw iOException;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (CtcProxyFactory.debug()) {
                int n = collection == null ? 0 : collection.size();
                CtcProxyFactory.println("getClients(" + CtcProxyFactory.getActualAddressDisplay(string) + "): exit - found: " + n + " clients");
            }
            throw throwable;
        }
        if (CtcProxyFactory.debug()) {
            int n = collection == null ? 0 : collection.size();
            CtcProxyFactory.println("getClients(" + CtcProxyFactory.getActualAddressDisplay(string) + "): exit - found: " + n + " clients");
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClients(String string, Collection collection) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("setClients(" + CtcProxyFactory.getActualAddressDisplay(string) + "): enter");
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            SckfwdClientGetter sckfwdClientGetter = new SckfwdClientGetter(inetAddress, 1080, collection);
            _serverGetters.run(inetAddress.getHostAddress(), sckfwdClientGetter);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("setClients(" + CtcProxyFactory.getActualAddressDisplay(string) + "): exit");
            }
            throw throwable;
        }
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("setClients(" + CtcProxyFactory.getActualAddressDisplay(string) + "): exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(String string, String string2, String string3, String string4, int n) throws IOException {
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("reset(" + CtcProxyFactory.getActualAddressDisplay(string) + ", " + string2 + ", " + CtcProxyFactory.getActualAddressDisplay(string4) + ", " + n + "): enter");
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getByName(string4);
            SckfwdReset sckfwdReset = new SckfwdReset(inetAddress, 1080, string2, string3, inetAddress2, n);
            _serverGetters.run(inetAddress.getHostAddress(), sckfwdReset);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (CtcProxyFactory.debug()) {
                CtcProxyFactory.println("reset(" + CtcProxyFactory.getActualAddressDisplay(string) + ", " + string2 + ", " + CtcProxyFactory.getActualAddressDisplay(string4) + ", " + n + "): exit");
            }
            throw throwable;
        }
        if (CtcProxyFactory.debug()) {
            CtcProxyFactory.println("reset(" + CtcProxyFactory.getActualAddressDisplay(string) + ", " + string2 + ", " + CtcProxyFactory.getActualAddressDisplay(string4) + ", " + n + "): exit");
        }
    }

    static String key(InetAddress inetAddress, int n) {
        return (inetAddress == null ? "" : inetAddress.getHostAddress()) + ":" + n;
    }

    static String keyDisplay(InetAddress inetAddress, int n) {
        return CtcProxyFactory.getActualAddressDisplay(inetAddress) + ":" + n;
    }

    static String keyDisplay(String string, int n) {
        return string + ":" + n;
    }

    static int getSizeInBits(InetAddress inetAddress) {
        return inetAddress.getAddress().length * 8;
    }

    static byte[] makeMask(int n, int n2) {
        byte[] byArray = new byte[n / 8];
        for (int i = 0; i < n2; ++i) {
            int n3 = i / 8;
            int n4 = 1 << 7 - i % 8;
            byArray[n3] = (byte)(byArray[n3] | n4);
        }
        return byArray;
    }

    static InetAddress maskAddress(InetAddress inetAddress, int n) {
        if (inetAddress == null) {
            return null;
        }
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = CtcProxyFactory.makeMask(CtcProxyFactory.getSizeInBits(inetAddress), n);
        InetAddress inetAddress2 = inetAddress;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] & byArray2[i]);
        }
        try {
            inetAddress2 = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return inetAddress2;
    }

    public static synchronized void registerAddressTranslator(IInetAddressTranslator iInetAddressTranslator) {
        _translator = iInetAddressTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void updateListOfSockServers() {
        HashSet hashSet;
        HashMap hashMap = _sckfwdServers;
        synchronized (hashMap) {
            hashSet = new HashSet(_sckfwdServers.values());
        }
        String[] stringArray = new String[hashSet.size()];
        int n = 0;
        for (Sckfwd sckfwd : hashSet) {
            stringArray[n] = sckfwd.getRealHost().getHostAddress();
            ++n;
        }
        if (stringArray != null && stringArray.length > 0) {
            try {
                CtcProxyFactory.addDesignatedGnes(stringArray, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static boolean areVirtualAndProxyInSameTopo(InetAddress inetAddress, InetAddress inetAddress2) {
        if (trans.isEnabled() && !CtcProxyFactory.isIPv6Network() && _translator != null) {
            return _translator.areNodesInSameTopo(inetAddress, inetAddress2);
        }
        return true;
    }

    static boolean isSocketHistoryEnabled() {
        return _debug.isSocketHistoryEnabled();
    }

    static {
        String[] stringArray = CtcProxyFactory.getDesignatedGnesFromPrefs();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                _designatedGnes.add(inetAddress);
                if (!_debug.on()) continue;
                CtcProxyFactory.println("Adding designated GNE " + inetAddress);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                CtcProxyFactory.println("Designated GNE is invalid: " + string);
            }
        }
    }

    public static class Debug
    extends KDebug
    implements IDebugDiag {
        private boolean socketHistory = Preferences.instance().getBoolean("ctc.proxy", "sockethistory", false);

        public Debug(String string) {
            super(string);
        }

        public final void sockets() {
            this.sockets(true);
        }

        public final void sockets(boolean bl) {
            this.sockets(bl, false);
        }

        public final void sockets(boolean bl, boolean bl2) {
            if (!this.socketHistory) {
                this.println("CtcProxy socket history collection disabled. Try setting CTC preference: ctc.proxy.sockethistory=true ");
                return;
            }
            this.println("CtcProxy socket history: ");
            Map<Socket, Exception> map = CtcProxy.getSockets();
            Set<Socket> set = map.keySet();
            int n = 0;
            int n2 = 0;
            int n3 = set.size();
            if (bl) {
                this.println("list of connected sockets");
            } else {
                this.println("list of sockets in any state");
            }
            for (Socket socket : set) {
                StackTraceElement[] stackTraceElementArray;
                Exception exception = map.get(socket);
                boolean bl3 = socket.isClosed();
                if (!bl3) {
                    ++n;
                } else if (bl) continue;
                String string = bl3 ? "CLOSED" : (socket.isInputShutdown() ? "INPUT CLOSED" : (socket.isConnected() ? "CONNECTED" : "UNCONNECTED"));
                this.print("socket on port " + socket.getLocalPort() + " in " + string + " state;");
                String string2 = exception.getMessage();
                if (string2.indexOf(CtcProxyFactory.CTC_NE_DIR) >= 0) {
                    ++n2;
                }
                this.println(" " + string2 + " with type " + socket.getClass().getName());
                if (!bl2) continue;
                for (StackTraceElement stackTraceElement : stackTraceElementArray = exception.getStackTrace()) {
                    this.println("  " + stackTraceElement);
                }
            }
            this.println("# of ctc->ne sockets in any state: " + n2);
            this.println("# of ne->ctc sockets in any state: " + (n3 - n2));
            this.println("# of connected sockets in either direction: " + n);
            this.println("# of sockets in any state: " + n3);
        }

        public final void dbgSetIPv6Network(boolean bl) {
            CtcProxyFactory.setIPv6Network(bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void proxies() {
            Object object;
            String string;
            this.println("CtcProxy list (CTC->NE connection): ");
            HashMap hashMap = _proxies;
            synchronized (hashMap) {
                for (Map.Entry entry : _proxies.entrySet()) {
                    string = (String)entry.getKey();
                    object = (CtcProxy)entry.getValue();
                    this.println("  " + string + " " + object);
                }
            }
            this.println("CtcServerProxy list (NE->CTC connection): ");
            hashMap = _serverProxies;
            synchronized (hashMap) {
                for (Map.Entry entry : _serverProxies.entrySet()) {
                    string = (String)entry.getKey();
                    object = (CtcServerProxy)entry.getValue();
                    this.println("  " + string + " " + object);
                }
            }
        }

        public final void enableSocketHistory() {
            this.socketHistory = true;
        }

        public final void disableSocketHistory() {
            this.socketHistory = false;
        }

        public final void socketHistoryEnabled() {
            this.println(Boolean.toString(this.socketHistory));
        }

        public final boolean isSocketHistoryEnabled() {
            return this.socketHistory;
        }

        public final void clearSocketHistory() {
            CtcProxy.clearSocketHistory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void flush() {
            HashSet hashSet;
            HashMap hashMap = _sckfwdServers;
            synchronized (hashMap) {
                hashSet = new HashSet(_sckfwdServers.values());
            }
            for (Sckfwd sckfwd : hashSet) {
                CtcProxyFactory.expire(sckfwd);
            }
        }

        public final void willGneProxyForEne(String string, String string2) {
            boolean bl = false;
            try {
                bl = CtcProxyFactory.willProxyFor(InetAddress.getByName(string), InetAddress.getByName(string2));
                if (bl) {
                    this.println("GNE : " + CtcProxyFactory.getActualAddressDisplay(string) + " will proxy for " + "ENE :" + CtcProxyFactory.getActualAddressDisplay(string2));
                } else {
                    this.println("GNE : " + CtcProxyFactory.getActualAddressDisplay(string) + " will not proxy for " + "ENE :" + CtcProxyFactory.getActualAddressDisplay(string2));
                }
            }
            catch (IOException iOException) {
                this.println("There was a failure while attempting to discover a Proxy server at : " + CtcProxyFactory.getActualAddressDisplay(string));
            }
        }

        public final void dbgDiscoverProxyServer(String string) {
            try {
                CtcProxyFactory.getServer(InetAddress.getByName(string));
            }
            catch (IOException iOException) {
                this.println("There was a failure while attempting to discover a Proxy server at : " + CtcProxyFactory.getActualAddressDisplay(string));
            }
        }

        public final void dbgRemoveProxyServer(String string) {
            CtcProxyFactory.removeProxyServer(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpDiag() {
            boolean bl = this.on();
            StringBuilder stringBuilder = new StringBuilder();
            try {
                HashSet hashSet;
                HashSet hashSet2;
                HashSet hashSet3;
                this.set(false);
                String string = "No";
                if (CtcProxyFactory.isIPv6Network()) {
                    string = "Yes";
                }
                this.println("Is IPv6 Network : " + string);
                Iterator iterator = _sckfwdServers;
                synchronized (iterator) {
                    this.println("# of proxy servers: " + _sckfwdServers.size());
                    hashSet3 = new HashSet(_sckfwdServers.values());
                }
                for (Sckfwd sckfwd : hashSet3) {
                    stringBuilder.append(CtcProxyFactory.getActualAddressDisplay(sckfwd.toString()));
                    stringBuilder.append(":: ");
                    stringBuilder.append(sckfwd.toClientString());
                    this.println(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                this.println("Failed servers:");
                iterator = _sckfwdServers;
                synchronized (iterator) {
                    long l = System.currentTimeMillis();
                    for (String string2 : _failedServers.keySet()) {
                        Long l2 = (Long)_failedServers.get(string2);
                        long l3 = l2 - l;
                        if (l3 < 0L) {
                            this.println("   " + string2 + " expired (last accessed " + (CtcProxyFactory.timeout() - l3) / 1000L + " sec. ago)");
                            continue;
                        }
                        this.println("   " + string2 + " TTL=" + l3 + " ms");
                    }
                }
                this.println("Designated GNEs:");
                if (_designatedGnes != null) {
                    for (InetAddress inetAddress : _designatedGnes) {
                        this.println("   " + inetAddress);
                    }
                }
                this.println("Permanent GNE:" + permGne);
                this.println("Initial GNE:" + initialServer);
                if (initialServerException != null) {
                    this.println("Initial GNE exception:");
                    Debug.printStackTrace(initialServerException);
                }
                this.println("");
                iterator = _proxies;
                synchronized (iterator) {
                    this.println("# of proxies: " + _proxies.size());
                    hashSet2 = new HashSet(_proxies.values());
                }
                for (CtcProxy ctcProxy : hashSet2) {
                    this.println(ctcProxy.toString());
                }
                this.println("");
                iterator = _serverProxies;
                synchronized (iterator) {
                    this.println("# of server proxies: " + _serverProxies.size());
                    hashSet = new HashSet(_serverProxies.values());
                }
                for (CtcServerProxy ctcServerProxy : hashSet) {
                    this.println(ctcServerProxy.toString());
                }
                Object var19_21 = null;
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                this.set(bl);
                throw throwable;
            }
            this.set(bl);
        }

        public final void context(boolean bl) {
            context = bl;
        }

        public final void id(String string) {
            Object object;
            boolean bl = false;
            int n = 0;
            String string2 = "";
            String string3 = "";
            try {
                object = CtcProxyFactory.connect(string, 80);
                bl = ((CtcProxy)object).isProxying();
                ((CtcProxy)object).getSocket().close();
            }
            catch (Exception exception) {
                this.println("Exception contacting " + string + ", test skipped");
                return;
            }
            try {
                object = CtcProxyFactory.getClients(string);
                n = object.size();
                StringBuilder stringBuilder = new StringBuilder();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    if (e instanceof SckfwdClient) {
                        stringBuilder.append(((SckfwdClient)e).getHost());
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    stringBuilder.append((String)e);
                }
                string2 = stringBuilder.toString();
            }
            catch (IOException iOException) {
                if (iOException.getMessage().equals("SOCKS server unavailable")) {
                    n = 0;
                }
                this.println("IOException getting " + string + " client list, test skipped");
                this.println("/" + iOException.getMessage() + "/");
                return;
            }
            string3 = !bl ? "an LNE" : (n == 0 ? "an ENE" : "a GNE");
            this.println(string + " is " + string3 + " -- proxying=" + bl + ", numEnes=" + n + ", enes=" + string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reach(String string, int n, int n2) throws IOException {
            boolean bl = false;
            try {
                bl = CtcProxyFactory.isReachable(string, n, n2);
                Object var6_5 = null;
                this.println("host " + string + (bl ? "was " : "was not ") + "reached");
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.println("host " + string + (bl ? "was " : "was not ") + "reached");
                throw throwable;
            }
        }
    }

    private static class Discoverer
    extends NamedRunnable {
        private InetAddress _host;

        Discoverer(InetAddress inetAddress) {
            this._host = inetAddress;
        }

        public void run() {
            try {
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("Attempting to discover SCKFWD server: " + CtcProxyFactory.getActualAddressDisplay(this._host.getHostAddress()));
                }
                CtcProxyFactory.getServer(this._host);
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("Discovered SCKFWD server: " + CtcProxyFactory.getActualAddressDisplay(this._host.getHostAddress()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getName() {
            return "CtcProxy discoverer for " + this._host.getHostAddress() + ":" + 1080;
        }
    }

    private static abstract class Getter {
        private InetAddress _host;
        private int _port;

        public Getter(InetAddress inetAddress, int n) {
            this._host = inetAddress;
            this._port = n;
        }

        public InetAddress getHost() {
            return this._host;
        }

        public int getPort() {
            return this._port;
        }

        public abstract void run() throws IOException;
    }

    private static abstract class NamedRunnable
    implements Runnable {
        private boolean _running = true;

        NamedRunnable() {
        }

        public abstract String getName();

        protected synchronized void done() {
            this._running = false;
            this.notify();
        }

        public synchronized void join() {
            while (this._running) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class OnePerKey {
        private final HashMap _locks = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String string, Getter getter) throws IOException {
            HashMap hashMap;
            RefCount refCount;
            Object object = this._locks;
            synchronized (object) {
                refCount = (RefCount)this._locks.get(string);
                if (refCount == null) {
                    refCount = new RefCount(string);
                    this._locks.put(string, refCount);
                }
                refCount.reference();
            }
            try {
                object = refCount;
                synchronized (object) {
                    getter.run();
                }
                Object var8_7 = null;
                hashMap = this._locks;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                HashMap hashMap2 = this._locks;
                synchronized (hashMap2) {
                    if (refCount.dereference() == 0) {
                        this._locks.remove(string);
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                if (refCount.dereference() == 0) {
                    this._locks.remove(string);
                }
            }
        }
    }

    private static class ProxyGetter
    extends Getter {
        private CtcProxy _proxy = null;

        public ProxyGetter(InetAddress inetAddress, int n) {
            super(inetAddress, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            String string = CtcProxyFactory.key(this.getHost(), this.getPort());
            HashMap hashMap = _proxies;
            synchronized (hashMap) {
                this._proxy = (CtcProxy)_proxies.get(string);
                if (this._proxy != null && this._proxy.expired()) {
                    CtcProxyFactory.expire(this._proxy);
                    this._proxy = null;
                }
            }
            if (this._proxy == null) {
                this._proxy = new CtcProxy(this.getHost(), this.getPort());
                CtcProxyFactory.addProxy(string, this._proxy);
            }
        }

        public CtcProxy getProxy() {
            return this._proxy;
        }
    }

    private static class RefCount {
        private String _key;
        private int _count;

        public RefCount(String string) {
            this._key = string;
            this._count = 0;
        }

        public int count() {
            return this._count;
        }

        public void reference() {
            ++this._count;
        }

        public int dereference() {
            return --this._count;
        }

        public String toString() {
            return "#<" + this._key + ", " + this._count + ">";
        }
    }

    private static class SckfwdClientGetter
    extends SckfwdGetter {
        private Collection _clients;

        public SckfwdClientGetter(InetAddress inetAddress, int n, Collection collection) {
            super(inetAddress, n);
            this._clients = collection;
        }

        public void run() throws IOException {
            super.run();
            Sckfwd sckfwd = this.getServer();
            if (sckfwd != null) {
                try {
                    sckfwd.setClients(this._clients);
                }
                catch (IOException iOException) {
                    CtcProxyFactory.expire(sckfwd);
                    throw iOException;
                }
            }
        }
    }

    private static class SckfwdGetter
    extends Getter {
        private Sckfwd _server = null;

        public SckfwdGetter(InetAddress inetAddress, int n) {
            super(inetAddress, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            block22: {
                Long l;
                String string = trans.isEnabled() && trans.isVirtual(this.getHost()) ? CtcProxyFactory.key(trans.getActualAddress(this.getHost()), this.getPort()) : CtcProxyFactory.key(this.getHost(), this.getPort());
                HashMap hashMap = _sckfwdServers;
                synchronized (hashMap) {
                    this._server = (Sckfwd)_sckfwdServers.get(string);
                    l = (Long)_failedServers.get(string);
                }
                if (this._server == null) {
                    if (l != null && System.currentTimeMillis() > l) {
                        hashMap = _sckfwdServers;
                        synchronized (hashMap) {
                            _failedServers.remove(string);
                        }
                        if (CtcProxyFactory.debug()) {
                            CtcProxyFactory.println("rechecking failed server:" + string);
                        }
                        l = null;
                    }
                    if (l == null) {
                        if (!CtcProxyFactory.isDesignatedGne(this.getHost())) {
                            throw new IOException("Not a designated GNE: " + this.getHost());
                        }
                        try {
                            this._server = new Sckfwd(this.getHost(), this.getPort());
                            hashMap = _sckfwdServers;
                            synchronized (hashMap) {
                                if (CtcProxyFactory.debug()) {
                                    CtcProxyFactory.println("adding proxy server: " + this._server);
                                }
                                _sckfwdServers.put(string, this._server);
                                break block22;
                            }
                        }
                        catch (IOException iOException) {
                            l = new Long(System.currentTimeMillis() + CtcProxyFactory.timeout());
                            HashMap hashMap2 = _sckfwdServers;
                            synchronized (hashMap2) {
                                _failedServers.put(string, l);
                            }
                            if (CtcProxyFactory.debug()) {
                                CtcProxyFactory.println("adding failed server: " + string);
                            }
                            throw iOException;
                        }
                    }
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("SOCKS server unavailable: " + string);
                    }
                    throw new IOException("SOCKS server unavailable");
                }
            }
        }

        public Sckfwd getServer() {
            return this._server;
        }
    }

    private static class SckfwdReset
    extends SckfwdGetter {
        private String _username;
        private String _password;
        private InetAddress _ene;
        private int _cost;

        public SckfwdReset(InetAddress inetAddress, int n, String string, String string2, InetAddress inetAddress2, int n2) {
            super(inetAddress, n);
            this._username = string;
            this._password = string2;
            this._ene = inetAddress2;
            this._cost = n2;
        }

        public void run() throws IOException {
            super.run();
            Sckfwd sckfwd = this.getServer();
            if (sckfwd != null) {
                try {
                    sckfwd.reset(this._username, this._password, this._ene, this._cost);
                }
                catch (IOException iOException) {
                    CtcProxyFactory.expire(sckfwd);
                    throw iOException;
                }
            }
        }
    }

    private static class ServerProxyGetter
    extends Getter {
        private CtcServerProxy _proxy = null;
        private boolean _secure;

        public ServerProxyGetter(InetAddress inetAddress, int n, boolean bl) {
            super(inetAddress, n);
            this._secure = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            String string = Integer.toString(this.getPort()) + "/" + Boolean.toString(this._secure);
            HashMap hashMap = _serverProxies;
            synchronized (hashMap) {
                this._proxy = (CtcServerProxy)_serverProxies.get(string);
                if (this._proxy != null && this._proxy.expired()) {
                    CtcProxyFactory.expire(this._proxy);
                    this._proxy = null;
                }
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("getServerProxy(" + string + "): " + this._proxy);
                }
            }
            if (this._proxy == null) {
                this._proxy = new CtcServerProxy(this.getHost(), this.getPort(), this._secure);
                hashMap = _serverProxies;
                synchronized (hashMap) {
                    if (CtcProxyFactory.debug()) {
                        CtcProxyFactory.println("creating: " + this._proxy);
                    }
                    if (this.getPort() == 0) {
                        string = Integer.toString(this._proxy.getPort()) + "/" + Boolean.toString(this._secure);
                    }
                    _serverProxies.put(string, this._proxy);
                }
            }
        }

        public CtcServerProxy getProxy() {
            return this._proxy;
        }
    }

    private static class Validator
    extends NamedRunnable {
        private Sckfwd _server;

        Validator(Sckfwd sckfwd) {
            this._server = sckfwd;
        }

        public void run() {
            try {
                this._server.validate();
            }
            catch (IOException iOException) {
                CtcProxyFactory.expire(this._server);
            }
        }

        public String getName() {
            String string = this._server.getHost().getHostAddress();
            String string2 = CtcProxyFactory.getActualAddressDisplay(string);
            return "CtcProxy validator for " + string2 + "(" + string + "):" + this._server.getPort();
        }
    }

    private static class Workers {
        private boolean _active = true;
        private LinkedList<NamedRunnable> _jobs = new LinkedList();
        private LinkedList<Thread> _workers = new LinkedList();

        public Workers(String string, int n) {
            for (int i = 0; i < n; ++i) {
                Thread thread = new Thread((Runnable)new Worker(), this.workerName(string, i));
                thread.setDaemon(true);
                this._workers.add(thread);
                thread.start();
            }
        }

        public void destroy() {
            this._active = false;
            for (Thread thread : this._workers) {
                thread.interrupt();
            }
        }

        private String workerName(String string, int n) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = Integer.toString(n);
            stringBuilder.append(string);
            for (int i = string2.length(); i < 3; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
            stringBuilder.append(": idle");
            return stringBuilder.toString();
        }

        public synchronized void submit(NamedRunnable namedRunnable) {
            this._jobs.add(namedRunnable);
            this.notify();
        }

        private synchronized NamedRunnable next() throws InterruptedException {
            while (true) {
                try {
                    return this._jobs.removeFirst();
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.wait();
                    continue;
                }
                break;
            }
        }

        private class Worker
        implements Runnable {
            private Worker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        Thread thread = Thread.currentThread();
                        while (Workers.this._active) {
                            try {
                                Object var6_8;
                                NamedRunnable namedRunnable = Workers.this.next();
                                String string = thread.getName();
                                try {
                                    try {
                                        thread.setName(namedRunnable.getName());
                                        namedRunnable.run();
                                    }
                                    catch (Throwable throwable) {
                                        _debug.println("Worker job exception: " + throwable);
                                        Debug.printStackTrace(throwable);
                                        var6_8 = null;
                                        namedRunnable.done();
                                        thread.setName(string);
                                        continue;
                                    }
                                    var6_8 = null;
                                    namedRunnable.done();
                                    thread.setName(string);
                                }
                                catch (Throwable throwable) {
                                    var6_8 = null;
                                    namedRunnable.done();
                                    thread.setName(string);
                                    throw throwable;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                _debug.println("Worker interrupted: " + interruptedException);
                            }
                            catch (Throwable throwable) {
                                _debug.println("Worker loop exception: " + throwable);
                                Debug.printStackTrace(throwable);
                            }
                        }
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        _debug.println("Worker run exception: " + throwable);
                        Debug.printStackTrace(throwable);
                        Object var8_11 = null;
                        _debug.println("Worker exiting: _active=" + Workers.this._active);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    _debug.println("Worker exiting: _active=" + Workers.this._active);
                    throw throwable;
                }
                _debug.println("Worker exiting: _active=" + Workers.this._active);
            }
        }
    }
}

