/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.launcher.CmsClassLoader;
import cerent.util.DebugManager;
import cerent.util.KDebug;
import cerent.version.IBuildInformation;
import cerent.version.Ngrp;
import cerent.version.NgrpFactory;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.INgrp;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class AbstractJarBuildInformation
implements IBuildInformation {
    private static final String JAR_COVERAGE_OUTPUT_FILE = "Emma-Output-File";
    private static final String JAR_BUILD_INFORMATION_SECTION = "Build-version";
    private static final String JAR_BUILD_INFORMATION_VERSION = "Implementation-version";
    private static final String JAR_BUILD_SPECIFICATIION_VERSION = "Specification-Version";
    private static final String JAR_VERSION_VIEW = "Version-View";
    private static final String JAR_VERSION_TSTAMP = "Version-Timestamp";
    private static final String JAR_SOURCE_TYPE = "Source-type";
    private static final String NGRP_MAJOR_RLS = "NGRP-Major-Release";
    private static final String NGRP_MAINT_RLS = "NGRP-Maintenance-Release";
    private static final String NGRP_INTERIM_VER = "NGRP-Interim-Version-Number";
    private static final String NGRP_MAJOR_REBUILD_DES = "NGRP-Major-Rebuild-Designator";
    private static final String NGRP_MAJOR_TECH_RLS_DES = "NGRP-Technology-Release-Designator";
    private static final String NGRP_REBUILD_DES = "NGRP-Rebuild-Designator";
    public static final String ELEMENT_MANIFEST = ClassLoaderEnum.ELE.manifestPrefix;
    public static final String INTERFACE_MANIFEST = ClassLoaderEnum.IF.manifestPrefix;
    public static final String LAUNCHER_MANIFEST = ClassLoaderEnum.SYSTEM.manifestPrefix;
    public static final String NETWORK_MANIFEST = ClassLoaderEnum.NET.manifestPrefix;
    private static final String UNKNOWN = "???";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    protected static HashSet<URL> nonCtcResources = new HashSet();
    protected static HashMap<String, INgrp> systemNgrps = new HashMap();
    protected static KDebug db;
    private Attributes mainattrs;
    private Attributes attrs;
    private String classPath;
    private String sourceType;
    private String branchPath;
    private long timeStamp;
    private Ngrp ngrp;
    private boolean isForCTC;
    private String specTitle;

    public AbstractJarBuildInformation(String string) {
        this.init(string, this.getClass().getClassLoader(), null);
    }

    public AbstractJarBuildInformation(String string, ClassLoader classLoader) {
        this(string, classLoader, false, null);
    }

    public AbstractJarBuildInformation(String string, ClassLoader classLoader, boolean bl, ClassLoaderEnum classLoaderEnum) {
        this.isForCTC = bl;
        this.init(string, classLoader, classLoaderEnum);
    }

    public static INgrp getSystemNgrp(String string) {
        return systemNgrps.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(String string, ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) {
        String string2;
        String string3;
        URL uRL;
        Object object;
        URL[] uRLArray;
        if (classLoader instanceof URLClassLoader && (uRLArray = ((URLClassLoader)(object = (URLClassLoader)classLoader)).getURLs()) != null && uRLArray.length == 1 && (uRL = uRLArray[0]).getProtocol().equals("file") && (string3 = URLDecoder.decode(string2 = uRL.getPath())).endsWith(".jar")) {
            File file = new File(string3);
            JarFile jarFile = null;
            jarFile = new JarFile(file);
            String string4 = file.getCanonicalPath();
            this.isForCTC = this.isForCTC;
            this.init(string, jarFile, string4, classLoaderEnum);
            Object var14_13 = null;
            if (jarFile == null) return;
            try {
                jarFile.close();
                return;
            }
            catch (IOException iOException) {
                KDebug.printStackTrace(iOException);
            }
            return;
            {
                catch (IOException iOException) {
                    Exception exception = new Exception("error processing jar file: " + file, iOException);
                    KDebug.printStackTrace(exception);
                    this.makeEmptyBuildInformation();
                    Object var14_14 = null;
                    if (jarFile == null) return;
                    try {
                        jarFile.close();
                        return;
                    }
                    catch (IOException iOException2) {
                        KDebug.printStackTrace(iOException2);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (jarFile == null) throw throwable;
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    KDebug.printStackTrace(iOException);
                }
                throw throwable;
            }
        }
        object = this.getManifest(string, classLoader, classLoaderEnum);
        this._init(string, (Manifest)object, classLoaderEnum);
    }

    private void init(String string, JarFile jarFile, String string2, ClassLoaderEnum classLoaderEnum) throws IOException {
        Manifest manifest = jarFile.getManifest();
        manifest = this.checkManifest(string, manifest, string2);
        this._init(string, manifest, classLoaderEnum);
    }

    private void _init(String string, Manifest manifest, ClassLoaderEnum classLoaderEnum) {
        if (manifest != null) {
            try {
                String string2;
                if (this.attrs == null && db.on()) {
                    db.println("old ill-formed Build-version handling this as thought one didn't exist");
                }
                if (!(string2 = this.getAttribute(this.attrs, JAR_BUILD_INFORMATION_VERSION)).equals(UNKNOWN) && !string2.equals("1.0")) {
                    throw new InvalidImplVersionException(string);
                }
                string2 = this.mainattrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                this.sourceType = this.getAttribute(this.attrs, JAR_SOURCE_TYPE);
                this.branchPath = this.getAttribute(this.attrs, JAR_VERSION_VIEW);
                String string3 = this.getAttribute(this.attrs, JAR_VERSION_TSTAMP);
                this.timeStamp = string3.equals(UNKNOWN) ? 0L : Long.decode(string3);
                this.ngrp = this.getNgrpFromAttr(this.attrs, this.mainattrs, string2, this.classPath);
                if (db.isFinestEnabled()) {
                    db.finest("NGRP created: " + this.ngrp);
                }
                try {
                    String string4 = this.getAttribute(this.attrs, JAR_COVERAGE_OUTPUT_FILE);
                    System.setProperty("emma.coverage.out.file", string4);
                }
                catch (NgrpFactory.AttrNotPresentException attrNotPresentException) {
                }
                catch (Exception exception) {
                    db.fine(exception.getMessage());
                }
            }
            catch (InvalidImplVersionException invalidImplVersionException) {
                if (db.isFineEnabled()) {
                    KDebug.printStackTrace(invalidImplVersionException);
                }
                this.makeEmptyBuildInformation();
            }
            catch (NgrpFactory.AttrNotPresentException attrNotPresentException) {
                if (db.isFineEnabled()) {
                    KDebug.printStackTrace(attrNotPresentException);
                }
                this.makeEmptyBuildInformation();
            }
            catch (Exception exception) {
                KDebug.printStackTrace(exception);
                this.makeEmptyBuildInformation();
            }
        } else {
            this.makeEmptyBuildInformation();
        }
        if (classLoaderEnum != null && classLoaderEnum.equals((Object)ClassLoaderEnum.SYSTEM)) {
            systemNgrps.put(this.classPath, this.ngrp);
        }
    }

    private Manifest getManifest(String string, ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) {
        Manifest manifest = null;
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        URL[] uRLArray = uRLClassLoader.getURLs();
        if (db.on()) {
            db.println("Looking for manifest for " + string + " in CL: " + classLoader.getClass().getName() + " with title: '" + string + "' with " + uRLArray.length + " CL URLs");
        }
        if (db.isFinestEnabled()) {
            for (URL uRL : uRLArray) {
                db.finest("  URL: " + uRL);
            }
        }
        Object object = null;
        try {
            object = classLoader.getResources(MANIFEST_NAME);
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
        }
        if (object != null) {
            boolean bl = false;
            if (classLoaderEnum == null) {
                if (classLoader instanceof CmsClassLoader) {
                    classLoaderEnum = ((CmsClassLoader)classLoader).getClassLoaderKey().getClassLoaderEnum();
                } else if (CoreConstants.scl.equals(classLoader)) {
                    classLoaderEnum = ClassLoaderEnum.SYSTEM;
                }
            }
            boolean bl2 = bl = classLoaderEnum != null && classLoaderEnum.isCore;
            while (object.hasMoreElements() && manifest == null) {
                URL uRL = (URL)object.nextElement();
                if (bl && nonCtcResources.contains(uRL)) continue;
                manifest = this.getManifest(string, uRL, bl);
            }
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Manifest getManifest(String var1_1, URL var2_2, boolean var3_3) {
        block44: {
            block50: {
                block46: {
                    block49: {
                        block47: {
                            block48: {
                                block43: {
                                    block52: {
                                        var7_4 = null;
                                        var8_5 = var2_2.getProtocol();
                                        var9_6 = null;
                                        var10_7 = null;
                                        var11_8 = null;
                                        var12_9 = null;
                                        var13_10 = null;
                                        var14_11 = null;
                                        try {
                                            var15_12 = var8_5.equals("jar");
                                            if (!var15_12) ** GOTO lbl57
                                            var14_11 = var2_2;
                                            var13_10 = var14_11.toExternalForm();
                                            var16_13 = null;
                                            var4_18 = var5_17 = var14_11.getPath();
                                            try {
                                                var16_13 = new URL(var4_18);
                                                var8_5 = var16_13.getProtocol();
                                            }
                                            catch (MalformedURLException var17_19) {
                                                AbstractJarBuildInformation.db.println("manifest problem with resource: " + var2_2);
                                                KDebug.printStackTrace(var17_19);
                                                var18_24 = var7_4;
                                                var22_27 = null;
                                                if (var12_9 != null) {
                                                    // empty if block
                                                }
                                                if (var9_6 != null) {
                                                    try {
                                                        var9_6.close();
                                                    }
                                                    catch (IOException var23_34) {
                                                        KDebug.printStackTrace(var23_34);
                                                    }
                                                }
                                                return var18_24;
                                            }
                                        }
                                        catch (Throwable var21_45) {
                                            var22_33 = null;
                                            if (var12_9 != null) {
                                                // empty if block
                                            }
                                            if (var9_6 != null) {
                                                try {
                                                    var9_6.close();
                                                }
                                                catch (IOException var23_40) {
                                                    KDebug.printStackTrace(var23_40);
                                                }
                                            }
                                            throw var21_45;
                                        }
                                        var6_41 = var16_13.getPath();
                                        var17_20 = var6_41.indexOf("!/");
                                        if (var17_20 > 0) {
                                            var6_41 = var6_41.substring(0, var17_20);
                                        }
                                        break block52;
lbl57:
                                        // 1 sources

                                        var4_18 = var2_2.toExternalForm();
                                        var5_17 = var2_2.getPath();
                                        var6_41 = var5_17;
                                        if (var6_41.endsWith("META-INF/MANIFEST.MF")) {
                                            var6_41 = var6_41.substring(0, var6_41.length() - "META-INF/MANIFEST.MF".length());
                                        }
                                    }
                                    if (AbstractJarBuildInformation.db.isFinerEnabled()) {
                                        AbstractJarBuildInformation.db.finer("Trying CP URL: " + var4_18);
                                    }
                                    if (var6_41.endsWith(".jar") && !var8_5.equals("http")) break block43;
                                    var7_4 = new Manifest();
                                    try {
                                        var9_6 = var2_2.openStream();
                                        var7_4.read(var9_6);
                                        break block44;
                                    }
                                    catch (IOException var16_14) {
                                        AbstractJarBuildInformation.db.println("manifest problem with resource: " + var2_2);
                                        KDebug.printStackTrace(var16_14);
                                        var17_21 = var7_4;
                                        var22_28 = null;
                                        if (var12_9 != null) {
                                            // empty if block
                                        }
                                        if (var9_6 != null) {
                                            try {
                                                var9_6.close();
                                            }
                                            catch (IOException var23_35) {
                                                KDebug.printStackTrace(var23_35);
                                            }
                                        }
                                        return var17_21;
                                    }
                                }
                                if (!var15_12 && !var8_5.equals("file")) break block44;
                                if (!this.isForCTC) break block46;
                                var16_13 = new File(var6_41);
                                var17_22 = var16_13.getName();
                                var18_25 = var17_22.lastIndexOf(".");
                                if (var18_25 >= 0) break block47;
                                var19_42 = var7_4;
                                var22_29 = null;
                                if (var12_9 != null) {
                                    // empty if block
                                }
                                if (var9_6 == null) break block48;
                                try {
                                    var9_6.close();
                                }
                                catch (IOException var23_36) {
                                    KDebug.printStackTrace(var23_36);
                                }
                            }
                            return var19_42;
                        }
                        var17_22 = var17_22.substring(0, var18_25);
                        var19_43 = var17_22.toUpperCase();
                        if (var17_22.equals(var19_43) || var19_43.indexOf("CTC") >= 0) break block46;
                        if (AbstractJarBuildInformation.db.isFinestEnabled()) {
                            AbstractJarBuildInformation.db.finest("skipping non-CTC jar: " + var17_22);
                        }
                        if (var3_3) {
                            AbstractJarBuildInformation.nonCtcResources.add(var2_2);
                        }
                        var20_44 = var7_4;
                        var22_30 = null;
                        if (var12_9 != null) {
                            // empty if block
                        }
                        if (var9_6 == null) break block49;
                        try {
                            var9_6.close();
                        }
                        catch (IOException var23_37) {
                            KDebug.printStackTrace(var23_37);
                        }
                    }
                    return var20_44;
                }
                if (var13_10 != null) break block50;
                var16_13 = URLDecoder.decode(var5_17);
                var11_8 = new File((String)var16_13);
                try {
                    var13_10 = "jar:" + var11_8.toURL() + "!/" + "META-INF/MANIFEST.MF";
                    var14_11 = new URL(var13_10);
                }
                catch (MalformedURLException var17_23) {
                    AbstractJarBuildInformation.db.println("manifest problem with resource: " + var2_2);
                    KDebug.printStackTrace(var17_23);
                    var18_26 = var7_4;
                    var22_31 = null;
                    if (var12_9 != null) {
                        // empty if block
                    }
                    if (var9_6 != null) {
                        try {
                            var9_6.close();
                        }
                        catch (IOException var23_38) {
                            KDebug.printStackTrace(var23_38);
                        }
                    }
                    return var18_26;
                }
            }
            try {
                var7_4 = new Manifest();
                var9_6 = var2_2.openStream();
                var7_4.read(var9_6);
                var7_4 = this.checkManifest(var1_1, var7_4, var6_41);
            }
            catch (IOException var16_15) {
                AbstractJarBuildInformation.db.println("manifest problem with resource: " + var2_2);
                KDebug.printStackTrace(var16_15);
            }
            catch (RuntimeException var16_16) {
                if (!AbstractJarBuildInformation.db.on()) break block44;
                AbstractJarBuildInformation.db.println("unexpected manifest problem with resource: " + var2_2);
                KDebug.printStackTrace(var16_16);
            }
        }
        var22_32 = null;
        if (var12_9 != null) {
            // empty if block
        }
        if (var9_6 != null) {
            try {
                var9_6.close();
            }
            catch (IOException var23_39) {
                KDebug.printStackTrace(var23_39);
            }
        }
        if ((var7_4 = this.checkManifest(var1_1, var7_4, var6_41)) == null) {
            AbstractJarBuildInformation.db.fine("Manifest not found");
        }
        return var7_4;
    }

    private Manifest checkManifest(String string, Manifest manifest, String string2) {
        if (manifest == null) {
            return manifest;
        }
        Manifest manifest2 = null;
        this.mainattrs = manifest.getMainAttributes();
        String string3 = this.mainattrs.getValue(Attributes.Name.SPECIFICATION_TITLE);
        if (db.isFinestEnabled()) {
            db.finest("Manifest spec title: " + string3);
        }
        if (string3 == null) {
            db.finest("No Specification-Title in manifest");
        } else {
            String string4 = string3.toLowerCase(Locale.ENGLISH);
            if (string4.indexOf("ctc ") >= 0 && (string == null || string4.indexOf(string) >= 0)) {
                if (db.on()) {
                    db.println("Manifest " + string3 + " found");
                }
                this.attrs = manifest.getAttributes(JAR_BUILD_INFORMATION_SECTION);
                this.specTitle = string3;
                this.classPath = string2;
                manifest2 = manifest;
            }
        }
        return manifest2;
    }

    public Attributes getMainAttributes() {
        return this.mainattrs;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Date getDate() {
        return new Date(this.timeStamp * 1000L);
    }

    public String getBranchPath() {
        return this.branchPath;
    }

    public Ngrp getNgrp() {
        return this.ngrp;
    }

    private String getAttribute(Attributes attributes, String string) throws NgrpFactory.AttrNotPresentException {
        return NgrpFactory.getAttribute(attributes, string);
    }

    private Ngrp getNgrpFromAttr(Attributes attributes, Attributes attributes2, String string, String string2) throws NgrpFactory.AttrNotPresentException {
        return NgrpFactory.getNgrpFromAttr(this.specTitle, attributes, attributes2, string, string2);
    }

    private void makeEmptyBuildInformation() {
        if (db.isFinestEnabled()) {
            KDebug.printStackTrace(new Exception());
        }
        this.sourceType = UNKNOWN;
        this.branchPath = UNKNOWN;
        this.timeStamp = Long.MIN_VALUE;
        this.ngrp = new Ngrp(UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, null);
        this.ngrp.isEmpty = true;
    }

    static {
        DebugManager.instance();
        db = new KDebug("AbstractJarBuildInformation");
    }

    private class InvalidImplVersionException
    extends Exception {
        InvalidImplVersionException() {
            this(AbstractJarBuildInformation.UNKNOWN);
        }

        InvalidImplVersionException(String string) {
            super("The version is incorrect for the " + string + " jar file.");
        }
    }
}

