/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.DownloadState;
import cerent.launcher.DownloadView;
import cerent.util.KDebug;
import com.cisco.ctc.core.BaseDownloadItem;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.DownloadArea;
import com.cisco.ctc.core.DownloadAreas;
import com.cisco.ctc.core.DownloadItem;
import com.cisco.ctc.core.IAbortable;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.IDownloadItem;
import com.cisco.ctc.core.INameVersion;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.NameVersion;
import com.cisco.ctc.core.cache.CacheManager;
import com.cisco.ctc.core.cache.CtcCachedFile;
import com.cisco.ctc.core.cache.ICacheManager;
import com.cisco.ctc.core.download.DownloadManager;
import com.cisco.ctc.core.download.IDownloadManager;
import com.cisco.ctc.core.download.JarTransferEnum;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Observable;

public class CacheLocator
extends Observable
implements IAbortable {
    protected static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    protected static final IDownloadManager dm = DownloadManager.instance();
    protected static final ICacheManager cm = CacheManager.instance();
    protected static final DownloadAreas das = DownloadAreas.instance();
    protected static final String CLL_STRATEGY_PREF = "cllstrategy";
    protected static final String TEST_MODE_PREF = "cllstrategy.testmode";
    protected static boolean testmode = CoreConstants.prefs.getBoolean("ctc", "cllstrategy.testmode", false);
    protected static final String tempDirName = CoreConstants.prefs.getProperty("ctc", "download.temp.dir", "");
    protected static final File tempDir = new File(tempDirName);
    protected static final String DWLD_UI_PROP = "ctc.download";
    protected static final String DWLD_UI_KEY = "showui";
    protected boolean abort;
    private String defaultHostName;
    private NETypeEnum defaultNetype;
    private Comparable defaultNeSwVersion;
    protected KDebug db;
    protected static final KDebug staticDb = new KDebug("CacheLocator");

    protected CacheLocator(KDebug kDebug) {
        this.db = kDebug == null ? staticDb : kDebug;
    }

    public CacheLocator(String string, NETypeEnum nETypeEnum, Comparable comparable) {
        this.db = staticDb;
        this.defaultHostName = string;
        this.defaultNetype = nETypeEnum;
        this.defaultNeSwVersion = comparable;
    }

    public boolean getAbort() {
        return this.abort;
    }

    public void setAbort(boolean bl) {
        this.abort = bl;
    }

    protected final URL toURL(RequestState requestState, INameVersion iNameVersion) throws IOException, ClassLoaderException {
        return CacheLocator.toURL(this.toCtcCachedFile(requestState, iNameVersion));
    }

    protected final CtcCachedFile toCtcCachedFile(RequestState requestState, INameVersion iNameVersion) throws IOException, ClassLoaderException {
        CtcCachedFile ctcCachedFile;
        NameVersion nameVersion = (NameVersion)iNameVersion;
        if (this.db.isFinestEnabled()) {
            this.db.println("entering toCtcCachedFile() for nv " + nameVersion + "(" + nameVersion.getPresenceType() + ")");
        }
        if ((ctcCachedFile = this.getNonBootstrapJarFromCache(nameVersion)) == null) {
            int n = nameVersion.getPresenceType();
            if (n == 0 || n == 1) {
                if (requestState == null) {
                    requestState = this.createRequestState(this.defaultHostName, this.defaultNetype, null, this.defaultNeSwVersion);
                }
                try {
                    ctcCachedFile = this._addNonBootstrapJarToCache(requestState, nameVersion);
                }
                catch (ClassLoaderException classLoaderException) {
                    if (n == 0) {
                        throw classLoaderException;
                    }
                    if (this.db.on()) {
                        this.db.println("warning: NameVersion: " + nameVersion.name + ".jar not found in cache/could not be downloaded but was not deemed required");
                    }
                    throw classLoaderException;
                }
            } else if (this.db.on()) {
                this.db.println("warning: NameVersion: " + nameVersion.name + ".jar not found in cache but was not deemed required");
            }
        }
        return ctcCachedFile;
    }

    protected final URL[] toURLs(RequestState requestState, INameVersion[] iNameVersionArray) throws IOException, ClassLoaderException {
        int n = iNameVersionArray == null ? 0 : iNameVersionArray.length;
        URL[] uRLArray = new URL[n];
        for (int i = 0; i < n; ++i) {
            uRLArray[i] = this.toURL(requestState, iNameVersionArray[i]);
        }
        return uRLArray;
    }

    protected static File realizeTempDir() throws IOException {
        if (tempDirName == null || tempDirName.length() == 0) {
            return null;
        }
        if (tempDir.exists()) {
            if (!tempDir.isDirectory()) {
                throw new IOException(tempDirName + " does not appear to be a directory.");
            }
        } else if (!tempDir.mkdir()) {
            throw new IOException("The temporary directory " + tempDirName + " could not be created.");
        }
        return tempDir;
    }

    public static File getTempFile(String string, String string2) throws IOException {
        File file = CacheLocator.realizeTempDir();
        File file2 = File.createTempFile(string, string2, file);
        file2.deleteOnExit();
        return file2;
    }

    protected static File getTempFile() throws IOException {
        return CacheLocator.getTempFile("temp", ".ctc");
    }

    protected static File getTempJar() throws IOException {
        return CacheLocator.getTempFile("temp", ".ctc.jar");
    }

    protected final String getStateName(RequestState requestState) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = requestState.neFullSwVersion;
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(" (");
        stringBuilder.append((Object)requestState.clEnum);
        stringBuilder.append(")");
        stringBuilder.append(" for a CISCO ONS ");
        stringBuilder.append(requestState.netype.fifteenType);
        stringBuilder.append(" from ");
        stringBuilder.append(requestState.getActualHostName());
        return stringBuilder.toString();
    }

    protected final String getStateName(RequestState requestState, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = requestState.neFullSwVersion;
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(" (");
        stringBuilder.append(string);
        stringBuilder.append(")");
        stringBuilder.append(" for a CISCO ONS ");
        stringBuilder.append(requestState.netype.fifteenType);
        stringBuilder.append(" from ");
        stringBuilder.append(requestState.getActualHostName());
        return stringBuilder.toString();
    }

    protected boolean isDownloadUiPermitted() {
        return true;
    }

    protected final boolean showDownloadUi() {
        boolean bl = this.isDownloadUiPermitted() && CoreConstants.prefs.getBoolean(DWLD_UI_PROP, DWLD_UI_KEY, true);
        return bl;
    }

    public CtcCachedFile locateBootstrapJarInCache(ClassLoaderEnum classLoaderEnum) throws IOException, ClassLoaderException {
        CtcCachedFile ctcCachedFile;
        if (this.db.isFinerEnabled()) {
            this.db.finer("attempting to locate bootstrap jar: " + classLoaderEnum.jarPrefix + " from " + this.defaultHostName + " (" + this.defaultNeSwVersion + ")");
        }
        if ((ctcCachedFile = this.getBootstrapJarFromCache(this.defaultNetype, classLoaderEnum, this.defaultNeSwVersion)) == null) {
            RequestState requestState = this.createRequestState(this.defaultHostName, this.defaultNetype, classLoaderEnum, this.defaultNeSwVersion);
            ctcCachedFile = this._addBootstrapJarToCache(requestState);
        }
        if (ctcCachedFile != null) {
            this.setChanged();
            this.notifyObservers(ctcCachedFile);
        }
        return ctcCachedFile;
    }

    protected final CtcCachedFile[] locateEleBootstrapJarsInCache() throws IOException, ClassLoaderException {
        ClassLoaderEnum classLoaderEnum = ClassLoaderEnum.ELE;
        RequestState requestState = this.createRequestState(this.defaultHostName, this.defaultNetype, classLoaderEnum, this.defaultNeSwVersion);
        CtcCachedFile[] ctcCachedFileArray = this.locateEleBootstrapJarsInCache(requestState);
        return ctcCachedFileArray;
    }

    protected final URL[] locateEleBootstrapJarURLsInCache(RequestState requestState) throws IOException, ClassLoaderException {
        CtcCachedFile[] ctcCachedFileArray = this.locateEleBootstrapJarsInCache(requestState);
        return CacheLocator.toURLs(ctcCachedFileArray);
    }

    protected final CtcCachedFile[] locateEleBootstrapJarsInCache(RequestState requestState) throws IOException, ClassLoaderException {
        CtcCachedFile ctcCachedFile;
        CtcCachedFile[] ctcCachedFileArray;
        if (this.db.on()) {
            this.db.println("locating via " + requestState.getActualHostName() + " bootstrap jar: " + (Object)((Object)requestState.clEnum) + "/vo:" + cvu.prettyDottedString(requestState.neActualSwVersion) + "(" + requestState.neSwVersion + ")");
        }
        if (((ctcCachedFileArray = this.getBootstrapJarsFromCache(requestState.netype, requestState.clEnum, requestState.neSwVersion, requestState.neActualSwVersion)) == null || ctcCachedFileArray.length == 0) && (ctcCachedFile = this._addBootstrapJarToCache(requestState)) != null) {
            ctcCachedFileArray = new CtcCachedFile[]{ctcCachedFile};
        }
        return ctcCachedFileArray;
    }

    protected final CtcCachedFile getBootstrapJarFromCache(NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) throws IOException {
        CtcCachedFile ctcCachedFile = null;
        if (this.db.on()) {
            if (nETypeEnum == null || nETypeEnum.equals((Object)NETypeEnum.NE_DONT_CARE)) {
                this.db.println("looking in cache for bootstrap jar: " + (Object)((Object)classLoaderEnum) + "/vo:" + cvu.prettyDottedString(comparable));
            } else {
                this.db.println("looking in cache for " + (Object)((Object)nETypeEnum) + " bootstrap jar: " + (Object)((Object)classLoaderEnum) + "/vo:" + cvu.prettyDottedString(comparable));
            }
        }
        ctcCachedFile = cm.retrieve(nETypeEnum, classLoaderEnum, comparable);
        return ctcCachedFile;
    }

    protected final URL getBootstrapJarURLFromCache(NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) throws IOException {
        URL uRL;
        CtcCachedFile ctcCachedFile = this.getBootstrapJarFromCache(nETypeEnum, classLoaderEnum, comparable);
        URL uRL2 = uRL = ctcCachedFile != null ? (uRL = CacheLocator.toURL(ctcCachedFile)) : null;
        if (this.db.on()) {
            this.db.println("found " + uRL + " cache URL for bootstrap JAR: " + (Object)((Object)classLoaderEnum) + "/vo:" + cvu.prettyDottedString(comparable));
        }
        return uRL;
    }

    protected final CtcCachedFile[] getBootstrapJarsFromCache(NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, Comparable comparable2) throws IOException {
        if (this.db.isFinestEnabled()) {
            this.db.println("filtering cache ELE jars based on: " + cvu.prettyDottedString(comparable2) + "(" + cvu.prettyDottedString(comparable) + ")");
        }
        if (this.db.on()) {
            if (nETypeEnum == null || nETypeEnum.equals((Object)NETypeEnum.NE_DONT_CARE)) {
                this.db.println("looking in cache for bootstrap JAR: " + (Object)((Object)classLoaderEnum) + "/vo:" + cvu.prettyDottedString(comparable2) + "(" + cvu.prettyDottedString(comparable) + ")");
            } else {
                this.db.println("looking in cache for " + (Object)((Object)nETypeEnum) + " bootstrap JAR: " + (Object)((Object)classLoaderEnum) + "/vo:" + cvu.prettyDottedString(comparable2) + "(" + cvu.prettyDottedString(comparable) + ")");
            }
        }
        CtcCachedFile[] ctcCachedFileArray = cm.retrieve(nETypeEnum, classLoaderEnum);
        if (this.db.isFinerEnabled()) {
            this.db.finer("found " + (ctcCachedFileArray == null ? 0 : ctcCachedFileArray.length) + " jars for clEnum: " + (Object)((Object)classLoaderEnum));
        }
        if (this.db.on()) {
            this.db.println("returned: " + (ctcCachedFileArray == null ? 0 : ctcCachedFileArray.length) + " CFs");
        }
        return ctcCachedFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final CtcCachedFile _addBootstrapJarToCache(RequestState requestState) throws IOException, ClassLoaderException {
        Object object;
        Object object2;
        Object object3;
        DownloadState downloadState;
        Object object4;
        DownloadView downloadView;
        File file;
        block30: {
            if (this.db.on()) {
                this.db.println("downloading via: " + requestState);
            }
            if (!requestState.isDownloadingPermitted) {
                throw new ClassLoaderException("download not permitted for: " + requestState + " check the cache to determine why the associated bootstrap jar file is missing/mis-named/download should be enabled");
            }
            if (requestState.hostName == null) {
                throw new ClassLoaderException("download not possible for " + requestState + " since hostname is null. Check the cache to determine why the associated bootstrap jar file is missing/mis-named/download should be enabled");
            }
            file = CacheLocator.getTempJar();
            downloadView = null;
            if (this.showDownloadUi()) {
                object4 = this.getStateName(requestState);
                downloadState = new DownloadState((String)object4);
            } else {
                downloadState = null;
            }
            this.setChanged();
            this.notifyObservers(null);
            if (this.getAbort()) {
                throw new ClassLoaderException("user aborted download of CTC bootstrap Jar: " + (Object)((Object)requestState.clEnum) + " from " + requestState.getActualHostName());
            }
            try {
                object4 = null;
                object3 = requestState.da;
                if (object3 != null) {
                    object2 = ((DownloadArea)object3).getDownloadItem(requestState.clEnum.jarPrefix);
                    object = null;
                    if (object2 == null) {
                        if (this.db.on()) {
                            this.db.println("Could not find: " + requestState.clEnum.jarPrefix + " in DA: " + object3);
                        }
                    } else {
                        object = new DownloadItem((IDownloadItem)object2);
                    }
                    if (object != null) {
                        File file2 = ((BaseDownloadItem)object).getFile();
                        JarTransferEnum.Type type = ((DownloadItem)object).getType();
                        if (file2.exists()) {
                            if (this.db.on()) {
                                this.db.println("using download area: " + object3 + " to download CTC bootstrap Jar: " + (Object)((Object)requestState.clEnum));
                            }
                            downloadState = null;
                            object4 = dm.downloadExplicitURL(((BaseDownloadItem)object).getURL(), file, downloadState, type);
                        }
                    }
                }
                if (object4 == null) {
                    if (requestState.clEnum.isCore && requestState.systemVo.compareTo(requestState.neActualSwVersion) > 0) {
                        if (this.db.on()) {
                            this.db.println("Skipping download since NE version < core Jar version for request: " + requestState);
                        }
                        object2 = null;
                        Object var12_12 = null;
                        if (downloadState != null) {
                            downloadState.doFinalStep();
                        }
                        if (downloadView == null) return object2;
                        downloadView.fini();
                        return object2;
                    }
                    object4 = dm.downloadCTCJar(requestState.hostName, requestState.netype, requestState.clEnum, file, downloadState);
                }
                if (object4 != null) {
                    downloadView = downloadState == null ? null : new DownloadView(downloadState);
                    object4.transfer();
                    if (this.db.on()) {
                        this.db.println("Successfully downloaded CTC bootstrap Jar: " + (Object)((Object)requestState.clEnum) + " from " + requestState.getActualHostName());
                    }
                    break block30;
                }
                if (this.db.on()) {
                    this.db.println("ITransferer could not be created for CTC bootstrap Jar: " + (Object)((Object)requestState.clEnum) + " from " + requestState.getActualHostName());
                }
                object2 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (downloadState != null) {
                    downloadState.doFinalStep();
                }
                if (downloadView == null) throw throwable;
                downloadView.fini();
                throw throwable;
            }
            Object var12_13 = null;
            if (downloadState != null) {
                downloadState.doFinalStep();
            }
            if (downloadView == null) return object2;
            downloadView.fini();
            return object2;
        }
        Object var12_14 = null;
        if (downloadState != null) {
            downloadState.doFinalStep();
        }
        if (downloadView != null) {
            downloadView.fini();
        }
        if (this.db.on()) {
            this.db.println("adding bootstrap jar: " + (Object)((Object)requestState.clEnum) + "/vo: " + cvu.prettyDottedString(requestState.neSwVersion) + " to cache");
        }
        if (this.db.isFinestEnabled()) {
            this.db.println("temp download file: " + file + " does" + (file.exists() ? "" : " not") + " exist");
        }
        object4 = null;
        if (!file.exists()) return object4;
        object3 = file.toURL();
        object2 = cvu.getNgrp((URL)object3);
        object = object2.getFullVersionFormat();
        try {
            requestState.jarVo = cvu.createManifestFullVersionOrdinal((String)object);
            return cm.store(file, requestState.netype, requestState.clEnum, requestState.jarVo, true);
        }
        catch (RuntimeException runtimeException) {
            throw new ClassLoaderException("invalid manifest version: " + (String)object + " for downloaded bootstrap jar: " + file + " with: " + requestState, runtimeException);
        }
    }

    protected URL addBootstrapJarToCache(RequestState requestState) throws IOException, ClassLoaderException {
        URL uRL = null;
        CtcCachedFile ctcCachedFile = this._addBootstrapJarToCache(requestState);
        if (ctcCachedFile != null) {
            uRL = CacheLocator.toURL(ctcCachedFile);
            if (this.db.on()) {
                this.db.println("cached location was: " + uRL);
            }
            if (this.db.isFinestEnabled()) {
                File file = new File(uRL.getFile());
                this.db.println("cached file: " + file + " does" + (file.exists() ? "" : " not") + " exist");
            }
        }
        return uRL;
    }

    public CtcCachedFile locateNonBootstrapJarToCache(NameVersion nameVersion) throws IOException, ClassLoaderException {
        CtcCachedFile ctcCachedFile = this.toCtcCachedFile(null, nameVersion);
        if (ctcCachedFile != null) {
            this.setChanged();
            this.notifyObservers(ctcCachedFile);
        }
        return ctcCachedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CtcCachedFile _addNonBootstrapJarToCache(RequestState requestState, NameVersion nameVersion) throws IOException, ClassLoaderException {
        DownloadArea downloadArea;
        DownloadState downloadState;
        Object object;
        String string = nameVersion.name;
        if (!requestState.isDownloadingPermitted) {
            throw new ClassLoaderException("download not permitted for extension " + string + ".jar for: " + requestState + " check the cache to determine why the associated jar file is missing/mis-named/download should be enabled");
        }
        if (requestState.hostName == null) {
            throw new ClassLoaderException("download not possible for extension " + string + ".jar for: " + requestState + " since hostname is null. Check the cache to determine why the associated jar file is missing/mis-named/download should be enabled");
        }
        File file = CacheLocator.getTempJar();
        DownloadView downloadView = null;
        if (this.showDownloadUi()) {
            object = this.getStateName(requestState, string);
            downloadState = new DownloadState((String)object);
        } else {
            downloadState = null;
        }
        this.setChanged();
        this.notifyObservers(null);
        if (this.getAbort()) {
            throw new ClassLoaderException("user aborted download of CTC non-bootstrap Jar: " + string + " from " + requestState.getActualHostName());
        }
        object = null;
        try {
            IDownloadItem iDownloadItem;
            DownloadItem downloadItem;
            downloadArea = requestState.da;
            boolean bl = false;
            if (downloadArea != null && (downloadItem = new DownloadItem(iDownloadItem = downloadArea.getDownloadItem(string))) != null) {
                File file2 = downloadItem.getFile();
                JarTransferEnum.Type type = downloadItem.getType();
                if (file2.exists()) {
                    if (this.db.on()) {
                        this.db.println("using download area: " + downloadArea + " to download CTC non-bootstrap Jar: " + string);
                    }
                    downloadState = null;
                    bl = true;
                    object = dm.downloadExplicitURL(downloadItem.getURL(), file, downloadState, type);
                }
            }
            if (object == null) {
                object = dm.downloadExplicitJar(requestState.hostName, string, file, downloadState);
            }
            if (object != null) {
                downloadView = downloadState == null ? null : new DownloadView(downloadState);
                try {
                    object.transfer();
                }
                catch (IOException iOException) {
                    if (!bl) {
                        throw iOException;
                    }
                    object = dm.downloadExplicitJar(requestState.hostName, string, file, downloadState);
                    object.transfer();
                }
                if (this.db.on()) {
                    this.db.println("Successfully downloaded CTC non-bootstrap Jar: " + string + " from " + requestState.getActualHostName());
                }
            }
            Object var15_15 = null;
            if (downloadState != null) {
                downloadState.doFinalStep();
            }
            if (downloadView != null) {
                downloadView.fini();
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (downloadState != null) {
                downloadState.doFinalStep();
            }
            if (downloadView != null) {
                downloadView.fini();
            }
            throw throwable;
        }
        downloadArea = object == null ? null : cm.store(file, nameVersion);
        return downloadArea;
    }

    protected final URL addNonBootstrapJarToCache(RequestState requestState, NameVersion nameVersion) throws IOException, ClassLoaderException {
        CtcCachedFile ctcCachedFile = this._addNonBootstrapJarToCache(requestState, nameVersion);
        URL uRL = CacheLocator.toURL(ctcCachedFile);
        return uRL;
    }

    protected final URL getNonBootstrapJarURLFromCache(NameVersion nameVersion) throws IOException {
        URL uRL = null;
        CtcCachedFile ctcCachedFile = this.getNonBootstrapJarFromCache(nameVersion);
        if (ctcCachedFile != null) {
            uRL = CacheLocator.toURL(ctcCachedFile);
        }
        if (this.db.on()) {
            this.db.println("looking up: " + nameVersion + " in cache got: " + uRL);
        }
        return uRL;
    }

    protected CtcCachedFile getNonBootstrapJarFromCache(NameVersion nameVersion) throws IOException {
        CtcCachedFile ctcCachedFile = cm.retrieve(nameVersion);
        return ctcCachedFile;
    }

    protected static final URL toURL(CtcCachedFile ctcCachedFile) throws MalformedURLException {
        return ctcCachedFile == null ? null : ctcCachedFile.file.toURL();
    }

    protected static final URL[] toURLs(CtcCachedFile[] ctcCachedFileArray) throws MalformedURLException {
        int n;
        int n2 = n = ctcCachedFileArray == null ? 0 : ctcCachedFileArray.length;
        if (n == 0) {
            return CoreConstants.URLArrayTemplate;
        }
        URL[] uRLArray = new URL[n];
        int n3 = 0;
        for (int i = 0; i < ctcCachedFileArray.length; ++i) {
            CtcCachedFile ctcCachedFile = ctcCachedFileArray[i];
            uRLArray[n3++] = CacheLocator.toURL(ctcCachedFile);
        }
        return uRLArray;
    }

    protected static final String toString(URL[] uRLArray) {
        int n;
        int n2 = n = uRLArray == null ? 0 : uRLArray.length;
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(uRLArray[0].toString());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(";");
            stringBuilder.append(uRLArray[i].toString());
        }
        return stringBuilder.toString();
    }

    protected RequestState createRequestState(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) throws IOException {
        return this.createRequestState(string, nETypeEnum, classLoaderEnum, comparable, null);
    }

    protected RequestState createRequestState(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, Comparable comparable2) throws IOException {
        RequestState requestState = new RequestState(string, nETypeEnum, classLoaderEnum, comparable, comparable2, CoreConstants.isDownloadingPermitted);
        if (this.db.isFinestEnabled()) {
            this.db.finest("request state: " + requestState);
        }
        return requestState;
    }

    protected static class RequestState {
        public final String hostName;
        public final NETypeEnum netype;
        public final ClassLoaderEnum clEnum;
        public final Comparable neSwVersion;
        public Comparable systemVo;
        public final String neFullSwVersion;
        public final Comparable neActualSwVersion;
        public final boolean isDownloadingPermitted;
        public Comparable jarVo;
        public ClassLoader bestEleCl;
        public INgrp bootstrapJarNgrp;
        public DownloadArea da;

        public RequestState(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, Comparable comparable2, boolean bl) throws IOException {
            String string2;
            Comparable comparable3;
            String string3;
            this.hostName = string;
            this.netype = nETypeEnum;
            this.clEnum = classLoaderEnum;
            this.neSwVersion = comparable;
            this.systemVo = comparable2;
            this.isDownloadingPermitted = bl;
            if (classLoaderEnum != null && classLoaderEnum.isCore) {
                int n;
                string3 = cvu.getOriginalVersionStr(comparable);
                if (string3 != null && (n = string3.indexOf("-")) < 0) {
                    string3 = string3 + "-XXXX-00.00";
                }
                comparable3 = comparable;
            } else {
                string3 = null;
                comparable3 = null;
            }
            if (string3 == null) {
                string3 = string == null ? null : CtcHttpRetriever.getSwVersion(string);
                comparable3 = string3 == null ? null : cvu.createNeVersionOrdinal(string3);
            }
            this.neFullSwVersion = string3;
            this.neActualSwVersion = comparable3;
            if (this.systemVo == null && classLoaderEnum != null && classLoaderEnum.equals((Object)ClassLoaderEnum.SYSTEM) && das.getInitialConfiguredDas() != null && das.getInitialConfiguredDas().size() > 0 && (string2 = cvu.getCTCBootstrapManifestFullVersion(ClassLoader.getSystemClassLoader())) != null) {
                this.systemVo = cvu.createManifestFullVersionOrdinal(string2);
            }
            if (this.systemVo == null) {
                this.systemVo = comparable;
            } else if (staticDb.on()) {
                staticDb.println("System VO determined from launch path: " + this.systemVo);
            }
            Map<Comparable, DownloadArea> map = das.getInitialConfiguredDas();
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>(map.keySet());
            Collections.reverse(arrayList);
            DownloadArea downloadArea = null;
            for (Comparable comparable4 : arrayList) {
                DownloadArea downloadArea2 = map.get(comparable4);
                if (!downloadArea2.isAreaComplete()) continue;
                downloadArea = downloadArea2;
                if (!staticDb.on()) break;
                staticDb.println("Best DA found was: " + downloadArea);
                break;
            }
            if (downloadArea != null && this.systemVo != null && this.systemVo.compareTo(downloadArea) > 0) {
                downloadArea = null;
                if (staticDb.on()) {
                    staticDb.println("Best DA ignored due to > version system VO: " + this.systemVo);
                }
            }
            if (map != null) {
                if (comparable == null || comparable.compareTo(this.systemVo) < 0) {
                    this.da = downloadArea != null ? downloadArea : map.get(this.systemVo);
                } else {
                    this.da = downloadArea != null ? downloadArea : map.get(comparable);
                    if (this.da == null) {
                        this.da = map.get(this.systemVo);
                    }
                }
            }
        }

        public String getActualHostName() {
            return CoreConstants.GetActualAddress(this.hostName);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("hostName: ");
            stringBuilder.append(this.getActualHostName());
            stringBuilder.append("; netype: ");
            stringBuilder.append((Object)this.netype);
            stringBuilder.append("; ClassLoader: ");
            stringBuilder.append((Object)this.clEnum);
            stringBuilder.append("; nwSwVersion: ");
            stringBuilder.append(cvu.prettyDottedString(this.neSwVersion));
            stringBuilder.append("; neFullSwVersion: ");
            stringBuilder.append(this.neFullSwVersion);
            stringBuilder.append("; systemVo: ");
            stringBuilder.append(this.systemVo);
            stringBuilder.append("; bestEleCl: ");
            stringBuilder.append(this.bestEleCl);
            return stringBuilder.toString();
        }
    }
}

