/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.launcher.CmsClassLoader;
import cerent.util.KDebug;
import com.cisco.ctc.core.AbstractClassLoaderLocatingStrategy;
import com.cisco.ctc.core.CacheLocator;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.RetryableException;
import com.cisco.ctc.core.cache.CtcCachedFile;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;

public class CoreClassLoaderLocatingStrategy
extends AbstractClassLoaderLocatingStrategy {
    protected static final KDebug staticDb = new KDebug("CLLCoreStrategy");
    private static CoreClassLoaderLocatingStrategy instance = new CoreClassLoaderLocatingStrategy(staticDb);

    protected CoreClassLoaderLocatingStrategy(KDebug kDebug) {
        super(kDebug == null ? staticDb : kDebug);
    }

    public static CoreClassLoaderLocatingStrategy instance() {
        return instance;
    }

    protected void checkCreatedClassLoader(CacheLocator.RequestState requestState, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassLoaderException, IOException {
        super.checkCreatedClassLoader(requestState, classLoader);
        ClassLoader classLoader2 = classLoader.getParent();
        if (requestState.isDownloadingPermitted && !this.isSystemClassLoader(classLoader) && this.isCoreClassLoader(classLoader2) && classLoader instanceof CmsClassLoader) {
            String string = this.isSystemClassLoader(classLoader2) ? this.getSystemSwVersion() : ((CmsClassLoader)classLoader2).getSwVersion();
            CmsClassLoader cmsClassLoader = (CmsClassLoader)classLoader;
            String string2 = cmsClassLoader.getSwVersion();
            if (string == null || !string.equals(string2)) {
                Comparable comparable = this.getManifestComparable(string);
                Comparable comparable2 = this.getManifestComparable(string2);
                String string3 = "warning: parent CL (" + classLoader2 + "/vo:" + cvu.prettyDottedString(comparable) + ") full version: " + string + " mismatches child CL (" + classLoader + "/vo:" + cvu.prettyDottedString(comparable2) + ") full version: " + string2;
                this.db.println(string3);
                cmsClassLoader.setWarning(new ClassLoaderException(string3));
            }
        }
    }

    public final URL toURL(CacheLocator.RequestState requestState, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) throws IOException, ClassLoaderException {
        URL uRL;
        CtcCachedFile ctcCachedFile = this.getBootstrapJarFromCache(nETypeEnum, classLoaderEnum, comparable);
        URL uRL2 = uRL = ctcCachedFile != null ? (uRL = CoreClassLoaderLocatingStrategy.toURL(ctcCachedFile)) : null;
        if (uRL == null) {
            uRL = this.addBootstrapJarToCache(requestState);
            if (uRL == null) {
                throw new IOException("could not locate the bootstrap JAR URL for: " + (Object)((Object)classLoaderEnum));
            }
        } else {
            requestState.bootstrapJarNgrp = cm.getNgrp(ctcCachedFile);
        }
        return uRL;
    }

    public ClassLoader locateClassLoader(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, Comparable comparable2) throws ClassNotFoundException, MalformedURLException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassLoaderException, RetryableException {
        if (!classLoaderEnum.isCore) {
            throw new IllegalArgumentException("cannot use this locator: " + this.getClass().getName() + " for a non CORE CL: " + (Object)((Object)classLoaderEnum));
        }
        ClassLoader classLoader = super.locateClassLoader(string, nETypeEnum, classLoaderEnum, comparable, comparable2);
        if (classLoader != null) {
            if (this.db.isFinestEnabled()) {
                this.db.finest("returning CL: " + classLoader);
            }
            return classLoader;
        }
        if (this.db.isFinerEnabled()) {
            this.db.finer("must create a new Core " + (Object)((Object)classLoaderEnum) + " CL");
        }
        ClassLoader classLoader2 = this.lookupParent(classLoaderEnum, comparable);
        Comparable comparable3 = this.getManifestComparable(classLoader2);
        CacheLocator.RequestState requestState = this.createRequestState(string, nETypeEnum, classLoaderEnum, comparable, comparable3);
        URL uRL = this.toURL(requestState, nETypeEnum, classLoaderEnum, comparable3);
        URL[] uRLArray = new URL[]{uRL};
        INgrp iNgrp = requestState.bootstrapJarNgrp;
        String string2 = iNgrp == null ? null : iNgrp.getFullVersionFormat();
        INgrp iNgrp2 = requestState.bootstrapJarNgrp;
        String string3 = null;
        if (iNgrp2 != null) {
            string3 = iNgrp2.getMainClass();
        }
        CmsClassLoader cmsClassLoader = new CmsClassLoader(classLoaderEnum, comparable, uRLArray, classLoader2, string2, string3);
        classLoader = this.addClassLoader(requestState, cmsClassLoader);
        return classLoader;
    }
}

