/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.util.CtcRuntime;
import cerent.util.KDebug;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.CtcBootstrapJar;
import com.cisco.ctc.core.DownloadArea;
import com.cisco.ctc.core.DownloadAreas;
import com.cisco.ctc.core.IClassLoaderManager;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.LauncherJarFileFilter;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.cache.CacheManager;
import com.cisco.ctc.core.cache.CtcCachedFile;
import com.cisco.ctc.core.cache.ICacheManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreClassLoadersSetupUtil {
    private static final String CTC = "ctc";
    private static final String CACHE_DIR = "cache.dir";
    private static final IClassLoaderManager clm = ClassLoaderManager.instance();
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static final ICacheManager cm = CacheManager.instance();
    private static final DownloadAreas das = DownloadAreas.instance();
    private static final Map<Comparable, DownloadArea> initialConfiguredDas = das.getInitialConfiguredDas();
    private static CoreClassLoadersSetupUtil instance = new CoreClassLoadersSetupUtil();
    private static final KDebug db = new KDebug("CoreSetup");

    public static CoreClassLoadersSetupUtil instance() {
        return instance;
    }

    private CoreClassLoadersSetupUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public void defaultSetupCache() throws IOException {
        File file;
        Object object;
        Object object4;
        String[] stringArray = null;
        String string = CoreConstants.prefs.getProperty(CTC, CACHE_DIR, null);
        Object object5 = null;
        if (string != null) {
            stringArray = string.split(";");
        } else {
            object4 = ClassLoaderEnum.SYSTEM.jarPrefix + ".JAR";
            for (URL object32 : CoreConstants.scl.getURLs()) {
                String string2;
                String string3;
                if (db.isFinestEnabled()) {
                    db.finest("considering CP url: " + object32);
                }
                if (!(string3 = object32.toExternalForm()).startsWith("file:")) {
                    if (!db.on()) continue;
                    db.println("skipping URL: " + string3);
                    continue;
                }
                object = object32.getFile();
                object = ((String)object).replaceAll("%20", " ");
                if (db.isFinestEnabled()) {
                    db.println("path= " + (String)object);
                }
                if (!(string2 = ((String)object).toUpperCase(Locale.ENGLISH)).endsWith((String)object4)) continue;
                object5 = object;
                if (!db.isFinestEnabled()) break;
                db.println("found path: " + (String)object);
                break;
            }
        }
        object4 = new ArrayList();
        int n = 0;
        if (object5 != null) {
            if (initialConfiguredDas != null && initialConfiguredDas.size() > 0 && this.launchingInDownloadArea((String)object5)) {
                File file2 = this.getDefaultCacheDir();
                stringArray = new String[]{file2.getCanonicalPath()};
                object5 = null;
            } else {
                File file3 = this.getDefaultCacheDir();
                File file4 = new File((String)object5);
                File file2 = file4.getParentFile();
                if (file3.exists() && CoreConstants.isDownloadingPermitted) {
                    db.println("remnant DA jar cache dirs needed for launcher path: " + object5);
                    n = 1;
                    stringArray = new String[]{file2.getCanonicalPath(), file3.getCanonicalPath()};
                }
            }
        }
        if (object5 != null && stringArray == null) {
            File file5 = new File((String)object5);
            File file6 = file5.getParentFile();
            String string4 = file6.getCanonicalPath();
            File file3 = new File(string4 + "/lib");
            ((ArrayList)object4).add(string4);
            if (file3.exists()) {
                ((ArrayList)object4).add(file3.getCanonicalPath());
            }
            if (CoreConstants.OPENFUSION_LIB_DIR != null) {
                object = new File(CoreConstants.OPENFUSION_LIB_DIR);
                ((ArrayList)object4).add(((File)object).getCanonicalPath());
            }
            stringArray = ((ArrayList)object4).toArray(new String[0]);
        }
        if (stringArray == null && (file = new File(".")).list(LauncherJarFileFilter.instance()).length > 0) {
            stringArray = new String[]{file.getCanonicalPath()};
        }
        if (stringArray != null) {
            void var8_22;
            db.print("*** jar cache dirs: ");
            String[] stringArray2 = stringArray;
            int n2 = stringArray2.length;
            boolean bl = false;
            while (var8_22 < n2) {
                String string5 = stringArray2[var8_22];
                db.print(string5 + " ");
                ++var8_22;
            }
            db.println("");
            cm.refresh(stringArray, n);
        } else {
            db.println("warning: no directory could be established for the Cache Manager. No refresh was performed.");
        }
    }

    private File getDefaultCacheDir() {
        return CtcRuntime.getDefaultCacheDir();
    }

    private boolean launchingInDownloadArea(String string) {
        Iterator<DownloadArea> iterator = initialConfiguredDas.values().iterator();
        File file = new File(string);
        while (iterator.hasNext()) {
            DownloadArea downloadArea = iterator.next();
            String string2 = downloadArea.getLauncherPath();
            File file2 = new File(string2);
            if (!file2.equals(file)) continue;
            return true;
        }
        return false;
    }

    public String getBootstrapPath(Comparable comparable) {
        CtcBootstrapJar ctcBootstrapJar = new CtcBootstrapJar(ClassLoaderEnum.SYSTEM, NETypeEnum.NE_DONT_CARE, comparable);
        CtcCachedFile ctcCachedFile = cm.retrieve(ctcBootstrapJar);
        String string = ctcCachedFile == null ? null : ctcCachedFile.getPath();
        return string;
    }

    public ClassLoader setup(String string, Comparable comparable) throws IOException, ClassLoaderException {
        return this.setup(clm, string, comparable);
    }

    public ClassLoader setup(IClassLoaderManager iClassLoaderManager, String string, Comparable comparable) throws IOException, ClassLoaderException {
        return this.setup(iClassLoaderManager, string, comparable, false);
    }

    public ClassLoader setup(IClassLoaderManager iClassLoaderManager, String string, Comparable comparable, boolean bl) throws IOException, ClassLoaderException {
        ClassLoader classLoader = null;
        NETypeEnum nETypeEnum = NETypeEnum.NE_DONT_CARE;
        try {
            if (db.isFinerEnabled()) {
                db.finer("about to setup the SYSTEM CL w/ login node: " + CoreConstants.GetActualAddress(string) + (bl ? " for launcher only" : ""));
            }
            ClassLoader classLoader2 = iClassLoaderManager.getCoreClassLoader(string, nETypeEnum, ClassLoaderEnum.SYSTEM, comparable);
            if (!bl) {
                ClassLoader classLoader3;
                String string2 = iClassLoaderManager.getSystemSwVersion();
                Comparable comparable2 = cvu.createManifestFullVersionOrdinal(string2);
                if (db.isFinerEnabled()) {
                    db.finer("about to setup the IF CL");
                }
                ClassLoader classLoader4 = iClassLoaderManager.getCoreClassLoader(string, nETypeEnum, ClassLoaderEnum.IF, comparable2);
                if (db.isFinerEnabled()) {
                    db.finer("icl created: " + classLoader4);
                    db.finer("about to setup the NET CL");
                }
                Comparable comparable3 = cvu.createManifestFullVersionOrdinal(string2);
                classLoader = classLoader3 = iClassLoaderManager.getCoreClassLoader(string, nETypeEnum, ClassLoaderEnum.NET, comparable2);
                das.cleanupDownloadArea(das.removeCoreMapping(comparable2));
            } else {
                classLoader = classLoader2;
            }
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
            throw iOException;
        }
        catch (ClassLoaderException classLoaderException) {
            KDebug.printStackTrace(classLoaderException);
            throw classLoaderException;
        }
        catch (RuntimeException runtimeException) {
            KDebug.printStackTrace(runtimeException);
            throw runtimeException;
        }
        return classLoader;
    }

    public boolean isUnifiedCoreLaunchComplete(Comparable comparable, boolean bl) throws IOException {
        String string;
        File file;
        if (!cvu.isUnifiedCore(comparable)) {
            throw new IllegalArgumentException("launcherVo: " + cvu.prettyDottedString(comparable) + " must be a unified core version");
        }
        CtcCachedFile ctcCachedFile = cm.retrieve(NETypeEnum.NE_DONT_CARE, ClassLoaderEnum.SYSTEM, comparable);
        if (ctcCachedFile != null) {
            return true;
        }
        if (initialConfiguredDas == null) {
            return false;
        }
        DownloadArea downloadArea = initialConfiguredDas.get(comparable);
        if (downloadArea != null && (file = new File(string = downloadArea.getLauncherPath())).exists()) {
            if (bl) {
                cm.store(file, NETypeEnum.NE_DONT_CARE, ClassLoaderEnum.SYSTEM, comparable, false);
            }
            return true;
        }
        return false;
    }

    public boolean isUnifiedCoreLaunchComplete(Comparable comparable) throws IOException {
        return this.isUnifiedCoreLaunchComplete(comparable, false);
    }

    public Map<? super Comparable, ? super DownloadArea> getDownloadAreasWithLauncher() throws IOException {
        HashMap<Comparable, DownloadArea> hashMap = new HashMap<Comparable, DownloadArea>();
        for (Comparable comparable : initialConfiguredDas.keySet()) {
            String string;
            File file;
            DownloadArea downloadArea = initialConfiguredDas.get(comparable);
            if (downloadArea == null || !(file = new File(string = downloadArea.getLauncherPath())).exists()) continue;
            hashMap.put(comparable, downloadArea);
        }
        return hashMap;
    }

    public void finishCoreSetup() {
        if (db.on()) {
            db.print("starting core setup cleanup");
        }
        das.cleanupAllDownloadAreas();
    }
}

