/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.launcher.CmsClassLoader;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.DisposableURLClassLoader;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.version.AbstractInterfaceVersion;
import cerent.version.AbstractJarBuildInformation;
import cerent.version.ComparableFactory;
import cerent.version.IncompatibleException;
import cerent.version.InternalLayerVersion;
import cerent.version.Ngrp;
import cerent.version.VersionFormatEnum;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreReflectionUtil;
import com.cisco.ctc.core.CtcBootstrapJar;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.JreVersion;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.NgrpAndURL;
import com.cisco.ctc.core.VersionOrdinalComparator;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class CoreVersionUtil
implements ICoreVersionUtil {
    private static final ClassLoaderEnum[] CL_ENUMS = ClassLoaderEnum.values();
    private static final NETypeEnum[] NETYPE_ENUMS = NETypeEnum.values();
    private static final Class[] NE_PROXY_CTOR_ARGS = new Class[]{String.class, Comparable.class};
    private static final Class[] OLD_NE_PROXY_CTOR_ARGS = new Class[]{String.class};
    private static final Class[] OLD_OLD_NE_PROXY_CTOR_ARGS = null;
    private static final String SET_HOST_METHOD = "setHost";
    private static final Class[] SET_HOST_METHOD_ARG_TYPES = new Class[]{String.class};
    private static final String GET_VERSION_ACCESSOR = "getVersion";
    private static CoreVersionUtil instance = new CoreVersionUtil();
    private static final Preferences prefs = Preferences.instance();
    private static boolean coreCanBeLowerThanEle = prefs.getBoolean("ctc", "coreCanBeLowerThanEle", false);
    protected static final NgrpAndURL[] NgrpAndURLArrayTemplate = new NgrpAndURL[0];
    private static final KDebug db = new KDebug("CoreVersionUtil");

    public static ICoreVersionUtil instance() {
        return instance;
    }

    public boolean isUnifiedEle(Comparable comparable) {
        return comparable == null ? false : comparable.compareTo(InternalLayerVersion.OLDEST_UNIFIED_ELE_VERSION) >= 0;
    }

    public String getCTCBootstrapManifestFullVersion(ClassLoader classLoader) {
        String string;
        if (classLoader == null) {
            throw new IllegalArgumentException("cl must be non-null");
        }
        INgrp iNgrp = this.getCTCBootstrapNgrp(classLoader, null);
        if (iNgrp != null) {
            string = iNgrp.getFullVersionFormat();
        } else {
            db.println("CTC manifest not found for: " + classLoader);
            string = null;
        }
        return string;
    }

    public String getCTCBootstrapManifestFullVersion(ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) {
        Object object;
        INgrp iNgrp = null;
        if (classLoaderEnum != null) {
            if (db.on()) {
                db.println("looked-up CL enum: " + (Object)((Object)classLoaderEnum) + " based on CL: " + classLoader);
            }
            object = new AbstractJarBuildInformation(classLoaderEnum.manifestPrefix, classLoader, true, classLoaderEnum){};
            iNgrp = ((AbstractJarBuildInformation)object).getNgrp();
        }
        if (iNgrp != null) {
            object = iNgrp.getFullVersionFormat();
        } else {
            db.println("CTC manifest not found for: " + classLoader);
            object = null;
        }
        return object;
    }

    public INgrp getCTCBootstrapNgrp(ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) {
        ClassLoaderEnum classLoaderEnum2;
        Ngrp ngrp = null;
        if (!(classLoader instanceof URLClassLoader)) {
            return ngrp;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        if (db.isFinestEnabled()) {
            db.finest("entering getCTCBootstrapNgrp(" + classLoader + ")");
        }
        if ((classLoaderEnum2 = classLoaderEnum) == null && classLoader instanceof CmsClassLoader) {
            classLoaderEnum2 = ((CmsClassLoader)classLoader).getClassLoaderKey().getClassLoaderEnum();
        }
        if (classLoaderEnum2 != null) {
            AbstractJarBuildInformation abstractJarBuildInformation = new AbstractJarBuildInformation(classLoaderEnum2.manifestPrefix, classLoader, true, classLoaderEnum){};
            Ngrp ngrp2 = abstractJarBuildInformation.getNgrp();
            return ngrp2;
        }
        for (URL uRL : uRLClassLoader.getURLs()) {
            AbstractJarBuildInformation abstractJarBuildInformation;
            Ngrp ngrp3;
            String string;
            if (db.isFinestEnabled()) {
                db.finest("considering CP url: " + uRL);
            }
            if (uRL == null || (classLoaderEnum2 = CoreVersionUtil.getClassLoaderEnum(string = uRL.getFile())) == null) continue;
            if (db.on()) {
                db.println("looked-up CL enum: " + (Object)((Object)classLoaderEnum2) + " based on URL: " + uRL);
            }
            if ((ngrp3 = (abstractJarBuildInformation = new AbstractJarBuildInformation(classLoaderEnum2.manifestPrefix, classLoader, true, classLoaderEnum){}).getNgrp()) == null) continue;
            ngrp = ngrp3;
            break;
        }
        return ngrp;
    }

    private static ClassLoaderEnum getClassLoaderEnum(String string) {
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        ClassLoaderEnum classLoaderEnum = ClassLoaderEnum.getClassLoaderEnum(string);
        return classLoaderEnum;
    }

    Class loadInterfaceVersionClass(ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) throws ClassNotFoundException {
        Class clazz = CoreReflectionUtil.loadCLClass("cerent.version", classLoader, classLoaderEnum, "InterfaceVersion");
        return clazz;
    }

    Class loadNeInterfaceVersionClass(ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass("cerent.version.NeProxyInterfaceVersion");
        return clazz;
    }

    Object getInterfaceVersion(ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (classLoader == null) {
            return null;
        }
        Class clazz = this.loadInterfaceVersionClass(classLoader, classLoaderEnum);
        Object t = clazz.newInstance();
        return t;
    }

    public boolean isCompatible(ClassLoader classLoader, ClassLoader classLoader2, ClassLoaderEnum classLoaderEnum) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ClassLoaderEnum classLoaderEnum2 = classLoaderEnum.parent;
        Object object = null;
        Object object2 = null;
        try {
            object = this.getInterfaceVersion(classLoader, classLoaderEnum2);
            try {
                object2 = this.getInterfaceVersion(classLoader2, classLoaderEnum);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (classLoaderEnum.equals((Object)ClassLoaderEnum.ELE)) {
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            db.println("parent CL: " + classLoader + "; child CL: " + classLoader2);
            KDebug.printStackTrace(classNotFoundException);
            throw classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            db.println("parent CL: " + classLoader + "; child CL: " + classLoader2);
            KDebug.printStackTrace(instantiationException);
            throw instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            db.println("parent CL: " + classLoader + "; child CL: " + classLoader2);
            KDebug.printStackTrace(illegalAccessException);
            throw illegalAccessException;
        }
        boolean bl = object != null ? CoreVersionUtil.isCompatibleWith(object, object2) : true;
        return bl;
    }

    private boolean isCompatibleWith(INgrp iNgrp, String string) {
        if (iNgrp == null || string == null) {
            return false;
        }
        String string2 = iNgrp.getFullVersionFormat();
        String string3 = null;
        try {
            string3 = CtcHttpRetriever.getSwVersion(string);
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
            return false;
        }
        Comparable comparable = this.createManifestFullVersionOrdinal(string2);
        Comparable comparable2 = this.createNeVersionOrdinal(string3);
        return comparable.compareTo(comparable2) == 0;
    }

    static boolean isCompatibleWith(Object object, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        boolean bl;
        if (object instanceof AbstractInterfaceVersion && object2 instanceof AbstractInterfaceVersion) {
            AbstractInterfaceVersion abstractInterfaceVersion = (AbstractInterfaceVersion)object;
            AbstractInterfaceVersion abstractInterfaceVersion2 = (AbstractInterfaceVersion)object2;
            bl = abstractInterfaceVersion.isCompatibleWith(abstractInterfaceVersion2);
        } else {
            bl = CoreReflectionUtil.isCompatibleWith(AbstractInterfaceVersion.class, object, object2);
        }
        if (db.isFinestEnabled()) {
            db.finest("isCompatibleWith(" + object + ", " + object2 + ") returned " + bl);
        }
        return bl;
    }

    private static Object getNeIv(Class clazz, String string, Comparable comparable) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (clazz == null) {
            return null;
        }
        Object var3_3 = null;
        try {
            Constructor constructor = clazz.getConstructor(NE_PROXY_CTOR_ARGS);
            var3_3 = constructor.newInstance(string, comparable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Constructor constructor = clazz.getConstructor(OLD_NE_PROXY_CTOR_ARGS);
                var3_3 = constructor.newInstance(string);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                Constructor constructor = clazz.getConstructor(OLD_OLD_NE_PROXY_CTOR_ARGS);
                var3_3 = constructor.newInstance(new Object[0]);
                Method method = clazz.getMethod(SET_HOST_METHOD, SET_HOST_METHOD_ARG_TYPES);
                method.invoke(var3_3, string);
            }
        }
        return var3_3;
    }

    public ClassLoader[] getBestELEClassLoader(Comparable comparable, NETypeEnum nETypeEnum, String string, ClassLoader[] classLoaderArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int n;
        int n2 = n = classLoaderArray == null ? 0 : classLoaderArray.length;
        if (n == 0) {
            return CoreConstants.ClassLoaderArrayTemplate;
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(n);
        boolean bl = nETypeEnum == null || nETypeEnum == NETypeEnum.NE_DONT_CARE;
        for (ClassLoader classLoader : classLoaderArray) {
            if (db.isFinestEnabled()) {
                db.finest("considering compat of candidate: " + classLoader);
            }
            if (!bl && classLoader instanceof CmsClassLoader && NETypeEnum.compare(((CmsClassLoader)classLoader).getClassLoaderKey().getNeType(), nETypeEnum) != 0) {
                if (!db.isFinestEnabled()) continue;
                db.finest("incompat CL " + classLoader + " vs. " + (Object)((Object)nETypeEnum) + " for " + string);
                continue;
            }
            Object object = null;
            try {
                object = this.getInterfaceVersion(classLoader, ClassLoaderEnum.ELE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Class clazz = null;
            try {
                clazz = this.loadNeInterfaceVersionClass(classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Object object2 = CoreVersionUtil.getNeIv(clazz, string, comparable);
            boolean bl2 = object == null && object2 == null;
            INgrp iNgrp = this.getNgrp((URLClassLoader)classLoader, null);
            if (iNgrp == null || (!bl2 || !this.isCompatibleWith(iNgrp, string)) && (bl2 || !CoreVersionUtil.isCompatibleWith(object, object2))) continue;
            arrayList.add(classLoader);
        }
        ClassLoader[] classLoaderArray2 = arrayList.toArray(CoreConstants.ClassLoaderArrayTemplate);
        Arrays.sort(classLoaderArray2, ReverseComparator.instance());
        return classLoaderArray2;
    }

    public ClassLoader[] getBestELEClassLoader(Comparable comparable, String string, ClassLoader[] classLoaderArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.getBestELEClassLoader(comparable, NETypeEnum.NE_DONT_CARE, string, classLoaderArray);
    }

    public INgrp getNgrp(URL uRL) {
        return this.getNgrp(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public INgrp getNgrp(URL uRL, ClassLoaderEnum classLoaderEnum) {
        Ngrp ngrp = null;
        DisposableURLClassLoader disposableURLClassLoader = null;
        try {
            disposableURLClassLoader = new DisposableURLClassLoader(new URL[]{uRL}, null);
            AbstractJarBuildInformation abstractJarBuildInformation = new AbstractJarBuildInformation(null, disposableURLClassLoader, true, classLoaderEnum){};
            ngrp = abstractJarBuildInformation.getNgrp();
            Object var7_6 = null;
            if (disposableURLClassLoader == null) return ngrp;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (disposableURLClassLoader == null) throw throwable;
            try {
                disposableURLClassLoader.dispose();
                throw throwable;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                KDebug.printStackTrace(noSuchFieldException);
                throw throwable;
            }
            catch (IllegalAccessException illegalAccessException) {
                KDebug.printStackTrace(illegalAccessException);
            }
            throw throwable;
        }
        try {
            disposableURLClassLoader.dispose();
            return ngrp;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            KDebug.printStackTrace(noSuchFieldException);
            return ngrp;
        }
        catch (IllegalAccessException illegalAccessException) {
            KDebug.printStackTrace(illegalAccessException);
        }
        return ngrp;
    }

    public INgrp getNgrp(URLClassLoader uRLClassLoader, ClassLoaderEnum classLoaderEnum) {
        Ngrp ngrp = null;
        AbstractJarBuildInformation abstractJarBuildInformation = new AbstractJarBuildInformation(null, uRLClassLoader, true, classLoaderEnum){};
        ngrp = abstractJarBuildInformation.getNgrp();
        return ngrp;
    }

    public Comparable createCLURLVersionOrdinal(String string) {
        Comparable comparable = ComparableFactory.createComparable(string, VersionFormatEnum.ELE_MULTI_CLASSPATH_PROPERTY, string);
        return comparable;
    }

    protected static final URL[] toURLs(NgrpAndURL[] ngrpAndURLArray) {
        int n = ngrpAndURLArray == null ? 0 : ngrpAndURLArray.length;
        URL[] uRLArray = new URL[n];
        for (int i = 0; i < n; ++i) {
            uRLArray[i] = ngrpAndURLArray[i].url;
        }
        return uRLArray;
    }

    public NgrpAndURL[] getBestELEJars(ClassLoader classLoader, Comparable comparable, Comparable comparable2, NETypeEnum nETypeEnum, String string, URL[] uRLArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int n;
        int n2 = n = uRLArray == null ? 0 : uRLArray.length;
        if (n == 0) {
            return NgrpAndURLArrayTemplate;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        boolean bl = nETypeEnum == null || nETypeEnum == NETypeEnum.NE_DONT_CARE;
        INgrp iNgrp = ClassLoaderManager.instance().getSystemNgrp();
        Comparable comparable3 = iNgrp.getManifestVersionOrdinal();
        VersionOrdinalComparator versionOrdinalComparator = new VersionOrdinalComparator();
        for (URL uRL : uRLArray) {
            Object object;
            NETypeEnum nETypeEnum2;
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, classLoader);
            Object object2 = null;
            try {
                object2 = this.getInterfaceVersion(uRLClassLoader, ClassLoaderEnum.ELE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Class clazz = null;
            try {
                clazz = this.loadNeInterfaceVersionClass(uRLClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Object object3 = CoreVersionUtil.getNeIv(clazz, string, comparable);
            boolean bl2 = object2 == null && object3 == null;
            INgrp iNgrp2 = this.getNgrp(uRL, null);
            if (iNgrp2 == null) continue;
            Object object4 = null;
            if (!bl2 && object2 instanceof AbstractInterfaceVersion) {
                object4 = ((AbstractInterfaceVersion)object2).getVersion();
            }
            if (db.isFinestEnabled()) {
                db.finest("considering compat of jar candidate: " + uRL);
            }
            if (!bl && NETypeEnum.compare(nETypeEnum2 = NETypeEnum.getNeTypeFromManifest((String)(object = iNgrp2.getImplementationTitle())), nETypeEnum) != 0) {
                if (!db.isFinestEnabled()) continue;
                db.finest("incompat JAR '" + (String)object + "' vs. " + (Object)((Object)nETypeEnum) + " for " + string);
                continue;
            }
            if (bl2 && this.isCompatibleWith(iNgrp2, string) || !bl2 && (coreCanBeLowerThanEle || comparable3 != null && versionOrdinalComparator.compare(comparable3, object4) >= 0) && CoreVersionUtil.isCompatibleWith(object2, object3)) {
                object = new NgrpAndURL(iNgrp2, uRL);
                arrayList.add(object);
                continue;
            }
            if (!db.isFinestEnabled()) continue;
            db.finest("jar candidate: " + uRL + " not added to result set => HostName " + string + " coreCanBeLowerThanEle = " + coreCanBeLowerThanEle);
        }
        Object[] objectArray = arrayList.toArray(NgrpAndURLArrayTemplate);
        Arrays.sort(objectArray, ReverseComparator.instance());
        return objectArray;
    }

    public NgrpAndURL[] getBestELEJars(ClassLoader classLoader, Comparable comparable, Comparable comparable2, String string, URL[] uRLArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.getBestELEJars(classLoader, comparable, comparable2, NETypeEnum.NE_DONT_CARE, string, uRLArray);
    }

    public String toString(Comparable comparable) {
        String string = null;
        if (comparable != null) {
            if (!(comparable instanceof InternalLayerVersion)) {
                try {
                    Class<?> clazz = comparable.getClass();
                    Method method = clazz.getMethod("getLayerVersionString", null);
                    string = (String)method.invoke((Object)comparable, new Object[0]);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("unsupported type: " + comparable.getClass().getName());
                }
            } else {
                InternalLayerVersion internalLayerVersion = (InternalLayerVersion)comparable;
                string = internalLayerVersion.getLayerVersionString();
            }
        }
        return string;
    }

    public String prettyDottedString(Comparable comparable) {
        int n;
        if (comparable == null) {
            return "null";
        }
        String string = this.toString(comparable);
        if (string != null && (n = Integer.parseInt(string)) > 10000) {
            float f = n;
            string = Float.toString(f /= 10000.0f).trim();
            if (string.endsWith(".")) {
                string = string + "0";
            }
        }
        return string;
    }

    public String prettyDottedMajorMinorMaintString(Comparable comparable) {
        if (comparable == null) {
            return "null";
        }
        String string = this.prettyDottedString(comparable);
        int n = string.indexOf(".");
        if (n + 2 < string.length()) {
            string = string.substring(0, n += 2) + "." + string.substring(n);
        }
        return string;
    }

    public Comparable createVersionOrdinal(ClassLoaderEnum classLoaderEnum, Comparable comparable) {
        String string = classLoaderEnum.voName;
        Comparable comparable2 = comparable instanceof String ? this.createVersionOrdinal(string, (String)((Object)comparable)) : ComparableFactory.createComparable(string, comparable);
        return comparable2;
    }

    public CtcBootstrapJar parseBootstrapJarName(String string) {
        int n;
        if (db.isFinestEnabled()) {
            db.println("Parsing CtcBootstrapJar file name:" + string);
        }
        if ((n = string.indexOf(46)) >= 0) {
            string = string.substring(0, n);
        }
        ClassLoaderEnum classLoaderEnum = null;
        Comparable comparable = null;
        NETypeEnum enum_ = NETypeEnum.NE_DONT_CARE;
        for (ClassLoaderEnum classLoaderEnum2 : CL_ENUMS) {
            if (!string.startsWith(classLoaderEnum2.jarPrefix)) continue;
            classLoaderEnum = classLoaderEnum2;
            string = string.substring(classLoaderEnum2.jarPrefix.length());
            break;
        }
        if (classLoaderEnum == null) {
            return null;
        }
        if (string.length() > 0) {
            if (string.charAt(0) != '_') {
                if (classLoaderEnum.isCore) {
                    db.finest("Core bjar cannot have a ne-type-name field");
                    return null;
                }
                for (NETypeEnum nETypeEnum : NETYPE_ENUMS) {
                    if (!string.startsWith(nETypeEnum.fifteenType)) continue;
                    enum_ = nETypeEnum;
                    string = string.substring(nETypeEnum.fifteenType.length());
                    break;
                }
                if (enum_ == null) {
                    if (db.isFinestEnabled()) {
                        db.println("Ne Type name mismatch:" + string);
                    }
                    return null;
                }
            }
            if (string.length() > 0) {
                if (string.charAt(0) != '_') {
                    if (db.isFinestEnabled()) {
                        db.println("Underscore missing:" + string);
                    }
                    return null;
                }
                if ((string = string.substring(1)).length() < 4) {
                    if (db.isFinestEnabled()) {
                        db.println("Version length too short:" + string);
                    }
                    return null;
                }
                try {
                    comparable = ComparableFactory.createComparable(classLoaderEnum.voName, VersionFormatEnum.INTERNAL, string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (db.isFinestEnabled()) {
                        db.println("Version field format error:" + string);
                    }
                    return null;
                }
            }
        }
        CtcBootstrapJar ctcBootstrapJar = new CtcBootstrapJar(classLoaderEnum, enum_, comparable);
        if (db.isFinestEnabled()) {
            db.println("Result=" + ctcBootstrapJar);
        }
        return ctcBootstrapJar;
    }

    public void throwIncompatibleException(String string) throws ClassLoaderException {
        throw new ClassLoaderException(new IncompatibleException(string));
    }

    public void checkParentClassLoaderAgainstNe(ClassLoader classLoader, Comparable comparable, boolean bl) throws ClassLoaderException {
        int n;
        String string = this.getCTCBootstrapManifestFullVersion(classLoader);
        Comparable comparable2 = this.createManifestFullVersionOrdinal(string);
        int n2 = n = comparable == null ? 0 : comparable2.compareTo(comparable);
        if (!(n == 0 || bl && n >= 0)) {
            throw new ClassLoaderException("parent CL " + classLoader + " manifest: " + string + " does not compare to NE vo: " + comparable);
        }
    }

    public JreReqs getJreReqs(URL uRL) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class clazz = CoreReflectionUtil.loadClass(uRL, JreReqs.class.getName());
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?> clazz2 = classLoader.loadClass(JreVersion.class.getName());
        Method method = clazz2.getMethod(GET_VERSION_ACCESSOR, new Class[0]);
        Field field = clazz.getField("CURRENT");
        Object object = field.get(null);
        field = clazz.getField("MINIMUM_VERSION");
        Object object2 = field.get(object);
        String string = (String)method.invoke(object2, new Object[0]);
        field = clazz.getField("RECOMMENDED_VERSION");
        object2 = field.get(object);
        String string2 = (String)method.invoke(object2, new Object[0]);
        field = clazz.getField("MAXIMUM_VERSION");
        object2 = field.get(object);
        String string3 = (String)method.invoke(object2, new Object[0]);
        JreReqs jreReqs = new JreReqs(new JreVersion(string), new JreVersion(string3), new JreVersion(string2));
        if (classLoader instanceof DisposableURLClassLoader) {
            DisposableURLClassLoader disposableURLClassLoader = (DisposableURLClassLoader)classLoader;
            disposableURLClassLoader.dispose();
        }
        return jreReqs;
    }

    public Comparable createNeVersionOrdinal(String string) {
        return ComparableFactory.createNeComparable(string);
    }

    protected Comparable createVersionOrdinal(String string, String string2) throws NumberFormatException {
        return ComparableFactory.createComparable(string, VersionFormatEnum.INTERNAL, string2);
    }

    public Comparable createManifestFullVersionOrdinal(String string) {
        Comparable comparable = ComparableFactory.createManifestComparable(string);
        return comparable;
    }

    public String getBuildInfo(ClassLoader classLoader) {
        INgrp iNgrp = this.getCTCBootstrapNgrp(classLoader, null);
        StringBuilder stringBuilder = new StringBuilder(iNgrp.getFullVersionFormat());
        stringBuilder.append(" - ");
        stringBuilder.append(iNgrp.getRebuildDate());
        return stringBuilder.toString();
    }

    public boolean isUnifiedCore(Comparable comparable) {
        return InternalLayerVersion.CONQUEROR_OBJ.compareTo(comparable) <= 0;
    }

    public INgrp getSystemNgrp(String string) {
        return AbstractJarBuildInformation.getSystemNgrp(string);
    }

    public String getOriginalVersionStr(Comparable comparable) {
        String string = null;
        if (comparable instanceof InternalLayerVersion) {
            string = ((InternalLayerVersion)comparable).getOriginalVersionStr();
        }
        return string;
    }

    public boolean isUnavailable(Comparable comparable) {
        boolean bl = comparable != null && comparable instanceof InternalLayerVersion && ((InternalLayerVersion)comparable).isUnavailable();
        return bl;
    }

    private static class ReverseComparator
    implements Comparator {
        private static ReverseComparator instance = new ReverseComparator();

        private ReverseComparator() {
        }

        public static Comparator instance() {
            return instance;
        }

        public int compare(Object object, Object object2) {
            return -((Comparable)object).compareTo(object2);
        }
    }
}

