/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.launcher.CtcHttpRetriever;
import cerent.util.IIPAddressTranslator;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.Preferences;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClientFutureProofer;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.DownloadAreaConstants;
import com.cisco.ctc.core.DownloadAreas;
import com.cisco.ctc.core.DownloadItem;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.IDownloadItem;
import com.cisco.ctc.core.IFutureProofer;
import com.cisco.ctc.core.IJreReqs;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.download.DownloadManager;
import com.cisco.ctc.core.download.IDownloadManager;
import com.cisco.ctc.core.download.ITransferer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadArea
implements Comparable {
    private static final String LAUNCHER_JAR = ClassLoaderEnum.SYSTEM.jarPrefix + ".jar";
    protected static final DownloadItem LAUNCHER_ITEM = DownloadArea.getDummyDownloadItem(new File("./" + LAUNCHER_JAR), LAUNCHER_JAR);
    private static final String CTC_PREF = "ctc";
    private static final String CTC_DOWNLOAD_AREA_PREF_LIST = "downloadareas";
    private static final String DA_PREF_SEP = "-";
    private static final String PREF_TRIPLET_ITEM_SEP = ";";
    private static final String[] StringArrayTemplate = new String[0];
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static final IDownloadManager dm = DownloadManager.instance();
    private static final IIPAddressTranslator trans = IPAddressTranslator.instance();
    private static final int DEFAULT_NODE_ID = 0;
    private Preferences prefs;
    private String downloadVirtualAddr;
    private String downloadActualAddr;
    private int downloadNodeId = 0;
    private String downloadKey;
    private final File downloadDir;
    private final String downloadDirPath;
    private final String neSwVersion;
    private final DownloadItem launcherItem;
    private String prefName;
    private String downloadListUri;
    private String launcherUri;
    private String launcherPath;
    private IFutureProofer fp;
    private IDownloadItem[] downloadItems;
    private Map<String, IDownloadItem> simpleNameLookup;
    private static final long POSITIVE_INF = 0x80000000L;
    private static final KDebug db = new KDebug("DownloadArea");

    private static final DownloadItem getDummyDownloadItem(File file, String string) {
        try {
            return new DownloadItem(file, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static File realizeTempDir(String string, String string2) throws IOException {
        File file;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            string3 = System.getProperty("java.io.tmpdir");
        }
        if (string2 != null) {
            string3 = string3 + "/" + string2;
        }
        if ((file = new File(string3)).exists()) {
            if (!file.isDirectory()) {
                throw new IOException(string3 + " does not appear to be a directory.");
            }
        } else if (!file.mkdirs()) {
            throw new IOException("The temporary directory " + string3 + " could not be created.");
        }
        return file;
    }

    public DownloadArea(String string, String string2) throws IOException, CoreException {
        this.prefs = Preferences.instance();
        if (string2 == null) {
            throw new IllegalArgumentException("The NE software version cannot be null.");
        }
        this.neSwVersion = string2;
        this._setDownloadVirtualAddr(string);
        if (this.downloadKey != null) {
            this.simpleNameLookup = new HashMap<String, IDownloadItem>();
            String string3 = this.prefs.getProperty(CTC_PREF, "download.temp.dir", "");
            this.downloadDir = DownloadArea.realizeTempDir(string3, this.downloadKey);
        } else {
            this.prefName = DownloadArea.getDownloadAreaPreferenceName(string2);
            String string4 = this.getDirPreference();
            if (string4 == null) {
                throw new CoreException("The preference is not set or does not exist.");
            }
            this.simpleNameLookup = new HashMap<String, IDownloadItem>();
            this.downloadListUri = "getCtcFiles";
            this.downloadDir = DownloadArea.realizeTempDir(string4, null);
            File file = this.createFileFromUri(this.downloadListUri);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.setDownloadItems(DownloadItem.readDownloadItems(this.downloadDir, fileInputStream));
            }
        }
        this.downloadDirPath = this.downloadDir.getCanonicalPath();
        this.launcherUri = "fs/LAUNCHER.JAR";
        this.launcherItem = new DownloadItem(this.downloadDir, this.launcherUri);
        this.launcherPath = this.launcherItem.getFile().getCanonicalPath();
        if (db.on()) {
            db.println("Creating download area in dir: " + this.downloadDir);
        }
    }

    public DownloadArea(String string, String string2, String string3) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        this(Preferences.instance(), string, string2, string3);
    }

    public DownloadArea(Preferences preferences, String string, String string2, String string3) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        String string4;
        this.prefs = preferences;
        int n = string == null ? -1 : string.indexOf(DA_PREF_SEP);
        String string5 = string4 = n < 0 ? null : string.substring(n + 1);
        if (string4 == null) {
            throw new IllegalArgumentException("The NE software version may not be null.");
        }
        this.neSwVersion = string4;
        this.prefName = string;
        String string6 = preferences.getProperty(CTC_PREF, string, null);
        if (string6 == null) {
            throw new CoreException("The preference is not set or does not exist.");
        }
        this.downloadDir = new File(string6);
        this.simpleNameLookup = new HashMap<String, IDownloadItem>();
        this.downloadListUri = string2;
        this.downloadDirPath = this.downloadDir.getCanonicalPath();
        this.launcherUri = string3;
        this.launcherItem = new DownloadItem(this.downloadDir, string3);
        this.launcherPath = this.launcherItem.getFile().getCanonicalPath();
        this.initFutureProofer();
        File file = this.createFileFromUri(string2);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.setDownloadItems(this.fp.readCtcCoreFileList(this.downloadDir, fileInputStream));
        }
    }

    public DownloadArea(String string) throws IOException, CoreException {
        this(null, string);
    }

    public static String getDownloadAreaPreferenceName(String string) {
        return DownloadAreaConstants.getDownloadAreaPreferenceName(string);
    }

    public String getDownloadVirtualAddr() {
        return this.downloadVirtualAddr;
    }

    public void setDownloadVirtualAddr(String string) throws UnknownHostException {
        if (this.downloadVirtualAddr == null) {
            throw new IllegalArgumentException("The download hostname cannot be set because the original one was null.");
        }
        this._setDownloadVirtualAddr(string);
    }

    private void _setDownloadVirtualAddr(String string) throws UnknownHostException {
        if (string == null) {
            return;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        String string2 = inetAddress.getHostAddress();
        if (trans.isEnabled() && trans.isVirtual(inetAddress)) {
            this.downloadVirtualAddr = string2;
            this.downloadActualAddr = DownloadArea.toActual(string2);
            this.downloadNodeId = DownloadArea.toActualNodeId(string2);
        } else {
            String string3;
            this.downloadActualAddr = string3 = string2;
            this.downloadVirtualAddr = DownloadArea.toVirtual(string3, this.downloadNodeId);
        }
        this.downloadKey = DownloadArea.toDownloadKey(this.downloadActualAddr, this.downloadNodeId);
    }

    public Set<String> getDownloadAreaPreferenceName(Comparable comparable) {
        TreeSet<String> treeSet = new TreeSet<String>();
        List list = this.prefs.getMatchingPropertyKeys(CTC_PREF, "downloadarea");
        for (Object e : list) {
            String string = (String)e;
            int n = string.indexOf(DA_PREF_SEP);
            if (n < 0) continue;
            String string2 = string.substring(n + 1);
            Comparable comparable2 = cvu.createNeVersionOrdinal(string2);
            if (comparable != null && comparable.compareTo(comparable2) != 0) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public String getCoreVersion() {
        return this.neSwVersion;
    }

    public String getDirPreference() {
        return this.prefs.getProperty(CTC_PREF, this.prefName, null);
    }

    public String getLauncherPath() {
        return this.launcherPath;
    }

    public IFutureProofer getFutureProofer() {
        return this.fp;
    }

    public IDownloadItem[] getDownloadItems() {
        return this.downloadItems;
    }

    public IDownloadItem getDownloadItem(String string) {
        if (string == null) {
            return null;
        }
        return this.simpleNameLookup.get(string.toUpperCase(Locale.ENGLISH));
    }

    public void storeDirPreference() throws IOException, FileNotFoundException {
        this.prefs.setProperty(CTC_PREF, this.prefName, this.downloadDirPath);
        this.addPreferenceToList(this.prefName, this.downloadListUri, this.launcherUri);
        DownloadArea downloadArea = this;
        if (!downloadArea.prefs.isStoreEnabled()) {
            throw new IOException("By configuration, preferences storing has been disabled");
        }
        this.prefs.store();
    }

    public void removeDirPreference() throws IOException, FileNotFoundException {
        DownloadArea.removeDirPreferences(this.prefs, this.prefName, this.downloadListUri, this.launcherUri);
    }

    public static void removeDirPreferences(Preferences preferences, String string, String string2, String string3) throws IOException, FileNotFoundException {
        preferences.removeProperty(CTC_PREF, string);
        DownloadArea.removePreferenceFromList(preferences, string, string2, string3);
        if (!preferences.isStoreEnabled()) {
            throw new IOException("By configuration, preferences storing has been disabled");
        }
        preferences.store();
    }

    private static String getPrefItem(String string, String string2, String string3) {
        return string + PREF_TRIPLET_ITEM_SEP + string2 + PREF_TRIPLET_ITEM_SEP + string3;
    }

    private static int findPrefItem(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || string == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    private String[] addPreferenceToList(String string, String string2, String string3) {
        String string4 = DownloadArea.getPrefItem(string, string2, string3);
        String[] stringArray = this.prefs.getPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, StringArrayTemplate);
        int n = DownloadArea.findPrefItem(stringArray, string4);
        if (n < 0) {
            int n2 = stringArray == null ? 0 : stringArray.length;
            String[] stringArray2 = new String[n2 + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            stringArray = stringArray2;
            stringArray[n2] = string4;
            this.prefs.setPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, stringArray);
        }
        return stringArray;
    }

    private static String[] removePreferenceFromList(Preferences preferences, String string, String string2, String string3) {
        String string4 = DownloadArea.getPrefItem(string, string2, string3);
        String[] stringArray = preferences.getPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, StringArrayTemplate);
        int n = DownloadArea.findPrefItem(stringArray, string4);
        if (n >= 0) {
            int n2 = stringArray.length;
            if (n2 > 1) {
                String[] stringArray2 = new String[n2 - 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                System.arraycopy(stringArray, n + 1, stringArray2, n, n2 - (n + 1));
                stringArray = stringArray2;
                preferences.setPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, stringArray);
            } else {
                preferences.removeProperty(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST);
            }
        }
        return stringArray;
    }

    public static String[] getPrefItems(Preferences preferences) {
        if (preferences == null) {
            preferences = Preferences.instance();
        }
        String[] stringArray = preferences.getPropertyArray(CTC_PREF, CTC_DOWNLOAD_AREA_PREF_LIST, StringArrayTemplate);
        return stringArray;
    }

    public static String[] getPrefItems() {
        return DownloadArea.getPrefItems(null);
    }

    public static String getPrefNameFromPrefItem(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(PREF_TRIPLET_ITEM_SEP);
        return n < 0 ? null : string.substring(0, n);
    }

    public static String getDownloadListUriFromPrefItem(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(PREF_TRIPLET_ITEM_SEP);
        if (n2 < 0) {
            return null;
        }
        return (n = string.indexOf(PREF_TRIPLET_ITEM_SEP, ++n2)) < 0 ? null : string.substring(n2, n);
    }

    public static String getLauncherUriFromPrefItem(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.indexOf(PREF_TRIPLET_ITEM_SEP);
        if (n3 < 0) {
            return null;
        }
        if ((n2 = string.indexOf(PREF_TRIPLET_ITEM_SEP, (n = string.indexOf(PREF_TRIPLET_ITEM_SEP, ++n3)) + 1)) < 0) {
            n2 = string.length();
        }
        return n < 0 ? null : string.substring(n + 1, n2);
    }

    public boolean isAreaComplete() {
        boolean bl;
        boolean bl2 = bl = this.downloadItems != null;
        if (bl) {
            for (int i = 0; i < this.downloadItems.length && bl; ++i) {
                IDownloadItem iDownloadItem = this.downloadItems[i];
                if (iDownloadItem != null && iDownloadItem.getFile().exists()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void completeArea() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        this.completeArea(null);
    }

    public void completeArea(Callback callback) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        boolean bl;
        if (this.downloadVirtualAddr == null) {
            if (this.isAreaComplete()) {
                return;
            }
            throw new IOException("The download area is incomplete and the download host is null.");
        }
        boolean bl2 = db.isFinestEnabled();
        if (bl2) {
            db.finest("About to try downloading LAUNCHER.jar (if needed) from NE: " + this.downloadActualAddr);
        }
        if (callback != null && callback.notify(LAUNCHER_ITEM) > 0) {
            return;
        }
        this.downloadLauncher();
        if (bl2) {
            db.finest("About to try downloading the CTC core file list (if needed)");
        }
        this.downloadCoreFileList(true);
        boolean bl3 = bl = this.downloadItems != null;
        if (bl) {
            for (int i = 0; i < this.downloadItems.length; ++i) {
                IDownloadItem iDownloadItem = this.downloadItems[i];
                if (callback != null && callback.notify(iDownloadItem) > 0) {
                    return;
                }
                if (bl2) {
                    db.finest("About to try downloading the CTC core file item (if needed)" + iDownloadItem);
                }
                this.downloadItem(iDownloadItem);
            }
        }
        if (bl2) {
            db.finest("Done w/ completing area!");
        }
    }

    public void cleanArea() throws ClassNotFoundException, InstantiationException, InvocationTargetException, IOException, CoreException {
        File file;
        boolean bl;
        boolean bl2 = bl = this.downloadItems != null;
        if (db.on()) {
            db.println("request to cleanup DA: " + this);
        }
        if (!bl) {
            if (this.fp == null && this.downloadListUri == null) {
                File file2 = new File(this.launcherPath);
                if (file2.exists()) {
                    file2.delete();
                }
                this.downloadLauncher();
            }
            try {
                this.downloadCoreFileList(false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
            bl = this.downloadItems != null;
        }
        this.disposeFutureProofer();
        System.gc();
        if (bl) {
            int n = 0;
            for (int i = 0; i < this.downloadItems.length; ++i) {
                IDownloadItem iDownloadItem = this.downloadItems[i];
                if (iDownloadItem == null) continue;
                File file3 = iDownloadItem.getFile();
                if (file3.exists()) {
                    if (file3.delete()) {
                        this.downloadItems[i] = null;
                        ++n;
                    } else {
                        file3.deleteOnExit();
                    }
                } else {
                    this.downloadItems[i] = null;
                    ++n;
                }
                this.rmdirs(file3);
            }
            if (n == this.downloadItems.length) {
                this.downloadItems = null;
            }
        }
        if ((file = this.createFileFromUri(this.downloadListUri)).exists()) {
            file.delete();
        } else {
            File file4 = new File(this.launcherPath);
            if (file4.exists()) {
                file4.delete();
                this.rmdirs(file4);
            }
        }
        this.rmdirs(file);
    }

    private void rmdirs(File file) {
        File file2;
        if (file == null) {
            return;
        }
        File file3 = file2 = file.isDirectory() ? file : file.getParentFile();
        if (file2.delete()) {
            this.rmdirs(file2.getParentFile());
        }
    }

    private String determineDownloadListUri() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        return this.fp.getCtcCoreFileListUri();
    }

    public void initFutureProofer() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        if (this.fp == null) {
            this.fp = new ClientFutureProofer(this.launcherPath);
        }
    }

    public void disposeFutureProofer() {
        if (this.fp != null) {
            try {
                ((ClientFutureProofer)this.fp).dispose();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                KDebug.printStackTrace(noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                KDebug.printStackTrace(illegalAccessException);
            }
            catch (RuntimeException runtimeException) {
                KDebug.printStackTrace(runtimeException);
            }
            this.fp = null;
        }
    }

    private void downloadLauncher() throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, CoreException {
        this.downloadItem(this.launcherItem);
        if (this.fp == null) {
            this.initFutureProofer();
            String string = this.fp.isCoreSoftwareUpgradePossible((Comparable)((Object)this.neSwVersion));
            if (string != null) {
                throw new CoreException(string);
            }
            if (this.prefName == null) {
                this.prefName = this.fp.getDownloadAreaPreferenceName(this.neSwVersion);
            }
        }
    }

    private void downloadItem(IDownloadItem iDownloadItem) throws IOException {
        File file = iDownloadItem.getFile();
        if (file.exists()) {
            return;
        }
        Serializable serializable = file.getParentFile();
        if (serializable != null && !serializable.exists()) {
            serializable.mkdirs();
        }
        serializable = iDownloadItem.getDownloadURL(this.downloadVirtualAddr);
        this._downloadItem((URL)serializable, file);
    }

    private void _downloadItem(URL uRL, File file) throws IOException {
        try {
            ITransferer iTransferer = dm.downloadExplicitURL(uRL, file, null);
            if (iTransferer != null) {
                iTransferer.transfer();
                if (db.on()) {
                    db.println("Successfully downloaded CTC file url: " + uRL + " from " + uRL.getHost());
                }
            }
        }
        catch (IOException iOException) {
            if (db.on()) {
                KDebug.printStackTrace(iOException);
            }
            if (file.exists()) {
                System.gc();
                file.delete();
            }
            throw iOException;
        }
    }

    private File createFileFromUri(String string) throws IOException {
        File file;
        String string2;
        String string3;
        int n;
        if (string == null) {
            throw new IOException("uri cannot be null");
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.lastIndexOf("/")) >= 0) {
            string3 = string.substring(0, n);
            string3 = string3.replaceAll("/", File.separator);
            string2 = string.substring(n + 1);
        } else {
            string3 = null;
            string2 = string;
        }
        if (string3 != null) {
            File file2 = new File(this.downloadDir, string3);
            file2.mkdirs();
            file = new File(file2, string2);
        } else {
            file = new File(this.downloadDir, string2);
        }
        return file;
    }

    private void setDownloadItems(IDownloadItem[] iDownloadItemArray) {
        this.simpleNameLookup.clear();
        this.downloadItems = iDownloadItemArray;
        if (iDownloadItemArray != null) {
            for (int i = 0; i < this.downloadItems.length; ++i) {
                IDownloadItem iDownloadItem = this.downloadItems[i];
                String string = iDownloadItem.getSimpleName();
                this.simpleNameLookup.put(string, iDownloadItem);
            }
        }
    }

    private boolean createParentDirs(File file) {
        File file2 = file.getParentFile();
        boolean bl = true;
        if (file2 != null && !file2.exists()) {
            bl = file2.mkdirs();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadCoreFileList(boolean bl) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        File file;
        if (this.downloadListUri == null) {
            this.downloadListUri = this.determineDownloadListUri();
        }
        if ((file = this.createFileFromUri(this.downloadListUri)).exists()) {
            if (this.downloadItems != null) return;
            FileInputStream fileInputStream = new FileInputStream(file);
            this.setDownloadItems(this.fp.readCtcCoreFileList(this.downloadDir, fileInputStream));
            return;
        }
        this.createParentDirs(file);
        if (this.downloadVirtualAddr == null) {
            throw new IOException("The core download file list is missing and the download host is null.");
        }
        if (!bl) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            try {
                String string = this.downloadListUri;
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                URL uRL = new URL("http", this.downloadVirtualAddr, string);
                InputStream inputStream = CtcHttpRetriever.createTransferContentInputStream(uRL, null);
                this.setDownloadItems(this.fp.readCtcCoreFileList(this.downloadDir, inputStream));
                File file2 = new File(this.downloadDir, this.downloadListUri);
                this.createParentDirs(file2);
                fileOutputStream = new FileOutputStream(file2);
                this.fp.writeCtcCoreFileList(this.downloadItems, fileOutputStream);
            }
            catch (IOException iOException) {
                if (db.on()) {
                    KDebug.printStackTrace(iOException);
                }
                this.setDownloadItems(null);
                if (!file.exists()) throw iOException;
                System.gc();
                file.delete();
                throw iOException;
            }
            Object var9_10 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("download area: ");
        if (this.downloadVirtualAddr != null) {
            stringBuilder.append("host: " + this.downloadActualAddr);
            if (this.downloadNodeId != 0) {
                stringBuilder.append("; node id: " + DownloadArea.getNormalizedNodeId(this.downloadNodeId));
            }
            stringBuilder.append("; version: ");
        }
        if (this.prefName != null) {
            stringBuilder.append(this.prefName);
        }
        return stringBuilder.toString();
    }

    public int compareTo(Object object) {
        int n;
        int n2 = n = this == object ? 0 : -1;
        if (n != 0 && object instanceof DownloadArea) {
            DownloadArea downloadArea = (DownloadArea)object;
            n = this.neSwVersion.compareTo(downloadArea.neSwVersion);
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.neSwVersion.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFileOrDir(File file, File file2) throws IOException {
        IOException iOException222;
        FileOutputStream fileOutputStream;
        block13: {
            if (file.isDirectory()) {
                if (!file2.exists()) {
                    file2.mkdir();
                }
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string.equals(".") || string.equals("..")) continue;
                    this.copyFileOrDir(new File(file, string), new File(file2, string));
                }
                return;
            }
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[8192];
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                Object var8_10 = null;
                if (fileInputStream == null) break block13;
            }
            catch (Throwable throwable) {
                IOException iOException322;
                Object var8_11 = null;
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException322) {
                        // empty catch block
                    }
                }
                if (fileOutputStream == null) throw throwable;
                try {
                    ((OutputStream)fileOutputStream).close();
                    throw throwable;
                }
                catch (IOException iOException322) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException222) {
                // empty catch block
            }
        }
        if (fileOutputStream == null) return;
        try {
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (IOException iOException222) {}
    }

    private static String toActual(String string) {
        return trans.getActualAddressDisplay(string);
    }

    private static int toActualNodeId(String string) {
        return trans.getActualNodeId(string);
    }

    private static String toVirtual(String string, int n) throws UnknownHostException {
        if (!trans.isEnabled()) {
            return string;
        }
        String string2 = null;
        InetAddress inetAddress = trans.getVirtualAddress(string, n);
        if (inetAddress != null) {
            string2 = inetAddress.getHostAddress();
        }
        return string2;
    }

    private static String toVirtual(String string) throws UnknownHostException {
        return DownloadArea.toVirtual(string, 0);
    }

    private static long getNormalizedNodeId(int n) {
        long l = n;
        if (l < 0L) {
            l += 0x80000000L;
        }
        return l;
    }

    private static String toDownloadKey(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (n != 0) {
            long l = DownloadArea.getNormalizedNodeId(n);
            stringBuilder.append(DA_PREF_SEP);
            stringBuilder.append(Long.toString(l));
        }
        return stringBuilder.toString();
    }

    private static String frommDownloadKeyToActual(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(DA_PREF_SEP);
        String string2 = "";
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private static int getNodeId(String string) {
        int n = 0;
        if (string != null && string.length() > 0) {
            int n2 = 0;
            try {
                n2 = Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 == 0) {
                long l = Long.decode(string) & 0xFFFFFFFFFFFFFFFFL;
                n = (int)l;
            } else {
                n = n2;
            }
        }
        return n;
    }

    private static int frommDownloadKeyToNodeId(String string) {
        int n;
        if (string == null) {
            return 0;
        }
        int n2 = string.indexOf(DA_PREF_SEP);
        if (n2 >= 0) {
            String string2 = string.substring(n2 + 1);
            n = DownloadArea.getNodeId(string2);
        } else {
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            db.println("usage: java " + DownloadArea.class.getName() + " downloadhost");
            System.exit(1);
        }
        String string = stringArray[0];
        boolean bl = false;
        try {
            String string2;
            Object object;
            String[] stringArray2;
            DownloadArea downloadArea;
            String string3;
            block23: {
                if (trans.isEnabled()) {
                    db.println("DUP-IP is enabled!");
                }
                string3 = CtcHttpRetriever.getSwVersion(string);
                String string4 = CtcHttpRetriever.getNodeId(string);
                int n = DownloadArea.getNodeId(string4);
                InetAddress inetAddress = trans.getVirtualAddress(string, n);
                string = inetAddress.getHostAddress();
                downloadArea = new DownloadArea(string, string3);
                downloadArea.removeDirPreference();
                downloadArea.cleanArea();
                bl = downloadArea.isAreaComplete();
                System.out.println("old-core " + downloadArea + " is initially incomplete? " + !bl);
                try {
                    downloadArea.completeArea();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.out);
                }
                bl = downloadArea.isAreaComplete();
                System.out.println("old-core " + downloadArea + " complete? " + bl);
                if (bl) {
                    downloadArea.storeDirPreference();
                }
                downloadArea.removeDirPreference();
                downloadArea.cleanArea();
                bl = downloadArea.isAreaComplete();
                System.out.println("old-core " + downloadArea + " after cleaning is incomplete? " + !bl);
                try {
                    downloadArea.completeArea(new Callback(){

                        public int notify(IDownloadItem iDownloadItem) {
                            System.out.println("About to download (if needed) item: " + iDownloadItem);
                            return 0;
                        }
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.out);
                }
                bl = downloadArea.isAreaComplete();
                System.out.println("old-core " + downloadArea + " complete? " + bl);
                IFutureProofer iFutureProofer = downloadArea.getFutureProofer();
                IJreReqs iJreReqs = iFutureProofer.getJreReqs();
                String string5 = ((Object)iJreReqs).toString();
                System.out.println("downloaded core in " + downloadArea + " - jre reqs: " + string5);
                boolean bl2 = iJreReqs.meetsReqs(JreReqs.CURRENT.RECOMMENDED_VERSION);
                System.out.println("RECOMMENDED_VERSION meetsReqs?: " + bl2);
                String string6 = downloadArea.getLauncherPath();
                File file = new File(string6);
                JarFile jarFile = null;
                try {
                    try {
                        jarFile = new JarFile(file);
                        stringArray2 = jarFile.getManifest();
                        object = iFutureProofer.getNgrp((Manifest)stringArray2, string6);
                        System.out.println("ngrp for launcher in da is: " + object);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.out);
                        string2 = null;
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        break block23;
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace(System.out);
                        string2 = null;
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        break block23;
                    }
                    string2 = null;
                    if (jarFile == null) break block23;
                }
                catch (Throwable throwable) {
                    Object var18_23 = null;
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    throw throwable;
                }
                jarFile.close();
            }
            if (bl) {
                downloadArea.storeDirPreference();
            }
            stringArray2 = DownloadArea.getPrefItems();
            object = stringArray2[0];
            String string7 = DownloadArea.getPrefNameFromPrefItem((String)object);
            string2 = DownloadArea.getDownloadListUriFromPrefItem((String)object);
            String string8 = DownloadArea.getLauncherUriFromPrefItem((String)object);
            DownloadArea downloadArea2 = new DownloadArea(string7, string2, string8);
            System.out.println("present-core discovery download area " + downloadArea2);
            ClientFutureProofer clientFutureProofer = (ClientFutureProofer)downloadArea2.getFutureProofer();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("java");
            ArrayList arrayList2 = clientFutureProofer.ctcExecArgs(arrayList);
            System.out.println("CTC exec args to the assoc. launcher are:");
            if (arrayList2 != null) {
                for (Object object2 : arrayList2) {
                    System.out.print(object2 + " ");
                }
            }
            System.out.println("");
            try {
                Object object2;
                DownloadArea downloadArea3 = new DownloadArea(string3);
                bl = downloadArea3.isAreaComplete();
                System.out.println("present-core " + downloadArea3 + " complete? " + bl);
                object2 = DownloadAreas.instance();
                Map<Comparable, DownloadArea> map = ((DownloadAreas)object2).refreshConfiguredDownloadAreas();
                System.out.println("# configed DAs: " + map.size());
                Iterator<Comparable> iterator = map.keySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Comparable comparable = iterator.next();
                    System.out.println("  " + Integer.toString(n) + ": " + comparable + " - " + map.get(comparable));
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
            System.out.println("unit test done!");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        System.exit(0);
    }

    public static interface Callback {
        public int notify(IDownloadItem var1);
    }
}

