/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.DownloadState;
import cerent.launcher.HttpResponseException;
import cerent.util.KDebug;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.download.AbstractTransferer;
import com.cisco.ctc.core.download.DecompressingTransfererFactory;
import com.cisco.ctc.core.download.IDownloadManager;
import com.cisco.ctc.core.download.ITransferer;
import com.cisco.ctc.core.download.JarTransferEnum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class DownloadManager
implements IDownloadManager {
    private static final DecompressingTransfererFactory factory = DecompressingTransfererFactory.instance();
    private static final DownloadManager instance = new DownloadManager();
    private static KDebug db = new KDebug("DownloadManager");

    private DownloadManager() {
    }

    public static DownloadManager instance() {
        return instance;
    }

    public ITransferer downloadCTCJar(String string, ClassLoaderEnum classLoaderEnum, File file, DownloadState downloadState) throws IOException {
        return this.downloadCTCJar(string, NETypeEnum.NE_DONT_CARE, classLoaderEnum, file, downloadState);
    }

    public ITransferer downloadCTCJar(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, File file, DownloadState downloadState) throws IOException {
        JarTransferEnum.Type[] typeArray = classLoaderEnum.preferredDownloadTypes;
        String string2 = DownloadManager.createSimpleName(nETypeEnum, classLoaderEnum);
        String string3 = DownloadManager.createSimpleName(NETypeEnum.NE_DONT_CARE, classLoaderEnum);
        return this.downloadExplicitJar(string, string3, string2, file, downloadState, nETypeEnum, typeArray);
    }

    private static String createSimpleName(NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum) {
        StringBuilder stringBuilder = new StringBuilder(classLoaderEnum.jarPrefix);
        if (nETypeEnum != NETypeEnum.NE_DONT_CARE) {
            stringBuilder.append(nETypeEnum.fifteenType);
        }
        return stringBuilder.toString();
    }

    private static URL createURL(String string, String string2, JarTransferEnum.Type type) throws MalformedURLException {
        URL uRL = CtcHttpRetriever.makeUrl(string, "/fs/" + string2 + "." + type.uriSuffix);
        if (db.on()) {
            URL uRL2 = CtcHttpRetriever.makeUrl(CoreConstants.GetActualAddress(string), "/fs/" + string2 + "." + type.uriSuffix);
            db.println("downloading from: " + uRL2);
        }
        return uRL;
    }

    public ITransferer downloadExplicitJar(String string, String string2, File file, DownloadState downloadState) throws IOException {
        return this.downloadExplicitJar(string, string2, string2, file, downloadState, NETypeEnum.NE_DONT_CARE, JarTransferEnum.getCoreCompressionPreferredTypes());
    }

    private ITransferer downloadExplicitJar(String string, String string2, String string3, File file, DownloadState downloadState, NETypeEnum nETypeEnum, JarTransferEnum.Type[] typeArray) throws IOException {
        ITransferer iTransferer = null;
        if (db.on()) {
            db.println("attempting download of " + string2 + "(" + string3 + ") to: " + file.getAbsolutePath() + " for ne type: " + (Object)((Object)nETypeEnum));
        }
        JarTransferEnum.Type[] typeArray2 = typeArray != null ? typeArray : JarTransferEnum.getPreferredTypes();
        for (int i = 0; i < typeArray2.length && iTransferer == null; ++i) {
            JarTransferEnum.Type type = typeArray2[i];
            iTransferer = this.downloadExplicitJarPerFormat(string, string2, string3, file, downloadState, nETypeEnum, type);
            if (iTransferer == null || !db.on()) continue;
            db.println("successful download to: " + file.getAbsolutePath());
        }
        return iTransferer;
    }

    public ITransferer downloadExplicitJarPerFormat(String string, String string2, String string3, File file, DownloadState downloadState, NETypeEnum nETypeEnum, JarTransferEnum.Type type) throws IOException {
        ITransferer iTransferer = null;
        String string4 = null;
        if (type.neTypePartOfJarName) {
            if (nETypeEnum == NETypeEnum.NE_DONT_CARE) {
                return iTransferer;
            }
            string4 = string3;
        } else {
            string4 = string2;
        }
        if (db.on()) {
            db.println("trying jar xfer type: " + (Object)((Object)type) + " w/ simple name: " + string4);
        }
        return this.downloadExplicitJarPerFormat(string, string4, file, downloadState, type);
    }

    public ITransferer downloadExplicitJarPerFormat(String string, String string2, File file, DownloadState downloadState, JarTransferEnum.Type type) throws IOException {
        ITransferer iTransferer = null;
        try {
            URL uRL = DownloadManager.createURL(string, string2, type);
            iTransferer = this.downloadExplicitURL(uRL, file, downloadState, type);
        }
        catch (MalformedURLException malformedURLException) {
            if (db.isFinestEnabled()) {
                db.println("got bad URL error: " + malformedURLException);
                KDebug.printStackTrace(malformedURLException);
            }
            throw malformedURLException;
        }
        return iTransferer;
    }

    public ITransferer downloadExplicitURL(URL uRL, File file, DownloadState downloadState, JarTransferEnum.Type type) throws IOException {
        ITransferer iTransferer = null;
        try {
            InputStream inputStream = CtcHttpRetriever.createTransferContentInputStream(uRL, downloadState);
            iTransferer = this.createTransferer(inputStream, file, downloadState, type);
            if (db.on()) {
                db.println("created decompressor " + (iTransferer == null ? "failed for URL: " + uRL : ": " + iTransferer.toString()) + " for xfertype: " + (Object)((Object)type));
            }
        }
        catch (HttpResponseException httpResponseException) {
            if (db.isFinerEnabled()) {
                db.println("got HTTP error: " + httpResponseException);
            }
        }
        catch (IOException iOException) {
            if (db.isFinestEnabled()) {
                db.println("got IO error: " + iOException);
                KDebug.printStackTrace(iOException);
            }
            throw iOException;
        }
        return iTransferer;
    }

    public final ITransferer createTransferer(InputStream inputStream, File file, DownloadState downloadState, JarTransferEnum.Type type) throws IOException {
        AbstractTransferer abstractTransferer = factory.createDecompressor(type, inputStream, file);
        if (downloadState != null && abstractTransferer != null) {
            float f = (float)downloadState.getMaximum() * abstractTransferer.getEstimatedCompressionRatio();
            downloadState.setMaximum((long)f);
            abstractTransferer.addObserver(downloadState);
        }
        return abstractTransferer;
    }

    public ITransferer downloadExplicitURL(URL uRL, File file, DownloadState downloadState) throws IOException {
        return this.downloadExplicitURL(uRL, file, downloadState, JarTransferEnum.Type.NONE);
    }
}

