/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.DownloadArea;
import com.cisco.ctc.core.DownloadAreas;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.VersionOrdinalComparator;
import com.cisco.ctc.core.cache.CacheManager;
import com.cisco.ctc.core.cache.CtcCachedFile;
import com.cisco.ctc.core.launcher.DefaultCtcReqs;
import java.util.Map;
import java.util.TreeSet;

public class JarSetManager {
    private TreeSet<Comparable> jarSets = new TreeSet(new VersionOrdinalComparator());
    private Map<Comparable, DownloadArea> daMap;

    protected JarSetManager() {
        this.init();
    }

    void init() {
        CtcCachedFile[] ctcCachedFileArray;
        CacheManager cacheManager = CacheManager.instance();
        ICoreVersionUtil iCoreVersionUtil = CoreVersionUtil.instance();
        for (CtcCachedFile ctcCachedFile : ctcCachedFileArray = cacheManager.retrieve(NETypeEnum.NE_DONT_CARE, ClassLoaderEnum.SYSTEM)) {
            Comparable comparable = ctcCachedFile.bootstrapJar.getVersion();
            if (iCoreVersionUtil.isUnifiedCore(comparable)) {
                this.jarSets.add(comparable);
                continue;
            }
            if (!DefaultCtcReqs.isComplete(comparable)) continue;
            this.jarSets.add(comparable);
        }
        if (DownloadAreas.instance().getInitialConfiguredDas() == null) {
            DownloadAreas.instance().refreshConfiguredDownloadAreas();
        }
        this.daMap = DownloadAreas.instance().getInitialConfiguredDas();
        this.jarSets.addAll(this.daMap.keySet());
    }

    public Comparable[] getJarSets() {
        return this.jarSets.toArray(new Comparable[this.jarSets.size()]);
    }

    public void dispose() {
        this.jarSets.clear();
        DownloadAreas.instance().clearConfiguredDownloadAreas();
    }

    public Comparable getLatestJarSet() {
        if (this.jarSets.isEmpty()) {
            return null;
        }
        return this.jarSets.last();
    }

    public String getLauncherPath(Comparable comparable) {
        String string = null;
        CtcCachedFile ctcCachedFile = CacheManager.instance().retrieve(NETypeEnum.NE_DONT_CARE, ClassLoaderEnum.SYSTEM, comparable);
        if (ctcCachedFile == null) {
            DownloadArea downloadArea = this.daMap.get(comparable);
            if (downloadArea != null) {
                string = downloadArea.getLauncherPath();
            }
        } else {
            string = ctcCachedFile.getPath();
        }
        return string;
    }
}

