/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import cerent.util.KDebug;
import com.cisco.ctc.core.CoreReflectionUtil;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.IJreReqs;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.JreVersion;
import com.cisco.ctc.core.launcher.JreChooser;
import com.cisco.ctc.core.launcher.JreProperties;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JreManager {
    private static JreProperties jp = JreProperties.instance();
    private static JreManager instance = new JreManager();
    protected static final KDebug dbg = new KDebug("JreManager", true);

    private JreManager() {
    }

    public static JreManager instance() {
        return instance;
    }

    public ArrayList<String> getJreCommand(Frame frame, Comparable comparable, Object object) {
        ArrayList<String> arrayList;
        Object object2;
        IJreReqs iJreReqs = null;
        JreReqs jreReqs = null;
        if (object instanceof JreReqs) {
            jreReqs = (JreReqs)object;
        } else if (!(object instanceof IJreReqs)) {
            try {
                iJreReqs = CoreReflectionUtil.getJreReqs(object);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            iJreReqs = (IJreReqs)object;
        }
        if (jreReqs == null && iJreReqs != null) {
            jreReqs = new JreReqs(iJreReqs);
        }
        JreVersion jreVersion = null;
        String string = null;
        if (dbg.on()) {
            dbg.println("getJreCommand for CTC=" + comparable + " reqs=" + jreReqs);
            dbg.println("This Jre Reqs=" + JreReqs.CURRENT);
        }
        if ((jreVersion = jp.getCtcJreVersion(comparable)) != null) {
            if (jreReqs.meetsReqs(jreVersion)) {
                string = this.getVerifiedJrePath(jreVersion);
                if (string == null) {
                    jreVersion = null;
                }
            } else {
                jreVersion = null;
            }
        }
        if (jreVersion == null) {
            Object object3;
            object2 = jp.getJreVersions(jreReqs);
            arrayList = object2.iterator();
            while (arrayList.hasNext()) {
                object3 = arrayList.next();
                string = this.getVerifiedJrePath((JreVersion)object3);
                if (string == null) continue;
                jreVersion = object3;
                break;
            }
            if (jreVersion == null) {
                arrayList = jp.getCurrentJreVersionIfNotMinimum(jreReqs);
                object3 = new JreChooser(frame, jreReqs, CoreVersionUtil.instance().prettyDottedString(comparable), (String)((Object)arrayList));
                ((Dialog)object3).setVisible(true);
                jreVersion = ((JreChooser)object3).getJavaVersion();
                if (jreVersion != null) {
                    try {
                        string = ((JreChooser)object3).getJavaDirectory().getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        KDebug.printStackTrace(iOException);
                        string = ((JreChooser)object3).getJavaDirectory().getAbsolutePath();
                    }
                    jp.setJrePath(jreVersion, string);
                }
            }
        }
        jp.setCtcJreVersion(comparable, jreVersion);
        try {
            jp.save();
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
        }
        if (string != null) {
            object2 = new StringBuilder(string);
            ((StringBuilder)object2).append(File.separatorChar);
            ((StringBuilder)object2).append("bin");
            ((StringBuilder)object2).append(File.separatorChar);
            ((StringBuilder)object2).append("java");
            arrayList = new ArrayList<String>();
            arrayList.add(((StringBuilder)object2).toString());
            jp.getJreArgs(arrayList, jreVersion, comparable);
            return arrayList;
        }
        return null;
    }

    private String getVerifiedJrePath(JreVersion jreVersion) {
        String string = jp.getJrePath(jreVersion);
        if (string != null) {
            try {
                JreChooser.getJreDir(new File(string));
            }
            catch (IOException iOException) {
                jp.setJrePath(jreVersion, null);
                string = null;
            }
        }
        return string;
    }

    public Map<JreVersion, String> getJreDirMap() {
        Map<JreVersion, String> map = jp.getJreDirMap();
        if (!map.containsKey(JreVersion.USER_VERSION)) {
            String string = System.getProperty("java.home");
            File file = null;
            try {
                file = JreChooser.getJreDir(new File(string));
                if (file != null) {
                    map.put(JreVersion.USER_VERSION, file.getCanonicalPath());
                }
            }
            catch (IOException iOException) {
                KDebug.printStackTrace(iOException);
            }
        }
        return map;
    }
}

