/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import cerent.launcher.CtcHttpRetriever;
import cerent.util.CtcRuntime;
import cerent.util.DebugManager;
import cerent.util.EncryptionException;
import cerent.util.IDecrypter;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.PBEEncrypter;
import cerent.util.Preferences;
import com.cisco.ctc.core.CacheLocator;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.DownloadAreas;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.cache.CacheManager;
import com.cisco.ctc.core.cache.CtcCachedFile;
import com.cisco.ctc.core.cache.ICacheManager;
import com.cisco.ctc.core.launcher.DefaultCtcReqs;
import com.cisco.ctc.core.launcher.JarSetManager;
import com.cisco.ctc.core.launcher.JreManager;
import com.cisco.sot.Tl1Tunnel;
import com.cisco.sot.Tl1TunnelDialog;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    private static ICoreVersionUtil cvu = null;
    private static ICacheManager icm = null;
    private static JreManager jreManager = null;
    private static DownloadAreas das = DownloadAreas.instance();
    private static final String CTC_PREF = "ctc";
    private static final String PREF_CACHE_DIR = "cache.dir";
    private static final String CONSOLE_AVAILABLE = "ctc.console.available";
    private static final String SOTL1 = "ctc.sotl1";
    private static final String SOTL1_ADDR = "ctc.sotl1.address";
    private static final String SOTL1_USER = "ctc.sotl1.user";
    private static final String SOTL1_PASSWD = "ctc.sotl1.password";
    private static IDecrypter decrypter = null;
    private static Launcher instance = null;
    private boolean useTl1Tunnel = false;
    private Tl1Tunnel tt = null;
    private static KDebug dbg;
    private Comparable lastLaunchedCtcVo = null;
    private JarSetManager jsm;

    private Launcher() {
    }

    public static final synchronized Launcher init() throws IOException {
        if (instance == null) {
            String string = System.getProperty("ctc.launcher.ini.file", null);
            if (string == null) {
                string = Preferences.getDefaultLauncherPrefsFileName();
            }
            Preferences.setDefault(string, true);
            String string2 = System.getProperty(CONSOLE_AVAILABLE);
            boolean bl = string2 == null || !string2.equals("false");
            DebugManager.init(bl);
            dbg = new KDebug("Launcher");
            cvu = CoreVersionUtil.instance();
            icm = CacheManager.instance();
            jreManager = JreManager.instance();
            CtcHttpRetriever.useProxy(false);
            Preferences preferences = Preferences.instance();
            String[] stringArray = preferences.getPropertyArray(CTC_PREF, PREF_CACHE_DIR, null);
            if (stringArray == null) {
                File file = CtcRuntime.getDefaultCacheDir();
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("An error occurred while creating the default cache directory " + file.getCanonicalPath() + ".");
                }
                stringArray = new String[]{file.getCanonicalPath()};
            }
            icm.refresh(stringArray);
            instance = new Launcher();
        }
        return instance;
    }

    public static final synchronized void dispose() throws IOException {
        if (instance != null) {
            instance.getJarSetManager().dispose();
        }
    }

    public static final Launcher instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Process launchCtc(Frame frame, CtcVersionSelection ctcVersionSelection, String string, Comparable comparable, Comparable comparable2) throws MalformedURLException, IOException, ClassLoaderException, FileNotFoundException {
        Process process;
        block37: {
            Object object4;
            block36: {
                process = null;
                try {
                    ArrayList<String> arrayList;
                    ArrayList<String> arrayList2;
                    JreReqs jreReqs;
                    Object object2;
                    Object object3;
                    if (dbg.on()) {
                        dbg.println("launchCtc loginNE=" + string + " sel=" + (Object)((Object)ctcVersionSelection) + " loginVo=" + comparable + " selVo=" + comparable2);
                    }
                    if (comparable == null) {
                        try {
                            object3 = CtcHttpRetriever.getSwVersion(string);
                            if (dbg.on()) {
                                dbg.println("login to " + string + " swv=" + (String)object3);
                            }
                            comparable = cvu.createNeVersionOrdinal((String)object3);
                            if (dbg.on()) {
                                dbg.println("login VO=" + comparable);
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            KDebug.printStackTrace(nullPointerException);
                            throw new IOException("Internal error (pem files missing in class path)");
                        }
                    }
                    object3 = comparable;
                    if (ctcVersionSelection == CtcVersionSelection.LATEST_VERSION) {
                        if (icm.doesNeedRefresh()) {
                            icm.refresh();
                        }
                        das.refreshConfiguredDownloadAreas(false);
                        JarSetManager jarSetManager = this.getJarSetManager();
                        if (dbg.on()) {
                            object2 = jarSetManager.getJarSets();
                            dbg.println("# of core jar sets found: " + ((Object)object2).length);
                            for (Object object4 : object2) {
                                dbg.println("  " + object4);
                            }
                        }
                        if ((object2 = jarSetManager.getLatestJarSet()) != null && object2.compareTo(comparable) > 0) {
                            object3 = object2;
                        }
                    } else if (ctcVersionSelection == CtcVersionSelection.SELECTED_VERSION) {
                        object3 = comparable2;
                    }
                    boolean bl = cvu.isUnifiedCore((Comparable)object3);
                    if (!bl && !DefaultCtcReqs.supports((Comparable)object3)) {
                        throw new IOException("CTC version " + cvu.prettyDottedString((Comparable)object3) + " is not supported.");
                    }
                    object2 = null;
                    int n = comparable.compareTo(object3);
                    if (n == 0) {
                        CacheLocator cacheLocator = new CacheLocator(string, NETypeEnum.NE_DONT_CARE, comparable);
                        CtcCachedFile ctcCachedFile = cacheLocator.locateBootstrapJarInCache(ClassLoaderEnum.SYSTEM);
                        if (!bl) {
                            DefaultCtcReqs.makeComplete((Comparable)object3, cacheLocator);
                        }
                        object2 = ctcCachedFile.getPath();
                    } else {
                        if (n > 0) {
                            String string2 = cvu.prettyDottedString((Comparable)object3);
                            String string3 = cvu.prettyDottedString(comparable);
                            KErrorMsg.displayError((Component)frame, KEMC.EID_CORE_MUST_BE_GE_LOGIN_NODE, new Object[]{cvu.prettyDottedString((Comparable)object3), cvu.prettyDottedString(comparable)});
                            object4 = null;
                            Object var16_25 = null;
                            das.disposeFutureProofers();
                            return object4;
                        }
                        object2 = this.jsm.getLauncherPath((Comparable)object3);
                    }
                    if (object2 == null) {
                        dbg.println("Cannot find LAUNCHER.jar:" + object3);
                        throw new IOException("LAUNCHER.jar cannot be found.\n" + object3);
                    }
                    if (dbg.on()) {
                        dbg.println("Using launcher: " + (String)object2);
                    }
                    if (bl) {
                        try {
                            URL uRL = new File((String)object2).toURL();
                            jreReqs = cvu.getJreReqs(uRL);
                        }
                        catch (Exception exception) {
                            throw new IOException("The JRE requirements cannot be retrieved from the LAUNCHER.\n" + object3);
                        }
                    } else {
                        jreReqs = DefaultCtcReqs.getJreReqs((Comparable)object3);
                    }
                    if (dbg.on()) {
                        dbg.println("JRE Reqs for " + object3 + "= " + jreReqs);
                    }
                    if ((arrayList2 = jreManager.getJreCommand(frame, (Comparable)object3, jreReqs)) == null) {
                        object4 = null;
                        break block36;
                    }
                    if (this.useTl1Tunnel) {
                        object4 = "";
                        try {
                            arrayList = new PBEEncrypter(CoreConstants.CoreString1, CoreConstants.CoreString2);
                            if (this.tt.getAddress().gnePassword != null) {
                                object4 = ((PBEEncrypter)((Object)arrayList)).encrypt(this.tt.getAddress().gnePassword);
                            }
                        }
                        catch (EncryptionException encryptionException) {
                            dbg.println("Launcher: Password encryption failed");
                            encryptionException.printStackTrace(System.out);
                        }
                        arrayList = new StringBuilder();
                        ((StringBuilder)((Object)arrayList)).append(this.tt.getAddress().host);
                        ((StringBuilder)((Object)arrayList)).append("," + this.tt.getAddress().pneTid);
                        ((StringBuilder)((Object)arrayList)).append("," + this.tt.getAddress().encoding);
                        ((StringBuilder)((Object)arrayList)).append("," + this.tt.getAddress().gneTl1Port);
                        if (this.tt.getAddress().gneTid != null) {
                            ((StringBuilder)((Object)arrayList)).append("," + this.tt.getAddress().gneTid);
                        }
                        arrayList2.add("-Dctc.sotl1=true");
                        arrayList2.add("-Dctc.sotl1.address=" + ((StringBuilder)((Object)arrayList)).toString());
                        arrayList2.add("-Dctc.sotl1.user=" + this.tt.getAddress().gneUsername);
                        arrayList2.add("-Dctc.sotl1.password=" + (String)object4);
                    }
                    object4 = new ArrayList<String>();
                    this.adjustJvmArgs((Comparable)object3, arrayList2, (ArrayList<String>)object4, bl);
                    if (((ArrayList)object4).isEmpty()) {
                        process = CtcRuntime.instance().exec(string, arrayList2, (String)object2);
                    } else {
                        arrayList = new ArrayList<String>();
                        arrayList.add("cerent.launcher.Bootstrap");
                        if (string != null) {
                            arrayList.add(string);
                        }
                        ((ArrayList)object4).add(object2);
                        process = CtcRuntime.instance().execByClassPath(arrayList, arrayList2, (ArrayList<String>)object4);
                    }
                    this.lastLaunchedCtcVo = object3;
                    break block37;
                }
                catch (Throwable throwable) {
                    Object var16_28 = null;
                    das.disposeFutureProofers();
                    throw throwable;
                }
            }
            Object var16_26 = null;
            das.disposeFutureProofers();
            return object4;
        }
        Object var16_27 = null;
        das.disposeFutureProofers();
        return process;
    }

    public Comparable getLastCtcVersion() {
        return this.lastLaunchedCtcVo;
    }

    public synchronized JarSetManager getJarSetManager() throws IOException {
        if (this.jsm == null) {
            this.jsm = new JarSetManager();
        } else {
            this.jsm.init();
        }
        return this.jsm;
    }

    private ArrayList<String> adjustJvmArgs(Comparable comparable, ArrayList<String> arrayList, ArrayList<String> arrayList2, boolean bl) throws FileNotFoundException {
        if (bl) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray = CacheManager.instance().getCacheDirList()) {
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("-Dctc.cache.dir=");
                } else {
                    stringBuilder.append(';');
                }
                stringBuilder.append(string);
            }
            if (stringBuilder.length() != 0) {
                arrayList.add(stringBuilder.toString());
            }
        } else {
            DefaultCtcReqs.getArgs(arrayList, arrayList2, comparable);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process launchCtc(Frame frame, CtcVersionSelection ctcVersionSelection) throws MalformedURLException, IOException, ClassLoaderException, Exception {
        Tl1TunnelDialog tl1TunnelDialog = new Tl1TunnelDialog();
        this.tt = tl1TunnelDialog.getTl1Tunnel();
        String string = null;
        if (this.tt == null) {
            throw new Exception("Could not open TL1 Tunnel");
        }
        Object object = this.tt.getPneIp();
        dbg.println("TL1 Tunnel connected:" + this.tt + " pneIP=" + object);
        string = ((InetAddress)object).getHostAddress();
        dbg.println("Using host=" + string);
        CtcHttpRetriever.useProxy(true);
        try {
            object = CtcHttpRetriever.getSwVersion(string);
            Comparable comparable = cvu.createNeVersionOrdinal((String)object);
            this.useTl1Tunnel = true;
            Process process = this.launchCtc(frame, ctcVersionSelection, string, comparable, null);
            Object var9_8 = null;
            if (this.tt != null) {
                this.tt.close();
            }
            this.useTl1Tunnel = false;
            this.tt = null;
            return process;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (this.tt != null) {
                this.tt.close();
            }
            this.useTl1Tunnel = false;
            this.tt = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheDirList(String[] stringArray) throws IOException {
        Preferences preferences = Preferences.instance();
        preferences.setPropertyArray(CTC_PREF, PREF_CACHE_DIR, stringArray);
        CacheManager.instance().refresh(stringArray);
        Launcher launcher = this;
        synchronized (launcher) {
            this.jsm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCache() {
        das.cleanupAllDownloadAreas();
        try {
            CacheManager.instance().refresh();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = CacheManager.instance().deleteCache();
        if (!bl) {
            JOptionPane.showMessageDialog(null, "Requested Cache cleanup failed\nto remove at least 1 file.\nCheck for an existing\nCTC application process.", "Cache Cleanup Unsuccessful", 2);
        }
        Launcher launcher = this;
        synchronized (launcher) {
            this.jsm = null;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CtcVersionSelection {
        LATEST_VERSION,
        LOGIN_NODE_VERSION,
        SELECTED_VERSION;

    }
}

