/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import com.cisco.ctc.core.launcher.CacheSettings;
import com.cisco.ctc.core.launcher.JvmSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LauncherSettingsDialog
extends JDialog
implements ActionListener,
WindowListener,
ChangeListener {
    private boolean dirty = false;
    private int oldTab = 0;
    private JButton okBtn = null;
    private JButton cancelBtn = null;
    private JButton applyBtn = null;
    private JTabbedPane tabPane = new JTabbedPane();
    private static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";

    public LauncherSettingsDialog(Frame frame) {
        super(frame, "CTC Launcher Settings", true);
        try {
            URL uRL = LauncherSettingsDialog.class.getResource(APPLICATION_ICON);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            frame.setIconImage(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.tabPane.addChangeListener(this);
        this.pack();
        this.setSize(385, 300);
        this.setLocationRelativeTo(frame);
    }

    private void init() {
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.okBtn = this.createButton("OK", true);
        jPanel.add(this.okBtn);
        this.cancelBtn = this.createButton("Cancel", true);
        jPanel.add(this.cancelBtn);
        this.applyBtn = this.createButton("Apply", false);
        jPanel.add(this.applyBtn);
        container.add((Component)jPanel, "South");
        this.tabPane.addTab("Cache", new CacheSettings(this));
        this.tabPane.addTab("JVM", new JvmSettings(this));
        container.add((Component)this.tabPane, "Center");
    }

    private JButton createButton(String string, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setEnabled(bl);
        return jButton;
    }

    public void load() {
        this.setDirty(false);
    }

    public int store() {
        int n = -1;
        if (!this.isDirty()) {
            n = 0;
            return n;
        }
        Component component = this.tabPane.getComponentAt(this.oldTab);
        try {
            if (component instanceof CacheSettings) {
                CacheSettings cacheSettings = (CacheSettings)component;
                n = cacheSettings.store();
            } else if (component instanceof JvmSettings) {
                JvmSettings jvmSettings = (JvmSettings)component;
                n = jvmSettings.store();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setDirty(n != 0);
        return n;
    }

    private int getConfirmation() {
        String string = "Changes have been made. Do you want save the changes?";
        return JOptionPane.showConfirmDialog(this, string, "Confirm", 1, 2);
    }

    private int processUserAction() {
        int n = 0;
        if (this.isDirty()) {
            Component component;
            n = this.getConfirmation();
            if (n == 0) {
                n = this.store();
            } else if (n == 1 && (component = this.tabPane.getComponentAt(this.oldTab)) instanceof JvmSettings) {
                JvmSettings jvmSettings = (JvmSettings)component;
                jvmSettings.load();
            }
        }
        return n;
    }

    public boolean showSettings() {
        this.setVisible(true);
        CacheSettings cacheSettings = (CacheSettings)this.tabPane.getComponentAt(0);
        return cacheSettings.isDirty();
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.applyBtn.setEnabled(bl);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void destroy() {
        this.removeWindowListener(this);
        this.tabPane.removeChangeListener(this);
        this.okBtn.removeActionListener(this);
        this.cancelBtn.removeActionListener(this);
        this.applyBtn.removeActionListener(this);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = -1;
        if (object == this.okBtn || object == this.applyBtn) {
            n = this.store();
            if (n == -1) {
                return;
            }
            if (object == this.applyBtn) {
                return;
            }
        } else if (object == this.cancelBtn && ((n = this.processUserAction()) == 2 || n == -1)) {
            this.tabPane.setSelectedIndex(this.oldTab);
            return;
        }
        this.destroy();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.tabPane.getSelectedIndex();
        if (this.oldTab != n) {
            int n2 = this.processUserAction();
            if (n2 == 2 || n2 == -1) {
                this.tabPane.setSelectedIndex(this.oldTab);
                return;
            }
            this.load();
            this.oldTab = n;
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.isDirty() && this.getConfirmation() == 2) {
            return;
        }
        this.destroy();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

