/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import com.cisco.ctc.ui.CUESLoginWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CUESLoginAttributesPane
extends JPanel
implements ActionListener,
DocumentListener,
KeyListener {
    protected JButton loginButton = null;
    protected JButton cancelButton = null;
    protected JTextField userNameField = null;
    protected JPasswordField passwordField = null;
    protected CUESLoginWindow parent = null;

    public CUESLoginAttributesPane(CUESLoginWindow cUESLoginWindow) {
        this.parent = cUESLoginWindow;
        this.init();
    }

    protected void init() {
        this.setLayout(null);
        this.setBackground(CUESLoginWindow.GREEN_COLOR);
        this.setSize(this.getPreferredSize());
        this.userNameField = this.createTextField(this.getAttributeFieldX(), 15);
        this.add(this.userNameField);
        this.passwordField = this.createPasswordField(this.getAttributeFieldX(), 42);
        this.add(this.passwordField);
        this.loginButton = this.createButton("Login", this.getLoginButtonPoint().x, this.getLoginButtonPoint().y, false);
        this.add(this.loginButton);
        this.cancelButton = this.createButton("Cancel", this.getCancelButtonPoint().x, this.getCancelButtonPoint().y, true);
        this.add(this.cancelButton);
        this.setLocation(this.parent.getProductNameArea().width + this.parent.getPhotoDimension().width, this.parent.getProductNameArea().y);
        this.userNameField.requestFocus();
    }

    protected JButton createButton(String string, int n, int n2, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.setEnabled(bl);
        jButton.setSize(65, 22);
        jButton.setLocation(n, n2);
        jButton.addActionListener(this);
        jButton.addKeyListener(this);
        return jButton;
    }

    protected JTextField createTextField(int n, int n2) {
        JTextField jTextField = new JTextField();
        jTextField.setFont(new Font("Arial", 0, 12));
        jTextField.setSize(this.getTextFieldDimension());
        jTextField.setLocation(n, n2);
        jTextField.addKeyListener(this);
        jTextField.getDocument().addDocumentListener(this);
        return jTextField;
    }

    protected JPasswordField createPasswordField(int n, int n2) {
        JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.setFont(new Font("Arial", 0, 12));
        jPasswordField.setSize(this.getTextFieldDimension());
        jPasswordField.setLocation(n, n2);
        jPasswordField.addKeyListener(this);
        jPasswordField.getDocument().addDocumentListener(this);
        return jPasswordField;
    }

    protected void processLogin() {
        if (this.parent.getLoginStatus()) {
            return;
        }
        this.userNameField.requestFocus();
        this.parent.processLogin();
    }

    protected void processCancel() {
        System.exit(0);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(new Font("Arial", 0, 12));
        graphics2D.setPaint(Color.white);
        graphics2D.drawString("User Name", 15, 28);
        graphics2D.drawString("Password", 15, 57);
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 152);
    }

    protected Dimension getTextFieldDimension() {
        return new Dimension(137, 20);
    }

    protected int getAttributeFieldX() {
        return this.getWidth() - 155;
    }

    protected Point getLoginButtonPoint() {
        return new Point(this.getWidth() - 190, this.getHeight() - 39);
    }

    protected Point getCancelButtonPoint() {
        return new Point(this.getWidth() - 110, this.getHeight() - 39);
    }

    public String getUserName() {
        return this.userNameField.getText().trim();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.loginButton)) {
            this.processLogin();
        } else if (object.equals(this.cancelButton)) {
            this.processCancel();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.loginButton.setEnabled(this.getUserName().length() > 0);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.loginButton.isEnabled()) {
            this.processLogin();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

