/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.KDebug;
import com.cisco.sot.NioBufferHelper;
import com.cisco.sot.Tl1Tunnel;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Ssh {
    private static final int SSH_CODE_LEN = 1;
    private static final int SSH_INT_LEN = 4;
    private static final int SSH_STR_HDR_LEN = 4;
    private static KDebug dbg = new KDebug("Ssh");
    private static final String CHANNEL_DIRECT_TCP = "direct-tcp";
    private static final String CHANNEL_SOTL1_TUNNEL = "sotl1-tunnel";
    static final int OPEN_TUNNEL_SIZE = 5 + "sotl1-tunnel".length() + 12;
    static final int OPEN_CHANNEL_SIZE = 5 + "direct-tcp".length() + 4 + "192.100.100.100".length() + 24;
    static final int OPEN_CHANNEL_RS_SIZE = 17;
    static final int CLOSE_CHANNEL_SIZE = 5;
    static final int WINDOW_ADJ_SIZE = 9;
    static final int DATA_HDR_SIZE = 9;
    private static final byte MSG_CHANNEL_OPEN = 90;
    private static final byte MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    private static final byte MSG_CHANNEL_OPEN_FAILURE = 92;
    private static final byte MSG_CHANNEL_WINDOW_ADJUST = 93;
    private static final byte MSG_CHANNEL_DATA = 94;
    private static final byte MSG_CHANNEL_CLOSE = 97;
    private static final byte OPEN_CONNECT_FAILED = 2;
    private static final byte OPEN_UNKNOWN_CHANNEL_TYPE = 3;
    private static final byte OPEN_RESOURCE_SHORTAGE = 4;

    private Ssh() {
    }

    private static void putString(ByteBuffer byteBuffer, String string) {
        byteBuffer.putInt(string.length());
        byteBuffer.put(string.getBytes());
    }

    public static void openTunnelRq(ByteBuffer byteBuffer, int n) {
        byteBuffer.put((byte)90);
        Ssh.putString(byteBuffer, CHANNEL_SOTL1_TUNNEL);
        byteBuffer.putInt(n);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        if (dbg.on()) {
            dbg.println("Open Tunnel Rq");
        }
    }

    public static void openChannelRq(ByteBuffer byteBuffer, int n, int n2, int n3, String string, int n4) {
        byteBuffer.put((byte)90);
        Ssh.putString(byteBuffer, CHANNEL_DIRECT_TCP);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n3);
        Ssh.putString(byteBuffer, string);
        byteBuffer.putInt(n4);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        if (dbg.on()) {
            dbg.println("Chn-Open-Req id=" + Integer.toHexString(n) + "/0 dest=" + string + ":" + n4);
        }
    }

    public static void chnDataRq(ByteBuffer byteBuffer, int n, int n2, byte[] byArray, int n3, int n4) {
        byteBuffer.put((byte)94);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n4);
        byteBuffer.put(byArray, n3, n4);
        if (dbg.on()) {
            dbg.println("Chn-Data-Req id=" + Integer.toHexString(n) + "/" + Integer.toHexString(n2) + " L=" + n4);
            if (dbg.isFinestEnabled()) {
                NioBufferHelper.dump(byteBuffer, dbg, byteBuffer.position() - n4, n4, 256);
            }
        }
    }

    public static void chnDataEchoRq(ByteBuffer byteBuffer, int n, byte by, int n2) {
        byteBuffer.put((byte)94);
        byteBuffer.putInt(n);
        int n3 = n2 - 9;
        byteBuffer.putInt(n3);
        if (dbg.on()) {
            dbg.println("Chn-Data-Echo-Req remid=" + Integer.toHexString(n) + " L=" + n2);
        }
        for (int i = 0; i < n3; ++i) {
            byteBuffer.put(by);
        }
        if (dbg.isFinestEnabled()) {
            NioBufferHelper.dump(byteBuffer, dbg, byteBuffer.position() - n2, n2, 256);
        }
    }

    public static void chnWndAdjRq(ByteBuffer byteBuffer, int n, int n2, int n3) {
        byteBuffer.put((byte)93);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n3);
        if (dbg.on()) {
            dbg.println("Chn-Wndw-Req id=" + Integer.toHexString(n) + "/" + Integer.toHexString(n2) + " credit=" + n3);
        }
    }

    public static void chnCloseRq(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.put((byte)97);
        byteBuffer.putInt(n2);
        if (dbg.on()) {
            dbg.println("Chn-Clos-Req id=" + Integer.toHexString(n) + "/" + Integer.toHexString(n2));
        }
    }

    public static void openChannelRs(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        byteBuffer.put((byte)91);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n3);
        byteBuffer.putInt(n4);
    }

    private static void decodeError(ByteBuffer byteBuffer, String string) throws IOException {
        byteBuffer.rewind();
        NioBufferHelper.dump(byteBuffer, dbg, 64);
        throw new IOException(string);
    }

    public static int decode(Tl1Tunnel tl1Tunnel, ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        byteBuffer.mark();
        byte by = byteBuffer.get();
        switch (by) {
            case 91: {
                if (byteBuffer.remaining() < 16) {
                    Ssh.decodeError(byteBuffer, "SSH_MSG_CHANNEL_OPEN_CONFIRMATION truncated header");
                }
                int n2 = byteBuffer.getInt();
                int n3 = byteBuffer.getInt();
                int n4 = byteBuffer.getInt();
                int n5 = byteBuffer.getInt();
                if (dbg.on()) {
                    dbg.println("Chn Open Cnf id=" + Integer.toHexString(n2) + "/" + Integer.toHexString(n3) + " wsize=" + n4 + " psize=" + n5);
                }
                tl1Tunnel.chnOpenConf(n2, n3, n4, n5);
                break;
            }
            case 92: {
                if (byteBuffer.remaining() < 12) {
                    Ssh.decodeError(byteBuffer, "SSH_MSG_CHANNEL_OPEN_FAILURE truncated header");
                }
                int n6 = byteBuffer.getInt();
                int n7 = byteBuffer.getInt();
                int n8 = byteBuffer.getInt();
                if (byteBuffer.remaining() < n8) {
                    Ssh.decodeError(byteBuffer, "SSH_MSG_CHANNEL_OPEN_FAILURE truncated desc in header");
                }
                byte[] byArray = new byte[n8];
                byteBuffer.get(byArray);
                if (byteBuffer.remaining() < 4) {
                    Ssh.decodeError(byteBuffer, "SSH_MSG_CHANNEL_OPEN_FAILURE lang tag missing in header");
                }
                if ((n8 = byteBuffer.getInt()) > byteBuffer.remaining()) {
                    Ssh.decodeError(byteBuffer, "SSH_MSG_CHANNEL_OPEN_FAILURE truncated lang tag in header");
                }
                byteBuffer.position(byteBuffer.position() + n8);
                String string = new String(byArray);
                if (dbg.on()) {
                    dbg.println("Chn Open Fail id=" + Integer.toHexString(n6) + " reason=" + n7 + " desc=" + string);
                }
                tl1Tunnel.chnOpenFail(n6, n7, string);
                break;
            }
            case 93: {
                int n9 = byteBuffer.getInt();
                int n10 = byteBuffer.getInt();
                if (dbg.on()) {
                    dbg.println("Chn-Wndw-Ind id=" + Integer.toHexString(n9) + " credit=" + n10);
                }
                tl1Tunnel.chnWndAdjust(n9, n10);
                break;
            }
            case 94: {
                if (byteBuffer.remaining() < 8) {
                    Ssh.decodeError(byteBuffer, "SSH_MSG_CHANNEL_DATA truncated header");
                }
                int n11 = byteBuffer.getInt();
                int n12 = byteBuffer.getInt();
                if (n12 > byteBuffer.remaining()) {
                    Ssh.decodeError(byteBuffer, "SSH_MSG_CHANNEL_DATA truncated data");
                }
                if (dbg.on()) {
                    dbg.println("Chn-Data-Ind id=" + Integer.toHexString(n11) + " L=" + n12);
                    if (dbg.isFinestEnabled()) {
                        NioBufferHelper.dump(byteBuffer, dbg, byteBuffer.position(), n12, 256);
                    }
                }
                tl1Tunnel.chnData(n11, n12, byteBuffer);
                n = n12;
                break;
            }
            case 97: {
                if (byteBuffer.remaining() < 4) {
                    Ssh.decodeError(byteBuffer, "SSH_MSG_CHANNEL_CLOSE truncated header");
                }
                int n13 = byteBuffer.getInt();
                if (dbg.on()) {
                    dbg.println("Chn-Clos-Ind id=" + Integer.toHexString(n13));
                }
                tl1Tunnel.chnClose(n13);
                break;
            }
            default: {
                Ssh.decodeError(byteBuffer, "Invalid SSH code:" + (by & 0xFF) + " 0x" + Integer.toHexString(by & 0xFF));
            }
        }
        return n;
    }
}

