/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import com.cisco.sot.Tl1Tunnel;
import com.cisco.sot.Tl1TunnelAddr;
import com.cisco.sot.Tl1TunnelAddrBook;
import com.cisco.sot.Tl1TunnelFactory;
import com.cisco.sot.Tl1TunnelUidPid;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;

public class Tl1TunnelDialog
extends JFrame
implements WindowListener,
DocumentListener,
ActionListener,
Runnable {
    private static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";
    private static final String PREFS_PATH = "ctc.sotl1";
    public static final String[] TL1_ENCODINGS = new String[]{"LV + Binary Payload", "LV + Base64 Payload", "Raw"};
    public static final int ENCODE_LV_RAW = 0;
    public static final int ENCODE_LV_B64 = 1;
    public static final int ENCODE_RAW = 2;
    private JComboBox cbPneTid;
    private JComboBox cbTl1Encoding;
    private JFormattedTextField tfTl1Port;
    private JRadioButton rbTl1DefaultPort;
    private JRadioButton rbTl1OtherPort;
    private JCheckBox cbGneLogin;
    private JTextField tfGneHostName;
    private JTextField tfGneTid;
    private JButton bCreateTunnel = new JButton("OK");
    private JButton bExit = new JButton("Exit");
    private JTextArea taLog = new JTextArea(6, 50);
    private JScrollPane spLog = new JScrollPane(this.taLog);
    private Tl1Tunnel tunnel;
    private Exception getTunnelException;
    private Object lock = new Object();
    private Tl1TunnelAddrBook addrBook = Tl1TunnelAddrBook.instance();
    private Tl1TunnelAddr[] addrs;
    private Rectangle visible = new Rectangle(1, 1);
    private boolean inited = false;

    public Tl1TunnelDialog() {
        super("Open CTC TL1 Tunnel");
        try {
            URL uRL = Tl1TunnelDialog.class.getResource(APPLICATION_ICON);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.setIconImage(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addRow(JPanel jPanel, String string, JComponent jComponent, JComponent jComponent2, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = null;
        if (string != null) {
            jLabel = new JLabel(string);
            jLabel.setHorizontalAlignment(2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = jComponent == null ? 2 : 1;
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        if (jComponent != null) {
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        if (jComponent2 != null) {
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)jComponent2, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
    }

    private void watchDocument(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.getDocument().addDocumentListener(this);
        }
    }

    protected void initContentPane() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.setBackground(Color.white);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 5, 5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.cbPneTid = new JComboBox();
        this.cbPneTid.setEditable(true);
        this.cbPneTid.addActionListener(this);
        JLabel jLabel = new JLabel("Far End TID:");
        jPanel2.add(jLabel);
        jPanel2.add(this.cbPneTid);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Gateway NE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(6, 5, 6, 5);
        Insets insets2 = new Insets(0, 5, 6, 5);
        Insets insets3 = new Insets(6, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        this.tfGneHostName = new JTextField();
        Tl1TunnelDialog.addRow(jPanel2, "Host Name/Node Address:", null, this.tfGneHostName, gridBagConstraints);
        this.rbTl1DefaultPort = new JRadioButton("Use Default TL1 Port");
        gridBagConstraints.insets = insets3;
        Tl1TunnelDialog.addRow(jPanel2, null, this.rbTl1DefaultPort, null, gridBagConstraints);
        this.rbTl1OtherPort = new JRadioButton("Use Other TL1 Port:");
        MaskFormatter maskFormatter = new MaskFormatter();
        try {
            maskFormatter.setMask("#####");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.tfTl1Port = new JFormattedTextField(maskFormatter);
        this.tfTl1Port.setFocusLostBehavior(3);
        gridBagConstraints.insets = insets2;
        Tl1TunnelDialog.addRow(jPanel2, null, this.rbTl1OtherPort, this.tfTl1Port, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbTl1DefaultPort);
        buttonGroup.add(this.rbTl1OtherPort);
        this.rbTl1DefaultPort.addActionListener(this);
        this.rbTl1OtherPort.addActionListener(this);
        this.cbTl1Encoding = new JComboBox<String>(TL1_ENCODINGS);
        gridBagConstraints.insets = insets;
        Tl1TunnelDialog.addRow(jPanel2, "TL1 Encoding Mode:", null, this.cbTl1Encoding, gridBagConstraints);
        this.cbTl1Encoding.addActionListener(this);
        this.cbGneLogin = new JCheckBox("GNE Login Required", false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets3;
        jPanel2.add((Component)this.cbGneLogin, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        this.tfGneTid = new JTextField();
        gridBagConstraints.insets = insets2;
        JLabel jLabel2 = new JLabel("TID:");
        jLabel2.setHorizontalAlignment(4);
        Tl1TunnelDialog.addRow(jPanel2, "    ", jLabel2, this.tfGneTid, gridBagConstraints);
        jPanel.add(jPanel2);
        Box box = Box.createHorizontalBox();
        this.getRootPane().setDefaultButton(this.bCreateTunnel);
        box.add(Box.createHorizontalGlue());
        box.add(this.bCreateTunnel);
        this.bCreateTunnel.addActionListener(this);
        box.add(Box.createHorizontalStrut(20));
        box.add(this.bExit);
        this.bExit.addActionListener(this);
        box.add(Box.createHorizontalGlue());
        box.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)box, "South");
        this.watchDocument(this.cbPneTid.getEditor().getEditorComponent());
        this.watchDocument(this.tfGneHostName);
        this.watchDocument(this.tfGneTid);
        this.cbGneLogin.addActionListener(this);
        this.watchDocument(this.tfTl1Port);
        container.add((Component)jPanel, "North");
        this.taLog = new JTextArea(6, 40);
        this.spLog = new JScrollPane(this.taLog);
        this.spLog.setVerticalScrollBarPolicy(20);
        this.spLog.setBorder(BorderFactory.createTitledBorder("TL1 Log"));
        this.taLog.setBorder(BorderFactory.createBevelBorder(1));
        this.taLog.setMinimumSize(new Dimension(400, 160));
        this.taLog.setOpaque(true);
        this.taLog.setEditable(false);
        this.taLog.setBackground(new Color(230, 230, 230));
        container.add(this.spLog);
        container.setBackground(jPanel2.getBackground());
        this.addrs = Tl1TunnelAddrBook.instance().getTunnels();
        for (int i = 0; i < this.addrs.length; ++i) {
            this.cbPneTid.addItem(this.addrs[i].pneTid);
        }
        this.cbPneTid.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tl1Tunnel getTl1Tunnel() {
        while (true) {
            this.getTunnelException = null;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.getTunnelException == null) break;
            JOptionPane.showMessageDialog(this, this.getTunnelException.getMessage(), this.getTitle(), 0);
        }
        this.dispose();
        return this.tunnel;
    }

    private void appendText(String string) {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            public void run() {
                Tl1TunnelDialog.this.taLog.append(string2);
                Tl1TunnelDialog.this.visible.setLocation(0, Tl1TunnelDialog.this.taLog.getHeight() - 1);
                Tl1TunnelDialog.this.taLog.scrollRectToVisible(Tl1TunnelDialog.this.visible);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static int getTl1Encoding(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 0: {
                return 128;
            }
        }
        return 1;
    }

    public static int getCbTl1Encoding(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 128) {
            return 0;
        }
        return 2;
    }

    public static int getTl1Port(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return 3081;
            }
        }
        return 3082;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            Object object = actionEvent.getSource();
            if (object == this.bCreateTunnel) {
                int n;
                try {
                    n = Integer.parseInt(this.tfTl1Port.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                String string = this.tfGneHostName.getText().trim();
                String string2 = ((String)this.cbPneTid.getEditor().getItem()).trim();
                String string3 = null;
                if (this.cbGneLogin.isSelected()) {
                    string3 = this.tfGneTid.getText().trim();
                }
                try {
                    Tl1TunnelAddr tl1TunnelAddr = new Tl1TunnelAddr(string, string2, Tl1TunnelDialog.getTl1Encoding(this.cbTl1Encoding.getSelectedIndex()), string3, n, null, null);
                    this.bCreateTunnel.setEnabled(false);
                    new Thread(new TunnelCreator(tl1TunnelAddr)).start();
                }
                catch (UnknownHostException unknownHostException) {
                    String string4 = "The GNE hostname " + string + " is invalid.";
                    this.appendText(string4 + "\n");
                    JOptionPane.showMessageDialog(this, string4, this.getTitle(), 0);
                }
            } else if (object == this.bExit) {
                this.appendText("The tunnel creation was canceled by the user.");
                Object object2 = this.lock;
                synchronized (object2) {
                    this.lock.notifyAll();
                }
            } else if (object == this.cbPneTid) {
                this.syncPneTid();
            } else if (object == this.cbTl1Encoding || object == this.rbTl1OtherPort || object == this.rbTl1DefaultPort || object == this.cbGneLogin) {
                this.syncPort();
            }
        }
    }

    private void syncPort() {
        if (this.rbTl1DefaultPort.isSelected()) {
            int n = Tl1TunnelDialog.getTl1Port(this.cbTl1Encoding.getSelectedIndex());
            this.tfTl1Port.setText(Integer.toString(n));
            this.tfTl1Port.setEditable(false);
        } else {
            this.tfTl1Port.setEditable(true);
        }
        this.tfGneTid.setEnabled(this.cbGneLogin.isSelected());
        this.tfGneTid.setEditable(this.cbGneLogin.isSelected());
    }

    private void syncPneTid() {
        int n = this.cbPneTid.getSelectedIndex();
        if (n >= 0) {
            Tl1TunnelAddr tl1TunnelAddr = this.addrs[n];
            this.tfGneHostName.setText(tl1TunnelAddr.host);
            this.cbTl1Encoding.setSelectedIndex(Tl1TunnelDialog.getCbTl1Encoding(tl1TunnelAddr.encoding));
            this.cbGneLogin.setSelected(tl1TunnelAddr.gneTid != null);
            if (tl1TunnelAddr.gneTid != null) {
                this.tfGneTid.setText(tl1TunnelAddr.gneTid);
            }
            if (tl1TunnelAddr.isDefaultPort()) {
                this.rbTl1DefaultPort.setSelected(true);
                this.rbTl1OtherPort.setSelected(false);
            } else {
                this.rbTl1DefaultPort.setSelected(false);
                this.rbTl1OtherPort.setSelected(true);
                this.tfTl1Port.setText(Integer.toString(tl1TunnelAddr.gneTl1Port));
            }
        } else {
            this.cbTl1Encoding.setSelectedIndex(0);
            this.rbTl1DefaultPort.setSelected(true);
            this.rbTl1OtherPort.setSelected(false);
        }
        this.syncPort();
    }

    private void syncButton() {
        boolean bl;
        String string = ((String)this.cbPneTid.getEditor().getItem()).trim();
        String string2 = this.tfGneHostName.getText().trim();
        boolean bl2 = bl = string.length() > 0 && string2.length() > 0;
        if (bl) {
            boolean bl3 = bl = this.tfTl1Port.getText().trim().length() > 0;
            if (bl && this.cbGneLogin.isSelected()) {
                bl = this.tfGneTid.getText().trim().length() > 0;
            }
        }
        this.bCreateTunnel.setEnabled(bl);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.syncButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.syncButton();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.syncButton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosed(WindowEvent windowEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.windowClosed(windowEvent);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void run() {
        if (!this.inited) {
            this.addWindowListener(this);
            this.initContentPane();
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            this.setLocation(n, n2);
            this.syncPneTid();
            this.syncButton();
            this.inited = true;
        }
        this.show();
    }

    private class TunnelCreator
    implements Runnable,
    Observer {
        private Tl1TunnelAddr addr;

        TunnelCreator(Tl1TunnelAddr tl1TunnelAddr) {
            this.addr = tl1TunnelAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                block12: {
                    Tl1TunnelDialog.this.appendText("Opening Tunnel " + this.addr.host + "/" + this.addr.pneTid + "...\n");
                    Tl1TunnelDialog.this.tunnel = null;
                    try {
                        try {
                            if (this.addr.gneTid != null) {
                                Tl1TunnelUidPid tl1TunnelUidPid = new Tl1TunnelUidPid((Frame)Tl1TunnelDialog.this, "Login to Gateway NE " + this.addr.gneTid, "Enter the GNE TL1 user name and password");
                                tl1TunnelUidPid.show();
                                this.addr.gneUsername = tl1TunnelUidPid.getUid();
                                this.addr.gnePassword = tl1TunnelUidPid.getPid();
                                if (this.addr.gneUsername == null) {
                                    Object var3_3 = null;
                                    break block12;
                                }
                            }
                            Tl1TunnelDialog.this.tunnel = Tl1TunnelFactory.instance().createTl1Tunnel(this.addr, 20000, this);
                            Tl1TunnelDialog.this.appendText("The connection succeeded.\n");
                            Tl1TunnelDialog.this.addrBook.setMruTunnel(this.addr);
                            break block13;
                        }
                        catch (Exception exception) {
                            Tl1TunnelDialog.this.appendText("The connection failed:" + exception.getMessage() + "\n\n");
                            Tl1TunnelDialog.this.getTunnelException = exception;
                            Object var3_5 = null;
                            Object object = Tl1TunnelDialog.this.lock;
                            synchronized (object) {
                                Tl1TunnelDialog.this.lock.notifyAll();
                            }
                            Tl1TunnelDialog.this.bCreateTunnel.setEnabled(true);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_6 = null;
                        Object object = Tl1TunnelDialog.this.lock;
                        synchronized (object) {
                            Tl1TunnelDialog.this.lock.notifyAll();
                        }
                        Tl1TunnelDialog.this.bCreateTunnel.setEnabled(true);
                        throw throwable;
                    }
                }
                Object object = Tl1TunnelDialog.this.lock;
                synchronized (object) {
                    Tl1TunnelDialog.this.lock.notifyAll();
                }
                Tl1TunnelDialog.this.bCreateTunnel.setEnabled(true);
                return;
            }
            Object var3_4 = null;
            Object object = Tl1TunnelDialog.this.lock;
            synchronized (object) {
                Tl1TunnelDialog.this.lock.notifyAll();
            }
            Tl1TunnelDialog.this.bCreateTunnel.setEnabled(true);
        }

        public void update(Observable observable, Object object) {
            if (object instanceof String) {
                Tl1TunnelDialog.this.appendText((String)object + "\n");
            }
        }
    }
}

