/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.TdmProtocolType;
import cerent.util.AbstractEnumBehavior;
import cerent.util.TDMTerminology;
import java.util.Arrays;

public class FramingType
extends AbstractEnumBehavior
implements IFramingType {
    protected static AbstractEnumBehavior.EnumRange Range = new AbstractEnumBehavior.EnumRange(FramingType.class);
    protected static final int IS_SONET = 0;
    protected static final int IS_SDH = 1;
    protected static final int CKT_TYPES = 3;
    protected static FramingType[] FramingTypes = new FramingType[Range.getNumTypes()];
    public static final FramingType SONET = new FramingType(0, "SONET", 1, 1, TdmProtocolType.SONET);
    public static final FramingType SDH_AU4 = new FramingType(1, "SDH-AU4", 3, 12, TdmProtocolType.SDH);
    public static final FramingType SDH_AU3 = new FramingType(2, "SDH-AU3", 1, 11, TdmProtocolType.SDH);
    protected ICircuitType[] supportedCktTypes = null;
    protected int mediumType;
    protected int opticalPayloadType;
    protected int protocolType;
    protected int minimumHoPathWidth;
    protected int lotSize;
    protected int hoCircuitType;
    protected int loCircuitType;
    protected int tunnelCircuitType;
    protected int loAggCircuitType;
    protected int hoVcatCircuitType;
    protected int loVcatCircuitType;
    protected TDMTerminology terms;
    protected ITdmProtocolType tdmProtocolType;
    protected String framingTypeStr;

    protected FramingType(int n, String string, int n2, int n3, ITdmProtocolType iTdmProtocolType) {
        super(FramingTypes, n);
        this.framingTypeStr = string;
        this.minimumHoPathWidth = n2;
        this.lotSize = n3;
        this.tdmProtocolType = iTdmProtocolType;
        this.supportedCktTypes = iTdmProtocolType.getSupportedCircuitTypes();
        this.mediumType = iTdmProtocolType.getMediumType();
        this.opticalPayloadType = iTdmProtocolType.getOpticalPayloadType();
        this.protocolType = iTdmProtocolType.isSonet() ? 0 : 1;
        this.hoCircuitType = iTdmProtocolType.getHoCircuitType();
        this.loCircuitType = iTdmProtocolType.getLoCircuitType();
        this.tunnelCircuitType = iTdmProtocolType.getTunnelCircuitType();
        this.loAggCircuitType = iTdmProtocolType.getAggCircuitType();
        this.hoVcatCircuitType = iTdmProtocolType.getHoVcatCircuitType();
        this.loVcatCircuitType = iTdmProtocolType.getLoVcatCircuitType();
        this.terms = iTdmProtocolType.getTDMTerminology();
        FramingType.FramingTypes[n] = this;
    }

    public static IFramingType getFramingType(int n) {
        FramingType.CheckType(n, Range);
        return FramingTypes[n];
    }

    public String getFramingTypeString() {
        return this.framingTypeStr;
    }

    public ICircuitType[] getSupportedCircuitTypes() {
        return this.supportedCktTypes;
    }

    public int getMediumType() {
        return this.mediumType;
    }

    public int getOpticalPayloadType() {
        return this.opticalPayloadType;
    }

    public static boolean isSonet(int n) {
        return FramingType.getFramingType(n).isSonet();
    }

    public boolean isSonet() {
        return this.tdmProtocolType.isSonet();
    }

    public boolean isSdh() {
        return this.tdmProtocolType.isSdh();
    }

    public int getMinimumHoPathWidth() {
        return this.minimumHoPathWidth;
    }

    public int getFramingTypeHoPathWidth(int n) {
        return n / this.minimumHoPathWidth;
    }

    public static boolean hasAu3(int[] nArray) {
        Arrays.sort(nArray);
        return Arrays.binarySearch(nArray, 2) >= 0;
    }

    public static boolean hasAu4(int[] nArray) {
        Arrays.sort(nArray);
        return Arrays.binarySearch(nArray, 1) >= 0;
    }

    public int getLoTunnelSize() {
        return this.lotSize;
    }

    public int getHoCircuitType() {
        return this.hoCircuitType;
    }

    public int getLoCircuitType() {
        return this.loCircuitType;
    }

    public int getTunnelCircuitType() {
        return this.tunnelCircuitType;
    }

    public int getAggCircuitType() {
        return this.loAggCircuitType;
    }

    public int getHoVcatCircuitType() {
        return this.hoVcatCircuitType;
    }

    public int getLoVcatCircuitType() {
        return this.loVcatCircuitType;
    }

    public TDMTerminology getTDMTerminology() {
        return this.terms;
    }

    public ITdmProtocolType getTdmProtocolType() {
        return this.tdmProtocolType;
    }
}

