/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.helper.ViewHelper;
import cerent.util.Debug;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.UObservable;
import cerent.util.gui.CerentDialog;
import java.awt.Frame;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;

public abstract class AbstractViewController
extends UObservable
implements IViewController {
    private static final int MAX_HIST = 20;
    protected static LinkedList history = new LinkedList();
    protected static int histCursor = -1;
    protected IUiToolkit uiToolkit = null;
    protected IViewController parentVC = null;
    protected ViewName viewName = null;
    protected JPanel cachedPanel = null;
    protected static ViewName currentView = null;
    protected static ViewName previousView = null;
    protected Set children = new HashSet();
    private static ViewHelper viewHelper = null;
    private static final String TITLE = "Cisco Transport Controller";
    protected KDebug db;
    public static final String ACTIVE_OBJECT = "ACTIVE_OBJECT";

    protected AbstractViewController(IUiToolkit iUiToolkit, KDebug kDebug) {
        this(null, ViewName.ROOT_VIEW, iUiToolkit, kDebug);
    }

    protected AbstractViewController(IViewController iViewController, ViewName viewName, IUiToolkit iUiToolkit, KDebug kDebug) {
        this.parentVC = iViewController;
        this.viewName = viewName;
        this.uiToolkit = iUiToolkit;
        this.db = kDebug;
    }

    protected AbstractViewController(IViewController iViewController, ViewName viewName, IUiToolkit iUiToolkit, Debug debug) {
        this(iViewController, viewName, iUiToolkit, (KDebug)debug);
    }

    public String toString() {
        return this.getViewName().toString();
    }

    public ViewName getViewName() {
        return this.viewName;
    }

    public ViewName getCurrentView() {
        if (this.viewName.strictlyEquals(ViewName.ROOT_VIEW)) {
            return currentView;
        }
        return this.parentVC.getCurrentView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jumpView(ViewName viewName, boolean bl) throws AbstractLeavePageException, AbstractInvalidViewException {
        if (this.db.on()) {
            this.db.println("jumpView destView is " + viewName);
        }
        if (this.parentVC != null) {
            this.parentVC.jumpView(viewName, bl);
        } else {
            try {
                if (this.uiToolkit != null) {
                    this.uiToolkit.setCursor(3);
                }
                AbstractViewController.setActiveObject(viewName);
                this.localJumpView(viewName, bl);
            }
            finally {
                if (this.uiToolkit != null) {
                    this.uiToolkit.setCursor(0);
                }
                this.uiToolkit.setSBText("");
            }
        }
    }

    private synchronized void localJumpView(ViewName viewName, boolean bl) throws AbstractLeavePageException, AbstractInvalidViewException {
        JPanel jPanel;
        if (viewName.getNodeId() != 0) {
            viewName.setLabel(null);
        }
        if (this.db.on()) {
            this.db.println("localJumpView destView is " + viewName);
        }
        if (this.getCurrentView() != null && this.getCurrentView().equals(viewName)) {
            if (!this.getCurrentView().strictlyEquals(viewName)) {
                this.updateViewPanel(viewName);
            }
            jPanel = null;
        } else {
            block13: {
                this.uiToolkit.setSBText("Changing to " + viewName.typeString() + " ...");
                jPanel = this.getViewPanel(viewName);
                if (this.getCurrentView() != null) {
                    try {
                        this.exitView(this.getCurrentView(), viewName);
                    }
                    catch (AbstractLeavePageException abstractLeavePageException) {
                        if (!viewName.isRootView()) {
                            this.flushViewPanel(viewName);
                        }
                        if (this.db.on()) {
                            this.db.println("exit current view :" + abstractLeavePageException);
                        }
                        throw abstractLeavePageException;
                    }
                    catch (AbstractInvalidViewException abstractInvalidViewException) {
                        if (!this.db.on()) break block13;
                        this.db.println("This is okay: " + abstractInvalidViewException);
                    }
                }
            }
            this.enterView(viewName);
            if (this.getCurrentView() != null) {
                this.cache(this.getCurrentView(), viewName);
            }
            this.setNewView(viewName);
            if (this.db.on()) {
                this.db.println("jumpView view switched: notify observers \n----------------- View is now " + viewName + "-----------------");
            }
        }
        this.setChanged();
        this.notifyObservers(jPanel);
    }

    public void tryJumpView(ViewName viewName) {
        if (this.db.on()) {
            this.db.println("tryJumpView destView is " + viewName);
        }
        try {
            this.jumpView(viewName, true);
        }
        catch (AbstractLeavePageException abstractLeavePageException) {
            if (this.db.on()) {
                this.db.println(abstractLeavePageException + " received when attempting to switch to " + viewName);
            }
            if (this.db.isInfoEnabled()) {
                KDebug.printStackTrace((Throwable)abstractLeavePageException);
            }
        }
        catch (AbstractInvalidViewException abstractInvalidViewException) {
            if (this.db.on()) {
                this.db.println(abstractInvalidViewException + " received when attempting to switch to " + viewName);
            }
            KDebug.printStackTrace((Throwable)abstractInvalidViewException);
            String string = abstractInvalidViewException.getMessage();
            if (string.indexOf("Software activation is in progress") < 0) {
                string = KErrorMsg.getString((EID)KEMC.EID_NAVIGATION_FAILURE_PARAM_1, (Object)this.getUserFriendlyViewName(viewName));
            }
            CerentDialog.errorDialog(this.getFrame(), string);
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
            throw new RuntimeException(exception.toString());
        }
    }

    protected String getUserFriendlyViewName(ViewName viewName) {
        return "this view";
    }

    public JPanel getViewPanel(ViewName viewName) throws AbstractInvalidViewException {
        if (this.db.on()) {
            this.db.println(this.viewName + " getViewPanel(" + viewName + ")");
        }
        try {
            this.checkForInvalidView(viewName);
        }
        catch (AbstractInvalidViewException abstractInvalidViewException) {
            this.db.println("Caught " + abstractInvalidViewException);
            viewName = viewName.getParentView();
        }
        if (this.viewName.equals(viewName)) {
            block10: {
                if (this.db.on()) {
                    this.db.println(this.viewName.toString() + ":destView is equal to local view");
                }
                try {
                    if (this.cachedPanel == null) {
                        this.cachedPanel = this.createPanel(viewName);
                        INodeModel iNodeModel = this.getTabbedView().getUiModel().getNodeModel();
                        if (!(Feature.provides(iNodeModel, Feature.NETWORK_EXPLORER) || viewName.isRootView() || viewName.isDomainView())) {
                            this.cachedPanel = this.uiToolkit.addNetworkExplorer(this.cachedPanel);
                        }
                    }
                    this.localUpdateViewPanel(viewName);
                }
                catch (AbstractInvalidViewException abstractInvalidViewException) {
                    this.localFlushViewPanel(viewName);
                    throw abstractInvalidViewException;
                }
                catch (AbstractLeavePageException abstractLeavePageException) {
                    if (!this.db.on()) break block10;
                    this.db.println("getViewPanel (this is OK): " + abstractLeavePageException);
                }
            }
            return this.cachedPanel;
        }
        AbstractViewController abstractViewController = this.locateVC(viewName);
        return abstractViewController.getViewPanel(viewName);
    }

    public ViewName getSelectedView(ViewName viewName) throws AbstractInvalidViewException {
        if (this.db.on()) {
            this.db.println("getSelectedView destView is " + viewName);
        }
        if (this.viewName.equals(viewName)) {
            return this.localGetSelectedView(viewName);
        }
        AbstractViewController abstractViewController = this.locateVC(viewName);
        return abstractViewController.getSelectedView(viewName);
    }

    public void updateViewPanel(ViewName viewName) throws AbstractInvalidViewException, AbstractLeavePageException {
        if (this.db.on()) {
            this.db.println("updateViewPanel destView is " + viewName);
        }
        if (this.viewName.equals(viewName)) {
            this.localUpdateViewPanel(viewName);
            this.switchToTab(viewName);
        } else {
            AbstractViewController abstractViewController = this.locateVC(viewName);
            abstractViewController.updateViewPanel(viewName);
        }
    }

    public void enterView(ViewName viewName) throws AbstractInvalidViewException {
        if (this.db.on()) {
            this.db.println(this.getViewName() + " enterView destView is " + viewName);
        }
        if (this.viewName.equals(viewName)) {
            this.localEnterView(viewName);
            this.switchToTab(viewName);
        } else {
            AbstractViewController abstractViewController = this.locateVC(viewName);
            abstractViewController.enterView(viewName);
        }
    }

    public void exitView(ViewName viewName, ViewName viewName2) throws AbstractInvalidViewException, AbstractLeavePageException {
        if (this.db.on()) {
            this.db.println("exitView srcView is " + viewName + " destView is " + viewName2);
        }
        if (this.viewName.equals(viewName)) {
            this.localExitView(viewName, viewName2);
        } else {
            AbstractViewController abstractViewController = this.locateVC(viewName);
            abstractViewController.exitView(viewName, viewName2);
        }
    }

    public void flushViewPanel(ViewName viewName) throws AbstractInvalidViewException {
        if (this.db.on()) {
            this.db.println("flushViewPanel destView is " + viewName);
        }
        if (this.viewName.equals(viewName)) {
            this.localFlushViewPanel(viewName);
        } else {
            AbstractViewController abstractViewController = this.locateVC(viewName);
            abstractViewController.flushViewPanel(viewName);
        }
    }

    public void destroy() {
        ViewName viewName;
        if (this.db.on()) {
            this.db.println(this.viewName + " destroy( )");
        }
        if ((viewName = this.getCurrentView()) != null) {
            int n = this.viewName.getNodeId();
            int n2 = viewName.getNodeId();
            boolean bl = viewName.isDomainView();
            boolean bl2 = this.viewName.isDomainView();
            if (!bl2 && !bl && this.viewName.contains(viewName) || bl2 && bl && this.viewName.strictlyEquals(viewName)) {
                if (this.db.on()) {
                    this.db.println(this.viewName + " is displayed (" + viewName + "), exiting view.");
                }
                try {
                    this.exitView(this.getCurrentView(), null);
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.println("destroy caught exception: " + exception);
                    }
                    KDebug.printStackTrace((Throwable)exception);
                }
            } else if (this.db.on()) {
                this.db.println(this.viewName + " is not displayed, destroying silently.");
            }
        }
        for (IViewController iViewController : this.children) {
            iViewController.destroy();
        }
        if (this.db.on()) {
            this.db.println(this.viewName + " disposing VC");
        }
        this.localDestroy();
        this.cachedPanel = null;
        this.children.clear();
    }

    public IViewController getParentVC() {
        return this.parentVC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(ViewName viewName) {
        if (this.viewName.strictlyEquals(ViewName.ROOT_VIEW)) {
            if (this.db.on()) {
                this.db.println("disconnect: " + viewName + " curview= " + this.getCurrentView());
            }
            AbstractViewController abstractViewController = this;
            synchronized (abstractViewController) {
                if (this.getCurrentView() != null) {
                    if (viewName.contains(this.getCurrentView())) {
                        ViewName viewName2 = ViewName.ROOT_VIEW;
                        try {
                            this.jumpView(viewName2, false);
                            int n = viewName.getNodeId();
                            String string = this.getNodeName(n);
                            string = string == null ? "" : " to " + string;
                            String string2 = "The connection to the node " + string + " was lost. CTC will change to the network view.";
                            DetailedLog detailedLog = new DetailedLog(2, string2);
                            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
                        }
                        catch (AbstractLeavePageException abstractLeavePageException) {
                        }
                        catch (Exception exception) {
                            KDebug.printStackTrace((Throwable)exception);
                            String string = KErrorMsg.getString((EID)KEMC.EID_FATAL_NAVIGATION_EXCEPTION);
                            CerentDialog.errorDialog(this.getFrame(), string);
                            System.exit(1);
                        }
                    } else if (this.db.on()) {
                        this.db.println("disconnect safely discarded (view not visible)");
                    }
                }
            }
        } else {
            this.parentVC.disconnect(viewName);
        }
    }

    public String getNodeName(int n) {
        return null;
    }

    protected Frame getFrame() {
        return this.uiToolkit.getApplicationFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localFlushViewPanel(ViewName viewName) {
        if (this.db.on()) {
            this.db.println("localFlushViewPanel destView is " + (viewName == null ? "null" : viewName.toString()));
        }
        try {
            this.localDispose();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("localFlushViewPanel( " + viewName + " ) " + exception);
            }
            KDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.cachedPanel = null;
        }
    }

    protected ViewName localGetSelectedView(ViewName viewName) {
        if (this.db.on()) {
            this.db.println("localGetSelectedView destView is " + viewName);
        }
        return null;
    }

    protected void cache(ViewName viewName, ViewName viewName2) {
    }

    public TabbedView getCurrentTabbedView() {
        TabbedView tabbedView;
        block4: {
            tabbedView = null;
            if (this.getCurrentView() != null) {
                if (this.viewName.equals(this.getCurrentView())) {
                    return this.getTabbedView();
                }
                try {
                    AbstractViewController abstractViewController = this.locateVC(this.getCurrentView());
                    return abstractViewController.getCurrentTabbedView();
                }
                catch (AbstractInvalidViewException abstractInvalidViewException) {
                    if (!this.db.on()) break block4;
                    KDebug.printStackTrace((Throwable)abstractInvalidViewException);
                }
            }
        }
        return tabbedView;
    }

    protected void setTitleLabel(String string) {
        if (string != null) {
            this.uiToolkit.setApplicationTitle(string + " - " + TITLE);
        } else {
            this.uiToolkit.setApplicationTitle(TITLE);
        }
    }

    public abstract TabbedView getTabbedView();

    protected abstract void localUpdateViewPanel(ViewName var1) throws AbstractInvalidViewException, AbstractLeavePageException;

    protected abstract void localEnterView(ViewName var1);

    protected abstract void localExitView(ViewName var1, ViewName var2) throws AbstractLeavePageException;

    protected abstract void localDestroy();

    protected abstract void localDispose();

    protected abstract void throwInvalidViewException(String var1) throws AbstractInvalidViewException;

    protected abstract JPanel createPanel(ViewName var1) throws AbstractInvalidViewException;

    public synchronized void addChild(IViewController iViewController) {
        IViewController iViewController2 = null;
        ViewName viewName = iViewController.getViewName();
        for (IViewController iViewController3 : this.children) {
            if (!iViewController3.getViewName().equals(viewName)) continue;
            iViewController2 = iViewController3;
        }
        if (iViewController2 != null) {
            if (this.db.on()) {
                this.db.println("addChild replacing view controller " + iViewController2);
            }
            this.removeChild(iViewController2);
        }
        if (this.db.on()) {
            this.db.println("addChild " + iViewController);
        }
        this.children.add(iViewController);
    }

    public synchronized void removeChild(IViewController iViewController) {
        if (this.db.on()) {
            this.db.println("removeChild " + iViewController);
        }
        this.children.remove(iViewController);
        iViewController.destroy();
    }

    public IViewController findChild(ViewName viewName) {
        return null;
    }

    protected synchronized AbstractViewController locateVC(ViewName viewName) throws AbstractInvalidViewException {
        if (this.db.on()) {
            this.db.println("locateVC target=" + viewName);
        }
        for (AbstractViewController abstractViewController : this.children) {
            if (!abstractViewController.getViewName().contains(viewName)) continue;
            if (this.db.on()) {
                this.db.println("locateVC found " + abstractViewController.getViewName());
            }
            return abstractViewController;
        }
        AbstractViewController abstractViewController = this.createChildContainerVC(viewName);
        this.children.add(abstractViewController);
        if (this.db.on()) {
            this.db.println("locateVC created and mounted " + abstractViewController.getViewName());
        }
        return abstractViewController;
    }

    public AbstractViewController createChildContainerVC(ViewName viewName) throws AbstractInvalidViewException {
        this.throwInvalidViewException(viewName + " doesn't exist!");
        return null;
    }

    public String[][] getCurTabHierarchy() {
        String[][] stringArray = new String[][]{};
        if (this.getCurrentTabbedView() != null) {
            stringArray = this.getCurrentTabbedView().getTabHierarchy();
        } else if (this.db.on()) {
            this.db.println("avc::getCurTabHierarchy: cur tabbed view is still null");
        }
        return stringArray;
    }

    private void switchToTab(ViewName viewName) {
        if (this.db.on()) {
            this.db.println("AVC.switchToTab: switch to " + viewName);
        }
        if (viewName.getSubTabs().length != 0) {
            this.getTabbedView().changeTab(viewName.getSubTabs());
        }
    }

    public void printView(int n) throws Exception {
        if (this.getCurrentView() == null) {
            return;
        }
        if (this.viewName.equals(this.getCurrentView())) {
            if (viewHelper == null) {
                viewHelper = ViewHelper.instance(this.uiToolkit);
            }
            viewHelper.printView(this, n);
        } else {
            AbstractViewController abstractViewController = this.locateVC(this.getCurrentView());
            abstractViewController.printView(n);
        }
    }

    public void exportView(int n, JTable[] jTableArray, String string, String string2) throws Exception {
        if (this.getCurrentView() == null) {
            return;
        }
        if (this.viewName.equals(this.getCurrentView())) {
            if (viewHelper == null) {
                viewHelper = ViewHelper.instance(this.uiToolkit);
            }
            viewHelper.exportView(this, n, jTableArray, string, string2);
        } else {
            AbstractViewController abstractViewController = this.locateVC(this.getCurrentView());
            abstractViewController.exportView(n, jTableArray, string, string2);
        }
    }

    public void exportView(int n) throws Exception {
        if (this.getCurrentView() == null) {
            return;
        }
        if (this.viewName.equals(this.getCurrentView())) {
            if (viewHelper == null) {
                viewHelper = ViewHelper.instance(this.uiToolkit);
            }
            viewHelper.exportView(this, n);
        } else {
            AbstractViewController abstractViewController = this.locateVC(this.getCurrentView());
            abstractViewController.exportView(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewName getBackView() {
        LinkedList linkedList = history;
        synchronized (linkedList) {
            if (this.hasBackView()) {
                return (ViewName)history.get(--histCursor);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewName getForwardView() {
        LinkedList linkedList = history;
        synchronized (linkedList) {
            if (this.hasForwardView()) {
                return (ViewName)history.get(++histCursor);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repairHistory(ViewName viewName, ViewName viewName2) {
        if (this.db.on()) {
            this.db.println("repairHistory( " + viewName + "," + viewName2 + " )");
        }
        LinkedList linkedList = history;
        synchronized (linkedList) {
            for (int i = 0; i < history.size(); ++i) {
                ViewName viewName3 = (ViewName)history.get(i);
                if (!viewName3.strictlyEquals(viewName)) continue;
                history.set(i, viewName2);
            }
        }
    }

    protected void pruneHistory(ViewName viewName) {
        if (this.db.on()) {
            this.db.println("pruneHistory( " + viewName + " )");
        }
        this.pruneHistory(viewName, 0);
    }

    public void pruneHistory(int n) {
        if (this.db.on()) {
            this.db.println("pruneHistory( " + n + " )");
        }
        this.pruneHistory(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pruneHistory(ViewName viewName, int n) {
        LinkedList linkedList = history;
        synchronized (linkedList) {
            LinkedList<ViewName> linkedList2 = new LinkedList<ViewName>();
            int n2 = 0;
            int n3 = histCursor;
            for (Object object : history) {
                if (viewName != null && ((ViewName)object).strictlyEquals(viewName) || viewName == null && ((ViewName)object).getNodeId() == n) {
                    if (this.db.on()) {
                        this.db.println("   discarding " + object);
                    }
                    if (n2 <= n3) {
                        --histCursor;
                    }
                } else {
                    linkedList2.addLast((ViewName)object);
                }
                ++n2;
            }
            if (linkedList2.size() != history.size()) {
                history.clear();
                Object object = null;
                n2 = 0;
                for (ViewName viewName2 : linkedList2) {
                    if (object != null && viewName2.strictlyEquals((ViewName)object)) {
                        if (n2 > histCursor) continue;
                        --histCursor;
                        continue;
                    }
                    history.addLast(viewName2);
                    object = viewName2;
                    ++n2;
                }
                if (linkedList2.size() > 0 && histCursor < 0) {
                    histCursor = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repairHistory(int n, int n2) {
        if (this.db.on()) {
            this.db.println("repairHistory( " + n + "->" + n2 + " )");
        }
        LinkedList linkedList = history;
        synchronized (linkedList) {
            for (int i = 0; i < history.size(); ++i) {
                ViewName viewName = (ViewName)history.get(i);
                if (viewName.getNodeId() != n) continue;
                ViewName viewName2 = new ViewName(n2, viewName.getSlotId(), viewName.getPortId(), viewName.getSkinId(), viewName.getTabId());
                history.set(i, viewName2);
                if (!this.db.on()) continue;
                this.db.println("   replacing " + viewName);
            }
        }
    }

    protected INodeModel getNodeModel(int n) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNewView(ViewName viewName) {
        if (this.db.on()) {
            this.db.println("setNewView " + viewName);
        }
        LinkedList linkedList = history;
        synchronized (linkedList) {
            if (currentView != null && currentView.equals(viewName)) {
                return;
            }
            previousView = currentView;
            currentView = viewName;
            if (this.db.on()) {
                this.db.println("prev = " + previousView + " curr = " + currentView);
            }
            if (history.size() != 0) {
                ViewName viewName2;
                if (this.db.on()) {
                    this.db.println("setView - histCursor: " + histCursor + "; history.size(): " + history.size());
                }
                if ((viewName2 = (ViewName)history.get(histCursor)).equals(viewName)) {
                    return;
                }
                int n = histCursor + 1;
                while (n < history.size()) {
                    history.removeLast();
                }
            }
            history.add(viewName);
            if (history.size() > 20) {
                history.removeFirst();
            }
            histCursor = history.size() - 1;
        }
    }

    protected boolean hasBackView() {
        return history.size() > 0 && histCursor > 0;
    }

    protected boolean hasForwardView() {
        return history.size() > 0 && histCursor < history.size() - 1;
    }

    public void dumpHierarchy(String string, String string2) {
        String string3 = string + string2;
        for (IViewController iViewController : this.children) {
            this.db.println(string3 + iViewController.getViewName() + " (" + iViewController.getParentVC().getViewName() + ")");
            iViewController.dumpHierarchy(string, string3);
        }
    }

    public synchronized void dumpHierarchy(KDebug kDebug, String string) {
        if (string == null) {
            string = "";
        }
        kDebug.println(string + this.getViewName());
        string = string + "   ";
        for (AbstractViewController abstractViewController : this.children) {
            abstractViewController.dumpHierarchy(kDebug, string);
        }
    }

    public static void setActiveObject(Object object) {
        EventBus.instance().notifyEvent((Object)ACTIVE_OBJECT, object);
    }

    protected void checkForInvalidView(ViewName viewName) throws AbstractInvalidViewException {
    }

    public IUiToolkit getUiToolkit() {
        return this.uiToolkit;
    }
}

