/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.CircuitSize;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.KDebug;

public abstract class AbstractLoNum
implements ILoNum {
    static final int VT1_5_IN_VT_GROUP = 4;
    static final int VT2_IN_VT_GROUP = 3;
    static final int VT_GROUPS_IN_STS1 = 7;
    static final int VC3_IN_VC4 = 3;
    static final int TUG2_IN_VC3 = 7;
    static final int VC11_IN_TUG2 = 4;
    static final int VC12_IN_TUG2 = 3;
    static final int TUG2_IN_VC4 = 21;
    static final int VT1_5 = 0;
    static final int VC3 = 1;
    static final int VC11 = 2;
    static final int VC12 = 3;
    static final int VT2 = 4;
    protected int type;
    private volatile int hashCode = 0;
    protected static KDebug db = new KDebug("AbstractLoNum");

    protected AbstractLoNum(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public abstract int getLoVal();

    public abstract int getGroupNum();

    public abstract int getNumInGroup();

    public abstract int groupSize();

    public abstract int numOfGroups();

    public int _numOfGroups() {
        return 7;
    }

    public int numOfGroupsInVc3() {
        return this.numOfGroups() / this.getNumVc3();
    }

    public static int LastTug2Group() {
        return 7;
    }

    public static int LastTug2Group(int n) {
        return AbstractLoNum.LastTug2Group();
    }

    public int lastTug2Group() {
        return AbstractLoNum.LastTug2Group(-1);
    }

    public static int group2Vc3(int n) {
        return 1 + (n - 1) / 7;
    }

    public static int group2Tug2InVc3(int n) {
        return 1 + (n - 1) % 7;
    }

    public int _getTug2OrVtGroupNum() {
        return this.getGroupNum();
    }

    public short getTug2OrVtGroupNum() {
        return (short)this._getTug2OrVtGroupNum();
    }

    public int getGroupIncrementSize() {
        return 1;
    }

    public static int GetType(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 30: {
                n2 = 4;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 1;
            }
        }
        return n2;
    }

    public int getCorrespondingCircuitSize() {
        return AbstractLoNum.GetCorrespondingCircuitSize(this.type);
    }

    public static int GetCorrespondingCircuitSize(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 4: {
                return 30;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 1: {
                return 11;
            }
        }
        throw new IllegalStateException("The circuit type " + n + " is unknown.");
    }

    public static String GetTypeString(int n) {
        String string = "???";
        switch (n) {
            case 0: {
                string = "VT1_5";
                break;
            }
            case 4: {
                string = "VT2";
                break;
            }
            case 2: {
                string = "VC11";
                break;
            }
            case 3: {
                string = "VC12";
                break;
            }
            case 1: {
                string = "VC3";
            }
        }
        return string;
    }

    public short getIdlGroupNum() {
        return (short)this.getGroupNum();
    }

    public short getIdlNumInGroup() {
        return (short)this.getNumInGroup();
    }

    public short getIdlFlatNum() {
        return (short)this.getLoVal();
    }

    public static boolean IsValidGroup(int n, int n2) {
        return n != 1 ? true : n2 % 7 == 1;
    }

    public static int GetGroupNum(int n, int n2) {
        return (n - 1) % n2 + 1;
    }

    public static int GetNumInGroup(int n, int n2) {
        return (n - 1) / n2 + 1;
    }

    public static int GetLoVal(int n, int n2, int n3) {
        return (n2 - 1) * n3 + n;
    }

    public boolean isCompatible(IHoNum iHoNum) {
        return this.getFramingType() == iHoNum.getFramingType();
    }

    public boolean equals(Object object) {
        if (object instanceof ILoNum) {
            ILoNum iLoNum = (ILoNum)object;
            return this.getFramingType() == iLoNum.getFramingType() && this.getLoPathWidth() == iLoNum.getLoPathWidth() && this.getIdlGroupNum() == iLoNum.getIdlGroupNum() && this.getIdlNumInGroup() == iLoNum.getIdlNumInGroup();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + this.getFramingType();
            n = 37 * n + this.getLoPathWidth();
            n = 37 * n + this.getIdlGroupNum();
            this.hashCode = n = 37 * n + this.getIdlNumInGroup();
        }
        return this.hashCode;
    }

    public int compareTo(Object object) {
        int n;
        if (object == null) {
            n = 1;
        } else if (object instanceof ILoNum) {
            ILoNum iLoNum = (ILoNum)object;
            n = this.getFramingType() - iLoNum.getFramingType();
        } else {
            throw new ClassCastException("The object type " + object.getClass().getName() + "is not supported for comparisons.");
        }
        return n;
    }

    public static int compareByType(ILoNum iLoNum, ILoNum iLoNum2) {
        int n;
        if (iLoNum == null && iLoNum2 == null) {
            n = 0;
        } else if (iLoNum != null && iLoNum2 == null) {
            n = -1;
        } else if (iLoNum == null && iLoNum2 != null) {
            n = 1;
        } else {
            n = iLoNum.getFramingType() - iLoNum2.getFramingType();
            if (n == 0) {
                n = iLoNum.getLoPathWidth() - iLoNum2.getLoPathWidth();
            }
        }
        return n;
    }

    public static int compareByGroup(ILoNum iLoNum, ILoNum iLoNum2) {
        int n;
        int n2;
        int n3 = 0;
        if (iLoNum == null && iLoNum2 != null) {
            n3 = -1;
        } else if (iLoNum != null && iLoNum2 == null) {
            n3 = 1;
        } else if ((iLoNum != null || iLoNum2 != null) && (n3 = AbstractLoNum.compareByType(iLoNum, iLoNum2)) == 0 && (n3 = (n2 = AbstractLoNum.vc3Num(iLoNum.getIdlGroupNum())) - (n = AbstractLoNum.vc3Num(iLoNum2.getIdlGroupNum()))) == 0 && (n3 = iLoNum.getIdlNumInGroup() - iLoNum2.getIdlNumInGroup()) == 0) {
            n3 = iLoNum.getIdlGroupNum() - iLoNum2.getIdlGroupNum();
        }
        return n3;
    }

    public static int compareByGroupIndustryMapped(ILoNum iLoNum, ILoNum iLoNum2) {
        int n;
        int n2;
        int n3 = 0;
        if (iLoNum == null && iLoNum2 != null) {
            n3 = -1;
        } else if (iLoNum != null && iLoNum2 == null) {
            n3 = 1;
        } else if ((iLoNum != null || iLoNum2 != null) && (n3 = AbstractLoNum.compareByType(iLoNum, iLoNum2)) == 0 && (n3 = (n2 = AbstractLoNum.vc3Num(iLoNum.getIdlGroupNum())) - (n = AbstractLoNum.vc3Num(iLoNum2.getIdlGroupNum()))) == 0 && (n3 = iLoNum.getIdlGroupNum() - iLoNum2.getIdlGroupNum()) == 0) {
            n3 = iLoNum.getIdlNumInGroup() - iLoNum2.getIdlNumInGroup();
        }
        return n3;
    }

    public static int vc3Num(int n) {
        int n2 = 1 + (n - 1) / 7;
        return n2;
    }

    public static boolean areSameType(ILoNum iLoNum, ILoNum iLoNum2) {
        boolean bl = true;
        if (iLoNum != null && iLoNum2 != null) {
            bl = AbstractLoNum.compareByType(iLoNum, iLoNum2) == 0;
        }
        return bl;
    }

    public boolean isSameTimeslot(ILoNum iLoNum) {
        AbstractLoNum abstractLoNum = (AbstractLoNum)iLoNum;
        return this.getGroupNum() == abstractLoNum.getGroupNum() && this.getNumInGroup() == abstractLoNum.getNumInGroup();
    }

    public String groupString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new Integer(this.getGroupNum()).toString());
        stringBuffer.append("-");
        stringBuffer.append(new Integer(this.getNumInGroup()).toString());
        return stringBuffer.toString();
    }

    public String toString() {
        return new Integer(this.getLoVal()).toString();
    }

    public String dumpString() {
        return "LoVal-" + this.getLoVal() + ":Group-" + this.getGroupNum() + ":NumInGroup-" + this.getNumInGroup() + ":Frame-" + this.getFramingType() + ":GroupSize-" + this.groupSize() + ":NumOfGroups-" + this.numOfGroups() + "\n\t" + this.prettyString();
    }

    public int getVc3() {
        return 1;
    }

    public short getVc3OrSts1() {
        return (short)this.getVc3();
    }

    public int getNumVc3() {
        return 1;
    }

    public int getCircuitSize() {
        return CircuitSize.width2sizeOfLoCircuit(this.getLoPathWidth()).getEnum();
    }

    public int getLoPathWidth() {
        return CircuitSize.getCircuitSize(this.getCorrespondingCircuitSize()).size2widthOfLoCircuit();
    }
}

