/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AbstractHoNum;

public class SdhAu3HoNum
extends AbstractHoNum {
    private int vc3;

    public SdhAu3HoNum(int n) {
        this.vc3 = n;
        this.validate();
    }

    private void validate() {
        if (this.vc3 <= 0) {
            throw new IllegalArgumentException("The VC3 must be a positive number.");
        }
    }

    public int getVc3Num() {
        return this.vc3;
    }

    public int getHoVal() {
        return this.getVc3Num();
    }

    public int getFramingType() {
        return 2;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            SdhAu3HoNum sdhAu3HoNum = (SdhAu3HoNum)object;
            n = this.vc3 - sdhAu3HoNum.vc3;
        }
        return n;
    }

    public String prettyString() {
        return "VC3=" + this.vc3;
    }

    public int toSonetSts() {
        return SdhAu3HoNum.GetSonetSts(this.vc3);
    }

    public static int GetSonetSts(int n) {
        return n;
    }

    public int getVc3() {
        return this.vc3;
    }

    public short getHoNum() {
        return (short)this.getVc3Num();
    }

    public int getAugNum() {
        return (this.vc3 - 1) / 3 + 1;
    }
}

