/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AbstractHoNum;

public class SdhAu4HoNum
extends AbstractHoNum {
    private int vc4;

    public SdhAu4HoNum(int n) {
        this.vc4 = n;
        this.validate();
    }

    private void validate() {
        if (this.vc4 <= 0) {
            throw new IllegalArgumentException("The VC4 must be a positive number.");
        }
    }

    public int getHoVal() {
        return this.vc4;
    }

    public int getFramingType() {
        return 1;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            SdhAu4HoNum sdhAu4HoNum = (SdhAu4HoNum)object;
            n = this.vc4 - sdhAu4HoNum.vc4;
        }
        return n;
    }

    public String prettyString() {
        return "VC4=" + this.vc4;
    }

    public int toSonetSts() {
        return SdhAu4HoNum.GetSonetSts(this.vc4);
    }

    public static int GetSonetSts(int n) {
        return SdhAu4HoNum.Vc4Num2Sts(n);
    }

    public int getVc4Num() {
        return this.vc4;
    }

    public short getHoNum() {
        return (short)this.getVc4Num();
    }
}

