/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AnnotatedException;
import cerent.util.IDebugCategory;
import cerent.util.IOriginLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SupplementalException
extends AnnotatedException {
    private SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
    private final Date creationDate = new Date();
    private final Thread creatingThread = Thread.currentThread();
    public static final int NET_NODE_ID = 0;
    private final int nodeId;
    private final IDebugCategory debugCategory;
    private final IOriginLevel originLevel;

    public SupplementalException(String string, Exception exception, IDebugCategory iDebugCategory, IOriginLevel iOriginLevel, int n) {
        super(string, exception);
        this.debugCategory = iDebugCategory;
        this.originLevel = iOriginLevel;
        this.nodeId = n;
    }

    public SupplementalException(String string, Exception exception, IDebugCategory iDebugCategory, IOriginLevel iOriginLevel) {
        this(string, exception, iDebugCategory, iOriginLevel, 0);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Thread getCreatingThread() {
        return this.creatingThread;
    }

    public IDebugCategory getDebugCategory() {
        return this.debugCategory;
    }

    public IOriginLevel getOriginLevel() {
        return this.originLevel;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String prettyString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = SupplementalException.prettyString(this, super.toString());
        stringBuffer.append("exception: ");
        stringBuffer.append(string);
        stringBuffer.append('\n');
        stringBuffer.append("creation date: ");
        stringBuffer.append(this.sdf.format(this.creationDate));
        stringBuffer.append('\n');
        stringBuffer.append("creating thread: ");
        stringBuffer.append(this.creatingThread.getName());
        stringBuffer.append('\n');
        stringBuffer.append("nodeId: ");
        stringBuffer.append(Integer.toString(this.nodeId));
        stringBuffer.append('\n');
        stringBuffer.append("debug category: ");
        stringBuffer.append(this.debugCategory);
        stringBuffer.append('\n');
        stringBuffer.append("originating level: ");
        stringBuffer.append(this.originLevel);
        if (bl) {
            stringBuffer.append('\n');
            stringBuffer.append(this.getStackTraceText());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStackTraceText() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        try {
            Throwable throwable = this.getTargetException(this.getChild());
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            Object var5_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        return stringWriter.toString();
    }

    public String toString() {
        return this.prettyString(false);
    }
}

