/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.Chart;
import com.klg.jclass.chart.ChartDataModel;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.data.IlvDataSource;
import ilog.views.chart.renderer.IlvBarChartRenderer;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

public class BarChart
extends Chart {
    public static final String[] TOOLTIP_STRING = new String[]{"To switch <b>2D/3D</b> Rendering", "SHIFT + ALT + left mouse button"};
    private IlvBarChartRenderer renderer = null;
    private IlvDataSource dataSource = null;
    private ChartDataModel datamodel;
    private BarStyle barStyle;

    public BarChart(BarStyle barStyle, boolean bl) {
        super(1);
        this.barStyle = barStyle;
        if (bl) {
            this.chart.getChartArea().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        if (!BarChart.this.chart.is3D() && mouseEvent.getClickCount() == 1 && mouseEvent.isAltDown() && mouseEvent.isShiftDown()) {
                            BarChart.this.renderer.setMode(1);
                            BarChart.this.chart.set3D(true);
                        } else if (BarChart.this.chart.is3D() && mouseEvent.getClickCount() == 1 && mouseEvent.isAltDown() && mouseEvent.isShiftDown()) {
                            if (BarChart.this.barStyle == BarStyle.STACKED) {
                                BarChart.this.renderer.setMode(1);
                            } else {
                                BarChart.this.renderer.setMode(2);
                            }
                            BarChart.this.chart.set3D(false);
                        }
                    }
                }
            });
            this.chart.getChartArea().setToolTipText(IlvSwingUtil.createMultiLineToolTipText((String[])TOOLTIP_STRING, (int)2));
        }
    }

    public BarChart(BarStyle barStyle) {
        this(barStyle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRenderer() {
        Object object = this.chart.getLock();
        synchronized (object) {
            if (this.dataSource == null) {
                if (this.chart.getRendererCount() > 0) {
                    this.chart.removeRenderer(this.chart.getRenderer(0));
                }
                return;
            }
            this.renderer = this.barStyle == BarStyle.STACKED ? new IlvBarChartRenderer(1) : new IlvBarChartRenderer(2);
            this.renderer.setStyles(this.datamodel.getStyles());
            this.renderer.setDataSource(this.dataSource);
            if (this.chart.getRendererCount() > 0) {
                this.chart.removeRenderer(this.chart.getRenderer(0));
            }
            this.chart.addRenderer((IlvChartRenderer)this.renderer);
            this.setOrigin(this.datamodel.getMin());
            this.chart.getYAxis(0).setDataRange(this.origin, this.datamodel.getMax());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(ChartDataModel chartDataModel) {
        if (chartDataModel != null) {
            this.datamodel = chartDataModel;
            this.dataSource = chartDataModel.getDataSource();
        } else {
            this.dataSource = null;
        }
        this.initRenderer();
        if (this.dataSource != null) {
            Object object = this.chart.getLock();
            synchronized (object) {
                this.chart.getXScale().setCategory(this.dataSource.getDataSet(0), false);
            }
        }
    }

    public IlvBarChartRenderer getRenderer() {
        return this.renderer;
    }

    public void setBarOverlap(int n) {
        this.renderer.setOverlap((double)n);
    }

    public void setBarWidth(int n) {
        this.renderer.setClusterWidth((double)n);
    }

    public void setBar100(boolean bl) {
        if (this.renderer.getMode() == 3) {
            this.renderer.setStacked100Percent(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXStepUnit(Double d, Double d2) {
        Object object = this.chart.getLock();
        synchronized (object) {
            this.chart.getXScale().setStepUnit(d, d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYStepUnit(Double d, Double d2) {
        Object object = this.chart.getLock();
        synchronized (object) {
            this.chart.getYScale(0).setStepUnit(d, d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BarStyle {
        STACKED,
        SUPERIMP;

    }
}

