/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.DetailedLog;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedLogPane;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.SortDirectionIconFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DetailedLogDialog
extends JDialog
implements ActionListener {
    public static final int MODE_OK_CANCEL = 1;
    public static final int MODE_HIDE_ROOT_DL = 2;
    private static final int PREF_WIDTH = 500;
    private static final Dimension PREF_DLP_SIZE = new Dimension(500, 200);
    private JLabel mainLabel;
    private DetailedLogPane dlp;
    private JButton bClose;
    private JButton bCancel;
    private JButton bDetails;
    private JButton bSave;
    private boolean detailsOn = false;
    private String errMsg;
    protected boolean cancelled;

    public DetailedLogDialog(Frame frame, String string, Icon icon, String string2, DetailedLog detailedLog, boolean bl, int n) {
        super(frame, string, true);
        this.init(icon, string2, detailedLog, bl, n);
        this.setLocationRelativeTo(frame);
    }

    public DetailedLogDialog(Dialog dialog, String string, Icon icon, String string2, DetailedLog detailedLog, boolean bl, int n) {
        super(dialog, string, true);
        this.init(icon, string2, detailedLog, bl, n);
        this.setLocationRelativeTo(dialog);
    }

    public DetailedLogDialog(Frame frame, String string, Icon icon, String string2, DetailedLog detailedLog, boolean bl) {
        this(frame, string, icon, string2, detailedLog, bl, 0);
    }

    public DetailedLogDialog(Dialog dialog, String string, Icon icon, String string2, DetailedLog detailedLog, boolean bl) {
        this(dialog, string, icon, string2, detailedLog, bl, 0);
    }

    public static DetailedLogDialog getMixedDetailedLogDialog(Frame frame, DetailedLog detailedLog) {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = 0;
        int n2 = 0;
        List list = detailedLog.getChildren();
        for (DetailedLog detailedLog2 : list) {
            if (detailedLog2.getType() == 3) {
                ++n;
                continue;
            }
            if (detailedLog2.getType() != 2) continue;
            ++n2;
        }
        if (n2 > 0) {
            string2 = "Warnings";
            detailedLog.setType(2);
        }
        if (n > 0) {
            string = "Errors";
            detailedLog.setType(3);
        }
        if (n > 0 && n2 > 0) {
            string3 = " & ";
        }
        detailedLog.setDesc(string + string3 + string2);
        boolean bl = n == 0 && n2 > 0;
        return new DetailedLogDialog(frame, bl ? "Warning" : "Error", (Icon)(bl ? CerentDialog.WARNING_ICON : CerentDialog.FATAL_ICON), bl ? "Provisioning Warning." : "Provisioning Error.", detailedLog, false);
    }

    protected void setMainLabel(String string) {
        WindowHelper.setLabelText(this.mainLabel, WindowHelper.toHtml(string));
    }

    protected void setCloseText(String string) {
        this.bClose.setText(string);
    }

    protected void setCloseEnabled(boolean bl) {
        if (bl) {
            this.setDefaultCloseOperation(2);
        }
        this.bClose.setEnabled(bl);
    }

    protected void setCancelEnabled(boolean bl) {
        this.bCancel.setEnabled(bl);
    }

    protected void updateDetailedLog(DetailedLog detailedLog, boolean bl) {
        this.dlp.updateDetailedLog(detailedLog, bl);
    }

    protected void addDetailedLog(DetailedLog detailedLog, boolean bl) {
        this.dlp.addDetailedLog(detailedLog, bl);
    }

    private void init(Icon icon, String string, DetailedLog detailedLog, boolean bl, int n) {
        Object object;
        Container container = this.getContentPane();
        this.errMsg = string;
        this.dlp = new DetailedLogPane(null, false, false);
        if ((n & 2) == 0) {
            this.dlp.addDetailedLog(detailedLog, false);
        } else {
            object = detailedLog.getChildren().iterator();
            while (object.hasNext()) {
                this.dlp.addDetailedLog((DetailedLog)object.next(), false);
            }
        }
        container.setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).insets = new Insets(10, 10, 10, 10);
        this.mainLabel = new JLabel(WindowHelper.toHtml(string), icon, 10);
        container.add((Component)this.mainLabel, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).anchor = 13;
        ((GridBagConstraints)object).insets = new Insets(5, 10, 0, 10);
        this.bClose = (n & 1) == 0 ? new JButton("Close") : new JButton("OK");
        this.bClose.addActionListener(this);
        this.bDetails = new JButton();
        this.bDetails.addActionListener(this);
        this.bSave = new JButton("Save...");
        this.bSave.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 1));
        jPanel.add(this.bDetails);
        jPanel.add(this.bClose);
        if ((n & 1) != 0) {
            this.bCancel = new JButton("Cancel");
            this.bCancel.addActionListener(this);
            jPanel.add(this.bCancel);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "East");
        jPanel2.add((Component)new JLabel(" "), "North");
        jPanel2.add((Component)this.bSave, "West");
        container.add((Component)jPanel2, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).anchor = 10;
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(500));
        container.add((Component)box, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).anchor = 10;
        ((GridBagConstraints)object).insets = new Insets(1, 1, 1, 1);
        this.detailsOn = bl;
        this.dlp.setVisible(this.detailsOn);
        this.bSave.setVisible(this.detailsOn);
        this.dlp.setPreferredSize(PREF_DLP_SIZE);
        this.dlp.setBorder(BorderFactory.createLoweredBevelBorder());
        container.add((Component)this.dlp, object);
        this.updateDetailsButton();
        this.setResizable(true);
        this.pack();
        this.setDefaultCloseOperation(2);
        if ((n & 1) != 0) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    DetailedLogDialog.this.cancelled = true;
                }
            });
        }
    }

    private void toggleDetails() {
        this.detailsOn = !this.detailsOn;
        int n = this.dlp.getSize().height;
        if (n == 0) {
            n = this.dlp.getPreferredSize().height;
        }
        this.dlp.setVisible(this.detailsOn);
        this.bSave.setVisible(this.detailsOn);
        this.updateDetailsButton();
        Dimension dimension = this.getSize();
        if (this.detailsOn) {
            this.setSize(dimension.width, dimension.height + n);
        } else {
            this.setSize(dimension.width, dimension.height - n);
        }
        this.doLayout();
    }

    private void updateDetailsButton() {
        this.bDetails.setIcon(SortDirectionIconFactory.getIcon(this.detailsOn));
        if (this.detailsOn) {
            this.bDetails.setText("Hide Details");
        } else {
            this.bDetails.setText("Show Details");
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bDetails) {
            this.toggleDetails();
        } else if (actionEvent.getSource() == this.bSave) {
            this.dlp.saveToFile("Save Detailed Error Dialog to File", "Select the file where the error message will be saved to", "ctc.dialog.dl", "save", this.errMsg);
        } else if (actionEvent.getSource() == this.bClose) {
            this.dispose();
        } else if (actionEvent.getSource() == this.bCancel) {
            this.setCancelled();
        }
    }

    public void setCancelled() {
        this.cancelled = true;
        this.dispose();
    }

    public void show() {
        CerentDialog.addVisibleDialog(this);
        super.show();
    }
}

