/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.model.IIosModule;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOSConsoleDisabledException;
import cerent.util.EID;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.TelnetTextAreaAppender;
import cerent.util.terminal.IDataProcessor;
import cerent.util.terminal.IReaderThread;
import cerent.util.terminal.SshReaderThread;
import cerent.util.terminal.TelnetReaderThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class IOSTelnetFrame
extends JFrame
implements IDataProcessor,
ActionListener {
    private static final int WELL_KNOWN_TELNET_PORT = 23;
    private static final int WELL_KNOWN_SSH_PORT = 22;
    private static final int NON_SECURE_PORT_OFFSET = 2000;
    private static final int SECURE_PORT_OFFSET = 4000;
    private static final byte NUL = 0;
    private static final byte LF = 10;
    private static final byte CR = 13;
    private static final byte BEL = 7;
    private static final byte BS = 8;
    private static final byte HT = 9;
    private static final byte VT = 11;
    private static final byte FF = 12;
    private static final byte PREVIOUS_KEY = 16;
    private static final byte NEXT_KEY = 14;
    protected static KDebug db = new KDebug("IOSTelnetFrame");
    private static final HashMap allInstances = new HashMap();
    private String host;
    protected String nodeName = null;
    protected int port = 23;
    private IModuleModel moduleModel = null;
    private JScrollPane jScrollPane;
    private ForwardKeyTextArea textArea;
    private TelnetTextAreaAppender textAreaAppender;
    private boolean connected = false;
    private IReaderThread readerThread;
    protected boolean secure = false;
    protected boolean closing = false;
    private byte[] data;
    private int read;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOSTelnetFrame instance(IModuleModel iModuleModel) throws IOSConsoleDisabledException {
        Object object;
        IOSTelnetFrame iOSTelnetFrame = null;
        boolean bl = false;
        if (iModuleModel instanceof IIosModule) {
            object = (IIosModule)((Object)iModuleModel);
            if (!object.isConsoleEnabled()) {
                throw new IOSConsoleDisabledException();
            }
            bl = object.isConsoleSecure();
        }
        object = allInstances;
        synchronized (object) {
            iOSTelnetFrame = (IOSTelnetFrame)allInstances.get(iModuleModel);
            if (null == iOSTelnetFrame) {
                if (IOSTelnetFrame.db.on) {
                    db.println("Creating a new instance...");
                }
                iOSTelnetFrame = new IOSTelnetFrame(iModuleModel, bl);
                allInstances.put(iModuleModel, iOSTelnetFrame);
            } else if (IOSTelnetFrame.db.on) {
                db.println("Using recycled instance...");
            }
        }
        return iOSTelnetFrame;
    }

    protected IOSTelnetFrame() {
    }

    private IOSTelnetFrame(IModuleModel iModuleModel, boolean bl) {
        this(iModuleModel.getNodeModel().getHostName(), iModuleModel.getSlot(), bl);
        this.moduleModel = iModuleModel;
        this.nodeName = iModuleModel.getNodeModel().getName();
        if (IOSTelnetFrame.db.on) {
            db.finest("Node model is: " + iModuleModel.getNodeModel());
            db.finest("Node name is: " + iModuleModel.getNodeModel().getName());
        }
    }

    private IOSTelnetFrame(String string, short s, boolean bl) {
        this(string, -1, bl);
        this.port = s;
    }

    private IOSTelnetFrame(String string, int n, boolean bl) {
        this.host = string;
        this.port = n == -1 ? (bl ? 22 : 23) : (bl ? 4000 + n : 2000 + n);
        this.initFrame(string, bl);
    }

    protected void initFrame(String string, boolean bl) {
        this.host = string;
        this.secure = bl;
        if (IOSTelnetFrame.db.on) {
            db.println("host is: " + string + " and port is: " + this.port);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (IOSTelnetFrame.db.on) {
                    db.finer("windowClosing");
                }
                IOSTelnetFrame.this.closing = true;
                IOSTelnetFrame.this.setVisible(false);
                IOSTelnetFrame.this.disconnect();
                IOSTelnetFrame.this.dispose();
            }
        });
        TelnetKeyProcessor telnetKeyProcessor = new TelnetKeyProcessor(this);
        this.textArea = new ForwardKeyTextArea(35, 120, telnetKeyProcessor);
        Font font = new Font("Monospaced", 0, 12);
        this.textArea.setFont(font);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.textAreaAppender = new TelnetTextAreaAppender(this.textArea);
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 10));
        JButton jButton = new JButton("Close");
        jButton.setActionCommand("closeButton");
        jButton.addActionListener(this);
        jButton.setRequestFocusEnabled(false);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Clear");
        jButton2.setActionCommand("clearButton");
        jButton2.addActionListener(this);
        jButton2.setRequestFocusEnabled(false);
        jPanel.add(jButton2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setActionCommand("exitMenuItem");
        jMenuItem.addActionListener(this);
        jMenuItem.setMnemonic(88);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        JMenuItem jMenuItem2 = new JMenuItem("Copy");
        jMenuItem2.setActionCommand("copyMenuItem");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setMnemonic(67);
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Paste");
        jMenuItem3.setActionCommand("pasteMenuItem");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setMnemonic(80);
        jMenu2.add(jMenuItem3);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        if (db.on()) {
            db.println("Finished initing, attempting to connect...");
        }
        this.attemptToConnect();
    }

    protected void attemptToConnect() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            if (db.on()) {
                db.println("IOException caught trying to connect: " + iOException);
            }
            String string = KErrorMsg.getString((EID)KEMC.EID_IOS_TELNET_CONNECT_FAILURE);
            CerentDialog.errorDialog(this, string);
            this.closing = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    protected String getFrameTitle() {
        if (this.nodeName != null) {
            return this.nodeName + ", slot " + Integer.toString(this.port - (this.secure ? 4000 : 2000));
        }
        return this.host + ", port " + Integer.toString(this.port);
    }

    public void setVisible(boolean bl) {
        this.setTitle(this.getFrameTitle());
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IOSTelnetFrame.this.textArea.requestFocus();
                }
            });
        }
        super.setVisible(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (IOSTelnetFrame.db.on) {
            db.println("dispose called.");
        }
        this.disconnect();
        HashMap hashMap = allInstances;
        synchronized (hashMap) {
            if (null != this.moduleModel) {
                allInstances.remove(this.moduleModel);
            }
        }
        super.dispose();
    }

    public void terminated(Object object) {
        db.println("terminated called");
        this.dispose();
        if (!this.closing) {
            CerentDialog.errorDialog(this, KErrorMsg.getString((EID)KEMC.EID_IOS_TELNET_SESSION_TERMINATED));
        }
    }

    public synchronized void connect() throws IOException {
        if (IOSTelnetFrame.db.on) {
            db.println("connect called");
        }
        if (this.readerThread == null) {
            try {
                this.readerThread = this.createReaderThread();
                this.readerThread.connect(this.host, this.port, this.retrieveUserName(), "", this, true);
                this.connected = true;
            }
            catch (IOException iOException) {
                this.disconnect();
                throw iOException;
            }
        }
    }

    protected IReaderThread createReaderThread() {
        if (this.secure) {
            return new SshReaderThread();
        }
        return new TelnetReaderThread();
    }

    protected String retrieveUserName() {
        return "";
    }

    public IReaderThread getReaderThread() {
        return this.readerThread;
    }

    public synchronized void disconnect() {
        if (IOSTelnetFrame.db.on) {
            db.println("disconnect called.");
        }
        if (this.readerThread != null) {
            this.connected = false;
            try {
                this.readerThread.disconnect();
                this.readerThread = null;
            }
            catch (IOException iOException) {
                CerentDialog.errorDialog(this, KErrorMsg.getString((EID)KEMC.EID_TERMINAL_DISCONNECT_EXCEPTION, (Object)this.getIOSConnectionType()));
            }
        }
    }

    protected String getIOSConnectionType() {
        return "IOS";
    }

    private boolean hasByte(byte[] byArray, int n, byte by) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int findByte(byte by) {
        int n = -1;
        for (int i = 0; i < this.read; ++i) {
            if (this.data[i] != by) continue;
            n = i;
            break;
        }
        return n;
    }

    private int findSpecialChar() {
        int n = -1;
        for (int i = 0; i < this.read; ++i) {
            if (this.data[i] != 8 && this.data[i] != 7 && this.data[i] != 0 && this.data[i] != 12) continue;
            n = i;
            break;
        }
        if (IOSTelnetFrame.db.on) {
            db.finest("scanning for special char - read is: " + this.read + "  found at: " + n);
        }
        return n;
    }

    public void incomingData(byte[] byArray, int n, byte[] byArray2, int n2, Object object) {
        this.data = byArray;
        this.read = n;
        int n3 = 0;
        n3 = this.findSpecialChar();
        if (IOSTelnetFrame.db.on) {
            db.finest("\n\nEntering incomingData with string: " + this.stringifyDataArray());
        }
        if (n3 == -1) {
            String string = new String(this.data, 0, this.read);
            this.textAreaAppender.append(string);
            if (IOSTelnetFrame.db.on) {
                db.finest("---- appended text: " + this.stringifyDataArray());
            }
        } else {
            if (IOSTelnetFrame.db.on) {
                db.finest("initial currentIndex is: " + n3 + "   and read is: " + this.read);
            }
            while (this.read > 0 && n3 < this.read && n3 != -1) {
                if (n3 > 0) {
                    this.appendUpTo(n3);
                }
                if (this.data[0] == 8) {
                    this.processBS();
                } else if (this.data[0] == 7) {
                    this.processBEL();
                } else if (this.data[0] == 12) {
                    this.processFF();
                } else if (this.data[0] == 0) {
                    this.processNUL();
                }
                n3 = this.findSpecialChar();
            }
            if (this.read > 0) {
                String string = new String(this.data, 0, this.read);
                this.textAreaAppender.append(string);
                if (IOSTelnetFrame.db.on) {
                    db.finest("strigified text is: " + this.stringifyDataArray());
                    db.finest("----- appended text: " + string);
                }
            }
            Thread.currentThread();
            Thread.yield();
        }
        if (IOSTelnetFrame.db.on) {
            db.finest("============= exiting incomingData ==========");
        }
    }

    private void appendUpTo(int n) {
        if (IOSTelnetFrame.db.on) {
            db.finest("appendUpTo(" + n + ")");
        }
        if (this.read > 0 && n < this.read) {
            String string = new String(this.data, 0, n);
            this.textAreaAppender.append(string);
            if (IOSTelnetFrame.db.on) {
                db.finest("------ appended text: " + this.stringifyDataArray());
            }
            this.removeLeftmostChars(n);
        }
    }

    private String stringifyDataArray() {
        String string = new String(this.data, 0, this.read);
        string = string + " [";
        for (int i = 0; i < this.read; ++i) {
            string = string + this.data[i] + ", ";
        }
        string = string + "]";
        return string;
    }

    private void removeLeftmostChars(int n) {
        if (n > this.read) {
            if (IOSTelnetFrame.db.on) {
                db.println("removeLeftmostChars called with TOO MANY !!");
            }
        } else {
            for (int i = 0; i < this.read - n; ++i) {
                this.data[i] = this.data[i + n];
            }
            this.read -= n;
        }
    }

    private void processBS() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (IOSTelnetFrame.db.on) {
            db.finest("in processBS with string: " + this.stringifyDataArray());
        }
        while (this.read > 0 && this.data[0] == 8) {
            if (this.data[0] == 8) {
                ++n2;
            }
            if (IOSTelnetFrame.db.on) {
                db.finest("removing leftmost 1 character from: " + this.stringifyDataArray());
            }
            this.removeLeftmostChars(1);
        }
        if (IOSTelnetFrame.db.on) {
            db.finest("    BS chars: " + n2);
        }
        n = n2;
        if (n2 % 2 != 0 && IOSTelnetFrame.db.on) {
            db.println("BScount is not even (" + n2 + ")");
        }
        if (n > 0) {
            this.textAreaAppender.backspace(n);
        }
    }

    private void processBEL() {
        this.removeLeftmostChars(1);
        Toolkit.getDefaultToolkit().beep();
        if (IOSTelnetFrame.db.on) {
            db.finest("\n\nDING!!!\n\n");
        }
    }

    private void processFF() {
        this.removeLeftmostChars(1);
        this.textAreaAppender.clear();
    }

    private void processNUL() {
        this.removeLeftmostChars(1);
    }

    public static void main(String[] stringArray) {
        IOSTelnetFrame iOSTelnetFrame = null;
        if (stringArray.length < 1) {
            System.out.println("Please provide a hostname and optional port for this telnet session...");
            System.exit(8);
        } else {
            int n;
            block13: {
                String string;
                boolean bl;
                if (stringArray.length == 3 && stringArray[0].equalsIgnoreCase("-s")) {
                    bl = true;
                    String string2 = stringArray[1];
                    string = stringArray[2];
                } else if (stringArray.length == 2 && stringArray[0].equalsIgnoreCase("-s")) {
                    bl = true;
                    String string3 = stringArray[1];
                    string = null;
                } else if (stringArray.length == 2) {
                    bl = false;
                    String string4 = stringArray[0];
                    string = stringArray[1];
                } else {
                    bl = false;
                    String string5 = stringArray[0];
                    string = null;
                }
                if (string != null) {
                    try {
                        n = (short)Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Could not format argument into an integer: " + string);
                        if (bl) {
                            n = 22;
                            System.out.println("Using the well known SSH port instead (" + n + ")");
                            break block13;
                        }
                        n = 23;
                        System.out.println("Using the well known telnet port instead (" + n + ")");
                    }
                } else {
                    n = bl ? 22 : 23;
                }
            }
            iOSTelnetFrame = new IOSTelnetFrame(stringArray[0], n, false);
            iOSTelnetFrame.pack();
            iOSTelnetFrame.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("closeButton") || string.equals("exitMenuItem")) {
            this.closing = true;
            this.setVisible(false);
            this.dispose();
        } else if (string.equals("clearButton")) {
            this.textAreaAppender.clear();
        } else if (string.equals("copyMenuItem")) {
            this.textArea.copy();
        } else if (string.equals("pasteMenuItem")) {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(new Object());
            String string2 = "";
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {
                    db.println("Exception caught getting data from clipboard: " + exception);
                }
            } else if (IOSTelnetFrame.db.on) {
                db.println("DataFlavor.stringFlavor is NOT supported.");
            }
            try {
                this.readerThread.write(string2.getBytes());
            }
            catch (Exception exception) {
                db.println("Exception caught tyring to write the bytes that were pasted..." + exception);
            }
        }
    }

    private class TelnetKeyProcessor
    extends KeyAdapter {
        private IOSTelnetFrame iosTelnetFrame;

        public TelnetKeyProcessor(IOSTelnetFrame iOSTelnetFrame2) {
            this.iosTelnetFrame = iOSTelnetFrame2;
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (IOSTelnetFrame.db.on) {
                db.println("keyTyped event was: " + keyEvent);
                db.finest("      keyChar says: " + keyEvent.getKeyChar());
                db.finest("      keyChar as int is: " + keyEvent.getKeyChar());
                db.finest("      keyCode is: " + keyEvent.getKeyCode());
                db.finest("      keyText says: " + KeyEvent.getKeyText(keyEvent.getKeyCode()));
            }
            try {
                char c = keyEvent.getKeyChar();
                if (keyEvent.getKeyChar() == '\n') {
                    byte[] byArray = new byte[]{13, 10};
                    this.iosTelnetFrame.getReaderThread().write(byArray);
                } else if (keyEvent.isAltDown() && (c == 'e' || c == 'E' || c == 'f' || c == 'F')) {
                    if (IOSTelnetFrame.db.on) {
                        db.finest("ignoring Alt-E/F ...");
                    }
                } else {
                    this.iosTelnetFrame.getReaderThread().write(new byte[]{(byte)keyEvent.getKeyChar()});
                    if (IOSTelnetFrame.db.on) {
                        db.finest("sending >" + keyEvent.getKeyChar() + "< (keyCode was:" + keyEvent.getKeyCode() + ")");
                    }
                }
            }
            catch (IOException iOException) {
                if (IOSTelnetFrame.db.on) {
                    db.println("IOException caught writing to telnet stream.  " + iOException);
                }
                this.iosTelnetFrame.setVisible(false);
                this.iosTelnetFrame.dispose();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (IOSTelnetFrame.db.on) {
                db.println("keyPressed event was: " + keyEvent);
                db.finest("      keyChar says: " + keyEvent.getKeyChar());
                db.finest("      keyChar as int is: " + keyEvent.getKeyChar());
                db.finest("      keyCode is: " + keyEvent.getKeyCode());
                db.finest("      keyText says: " + KeyEvent.getKeyText(keyEvent.getKeyCode()));
            }
            try {
                if (keyEvent.getKeyCode() == 38) {
                    this.iosTelnetFrame.getReaderThread().write(new byte[]{16});
                } else if (keyEvent.getKeyCode() == 40) {
                    this.iosTelnetFrame.getReaderThread().write(new byte[]{14});
                }
            }
            catch (IOException iOException) {
                if (IOSTelnetFrame.db.on) {
                    db.println("IOException caught writing to telnet stream.  " + iOException);
                }
                this.iosTelnetFrame.setVisible(false);
                this.iosTelnetFrame.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    private class ForwardKeyTextArea
    extends JTextArea {
        private KeyListener keyListener;

        public ForwardKeyTextArea(int n, int n2, KeyListener keyListener) {
            super(n, n2);
            this.keyListener = keyListener;
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (this.keyListener != null) {
                int n = keyEvent.getID();
                switch (n) {
                    case 400: {
                        this.keyListener.keyTyped(keyEvent);
                        break;
                    }
                    case 401: {
                        this.keyListener.keyPressed(keyEvent);
                        break;
                    }
                    case 402: {
                        this.keyListener.keyReleased(keyEvent);
                    }
                }
            }
        }
    }
}

