/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.PersistentFileChooser;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class PersistentFileChooserPanel
extends JPanel
implements ActionListener {
    private JComboBox cb;
    private JCheckBox chkBx;
    private PersistentFileChooser pfc;
    private int mruMaxSize;
    private String prefix;
    private String arrayName;
    private boolean saveto;
    private FileFilter filter = null;
    private static String COMPLETE_DB = "Complete Database(System and Provisioning)";

    public PersistentFileChooserPanel(Object object, boolean bl, String string, String string2, int n, boolean bl2) {
        super(new BorderLayout(20, 30));
        JComponent jComponent;
        this.saveto = bl;
        if (n < 5) {
            n = 5;
        }
        this.mruMaxSize = n;
        if (object instanceof String) {
            jComponent = new JLabel(WindowHelper.toHtml((String)object));
            this.add((Component)jComponent, "North");
        } else if (object instanceof JComponent) {
            this.add((Component)((JComponent)object), "North");
        }
        jComponent = new JButton("Browse...");
        ((AbstractButton)jComponent).addActionListener(this);
        this.prefix = string;
        this.arrayName = string2;
        this.pfc = new PersistentFileChooser(this.prefix, this.arrayName);
        String[] stringArray = this.pfc.getFileNames();
        this.cb = new UComboBox();
        this.cb.setEditable(true);
        this.cb.setPreferredSize(new Dimension(400, jComponent.getPreferredSize().height));
        this.add((Component)jComponent, "East");
        this.add(this.cb);
        if (stringArray.length > 0) {
            this.setCurrentSelection(stringArray[0]);
        } else {
            this.setCurrentSelection(PersistentFileChooserDialog.nodename + "_" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + "_bc.txt");
        }
        this.chkBx = new JCheckBox(COMPLETE_DB, false);
        if (bl2) {
            this.add((Component)this.chkBx, "South");
        }
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 10));
    }

    public PersistentFileChooserPanel(Object object, boolean bl, String string, String string2, int n) {
        this(object, bl, string, string2, n, false);
    }

    public PersistentFileChooserPanel(String string, boolean bl, String string2, String string3, int n) {
        this(string, bl, string2, string3, n, false);
    }

    public String getSelectedFileName() {
        String string = this.cb.getEditor().getItem().toString();
        string = string.trim();
        this.setCurrentSelection(string);
        return string;
    }

    public boolean isCompleteSelected() {
        return this.chkBx.isSelected();
    }

    public void initCombo() {
        if (this.cb != null) {
            this.cb.insertItemAt(this.makeObj(""), 0);
            this.cb.setSelectedIndex(0);
            this.cb.updateUI();
        }
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    public void clearCombo() {
        if (this.cb != null) {
            this.cb.removeAllItems();
            this.cb.updateUI();
        }
    }

    public void setEditable(boolean bl) {
        this.cb.setEditable(bl);
    }

    public void removeFileName(String string) {
        this.pfc.removeFileName(string);
        this.setCurrentSelection(null);
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    private void setCurrentSelection(String string) {
        String[] stringArray;
        if (string != null) {
            this.pfc.addFileName(string, true);
        }
        if ((stringArray = this.pfc.getFileNames()).length > this.mruMaxSize) {
            String[] stringArray2 = new String[this.mruMaxSize];
            System.arraycopy(stringArray, 0, stringArray2, 0, this.mruMaxSize);
            stringArray = stringArray2;
        }
        this.cb.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (this.cb.getItemCount() > 0) {
            this.cb.setSelectedIndex(0);
            this.cb.getEditor().selectAll();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.cb.getEditor().getItem().toString();
        string = string.trim();
        this.pfc.addFileName(string, true);
        File file = this.pfc.showFileChooser((Component)this, this.saveto, this.filter);
        if (file != null) {
            this.setCurrentSelection(file.getAbsolutePath());
        }
    }
}

