/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class UTableSorter
extends AbstractTableModel {
    private JTableHeader tableHeader;
    private TableModel tableModel;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Row[] viewToModel;
    private int[] modelToView;
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();

    public UTableSorter(TableModel tableModel) {
        this(tableModel, null);
    }

    public UTableSorter(TableModel tableModel, JTableHeader jTableHeader) {
        this.setTableHeader(jTableHeader);
        this.setTableModel(tableModel);
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    private void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    private boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int n) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Directive directive = (Directive)this.sortingColumns.get(i);
            if (directive.column != n) continue;
            return directive;
        }
        return Directive.NO_DIRECTIVE;
    }

    private Directive.Mode getSortingStatus(int n) {
        return this.getDirective(n).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    private void setSortingStatus(int n, Directive.Mode mode) {
        Directive directive = this.getDirective(n);
        if (directive != Directive.NO_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (mode != Directive.Mode.NOT_SORTED) {
            this.sortingColumns.add(new Directive(n, mode));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive == Directive.NO_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == Directive.Mode.DESCENDING, n2, this.sortingColumns.indexOf(directive));
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class clazz, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(clazz);
        } else {
            this.columnComparators.put(clazz, comparator);
        }
    }

    protected Comparator getComparator(int n) {
        Class<?> clazz = this.tableModel.getColumnClass(n);
        Comparator comparator = (Comparator)this.columnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Comparable)object).compareTo(object2);
                }
            };
        }
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        };
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int n = this.tableModel.getRowCount();
            this.viewToModel = new Row[n];
            for (int i = 0; i < n; ++i) {
                this.viewToModel[i] = new Row(i);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    private int modelIndex(int n) {
        Row[] rowArray = this.getViewToModel();
        if (n < rowArray.length) {
            return rowArray[n].modelIndex;
        }
        return -1;
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.modelIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.tableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.tableModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.isCellEditable(this.modelIndex(n), n2);
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.modelIndex(n);
        return this.tableModel.getValueAt(n3 != -1 ? n3 : n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, this.modelIndex(n), n2);
    }

    private static class Directive {
        public static Directive NO_DIRECTIVE = new Directive(-1, Mode.NOT_SORTED);
        private int column;
        private Mode direction;

        public Directive(int n, Mode mode) {
            this.column = n;
            this.direction = mode;
        }

        public static class Mode {
            private static final int _DESCENDING = -1;
            private static final int _NOT_SORTED = 0;
            private static final int _ASCENDING = 1;
            public static final Mode DESCENDING = new Mode(-1);
            public static final Mode NOT_SORTED = new Mode(0);
            public static final Mode ASCENDING = new Mode(1);
            private int _mode;

            private Mode(int n) {
                this._mode = n;
            }

            public Mode shiftUp() {
                int n = this._mode + 1;
                return Mode.from_int((n + 4) % 3 - 1);
            }

            public Mode shiftDown() {
                int n = this._mode - 1;
                return Mode.from_int((n + 4) % 3 - 1);
            }

            public static Mode from_int(int n) {
                switch (n) {
                    case -1: {
                        return DESCENDING;
                    }
                    case 1: {
                        return ASCENDING;
                    }
                }
                return NOT_SORTED;
            }
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                int n3 = jTable.convertColumnIndexToModel(n2);
                jLabel.setIcon(UTableSorter.this.getHeaderRendererIcon(n3, jLabel.getFont().getSize()));
            }
            return component;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean bl, int n, int n2) {
            this.descending = bl;
            this.size = n;
            this.priority = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component == null ? Color.GRAY : component.getBackground();
            int n3 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int n4 = this.descending ? n3 : -n3;
            n2 = n2 + 5 * this.size / 6 + (this.descending ? -n4 : 0);
            int n5 = this.descending ? 1 : -1;
            graphics.translate(n, n2);
            graphics.setColor(color.darker());
            graphics.drawLine(n3 / 2, n4, 0, 0);
            graphics.drawLine(n3 / 2, n4 + n5, 0, n5);
            graphics.setColor(color.brighter());
            graphics.drawLine(n3 / 2, n4, n3, 0);
            graphics.drawLine(n3 / 2, n4 + n5, n3, n5);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n3, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 != -1) {
                Directive.Mode mode = UTableSorter.this.getSortingStatus(n2);
                if (!mouseEvent.isControlDown()) {
                    UTableSorter.this.cancelSorting();
                }
                mode = mouseEvent.isShiftDown() ? mode.shiftDown() : mode.shiftUp();
                UTableSorter.this.setSortingStatus(n2, mode);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (!UTableSorter.this.isSorting()) {
                UTableSorter.this.clearSortingState();
                UTableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            if (tableModelEvent.getFirstRow() == -1) {
                UTableSorter.this.cancelSorting();
                UTableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            int n = tableModelEvent.getColumn();
            if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && n != -1 && UTableSorter.this.getSortingStatus(n) == Directive.Mode.NOT_SORTED && UTableSorter.this.modelToView != null) {
                int n2 = UTableSorter.this.getModelToView()[tableModelEvent.getFirstRow()];
                UTableSorter.this.fireTableChanged(new TableModelEvent(UTableSorter.this, n2, n2, n, tableModelEvent.getType()));
                return;
            }
            UTableSorter.this.clearSortingState();
            UTableSorter.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n) {
            this.modelIndex = n;
        }

        public int compareTo(Object object) {
            if (object instanceof Row) {
                int n = this.modelIndex;
                int n2 = ((Row)object).modelIndex;
                for (Directive directive : UTableSorter.this.sortingColumns) {
                    int n3 = directive.column;
                    Object object2 = UTableSorter.this.tableModel.getValueAt(n, n3);
                    Object object3 = UTableSorter.this.tableModel.getValueAt(n2, n3);
                    int n4 = 0;
                    n4 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : UTableSorter.this.getComparator(n3).compare(object2, object3)));
                    if (n4 == 0) continue;
                    return directive.direction == Directive.Mode.DESCENDING ? -n4 : n4;
                }
                return 0;
            }
            return 1;
        }
    }
}

