/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.KDebug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

class WindowsShortcutFileSystemView
extends FileSystemView {
    private FileSystemView other;
    private KDebug db = new KDebug("ShortcutFileSystemView");

    public WindowsShortcutFileSystemView(FileSystemView fileSystemView) {
        this.other = fileSystemView != null ? fileSystemView : FileSystemView.getFileSystemView();
    }

    public static boolean isLink(File file) {
        boolean bl = false;
        if (file instanceof ShellFolder) {
            ShellFolder shellFolder = (ShellFolder)file;
            Object var3_3 = null;
            if (shellFolder.isLink()) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isDirLink(File file) {
        boolean bl = false;
        if (WindowsShortcutFileSystemView.isLink(file)) {
            File file2 = WindowsShortcutFileSystemView.getLinkTarget(file);
            bl = file2 != null && file2.isDirectory();
        }
        return bl;
    }

    public static File getLinkTarget(File file) {
        File file2 = null;
        if (!(file instanceof ShellFolder)) {
            return null;
        }
        ShellFolder shellFolder = (ShellFolder)file;
        try {
            ShellFolder shellFolder2 = shellFolder.getLinkLocation();
            if (shellFolder2 != null) {
                file2 = shellFolder2.getCanonicalFile();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = fileNotFoundException.getMessage().replaceAll(" not found$", "");
            string = string.replaceAll("^File ", "");
            try {
                file2 = new File(string).getCanonicalFile();
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2;
    }

    public boolean isRoot(File file) {
        return this.other.isRoot(file);
    }

    public Boolean isTraversable(File file) {
        return WindowsShortcutFileSystemView.isDirLink(file) || this.other.isTraversable(file).equals(Boolean.TRUE);
    }

    public String getSystemDisplayName(File file) {
        return this.other.getSystemDisplayName(file);
    }

    public String getSystemTypeDescription(File file) {
        return this.other.getSystemTypeDescription(file);
    }

    public Icon getSystemIcon(File file) {
        return this.other.getSystemIcon(file);
    }

    public boolean isParent(File file, File file2) {
        return this.other.isParent(file, file2);
    }

    public File getChild(File file, String string) {
        return this.other.getChild(file, string);
    }

    public boolean isFileSystem(File file) {
        return this.other.isFileSystem(file);
    }

    public File createNewFolder(File file) throws IOException {
        return this.other.createNewFolder(file);
    }

    public boolean isHiddenFile(File file) {
        return this.other.isHiddenFile(file);
    }

    public boolean isFileSystemRoot(File file) {
        return this.other.isFileSystemRoot(file);
    }

    public boolean isDrive(File file) {
        return this.other.isDrive(file);
    }

    public boolean isFloppyDrive(File file) {
        return this.other.isFloppyDrive(file);
    }

    public boolean isComputerNode(File file) {
        return this.other.isComputerNode(file);
    }

    public File[] getRoots() {
        return this.other.getRoots();
    }

    public File getHomeDirectory() {
        return this.other.getHomeDirectory();
    }

    public File getDefaultDirectory() {
        return this.other.getDefaultDirectory();
    }

    public File createFileObject(File file, String string) {
        return this.other.createFileObject(file, string);
    }

    public File createFileObject(String string) {
        return this.other.createFileObject(string);
    }

    public File[] getFiles(File file, boolean bl) {
        if (WindowsShortcutFileSystemView.isDirLink(file)) {
            file = WindowsShortcutFileSystemView.getLinkTarget((ShellFolder)file);
        }
        List<File> list = Arrays.asList(super.getFiles(file, bl));
        Iterator<File> iterator = list.iterator();
        Vector<File> vector = new Vector<File>();
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            if (WindowsShortcutFileSystemView.isLink(file2)) {
                File file3 = WindowsShortcutFileSystemView.getLinkTarget(file2);
                if (file3 == null) continue;
                vector.add(file2);
                continue;
            }
            vector.add(file2);
        }
        return vector.toArray(new File[0]);
    }

    public File getParentDirectory(File file) {
        return this.other.getParentDirectory(file);
    }
}

