/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui.row;

import javax.swing.table.AbstractTableModel;

public class TableUpdateLogic {
    private static final int TABLE_END = -1;
    private Range range = new Range();
    private boolean dataChanged;

    public TableUpdateLogic() {
        this.reset();
    }

    public void rowAdded(int n) {
        if (!this.dataChanged) {
            this.range.rowInserted(n);
        }
    }

    public void rowRemoved(int n) {
        if (!this.dataChanged) {
            this.range.rowDeleted(n);
        }
    }

    public void rowUpdated(int n) {
        if (!this.dataChanged) {
            this.range.rowUpdated(n);
        }
    }

    public void tableDataChanged() {
        this.dataChanged = true;
    }

    public boolean hasTableDataChanged() {
        return this.dataChanged;
    }

    public void updateView(AbstractTableModel abstractTableModel) {
        int n = abstractTableModel.getRowCount();
        if (this.dataChanged || n == 0) {
            abstractTableModel.fireTableDataChanged();
        } else if (!this.range.empty) {
            if (this.range.delta > 0) {
                abstractTableModel.fireTableRowsInserted(this.range.low, this.range.low + this.range.delta - 1);
            } else if (this.range.delta < 0) {
                abstractTableModel.fireTableRowsDeleted(this.range.low, this.range.low - this.range.delta - 1);
            } else {
                if (this.range.high == -1) {
                    this.range.high = n - 1;
                }
                abstractTableModel.fireTableRowsUpdated(this.range.low, this.range.high);
            }
        }
        this.reset();
    }

    private void reset() {
        this.dataChanged = false;
        this.range.reset();
    }

    class Range {
        int high;
        int low;
        int delta;
        boolean empty;

        Range() {
            this.reset();
        }

        void reset() {
            this.empty = true;
        }

        void rowInserted(int n) {
            if (this.empty) {
                this.empty = false;
                this.low = n;
                this.delta = 1;
                this.high = -1;
            } else {
                if (n < this.low) {
                    this.low = n;
                }
                ++this.delta;
            }
        }

        void rowDeleted(int n) {
            if (this.empty) {
                this.empty = false;
                this.low = n;
                this.high = -1;
                this.delta = -1;
            } else {
                if (n < this.low) {
                    this.low = n;
                }
                --this.delta;
            }
        }

        void rowUpdated(int n) {
            if (this.empty) {
                this.empty = false;
                this.low = n;
                this.high = n;
                this.delta = 0;
            } else if (n < this.low) {
                this.low = n;
            } else if (this.high != -1 && n > this.high) {
                this.high = n;
            }
        }
    }
}

