/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.terminal;

import cerent.util.KDebug;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.terminal.ConnectionException;
import cerent.util.terminal.DataWriteException;
import cerent.util.terminal.IDataProcessor;
import cerent.util.terminal.IReaderThread;
import cerent.util.terminal.ITelnetNegotiator;
import java.io.IOException;
import java.net.Socket;

public class TelnetReaderThread
implements IReaderThread {
    private boolean connected = false;
    private IDataProcessor client = null;
    private ITelnetNegotiator negotiator;
    private Socket socket;
    private Thread server = null;
    private KDebug db = new KDebug("TelnetReaderThread");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int BYTES_PER_LINE = 16;
    private static final int BYTES_PER_GROUP = 4;

    public TelnetReaderThread() {
        this(null);
        this.negotiator = new DefaultNegotiator();
    }

    public TelnetReaderThread(ITelnetNegotiator iTelnetNegotiator) {
        this.negotiator = iTelnetNegotiator;
    }

    public void connect(String string, int n, String string2, String string3, IDataProcessor iDataProcessor) throws ConnectionException {
        this.connect(string, n, string2, string3, iDataProcessor, false);
    }

    public void connect(String string, int n, String string2, String string3, IDataProcessor iDataProcessor, boolean bl) throws ConnectionException {
        if (string == null) {
            throw new IllegalArgumentException("The host cannot be null.");
        }
        if (iDataProcessor == null) {
            throw new IllegalArgumentException("The client cannot be null.");
        }
        this.client = iDataProcessor;
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (this.negotiator == null) {
            this.negotiator = new DefaultNegotiator();
        }
        this.db.fine("connect: " + string + ":" + n + " user=" + string2 + " pw=" + string3);
        try {
            this.socket = CtcProxyFactory.connect((String)string, (int)n).getSocket();
            this.socket.setKeepAlive(bl);
            this.socket.setSoTimeout(0);
            this.server = new Thread((Runnable)this, "TelnetReaderThread - " + string + ":" + n);
            this.server.start();
            this.setConnected();
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException);
        }
    }

    public void disconnect() throws ConnectionException {
        this.db.fine("disconnect called");
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.clearConnected();
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException);
        }
    }

    private synchronized void setConnected() {
        this.connected = true;
    }

    private synchronized void clearConnected() {
        this.connected = false;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public void write(String string) throws DataWriteException {
        this.write(string.getBytes());
    }

    public void write(byte[] byArray) throws DataWriteException {
        if (!this.isConnected()) {
            throw new DataWriteException("No connection is present.");
        }
        try {
            this.db.finest("called write");
            this.db.finest(TelnetReaderThread.toHexDump(byArray, 0, byArray.length));
            this.socket.getOutputStream().write(byArray);
        }
        catch (IOException iOException) {
            throw new DataWriteException(iOException);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws DataWriteException {
        if (!this.isConnected()) {
            throw new DataWriteException("No connection is present.");
        }
        try {
            this.db.finest("called write");
            this.db.finest(TelnetReaderThread.toHexDump(byArray, n, n2));
            this.socket.getOutputStream().write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new DataWriteException(iOException);
        }
    }

    private void sendClientData(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.db.fine("sendClientData: sending " + n2 + " bytes");
        this.db.finest(TelnetReaderThread.toHexDump(byArray2, 0, n2));
        this.client.incomingData(byArray2, n2, byArray2, 0, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int handleTelnetProtocol(byte[] byArray, int n) throws DataWriteException {
        block12: {
            boolean bl = false;
            while (n > 0) {
                if (bl) return 0;
                int n2 = this.findIAC(byArray, 0, n);
                if (n2 == 0) {
                    if (n2 + 1 >= n) return n;
                    int n3 = this.getCommandLength(byArray[n2 + 1]);
                    if (n3 == 2) {
                        switch (byArray[n2 + 1]) {
                            case -9: {
                                this.sendClientData(new byte[]{8}, 0, 1);
                                break;
                            }
                            case -1: {
                                this.sendClientData(new byte[]{-1}, 0, 1);
                                break;
                            }
                        }
                    } else if (n3 == 3) {
                        if (n2 + 2 >= n) return n;
                        this.write(this.negotiator.handleOption(new byte[]{byArray[n2 + 1], byArray[n2 + 2]}));
                    } else {
                        n3 = this.findSubNegEnd(byArray, n2 + 1, n);
                        if (n3 == -1) {
                            return n;
                        }
                    }
                    if (n <= n3) return 0;
                    System.arraycopy(byArray, n3, byArray, 0, n - n3);
                    n -= n3;
                    continue;
                }
                if (n2 > 0) {
                    this.sendClientData(byArray, 0, n2);
                    System.arraycopy(byArray, n2, byArray, 0, n - n2);
                    n -= n2;
                    continue;
                }
                break block12;
            }
            return 0;
        }
        this.sendClientData(byArray, 0, n);
        return 0;
    }

    private int findIAC(byte[] byArray, int n, int n2) {
        while (n < n2) {
            if (byArray[n] == -1) {
                this.db.fine("findIAC: found at " + n + " end = " + n2);
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getCommandLength(byte by) {
        int n;
        switch (by) {
            case -5: 
            case -4: 
            case -3: 
            case -2: {
                n = 3;
                break;
            }
            case -6: {
                n = -1;
                break;
            }
            default: {
                n = 2;
            }
        }
        return n;
    }

    private int findSubNegEnd(byte[] byArray, int n, int n2) {
        int n3 = this.findIAC(byArray, n, n2);
        while (n3 != -1) {
            if (n3 + 1 < n2 && byArray[n3 + 1] == -16) {
                return n3 + 2 - (n - 1);
            }
            n3 = this.findIAC(byArray, n3 + 1, n2);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block10: {
            byte[] byArray = new byte[4096];
            int n = 0;
            if (this.socket == null) {
                this.clearConnected();
            }
            while (this.isConnected()) {
                try {
                    int n2 = this.socket.getInputStream().read(byArray, n, 4096 - n);
                    this.db.fine("run: read " + n2 + " bytes at offset " + n);
                    this.db.finest(TelnetReaderThread.toHexDump(byArray, n, n2));
                    if (this.client != null && this.isConnected() && (n2 += n) > 0) {
                        n = this.handleTelnetProtocol(byArray, n2);
                        continue;
                    }
                    if (n2 != -1) continue;
                    this.db.info("run: length = -1, disconnecting");
                    this.clearConnected();
                }
                catch (IOException iOException) {
                    this.db.info("run: IOException, disconnecting");
                    if (this.db.on()) {
                        KDebug.printStackTrace((Throwable)iOException);
                    }
                    this.clearConnected();
                }
            }
            try {
                try {
                    this.db.fine("run: calling disconnect");
                    this.disconnect();
                }
                catch (ConnectionException connectionException) {
                    Object var7_7 = null;
                    this.db.fine("run: calling client.terminated()");
                    this.client.terminated(this);
                    break block10;
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.db.fine("run: calling client.terminated()");
                this.client.terminated(this);
                throw throwable;
            }
            this.db.fine("run: calling client.terminated()");
            this.client.terminated(this);
        }
        this.server = null;
    }

    private static String toHexDump(byte[] byArray, int n, int n2) {
        int n3;
        boolean bl = false;
        int n4 = n;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 / 16 > 0) {
            for (n4 = n; n4 < n2; n4 += 16) {
                TelnetReaderThread.writeHexLine(stringBuffer, byArray, n4, 16);
            }
            n4 -= 16;
        }
        if ((n3 = n2 % 16) != 0) {
            TelnetReaderThread.writeHexLine(stringBuffer, byArray, n4, n3);
        }
        return stringBuffer.toString();
    }

    private static void writeHexLine(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2; ++n3) {
            int n4 = (byArray[n3] & 0xF0) >> 4;
            int n5 = byArray[n3] & 0xF;
            stringBuffer.append(HEX_DIGITS[n4]);
            stringBuffer.append(HEX_DIGITS[n5]);
            stringBuffer.append(' ');
        }
        for (n3 = 0; n3 < 16 - n2; ++n3) {
            stringBuffer.append("   ");
        }
        for (n3 = n; n3 < n2; ++n3) {
            if (byArray[n3] > 31 && byArray[n3] < 127) {
                stringBuffer.append((char)byArray[n3]);
                continue;
            }
            stringBuffer.append('.');
        }
        stringBuffer.append('\n');
    }

    private class DefaultNegotiator
    implements ITelnetNegotiator {
        public byte[] handleOption(byte[] byArray) {
            byte by = byArray[0];
            byte[] byArray2 = new byte[byArray.length - 1];
            byte[] byArray3 = null;
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            switch (byArray[0]) {
                case -3: {
                    byArray3 = this.processDo(byArray2);
                    break;
                }
                case -2: {
                    byArray3 = this.processDont(byArray2);
                    break;
                }
                case -5: {
                    byArray3 = this.processWill(byArray2);
                    break;
                }
                case -4: {
                    byArray3 = this.processWont(byArray2);
                    break;
                }
                default: {
                    TelnetReaderThread.this.db.info("handleOption: unknown option -- " + Integer.toHexString(0 | byArray[0]));
                }
            }
            return byArray3;
        }

        private byte[] processDo(byte[] byArray) {
            TelnetReaderThread.this.db.fine("called processDo");
            if (byArray[0] == 3 || byArray[0] == 1) {
                return new byte[]{-1, -5, byArray[0]};
            }
            return new byte[]{-1, -4, byArray[0]};
        }

        private byte[] processDont(byte[] byArray) {
            TelnetReaderThread.this.db.fine("called processDont");
            return new byte[]{-1, -4, byArray[0]};
        }

        private byte[] processWill(byte[] byArray) {
            TelnetReaderThread.this.db.fine("called processWill");
            if (byArray[0] == 3 || byArray[0] == 1) {
                return new byte[]{-1, -3, byArray[0]};
            }
            return new byte[]{-1, -2, byArray[0]};
        }

        private byte[] processWont(byte[] byArray) {
            TelnetReaderThread.this.db.fine("called processWont");
            return new byte[]{-1, -2, byArray[0]};
        }
    }
}

