/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.CLIParsingUtils;
import cerent.util.tty.ICLIError;
import cerent.util.tty.ICLIXMLTags;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import cerent.util.tty.TTYSessionFactory;
import cerent.util.tty.TTYSessionsPool;
import java.io.IOException;

public class CLIAction
implements ICLIXMLTags {
    protected String hostname;
    protected static final String XML = "xml";
    protected static final String EXIT = "exit";
    protected static final String COMMIT = "commit";
    protected static final String CONTROLLER = "controller";
    protected static final String DWDM = "dwdm";
    protected static final String NO = "no";
    protected static final String SHUTDOWN = "shutdown";
    protected static final String SPACE = " ";
    protected static final String ENDL = "\r\n";
    protected static final String _PARAMETER_ = "_Parameter_";
    protected static final String _PARAMETER2_ = "_Parameter2_";
    protected static final String _SEND_ = "_Send_";
    private static final char ERROR_PROMPT = '^';
    private static final char UNAUTHORIZED_PROMPT = '%';
    protected CLICmdRsp[] cliCmd;

    protected CLIAction(String string) {
        this.hostname = string;
    }

    protected CLIAction(ITTYSession iTTYSession) {
        this.hostname = iTTYSession.getHostname();
    }

    protected boolean performActionFailFast(CLICmdRsp cLICmdRsp) throws IOException, TTYException {
        final Thread thread = Thread.currentThread();
        Thread thread2 = new Thread(){

            public void run() {
                try {
                    Thread.sleep(TTYSessionsPool.SESSION_TIMEOUT);
                    thread.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread2.start();
        try {
            boolean bl = this.performAction(cLICmdRsp);
            thread2.interrupt();
            return bl;
        }
        catch (Exception exception) {
            throw new TTYException("Unable to execute the requested command");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performAction(CLICmdRsp cLICmdRsp) throws IOException, TTYException {
        String string = null;
        boolean bl = false;
        ITTYSession iTTYSession = null;
        ICLIError[] iCLIErrorArray = null;
        try {
            iTTYSession = cLICmdRsp.isXml() ? TTYSessionFactory.instance().getSession(this.hostname, TTYSessionFactory.SessionType.XML) : TTYSessionFactory.instance().getSession(this.hostname, TTYSessionFactory.SessionType.CLI);
            string = iTTYSession.sendCommand(cLICmdRsp.getCommand());
            if (string.length() != 0) {
                if (cLICmdRsp.isXml()) {
                    int n;
                    int n2 = string.indexOf("<Response MajorVersion=\"1\" MinorVersion=\"0\">");
                    if ((string = string.substring(n2, n = string.indexOf("</Response>", n2) + "</Response>".length())).contains("ErrorCode=\"") && string.contains("ErrorMsg=\"")) {
                        iCLIErrorArray = CLIParsingUtils.getXmlErrors(string);
                        bl = true;
                    } else {
                        int n3 = string.indexOf("<CLI>");
                        if (n3 >= 0 && (n3 = string.indexOf("<Configuration>", n3)) >= 0) {
                            String string2 = string.substring(n3 + "<Configuration>".length(), string.indexOf("</Configuration>"));
                            if (string2.length() > 0) {
                                iCLIErrorArray = CLIParsingUtils.getErrors(CLIParsingUtils.convertXmlString(string2));
                            }
                            if (iCLIErrorArray.length > 0) {
                                bl = true;
                            }
                        }
                    }
                } else if (string.charAt(0) == '^' || string.charAt(0) == '%') {
                    iCLIErrorArray = CLIParsingUtils.getErrors(string);
                    bl = true;
                }
            }
            Object var11_10 = null;
            if (iTTYSession != null) {
                iTTYSession.releaseMe();
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (iTTYSession != null) {
                iTTYSession.releaseMe();
            }
            throw throwable;
        }
        cLICmdRsp.setCliError(iCLIErrorArray);
        cLICmdRsp.setResponse(string);
        cLICmdRsp.setError(bl);
        return bl;
    }

    public CLICmdRsp[] getCliCmdRspArray() {
        return this.cliCmd;
    }
}

