/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import com.cisco.crs.model.PlimPortId;
import java.io.IOException;

public class CLIDataLinkAction
extends CLIAction {
    private static final String _PORTID_ = "_PORTID_";
    private static final String _PORTTYPE_ = "_PORTTYPE_";
    private static final String _MGMTETH_ = "_MGMTETH_";
    private static final String _IPADDR_ = "_IPADDR_";
    private static final String _TELINKID_ = "_TELINKID_";
    private static final String _DATALINKID_ = "_DATALINKID_";
    private static final String _WLEN_ = "_WLEN_";
    private static final String _CREATE_IPSECTION_ = "_CREATE_IPSECTION_";
    private static final String _DELETE_IPSECTION_ = "_DELETE_IPSECTION_";
    private static final String PORTTYPE_TENGIGE = "TenGigE";
    private static final String PORTTYPE_POS = "POS";
    private static final String CREATE_TENGIGE_IPSECTION = "interface TenGigE _PORTID_ ipv4 point-to-point\ninterface TenGigE _PORTID_ ipv4 unnumbered _MGMTETH_\n";
    private static final String CREATE_POS_IPSECTION = "interface POS _PORTID_ ipv4 unnumbered _MGMTETH_\n";
    private static final String CREATE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_CREATE_IPSECTION_mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\nneighbor _IPADDR_\nremote te-link-id unnum _TELINKID_\nremote interface-id unnum _DATALINKID_\nremote switching-capability fsc\nroot\ncontroller dwdm _PORTID_\nshutdown\ncommit\nwavelength _WLEN_\ncommit\nno shutdown\ncommit\n</Configuration></CLI></Request>";
    private static final String TENGIGE_CREATE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_CREATE_IPSECTION_mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\nneighbor _IPADDR_\nremote te-link-id unnum _TELINKID_\nremote interface-id unnum _DATALINKID_\nremote switching-capability fsc\nroot\ncontroller dwdm _PORTID_\nshutdown\ncommit\nwavelength _WLEN_\ncommit\nno shutdown\ncommit\n</Configuration></CLI></Request>".replace("_CREATE_IPSECTION_", "").replace("_PORTTYPE_", "TenGigE");
    private static final String POS_CREATE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_CREATE_IPSECTION_mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\nneighbor _IPADDR_\nremote te-link-id unnum _TELINKID_\nremote interface-id unnum _DATALINKID_\nremote switching-capability fsc\nroot\ncontroller dwdm _PORTID_\nshutdown\ncommit\nwavelength _WLEN_\ncommit\nno shutdown\ncommit\n</Configuration></CLI></Request>".replace("_CREATE_IPSECTION_", "").replace("_PORTTYPE_", "POS");
    private static final String FULL_TENGIGE_CREATE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_CREATE_IPSECTION_mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\nneighbor _IPADDR_\nremote te-link-id unnum _TELINKID_\nremote interface-id unnum _DATALINKID_\nremote switching-capability fsc\nroot\ncontroller dwdm _PORTID_\nshutdown\ncommit\nwavelength _WLEN_\ncommit\nno shutdown\ncommit\n</Configuration></CLI></Request>".replace("_CREATE_IPSECTION_", "interface TenGigE _PORTID_ ipv4 point-to-point\ninterface TenGigE _PORTID_ ipv4 unnumbered _MGMTETH_\n").replace("_PORTTYPE_", "TenGigE");
    private static final String FULL_POS_CREATE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_CREATE_IPSECTION_mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\nneighbor _IPADDR_\nremote te-link-id unnum _TELINKID_\nremote interface-id unnum _DATALINKID_\nremote switching-capability fsc\nroot\ncontroller dwdm _PORTID_\nshutdown\ncommit\nwavelength _WLEN_\ncommit\nno shutdown\ncommit\n</Configuration></CLI></Request>".replace("_CREATE_IPSECTION_", "interface POS _PORTID_ ipv4 unnumbered _MGMTETH_\n").replace("_PORTTYPE_", "POS");
    private static final String DELETE_TENGIGE_IPSECTION = "no interface TenGigE _PORTID_ ipv4 point-to-point\nno interface TenGigE _PORTID_ ipv4 unnumbered\n";
    private static final String DELETE_POS_IPSECTION = "no interface POS _PORTID_ ipv4 unnumbered\n";
    private static final String DELETE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>no snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_DELETE_IPSECTION_no mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\ncommit\n</Configuration></CLI></Request>";
    private static final String TENGIGE_DELETE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>no snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_DELETE_IPSECTION_no mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\ncommit\n</Configuration></CLI></Request>".replace("_DELETE_IPSECTION_", "").replace("_PORTTYPE_", "TenGigE");
    private static final String POS_DELETE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>no snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_DELETE_IPSECTION_no mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\ncommit\n</Configuration></CLI></Request>".replace("_DELETE_IPSECTION_", "").replace("_PORTTYPE_", "POS");
    private static final String FULL_TENGIGE_DELETE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>no snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_DELETE_IPSECTION_no mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\ncommit\n</Configuration></CLI></Request>".replace("_DELETE_IPSECTION_", "no interface TenGigE _PORTID_ ipv4 point-to-point\nno interface TenGigE _PORTID_ ipv4 unnumbered\n").replace("_PORTTYPE_", "TenGigE");
    private static final String FULL_POS_DELETE_CMD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Configuration>no snmp-server interface _PORTTYPE_ _PORTID_ index persistence\n_DELETE_IPSECTION_no mpls traffic-eng interface _PORTTYPE_ _PORTID_ lmp data-link adjacency\ncommit\n</Configuration></CLI></Request>".replace("_DELETE_IPSECTION_", "no interface POS _PORTID_ ipv4 unnumbered\n").replace("_PORTTYPE_", "POS");
    private KDebug db;

    public CLIDataLinkAction(ITTYSession iTTYSession, KDebug kDebug) {
        this(iTTYSession.getHostname(), kDebug);
    }

    public CLIDataLinkAction(String string, KDebug kDebug) {
        super(string);
        this.db = kDebug;
        this.cliCmd = new CLICmdRsp[1];
    }

    public boolean create(PlimPortId.PlimType plimType, String string, String string2, String string3, int n, int n2, int n3, boolean bl) {
        String string4;
        boolean bl2 = false;
        switch (plimType) {
            case TenGigE: {
                string4 = bl ? FULL_TENGIGE_CREATE_CMD : TENGIGE_CREATE_CMD;
                break;
            }
            case POS: {
                string4 = bl ? FULL_POS_CREATE_CMD : POS_CREATE_CMD;
                break;
            }
            default: {
                if (this.db.on()) {
                    this.db.warning("Unknown port type in CLICreateDataLinkAction");
                }
                return true;
            }
        }
        String string5 = string4.replaceAll(_PORTID_, string.toString()).replaceAll(_IPADDR_, string2).replaceAll(_MGMTETH_, string3).replace(_TELINKID_, Integer.toString(n)).replace(_DATALINKID_, Integer.toString(n2)).replace(_WLEN_, Integer.toString(n3));
        this.cliCmd[0] = new CLICmdRsp(string5, true);
        try {
            bl2 = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        catch (TTYException tTYException) {
            bl2 = true;
        }
        this.cliCmd[0].setError(bl2);
        return bl2;
    }

    public boolean delete(PlimPortId.PlimType plimType, String string, boolean bl) {
        String string2;
        boolean bl2 = false;
        switch (plimType) {
            case TenGigE: {
                string2 = bl ? FULL_TENGIGE_DELETE_CMD : TENGIGE_DELETE_CMD;
                break;
            }
            case POS: {
                string2 = bl ? FULL_POS_DELETE_CMD : POS_DELETE_CMD;
                break;
            }
            default: {
                if (this.db.on()) {
                    this.db.warning("Unknown port type in CLICreateDataLinkAction");
                }
                return true;
            }
        }
        String string3 = string2.replaceAll(_PORTID_, string.toString());
        this.cliCmd[0] = new CLICmdRsp(string3, true);
        try {
            bl2 = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        catch (TTYException tTYException) {
            bl2 = true;
        }
        this.cliCmd[0].setError(bl2);
        return bl2;
    }
}

