/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvSideModel;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.AlarmCounterGraphic;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewGeneralGrapher;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.ViewZoomLabel;
import cerent.util.view.fv.helper.SvgParams;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.graphic.IlvZoomableLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewAlarmGrapher
extends ViewGeneralGrapher
implements IObserver {
    public static final String DIRECTIONLESS_SIDE_LABEL = "DirectionLess";
    private String key = null;
    private IlvZoomableLabel[] alarm;
    private AlarmCounterGraphic aCg;

    public ViewAlarmGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super(svgParams);
        this.key = ViewAlarmGrapher.createKey((String)svgParams.svgKey);
        this.aCg = new AlarmCounterGraphic(this);
        if (this.sideModel instanceof IObservable) {
            ((IObservable)((Object)this.sideModel)).addObserver(this);
        }
        this.initViewGraphic((Object)viewGraphicSet);
        this.initDefaultPos();
        this.prepareAlarm();
    }

    private void prepareAlarm() {
        String string = this.sideModel.getNameLabel() != DIRECTIONLESS_SIDE_LABEL ? "SIDE " + this.sideModel.getNameLabel() : "DirLess";
        if (!this.getViewManager().isFromNfv()) {
            this.alarm = new IlvZoomableLabel[3];
            this.alarm[AlarmEnum.CR.getValue()] = (IlvZoomableLabel)this.cardlabels.get("ALARM_LABEL-1");
            this.alarm[AlarmEnum.MJ.getValue()] = (IlvZoomableLabel)this.cardlabels.get("ALARM_LABEL-2");
            this.alarm[AlarmEnum.MN.getValue()] = (IlvZoomableLabel)this.cardlabels.get("ALARM_LABEL-3");
        }
        this.sideLabel = (ViewZoomLabel)this.cardlabels.get("SIDE_LABEL");
        this.sideLabel.setLabel(string);
    }

    @Override
    public String getShortName() {
        return "ALARM " + this.sideModel.getName();
    }

    public void initDefaultPos() {
        this.setCoordinates(0.0, 860.0, 0.0, true);
        this.updateCoordinates();
    }

    @Override
    protected IViewSvg.IViewSvgEnum getGeneralType() {
        return IViewSvg.SvgGenericShape.FIBER_SIDE;
    }

    @Override
    protected void updateCardBckgInfo(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        if (this.sideModel != null) {
            this.info = new ViewShapeInfo(viewAttribute.getValue(), this.sideModel.getId());
            this.info.setSide(this.sideModel.getNameLabel());
        }
    }

    @Override
    protected void onInitPopupMenu(UPopupMenu uPopupMenu) {
    }

    @Override
    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
    }

    @Override
    public String getGraphKey() {
        return this.key;
    }

    @Override
    protected void createSideLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        if (viewAttribute.getValue() instanceof IlvZoomableLabel) {
            ViewZoomLabel viewZoomLabel = new ViewZoomLabel(viewAttribute.getValue());
            this.cardlabels.put(viewZoomLabel.getName(), viewZoomLabel);
        }
    }

    @Override
    protected void createAlarmLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        if (!this.getViewManager().isFromNfv() && viewAttribute.getValue() instanceof IlvZoomableLabel) {
            ViewZoomLabel viewZoomLabel = new ViewZoomLabel(viewAttribute.getValue());
            this.cardlabels.put(viewZoomLabel.getName(), viewZoomLabel);
        }
    }

    public void flipLabels() {
    }

    @Override
    public void doFlipH() {
        this.doFlipH(true);
    }

    public void doFlipH(boolean bl) {
        IViewShapeInfo iViewShapeInfo;
        iViewShapeInfo.setFlipH(!(iViewShapeInfo = this.getInfo()).getFlipH());
        if (bl) {
            this.initReDraws();
            this.invalidateRegion(this.boundingBox());
        }
        this.scale(1.0, -1.0);
        if (bl) {
            this.invalidateRegion(this.boundingBox());
            this.reDrawViews();
        }
    }

    @Override
    public void doFlipV() {
        this.doFlipV(true);
    }

    public void doFlipV(boolean bl) {
        IViewShapeInfo iViewShapeInfo;
        iViewShapeInfo.setFlipV(!(iViewShapeInfo = this.getInfo()).getFlipV());
        if (bl) {
            this.initReDraws();
            this.invalidateRegion(this.boundingBox());
        }
        this.scale(-1.0, 1.0);
        if (bl) {
            this.invalidateRegion(this.boundingBox());
            this.reDrawViews();
        }
    }

    @Override
    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof IFvSideModel) {
            if (this.sideModel.getName() != DIRECTIONLESS_SIDE_LABEL) {
                this.sideLabel.setLabel("SIDE " + this.sideModel.getName());
            } else {
                this.sideLabel.setLabel("DirLess");
            }
        }
    }

    public void setAlarmLabel(String string, AlarmEnum alarmEnum) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        String[] stringArray = new String[]{String.valueOf(alarmEnum.getValue()), string};
        if (!(this.getViewManager() != null && this.getViewManager().isFromNfv() || ilvGraphicBag == null)) {
            ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    String[] stringArray = (String[])object;
                    ViewAlarmGrapher.this.alarm[Integer.parseInt(stringArray[0])].setLabel(stringArray[1]);
                }
            }, (Object)stringArray, true);
        }
    }

    public String getSideNameAssociated() {
        return this.sideModel.getNameLabel();
    }

    public static String createKey(String string) {
        return "FunctDomainGrapher." + string;
    }

    public AlarmCounterGraphic getCounter() {
        return this.aCg;
    }

    @Override
    public void updateCoordinates() {
        this.initReDraws();
        this.invalidateRegion(this.boundingBox());
        this.move((float)this.info.getX(), (float)this.info.getY());
        this.invalidateRegion(this.boundingBox());
        this.reDrawViews();
    }

    @Override
    public void dispose() {
        if (this.aCg != null) {
            this.aCg.destroy();
            this.aCg = null;
        }
        if (this.sideModel != null && this.sideModel instanceof IObservable) {
            ((IObservable)((Object)this.sideModel)).deleteObserver(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlarmEnum {
        CR(0),
        MJ(1),
        MN(2);

        private int value;

        private AlarmEnum(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

