/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvAlarmStatus;
import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.util.IFvDebug;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.AbstractView;
import cerent.util.view.fv.GrapherViewCommand;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.helper.FunctDebug;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;

public abstract class ViewCardGrapher
extends ViewCompositeGraphic
implements Observer,
TransformerListener {
    protected IFvCardModel card = null;
    protected boolean even = false;
    protected boolean sideCard;
    protected IViewShapeInfo info = null;
    protected boolean transfFilterOn = false;
    private String cardname = null;
    protected static IFvDebug db = null;
    private String key = null;
    static final int _ObjectDeletedMsg = 0;
    static final int _ObjectChangedMsg = 1;
    static final int _ObjectAddedMsg = 2;
    static final int _ObjectRebootMsg = 3;

    public IFvCardModel getCard() {
        return this.card;
    }

    public ViewCardGrapher(ISvgParams iSvgParams, ViewGraphicSet viewGraphicSet) {
        super(iSvgParams, viewGraphicSet);
        if (db == null) {
            db = FunctDebug.instance().addChild("dumpPorts", "Dump the info related to card ports");
        }
        try {
            this.card = (IFvCardModel)iSvgParams.getSvgValue();
            IlvManager ilvManager = this.getCardManager();
            if (ilvManager != null) {
                ilvManager.addManagerSelectionListener((ManagerSelectionListener)new MyViewCardListener());
            }
            this.getTk().addTransformerListener(this);
            this.setIsSideCard();
        }
        catch (RuntimeException runtimeException) {
            FunctDebug.printStackTrace(runtimeException);
        }
        if (this.getNode().isMultishelf()) {
            this.setToolTipText(this.card.getEqTypeName() + ": shelf" + this.card.getShelfId() + "/s" + this.card.getSlot());
        } else {
            this.setToolTipText(this.card.getEqTypeName() + ": s" + this.card.getSlot());
        }
        if (this.card instanceof IFvOpticsCardModel) {
            if (((IFvOpticsCardModel)this.card).isEvenWavelengthCard()) {
                this.even = true;
            }
        } else if (this.card.getEqType() == 309) {
            this.even = true;
        }
    }

    protected void setIsSideCard() {
        IViewGraph iViewGraph = this.getGraphParent();
        this.sideCard = false;
        IFvEntityModel iFvEntityModel = null;
        if (((ViewDomainGrapher)iViewGraph).getSideModel() != null) {
            iFvEntityModel = this.getNode().getEntityModelByIndex(((ViewDomainGrapher)iViewGraph).getSideModel().getLineIn()).getParentModel();
        }
        if (iFvEntityModel == this.card) {
            this.sideCard = true;
        }
    }

    public boolean isSideCard() {
        return this.sideCard;
    }

    public IFvCardModel getCardModel() {
        return this.card;
    }

    public abstract int getEntityIndex();

    public abstract int getShelfId();

    public abstract int getSlotId();

    public String getShortName() {
        return this.card.getEqLabel();
    }

    protected void redrawAll() {
        if (this.getOwner() instanceof ViewDomainGrapher) {
            ViewDomainGrapher viewDomainGrapher = (ViewDomainGrapher)this.getOwner();
            viewDomainGrapher.redrawAllLinks();
        }
    }

    protected boolean addPort(IViewGraph iViewGraph, IViewSvgParamInfo iViewSvgParamInfo) {
        if (iViewGraph != null && iViewGraph instanceof ViewPortGraphic) {
            this.addGraphNode((ViewPortGraphic)iViewGraph, true, IViewGraph.Layers.Port);
            return true;
        }
        return false;
    }

    public IViewGraph getPortByName(String string) {
        return this.getGraphChildren().get(string);
    }

    public IlvManager getCardManager() {
        return (IlvManager)this.getOwner();
    }

    public void setCoordinates(double d, double d2, double d3, boolean bl) {
        this.info.setX(this.getTk().clipWorldX(d));
        this.info.setY(this.getTk().clipWorldY(d2));
        this.info.setAngle(d3);
        if (!(bl || this.info.getCenterX() != 0.0 && this.info.getCenterX() != (double)AbstractView.getCanvasWidth() && this.info.getCenterY() != 0.0 && this.info.getCenterY() != (double)AbstractView.getCanvasHeight())) {
            this.info.setCenterX(AbstractView.getCanvasCenterX());
            this.info.setCenterY(AbstractView.getCanvasCenterY());
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.transfFilterOn || ilvTransformer.getx11() == 1.0 && ilvTransformer.getx22() == 1.0) {
            super.applyTransform(ilvTransformer);
        }
        this.transfFilterOn = false;
    }

    public void updateCoordinates() {
        this.graphicMove((float)this.info.getX(), (float)this.info.getY());
        this.redrawAll();
    }

    public void doshapeRotate(Double d) {
        if (d == 0.0) {
            return;
        }
        this.transfFilterOn = true;
        this.graphicRotate(new Point((int)this.boundingBox().getCenterX(), (int)this.boundingBox().getCenterY()), d);
        this.redrawAll();
    }

    public int getNumberOfGraphLinks() {
        return 0;
    }

    public void doFlipH() {
        this.transfFilterOn = true;
        this.graphicScale(1.0, -1.0);
        ((ViewShapeInfo)this.info).flipH();
        this.redrawAll();
    }

    public void doFlipV() {
        this.transfFilterOn = true;
        this.graphicScale(-1.0, 1.0);
        ((ViewShapeInfo)this.info).flipV();
        this.redrawAll();
    }

    public void setCenter(double d, double d2) {
        ViewCardGrapher.setCenter(null, (IlvGraphic)this, d, d2);
    }

    public static void setCenter(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, double d, double d2) {
        IlvRect ilvRect = ilvGraphic.boundingBox();
        Rectangle2D.Float float_ = ViewCardGrapher.boundingBox(ilvGraphic);
        double d3 = ilvRect.getWidth() > float_.getWidth() ? ilvRect.getWidth() : float_.getWidth();
        double d4 = float_.getHeight();
        double d5 = d - d3 / 2.0;
        double d6 = d2 - d4 / 2.0;
        ViewCardGrapher.setLocation(ilvGrapher, ilvGraphic, d5, d6);
    }

    private static Rectangle2D.Float boundingBox(IlvGraphic ilvGraphic) {
        IlvRect ilvRect = ilvGraphic.boundingBox();
        return ilvRect;
    }

    public static void setLocation(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, double d, double d2) {
        if (ilvGrapher == null) {
            ilvGraphic.move((float)d, (float)d2);
        } else {
            ilvGrapher.moveObject(ilvGraphic, (float)d, (float)d2, true);
        }
    }

    public IViewShapeInfo getShapeInfo() {
        return this.info;
    }

    protected void onInitPopupMenu(UPopupMenu uPopupMenu) {
    }

    public void dispose() {
    }

    public String getcardName() {
        if (this.cardname != null) {
            return this.cardname;
        }
        if (this.card.getIFVNodeModel().isMultishelf()) {
            this.cardname = "sh" + this.card.getShelfId() + "/";
        }
        this.cardname = (this.cardname != null ? this.cardname : "") + "s" + this.card.getSlot() + " (" + this.card.getEqLabel() + ")";
        return this.cardname;
    }

    public String getGraphKey() {
        if (this.key == null) {
            return Integer.toString(this.getEntityIndex());
        }
        return this.key;
    }

    public IViewGraph getGraphParent() {
        return this.getOwner();
    }

    public void doAdd(GrapherViewCommand grapherViewCommand) {
    }

    public void doChange(GrapherViewCommand grapherViewCommand) {
    }

    public void doDelete(GrapherViewCommand grapherViewCommand) {
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof IFvModel) {
            if (object instanceof Integer) {
                int n = (Integer)object;
                switch (n) {
                    case 0: {
                        this.getTk().delCard(this);
                    }
                }
            }
        } else if (!(observable instanceof IFvAlarmStatus)) {
            // empty if block
        }
    }

    public IViewShapeInfo getInfo() {
        return null;
    }

    public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
        IlvTransformer ilvTransformer = transformerChangedEvent.getNewValue();
        if (ilvTransformer.getx11() < 0.0 || ilvTransformer.getx22() < 0.0) {
            this.applyTransform(transformerChangedEvent.getOldValue());
        }
    }

    public String toString() {
        String string = "";
        if (this.card != null) {
            string = this.card.getEqLabel();
        }
        return "ViewDomainGrapher for " + string;
    }

    public void paintParent(Color color) {
    }

    public void setGraphKey(String string) {
        this.key = string;
    }

    public abstract void setCardAlarmColor();

    public abstract void setCardinCircuit(boolean var1, int var2);

    public void doMouseClick(MouseViewCommand mouseViewCommand) {
    }

    public void doMouseDoubleClick(MouseViewCommand mouseViewCommand) {
    }

    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
    }

    public void doMousePopup(MouseViewCommand mouseViewCommand) {
    }

    public void doMouseUpdate(MouseViewCommand mouseViewCommand) {
    }

    public String getGraphName() {
        return null;
    }

    public String getToolTipText() {
        return super.getToolTipText();
    }

    public boolean isEvenCard() {
        return this.even;
    }

    class MyViewCardListener
    implements ManagerSelectionListener {
        MyViewCardListener() {
        }

        public void selectionChanged(ManagerSelectionChangedEvent managerSelectionChangedEvent) {
            IlvGraphic ilvGraphic = managerSelectionChangedEvent.getGraphic();
            IlvManager ilvManager = managerSelectionChangedEvent.getManager();
            if (ilvManager.isSelected(ilvGraphic)) {
                ViewManager.addToLog(this, "MyViewCardListener obj selected " + ilvGraphic.toString());
            } else {
                ViewManager.addToLog(this, "MyViewCardListener obj de-selected " + ilvGraphic.toString());
            }
        }
    }
}

